# French language file.
#	 
# (C) 2003-2007 Anope Team
# Contact us at info@anope.org
#
# Please read COPYING and README for furhter details.
#
# Based on the original code of Epona by Lara.
# Based on the original code of Services by Andy Church.
#
# Updated by Kevin@epiknet.org (03/15/2003)
# www.epiknet.org - www.botstats.com
#
# Updated by illu@rs2i.net (04/09/2005)
# irc.rs2i.net - http://www.rs2i.net
#
# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, let us know
# (dev@anope.org) which message is causing a problem and I'll see
# what I can do.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# services.conf).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.

###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Franais (French)

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%d %b %Y %H:%M:%S %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %d %b %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%d %b %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Dim
	Lun
	Mar
	Mer
	Jeu
	Ven
	Sam
# %A
STRFTIME_DAYS_LONG
	Dimanche
	Lundi
	Mardi
	Mercredi
	Jeudi
	Vendredi
	Samedi
# %b
STRFTIME_MONTHS_SHORT
	Jan
	Fv
	Mar
	Avr
	Mai
	Jun
	Jul
	Ao
	Sep
	Oct
	Nov
	Dc
# %B
STRFTIME_MONTHS_LONG
	Janvier
	Fvrier
	Mars
	Avril
	Mai
	Juin
	Juillet
	Aot
	Septembre
	Octobre
	Novembre
	Dcembre


# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	, 


# Various error messages.
USER_RECORD_NOT_FOUND
	Erreur interne - impossible d'effectuer la commande.
UNKNOWN_COMMAND
	Commande %s inconnue.
UNKNOWN_COMMAND_HELP
	Commande %s inconnue. Tapez "%R%s HELP" pour obtenir de l'aide.
SYNTAX_ERROR
	Syntaxe: %s
MORE_INFO
	Tapez %R%s HELP %s pour plus d'informations.
NO_HELP_AVAILABLE
	Aucune aide disponible sur %s.
OBSOLETE_COMMAND
	Cette commande est dpasse, utilisez %s  la place.

BAD_USERHOST_MASK
	Le masque doit avoir le format user@host.
BAD_EXPIRY_TIME
	Echance invalide.
USERHOST_MASK_TOO_WIDE
	La couverture de %s est trop grande, utilisez un masque plus prcis.

SERVICE_OFFLINE
	%s n'est pas connect actuellement.
READ_ONLY_MODE
	Note: les Services sont en mode lecture-seule; les changements ne seront pas sauvegards!
PASSWORD_INCORRECT
	Mot de passe incorrect.
INVALID_TARGET
	"/msg %s" is no longer supported.  Use "/msg %s@%s" or "/%s" instead.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	Accs refus.
PERMISSION_DENIED
	Permission refuse.
RAW_DISABLED
	L'option RAW n'est pas active. Si vous voulez l'utiliser, desactiver l'option DisableRaw dans la configuration des services.

MORE_OBSCURE_PASSWORD
	Veuillez ressayer avec un mot de passe plus difficile  trouver.  Les mots de passe doivent contenir au moins cinq caractres, ne doivent pas tre trop facilement devinables (par exemple votre vrai nom ou votre pseudo), et ne doit pas contenir d'espaces ou de tabulations.
PASSWORD_TRUNCATED
	Note:  Votre mot de passe a t tronqu  %d caractres.

NICK_NOT_REGISTERED
	Votre pseudo n'est pas enregistr.
NICK_NOT_REGISTERED_HELP
	Votre pseudo n'est pas enregistr.  Tapez %R%s HELP pour des informations sur l'enregistrement des pseudos.
NICK_X_IS_SERVICES
	Le pseudo %s fait partie des services du rseau.
NICK_X_NOT_REGISTERED
	Le nick %s n'est pas enregistr.
NICK_X_IN_USE
	Le pseudo %s est dja utilis.
NICK_X_NOT_IN_USE
	Le pseudo %s n'est actuellement pas utilis.
NICK_X_NOT_ON_CHAN
	%s n'est actuelement pas sur %s.
NICK_X_FORBIDDEN
	Le pseudo %s ne peut tre enregistr ou utilis.
NICK_X_FORBIDDEN_OPER
	Le pseudo %s a t interdit par %s:
	%s
NICK_X_ILLEGAL
	Le pseudo %s est un pseudo illgale et ne peut pas etre utilis
NICK_X_TRUNCATED
	Le pseudo %s a t tronqu de %d caractres.
NICK_X_SUSPENDED
	Le pseudo %s est actuelement suspendu.
CHAN_X_NOT_REGISTERED
	Le channel %s n'est pas enregistr.
CHAN_X_NOT_IN_USE
	Le channel %s n'existe pas.
CHAN_X_FORBIDDEN
	Le channel %s ne peut tre enregistr ou utilis.
CHAN_X_FORBIDDEN_OPER
	Le channel %s a t interdit par %s:
	%s
CHAN_X_SUSPENDED
	      Suspendu: [%s] %s
NICK_IDENTIFY_REQUIRED
	L'authentification par mot de passe est requise pour cette commande.
	Ressayez aprs avoir tap %R%s IDENTIFY motdepasse.
CHAN_IDENTIFY_REQUIRED
	L'authentification par mot de passe est requise pour cette commande.
	Ressayez aprs avoir tap %R%s IDENTIFY %s motdepasse.

MAIL_DISABLED
	Les services ont t configurs pour ne pas envoyer de mail.
MAIL_INVALID
	L'adresse e-mail de %s est invalide.
MAIL_X_INVALID
	%s n'est pas une adresse e-mail valide.
MAIL_LATER
	Impossible d'envoyer un e-mail maintenant, veuillez ressayez un peu
	plus tard.
MAIL_DELAYED
	Attendez %d secondes et ressayez.

NO_REASON
	Aucune raison
UNKNOWN
	<inconnu>

DURATION_DAY
	1 jour
DURATION_DAYS
	%d jours
DURATION_HOUR
	1 heure
DURATION_HOURS
	%d heures
DURATION_MINUTE
	1 minute
DURATION_MINUTES
	%d minutes
DURATION_SECOND
	1 seconde
DURATION_SECONDS
	%d secondes

# Human readable expiration
NO_EXPIRE
	n'expire pas
EXPIRES_SOON
	expire  la prochaine mise  jour de la base de donnes
EXPIRES_M
	expire dans %d minutes
EXPIRES_1M
	expire dans %d minute
EXPIRES_HM
	expire dans %d heures, %d minutes
EXPIRES_H1M
	expire dans %d heures, %d minute
EXPIRES_1HM
	expire dans %d heure, %d minutes
EXPIRES_1H1M
	expire dans %d heure, %d minute
EXPIRES_D
	expire dans %d jours
EXPIRES_1D
	expire dans %d jour

# Generic Footer message
END_OF_ANY_LIST
	Fin du %s list.

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
LIST_INCORRECT_RANGE
	Incorrect range specified. The correct syntax is #from-to.
CS_LIST_INCORRECT_RANGE
	To search for channels starting with #, search for the channel
	name without the #-sign prepended (anope instead of #anope).

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
HELP_LIMIT_SERV_OPER
	Limited to Services Operators.
HELP_LIMIT_SERV_ADMIN
	Limited to Services Administrators.
HELP_LIMIT_SERV_ROOT
	Limited to Services Roots.
HELP_LIMIT_IRC_OPER
	Limited to IRC Operators.
HELP_LIMIT_HOST_SETTER
	Limited to Host Setters.
HELP_LIMIT_HOST_REMOVER
	Limited to Host Removers.


###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Ce nick appartient  quelqu'un d'autre. Veuillez en changer.
	(Si c'est votre nick, tapez %R%s IDENTIFY motdepasse.)
NICK_IS_SECURE
	Ce pseudo est enregistr et protg. Si c'est votre pseudo,
	tapez %R%s IDENTIFY motdepasse. 
	Sinon, veuillez choisir un pseudo diffrent.
NICK_MAY_NOT_BE_USED
	Ce pseudo ne peut tre utilis.  Veuillez en choisir un autre.
FORCENICKCHANGE_IN_1_MINUTE
	Si vous ne changez pas d'ici 1 minute, je changerai votre pseudo.
FORCENICKCHANGE_IN_20_SECONDS
	Si vous ne changez pas d'ici 20 secondes, je changerai votre pseudo.
FORCENICKCHANGE_NOW
	Ce pseudo a t enregistr, vous ne pouvez pas l'utiliser.
FORCENICKCHANGE_CHANGING
	Votre pseudo est maintenant chang en %s.

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER motdepasse [email]
NICK_REGISTER_SYNTAX_EMAIL
	REGISTER motdepasse email
NICK_REGISTRATION_DISABLED
	Dsols, l'enregistrement de pseudos est temporairement dsactiv.
NICK_REGISTRATION_FAILED
	Dsols, l'enregistrement a chou.
NICK_REG_PLEASE_WAIT
	Veuillez attendre %d secondes avant d'utiliser la commande REGISTER  nouveau.
NICK_CANNOT_BE_REGISTERED
	Le pseudo %s ne peut tre enregistr.
NICK_ALREADY_REGISTERED
	Le pseudo %s est dj enregistr!
NICK_REGISTERED
	Le pseudo %s est maintenant enregistr sous votre masque: %s
NICK_REGISTERED_NO_MASK
	Le pseudo %s est enregistr.
NICK_PASSWORD_IS
	Votre mot de passe est %s - notez le pour une utilisation ultrieure.

# GROUP responses
NICK_REG_DELAY
	Vous devez rester connect plus de %d secondes pour enregistrer votre pseudo.

# GROUP responses
NICK_GROUP_SYNTAX
	GROUP cible motdepasse
NICK_GROUP_DISABLED
	Dsols, le groupage de pseudo est temporairement dsactiv.
NICK_GROUP_FAILED
	Dsols, le groupage de pseudo a chou.
NICK_GROUP_PLEASE_WAIT
	Attendez %d secondes avant d'utiliser la commande GROUP  nouveau.
NICK_GROUP_CHANGE_DISABLED
	Votre pseudo est dj enregistr, tapez %R%s DROP d'abord.
NICK_GROUP_SAME
	Vous tes dj un membre du groupe de %s.
NICK_GROUP_TOO_MANY
	Il y a trop de pseudos dans le groupe de %s; listez-les et 
	effacez-en quelques uns.
	Tapez %R%s HELP GLIST et %R%s HELP DROP pour
	plus d'informations.
NICK_GROUP_JOINED
	Vous tes maintenant dans le groupe de %s.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY motdepasse
NICK_IDENTIFY_FAILED
	Dsols, l'identification a chou.
NICK_IDENTIFY_SUCCEEDED
	Mot de passe accept - vous tes maintenant identifi.
NICK_IDENTIFY_EMAIL_REQUIRED
	Vous devez maintenant associer un e-mail  votre pseudo.
	Cet e-mail vous permettra de retrouver votre mot de passe
	au cas o vous le perdriez.
NICK_IDENTIFY_EMAIL_HOWTO
	Tapez %R%S SET EMAIL e-mail pour dfinir votre e-mail.
	Votre vie prive est respecte, cet e-mail ne sera pas 
	divulgu  des tierces personnes.

# LOGOUT responses
NICK_ALREADY_IDENTIFIED
	Vous tes dj identifi.

# UPDATE responses
NICK_UPDATE_SUCCESS
	Status mis  jour (memos, vhost, modes, flags).
	
# LOGOUT responses
NICK_LOGOUT_SYNTAX
	LOGOUT
NICK_LOGOUT_SUCCEEDED
	Votre pseudo n'est plus identifi.
NICK_LOGOUT_X_SUCCEEDED
	Le pseudo %s n'est plus identifi.

# DROP responses
NICK_LOGOUT_SERVICESADMIN
	Vous ne pouvez pas logout %s parceque c'est un administrateur
	des services.

# DROP responses
NICK_DROP_DISABLED
	Dsols, l'effacement de pseudo est temporairement dsactiv.
NICK_DROPPED
	Votre pseudo a t effac.
NICK_X_DROPPED
	Le pseudo %s a t effac.

# SET responses
NICK_SET_SYNTAX
	SET option paramtres
NICK_SET_SERVADMIN_SYNTAX
	SET [nick] option paramtres
NICK_SET_DISABLED
	Dsols, la configuration des options du pseudo est temporairement dsactive.
NICK_SET_UNKNOWN_OPTION
	L'option SET %s est inconnue.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	L'option SET %s est inconnue, ou le pseudo n'est pas enregistr.
NICK_SET_OPTION_DISABLED
	L'option %s ne peut tre change sur ce rseau.

# SET DISPLAY responses
NICK_SET_DISPLAY_INVALID
	Le nouvel affichage DOIT tre un pseudo de votre groupe de pseudos!
NICK_SET_DISPLAY_CHANGED
	Le nouvel affichage est maintenant %s.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Impossible de changer votre mot de passe.
NICK_SET_PASSWORD_CHANGED
	Votre mot de passe a t chang.
NICK_SET_PASSWORD_CHANGED_TO
	Votre mot de passe est maintenant %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE nombre
NICK_SET_LANGUAGE_UNKNOWN
	Numro de langue %d inconnu. Tapez %R%s HELP SET LANGUAGE pour une liste de langues.
NICK_SET_LANGUAGE_CHANGED
	Votre langue est maintenant le Franais.

# SET URL responses
NICK_SET_URL_CHANGED
	L'adresse de votre site est maintenant %s.
NICK_SET_URL_UNSET
	L'adresse de votre site a t efface.

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	Votre adresse e-mail est maintenant %s.
NICK_SET_EMAIL_UNSET
	Votre adresse e-mail a t efface.
NICK_SET_EMAIL_UNSET_IMPOSSIBLE
	Vous ne pouvez pas effacer votre e-mail sur ce rseau.

# SET ICQ responses
NICK_SET_ICQ_CHANGED
	Votre numro ICQ est maintenant %s.
NICK_SET_ICQ_UNSET
	Votre numro ICQ a t effac.
NICK_SET_ICQ_INVALID
	%s n'est pas un nombre valide.

# SET GREET responses
NICK_SET_GREET_CHANGED
	Votre message d'accueil est maintenant %s.
NICK_SET_GREET_UNSET
	Votre message d'accueil a t effac.

# SET KILL responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	La protection est maintenant active.
NICK_SET_KILL_QUICK
	La protection est maintenant active, avec un dlai rduit.
NICK_SET_KILL_IMMED
	La protection est maintenant active, sans dlai.
NICK_SET_KILL_IMMED_DISABLED
	L'option IMMED n'est pas disponible sur ce rseau.
NICK_SET_KILL_OFF
	La protection est maintenant dsactive.

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	La scurit est maintenant activ.
NICK_SET_SECURE_OFF
	La scurit est maintenant dsactiv.

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	Votre pseudo est maintenant priv.
NICK_SET_PRIVATE_OFF
	Votre pseudo est maintenant public.

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Votre adresse e-mail ne sera plus affiche par la commande INFO de %s.
NICK_SET_HIDE_EMAIL_OFF
	Votre adresse e-mail sera affiche par la commande INFO de %s.
NICK_SET_HIDE_MASK_ON
	Votre masque user@host ne sera plus affich par la commande INFO de %s.
NICK_SET_HIDE_MASK_OFF
	Votre masque user@host sera affich par la commande INFO de %s.
NICK_SET_HIDE_QUIT_ON
	Votre dernire raison de /QUIT ne sera plus affiche par la commande INFO de %s.
NICK_SET_HIDE_QUIT_OFF
	Votre dernire raison de /QUIT sera affiche par la commande INFO de %s.

# SET NOEXPIRE responses
NICK_SET_HIDE_STATUS_ON
	Votre status sera cach dans l'affichage de la commande INFO de %s.
NICK_SET_HIDE_STATUS_OFF
	Votre status sera affich dans l'affichage de la commande INFO de %s.
	
# SET MSG responses
NICK_SET_MSG_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_MSG_ON
	Les services vous repondrons avec des messages.	
NICK_SET_MSG_OFF
	Les services vous repondrons avec des notice.

# SET AUTOOP responses
NICK_SET_AUTOOP_SYNTAX
	SET AUTOOP {ON | OFF}
NICK_SET_AUTOOP_ON
	Services will now autoop you in channels.
NICK_SET_AUTOOP_OFF
	Services will no longer autoop you in channels.


# SET NOEXPIRE responses
NICK_SASET_SYNTAX
	SASET pseudo option paramtres
NICK_SASET_DISABLED
	Dsole, le changement d'options sur les pseudos est temporairement
	dsactiv.
NICK_SASET_UNKNOWN_OPTION
	Option SASET %s inconnue.
NICK_SASET_BAD_NICK
	Le pseudo %s n'est pas enregistr.
NICK_SASET_OPTION_DISABLED
	L'option %s ne peut pas configur sur ce rseau.

# SASET DISPLAY responses
NICK_SASET_DISPLAY_INVALID
	Le nouvel affichage pour %s DOIT etre un pseudo de son groupe!
NICK_SASET_DISPLAY_CHANGED
	Le nouvel affichage est maintenant %s.

# SASET PASSWORD responses
NICK_SASET_PASSWORD_FAILED
	Dsol, impossible de chang le mot de passe pour %s.
NICK_SASET_PASSWORD_CHANGED
	Mot de passe chang pour %s.
NICK_SASET_PASSWORD_CHANGED_TO
	Le mot de passe pour %s a t chang en %s.

# SASET LANGUAGE responses
NICK_SASET_URL_CHANGED
	L'URL pour %s a t chang en %s.
NICK_SASET_URL_UNSET
	L'URL %s a t effac.

# SASET EMAIL responses
NICK_SASET_EMAIL_CHANGED
	L'adresse E-mail pour %s a t chang en %s.
NICK_SASET_EMAIL_UNSET
	L'adresse E-mail pour %s a t effac.
NICK_SASET_EMAIL_UNSET_IMPOSSIBLE
	Vous ne pouvez pas configurer d'E-mail sur ce rseau.
	
# SASET ICQ responses
NICK_SASET_ICQ_CHANGED
	Le numro ICQ pour %s a t chang en %s.
NICK_SASET_ICQ_UNSET
	Le numro ICQ pour %s a t effac.
NICK_SASET_ICQ_INVALID
	%s n'est pas un numro ICQ valide.
	
# SASET GREET responses
NICK_SASET_GREET_CHANGED
	Le message de greet pour %s a t chang en %s
NICK_SASET_GREET_UNSET
	Le message de greet de %s a t effac.

# SASET PROTECT responses
NICK_SASET_KILL_SYNTAX
	SASET pseudo KILL {ON | QUICK | OFF}
NICK_SASET_KILL_IMMED_SYNTAX
	SASET pseudo KILL {ON | QUICK | IMMED | OFF}
NICK_SASET_KILL_ON
	La protection est maintenant ACTIVE pour %s.
NICK_SASET_KILL_QUICK
	La protection est maintenant ACTIVE pour %s, avec un dlais rduit.
NICK_SASET_KILL_IMMED
	La protection est maintenant ACTIVE pour %s, sans aucun dlais.
NICK_SASET_KILL_IMMED_DISABLED
	L'option IMMED est pas accssible sur ce rseau.
NICK_SASET_KILL_OFF
	La protection est maintenant INACTIVE pour %s.

# SASET SECURE responses
NICK_SASET_SECURE_SYNTAX
	SASET pseudo SECURE {ON | OFF}
NICK_SASET_SECURE_ON
	L'option scurit est maintenant ACTIVE pour %s.
NICK_SASET_SECURE_OFF
	L'option de scurit est maintenant INACTIVE pour %s.

# SASET PRIVATE responses
NICK_SASET_PRIVATE_SYNTAX
	SASET pseudo PRIVATE {ON | OFF}
NICK_SASET_PRIVATE_ON
	L'option priv est maintenant ACTIVE pour %s.
NICK_SASET_PRIVATE_OFF
	L'option priv est maintenant INACTIVE pour %s.

# SASET HIDE responses
NICK_SASET_HIDE_SYNTAX
	SET pseudo HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SASET_HIDE_EMAIL_ON
	L'adresse E-mail de %s sera cach dans la commande INFO de %s.
NICK_SASET_HIDE_EMAIL_OFF
	L'adresse email de %s sera maintenant affich dans la commande INFO de %s.
NICK_SASET_HIDE_MASK_ON
	Le dernier masque user@host de %s sera maintenant cach dans la commande INFO
	de %s.
NICK_SASET_HIDE_MASK_OFF
	Le dernier masque user@host de %s sera maintenant affich dans la commande INFO
	de %s.
NICK_SASET_HIDE_QUIT_ON
	Le dernier message de quit de %s ne sera plus affich dans la commande INFO de %s.
NICK_SASET_HIDE_QUIT_OFF
	Le dernier message de quit de %s sera affich dans la commande INFO de %s.
NICK_SASET_HIDE_STATUS_ON
	Le status sur les services de %s sera maintenant cach dans la commande INFO de %s.
NICK_SASET_HIDE_STATUS_OFF
	Le status sur les services de %s sera maintenant affich dans la commande INFO de %s.
	
# SASET MSG responses
NICK_SASET_MSG_SYNTAX
	SASET pseudo PRIVATE {ON | OFF}
NICK_SASET_MSG_ON
	Les services repondront  %s par des messages.
NICK_SASET_MSG_OFF
	Les services repondront  %s par des notices.

# SET NOEXPIRE responses
NICK_SASET_NOEXPIRE_SYNTAX
	SASET pseudo NOEXPIRE {ON | OFF}
NICK_SASET_NOEXPIRE_ON
	Le pseudo %s n'expirera pas.
NICK_SASET_NOEXPIRE_OFF
	Le pseudo %s expirera.

# ACCESS responses
NICK_SASET_AUTOOP_SYNTAX
	SASET nickname AUTOOP {ON | OFF}
NICK_SASET_AUTOOP_ON
	Services will now autoop %s in channels.
NICK_SASET_AUTOOP_OFF
	Services will no longer autoop %s in channels.


# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [mask]
NICK_ACCESS_ALREADY_PRESENT
	Le mask %s existe dj sur votre liste d'accs.
NICK_ACCESS_REACHED_LIMIT
	Vous ne pouvez avoir que %d entres dans la liste d'accs d'un nick.
NICK_ACCESS_ADDED
	%s ajout  votre liste d'accs.
NICK_ACCESS_NOT_FOUND
	%s introuvable sur votre liste d'accs.
NICK_ACCESS_DELETED
	%s supprim de votre liste d'accs.
NICK_ACCESS_LIST
	Liste d'accs:
NICK_ACCESS_LIST_X
	Liste d'accs de %s:
NICK_ACCESS_LIST_EMPTY
	Votre liste d'accs est vide.
NICK_ACCESS_LIST_X_EMPTY
	La liste d'accs de %s est vide.

# Status messages
NICK_STATUS_0
	STATUS %s 0
NICK_STATUS_1
	STATUS %s 1
NICK_STATUS_2
	STATUS %s 2
NICK_STATUS_3
	STATUS %s 3

# INFO responses
NICK_INFO_SYNTAX
	INFO pseudo [ALL]
NICK_INFO_REALNAME
	%s est %s
NICK_INFO_SERVICES_OPER
	%s est oprateur des services.
NICK_INFO_SERVICES_ADMIN
	%s est administrateur des services.
NICK_INFO_SERVICES_ROOT
	%s est un services root.
NICK_INFO_ADDRESS
	            Adresse: %s
NICK_INFO_ADDRESS_ONLINE
	        Connect de: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s est actuellement connect.
NICK_INFO_TIME_REGGED
	      Enregistr le: %s
NICK_INFO_LAST_SEEN
	  Dernire prsence: %s
NICK_INFO_LAST_QUIT
	       Dernier quit: %s
NICK_INFO_URL
	Adresse de son site: %s
NICK_INFO_EMAIL
	     Adresse e-mail: %s
NICK_INFO_VHOST
	              vhost: %s
NICK_INFO_VHOST2
	              vhost: %s@%s
NICK_INFO_ICQ
	         Numro ICQ: %d
NICK_INFO_GREET
	  Message d'accueil: %s
NICK_INFO_OPTIONS
	            Options: %s
NICK_INFO_EXPIRE
	Expire le: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Protection
NICK_INFO_OPT_SECURE
	Scurit
NICK_INFO_OPT_PRIVATE
	Confidentialit
NICK_INFO_OPT_MSG
	Mode message
NICK_INFO_OPT_AUTOOP
	Auto-op
NICK_INFO_OPT_NONE
	Aucune
NICK_INFO_NO_EXPIRE
	Ce nick n'expirera pas.
NICK_INFO_FOR_MORE
	Pour plus d'informations, tapez %R%s INFO %s ALL.

# LIST responses
NICK_INFO_SUSPENDED
	Ce pseudo est actuelement suspendu, raison: %s
NICK_INFO_SUSPENDED_NO_REASON
	Ce pseudo est actuelement suspendu.


# LIST responses
NICK_LIST_SYNTAX
	LIST modle
NICK_LIST_SERVADMIN_SYNTAX
	LIST modle [FORBIDDEN] [NOEXPIRE] [UNCONFIRMED]
NICK_LIST_HEADER
	Liste des entres correspondantes  %s:
NICK_LIST_RESULTS
	Fin de la liste - %d/%d correspondances affiches.
	
# GLIST responses
NICK_ALIST_SYNTAX
	ALIST pseudo
NICK_ALIST_HEADER
	Liste des cannaux auquels vous avez accs:
	  Num  Canal                Level    Description 
NICK_ALIST_HEADER_X
	Liste des cannaux auquels %s a accs:
	  Num  Canal                Level    Description 
NICK_ALIST_XOP_FORMAT
	  %3d %c%-20s %-8s %s
NICK_ALIST_ACCESS_FORMAT
	  %3d %c%-20s %-8d %s
NICK_ALIST_FOOTER
	Fin de la liste - %d/%d correspondances affiches.

# GLIST responses
NICK_GLIST_HEADER
	Liste des pseudos dans votre groupe:
NICK_GLIST_HEADER_X
	Liste des pseudos dans le groupe de %s:
NICK_GLIST_FOOTER
	%d pseudos dans le groupe.
NICK_GLIST_REPLY
	   %c%s
NICK_GLIST_REPLY_ADMIN
	   %c%s (expire le %s)

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER pseudo [motdepasse]
NICK_NO_RECOVER_SELF
	Vous ne pouvez utiliser RECOVER sur vous-mme!
NICK_RECOVERED
	L'utilisateur se servant de votre pseudo a t dconnect.
	%R%s RELEASE %s pour le rcuprer avant que la minute ne s'coule.

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE pseudo [motdepasse]
NICK_RELEASE_NOT_HELD
	Le pseudo %s n'est pas en tutelle.
NICK_RELEASED
	La tutelle des Services sur votre pseudo a t enleve.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST pseudo [motdepasse]
NICK_NO_GHOST_SELF
	Vous ne pouvez utiliser GHOST sur vous-mme!
NICK_GHOST_KILLED
	L'utilisateur fantme utilisant votre pseudo a t dconnect.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS pseudo
NICK_GETPASS_UNAVAILABLE
	La commande GETPASS est indisponible car l'encryption est utilise.
NICK_GETPASS_PASSWORD_IS
	Le mot de passe de %s est %s.

# SENDPASS responses
NICK_GETEMAIL_SYNTAX
	GETEMAIL user@email-host Pas de WildCards!!
NICK_GETEMAIL_EMAILS_ARE
	Emails trouvs %s pour %s.
NICK_GETEMAIL_NOT_USED
	Aucun Emails list pour %s.
	
# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS pseudo
NICK_SENDPASS_UNAVAILABLE
	La commande SENDPASS est indisponible car l'encryption est utilise.
NICK_SENDPASS_SUBJECT
	Mot de passe du pseudo %s
NICK_SENDPASS_HEAD
	Bonjour,
NICK_SENDPASS_LINE_1
	Vous avez demand  recevoir le mot de passe du pseudo %s par e-mail.
NICK_SENDPASS_LINE_2
	Le mot de passe est %s Pour des raisons de scurit, vous devriez le changer ds que vous lisez cet e-mail.
NICK_SENDPASS_LINE_3
	Si vous ne savez pas de quoi il retourne dans cet e-mail, il s'agit probablement d'une erreur, nous vous prions de nous excuser et vous demandons d'ignorer cet e-mail.
NICK_SENDPASS_LINE_4
	NE REPONDEZ PAS A CE MAIL!
NICK_SENDPASS_LINE_5
	Les administrateurs de %s.
NICK_SENDPASS_OK
	Le mot de passe de %s a t envoy.

# FORBID responses
NICK_SUSPEND_SYNTAX
	SUSPEND pseudo raison
NICK_SUSPEND_SUCCEEDED
	Le pseudo %s est suspendu.
NICK_SUSPEND_FAILED
	Impossible de suspend le pseudo %s!

# UNSUSPEND responses
NICK_UNSUSPEND_SYNTAX
	UNSUSPEND pseudo
NICK_UNSUSPEND_SUCCEEDED
	Le pseudo %s est liber.
NICK_UNSUSPEND_FAILED
	Impossible de liberer le pseudo %s!

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID pseudo [raison]
NICK_FORBID_SYNTAX_REASON
	FORBID pseudo raison
NICK_FORBID_SUCCEEDED
	Le pseudo %s est dsormais interdit.
NICK_FORBID_FAILED
	Impossible d'interdire le pseudo %s!

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
NICK_REQUESTED
	Une demande d'enregistrement pour ce pseudo est en cours. Merci de patienter 24 heures.
NICK_REG_RESENT
	Votre mot de passe a t renvoy  %s.
NICK_REG_UNABLE
	Pseudo non enregistr... Re-essayez plus tard.
NICK_IS_PREREG
	Une demande d'enregistrement pour ce pseudo est en cours. La confirmation n'a pas t effectue.
NICK_ENTER_REG_CODE
	Un passcode a t envoy  %s, merci de taper %R%s confirm <passcode> une fois que vous l'aurez reu pour complter l'enregistrement.
NICK_CONFIRM_NOT_FOUND
	Aucune validation en attente... Tapez: "%R%s register <password> <email>" pour l'enregistrer.
NICK_CONFIRM_INVALID
	Passcode invalide, merci de le vrifier.
NICK_REG_MAIL_SUBJECT
	Enregistrement d'un pseudo (%s)
NICK_REG_MAIL_HEAD
	Bonjour,
NICK_REG_MAIL_LINE_1
	Vous venez de demander l'enregistrement du pseudo %s.
NICK_REG_MAIL_LINE_2
	Veuillez tapez " %R%s confirm %s " sur IRC afin de valider l'enregistrement.
NICK_REG_MAIL_LINE_3
	Si vous ne savez pas pourquoi vous avez reu cet email, ignorez-le.
NICK_REG_MAIL_LINE_4
	NE REPONDEZ PAS A CE MESSAGE
NICK_REG_MAIL_LINE_5
	%s administrateurs.
NICK_GETPASS_PASSCODE_IS
	Le passcode pour %s est %s.
NICK_FORCE_REG
	Pseudo %s confirm

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Status automatique d'oprateur du channel
CHAN_LEVEL_AUTOVOICE
	Mode +v automatique
CHAN_LEVEL_AUTOHALFOP
	Mode +h automatique
CHAN_LEVEL_AUTOPROTECT
	Mode +a automatique
CHAN_LEVEL_AUTODEOP
	Non autoris  avoir le status d'oprateur du channel
CHAN_LEVEL_NOJOIN
	Non autoris  joindre le channel s'il est restreint
CHAN_LEVEL_INVITE
	Autoris  utiliser la commande INVITE
CHAN_LEVEL_AKICK
	Autoris  utiliser la commande AKICK
CHAN_LEVEL_SET
	Autoris  utiliser la commande SET (mais pas FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	Autoris  utiliser la commande CLEAR
CHAN_LEVEL_UNBAN
	Autoris  utiliser la commande UNBAN
CHAN_LEVEL_OPDEOP
	Autoris  utiliser les commandes OP/DEOP
CHAN_LEVEL_ACCESS_LIST
	Autoris  voir la liste d'accs
CHAN_LEVEL_ACCESS_CHANGE
	Autoris  modifier la liste d'accs
CHAN_LEVEL_MEMO
	Autoris  lister/lire les memos
CHAN_LEVEL_ASSIGN
	Autoris  attribuer/retirer un bot
CHAN_LEVEL_BADWORDS
	Autoris  utiliser la commande BADWORDS
CHAN_LEVEL_NOKICK
	Jamais kick par les kickers du bot
CHAN_LEVEL_FANTASIA
	Autoris  utiliser les commandes fantaisistes
CHAN_LEVEL_SAY
	Autoris  utiliser les commandes ACT et SAY
CHAN_LEVEL_GREET
	Message d'accueil affich
CHAN_LEVEL_VOICEME
	Autoris  se (de)voicer
CHAN_LEVEL_VOICE
	Autoris  utiliser les commandes VOICE/DEVOICE
CHAN_LEVEL_GETKEY
	Autoris  utiliser la commande GETKEY
CHAN_LEVEL_OPDEOPME
	Autoris  se (de)op
CHAN_LEVEL_HALFOPME
	Autoris  se (de)halfop
CHAN_LEVEL_HALFOP
	Autoris  utiliser les commandes HALFOP/DEHALFOP
CHAN_LEVEL_PROTECTME
	Autoris  se (de)protger
CHAN_LEVEL_PROTECT
	Autoris  utiliser les commandes PROTECT/DEPROTECT
CHAN_LEVEL_KICKME
	Autoris  se kicker
CHAN_LEVEL_KICK
	Autoris  utiliser la commande KICK
CHAN_LEVEL_SIGNKICK
	Pas de kick sign quand SIGNKICK LEVEL est utilis
CHAN_LEVEL_BANME
	Autoris  se bannir
CHAN_LEVEL_BAN
	Autoris  utiliser la commande BAN
CHAN_LEVEL_TOPIC
	Autoris  utiliser la commande TOPIC
CHAN_LEVEL_INFO
	Autoris  utiliser la commande INFO avec l'option ALL

# Automatic responses
CHAN_IS_REGISTERED
	Ce channel a t enregistr avec %s.
CHAN_NOT_ALLOWED_OP
	Vous ne pouvez tre oprateur du channel %s.
CHAN_MAY_NOT_BE_USED
	Ce channel ne peut tre utilis.
CHAN_NOT_ALLOWED_TO_JOIN
	Vous n'tes pas autoris  tre sur ce channel.

# REGISTER responses
CHAN_X_INVALID
	Channel %s is not a valid channel.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER canal motdepasse description
CHAN_REGISTER_DISABLED
	Dsols, l'enregistrement des cannaux est temporairement dsactiv.
CHAN_REGISTER_NOT_LOCAL
	Les cannaux locaux ne peuvent tre enregistrs.
CHAN_MUST_REGISTER_NICK
	Vous devez d'abord enregistrer votre pseudo.  Tapez %R%s HELP pour savoir comment enregistrer votre pseudo.
CHAN_MUST_IDENTIFY_NICK
	Vous devez d'abord vous identifier avec %s, en utilisant la commande:
	%R%s IDENTIFY motdepasse
CHAN_MAY_NOT_BE_REGISTERED
	Le canal %s ne peut tre enregistr.
CHAN_ALREADY_REGISTERED
	Le canal %s est dj enregistr!
CHAN_MUST_BE_CHANOP
	Vous devez tre un oprateur du canal pour l'enregistrer.
CHAN_REACHED_CHANNEL_LIMIT
	Dsols, vous avez dj atteint votre limite de %d canaux.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Dsols, vous avez dj dpass votre limite de %d canaux.
CHAN_REGISTRATION_FAILED
	Dsols, l'enregistrement a chou.
CHAN_REGISTERED
	Le canal %s a t enregistr sous votre pseudo: %s
CHAN_PASSWORD_IS
	Le mot de passe du canal est %s - notez le pour une utilisation ultrieure.
CHAN_REGISTER_NONE_CHANNEL
	Vous avez essay d'enregistrer le canal %s qui n'xiste pas.
CHAN_SYMBOL_REQUIRED
	Veuillez utiliser les symbole # quand vous voulez enregistrer
	un canal.
	
# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY canal motdepasse
CHAN_IDENTIFY_FAILED
	Dsols, l'identification a chou.
CHAN_IDENTIFY_SUCCEEDED
	Password accept - vous avez maintenant un level d'accs sur %s quivalent 
	 celui de son propritaire.

# LOGOUT responses
CHAN_LOGOUT_SYNTAX
	LOGOUT canal pseudo
CHAN_LOGOUT_SERVADMIN_SYNTAX
	LOGOUT canal [pseudo]
CHAN_LOGOUT_SUCCEEDED
	L'utilisateur %s n'est plus identifi pour le canal %s.
CHAN_LOGOUT_ALL_SUCCEEDED
	Tous les utilisateurs identifis au canal %s ne le sont plus.

# DROP responses
CHAN_DROP_SYNTAX
	DROP canal
CHAN_DROP_DISABLED
	Dsols, l'effacement de canaux est temporairement dsactiv.
CHAN_DROPPED
	Le canal %s a t effac.

# SET responses
CHAN_SET_SYNTAX
	SET canal option paramtres
CHAN_SET_DISABLED
	Dsols, la configuration des options du canal est temporairement dsactive.
CHAN_SET_UNKNOWN_OPTION
	Option SET %s inconnue.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s a trop de channels enregistrs.
CHAN_FOUNDER_CHANGED
	Le propritaire de %s est maintenant %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Le successeur de %s est maintenant %s.
CHAN_SUCCESSOR_UNSET
	Il n'y a plus de successeur sur %s.
CHAN_SUCCESSOR_IS_FOUNDER
	%s ne peut tre successeur et propritaire du canal %s.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Impossible de changer le mot de passe.
CHAN_PASSWORD_CHANGED
	Le mot de passe de %s a t chang.
CHAN_PASSWORD_CHANGED_TO
	Le mot de passe de %s est maintenant %s.

# SET DESC responses
CHAN_DESC_CHANGED
	La description de %s est maintenant %s.

# SET URL responses
CHAN_URL_CHANGED
	L'adresse du site de %s est maintenant %s.
CHAN_URL_UNSET
	L'adresse du site de %s a t efface.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	L'e-mail de %s est maintenant %s.
CHAN_EMAIL_UNSET
	L'e-mail de %s a t effac.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Le message d'entre de %s a t chang.
CHAN_ENTRY_MSG_UNSET
	Le message d'entre de %s a t effac.
	
# SET BANTYPE responses
CHAN_SET_BANTYPE_INVALID
	%s n'est pas un type de ban valide.
CHAN_SET_BANTYPE_CHANGED
	Le type de ban du channel %s est maintenant le numro %d.

# SET MLOCK responses
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Mode %c ignor car inconnu.
CHAN_SET_MLOCK_IMPOSSIBLE_CHAR
	Mode %c ignor car il ne peut tre maintenu.
CHAN_SET_MLOCK_L_REQUIRED
	Vous devez faire garder le mode +l pour en faire autant avec le mode +L.
CHAN_SET_MLOCK_K_REQUIRED
	Vous devez faire garder le mode +i pour en faire autant avec le mode +K.
CHAN_MLOCK_CHANGED
	Les modes maintenus du canal %s sont maintenant %s.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET canal KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Le maintient du topic est maintenant ACTIF sur %s.
CHAN_SET_KEEPTOPIC_OFF
	Le maintient du topic est maintenant INACTIF sur %s.

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET canal TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Le vrouillage du topic pour %s est maintenant ACTIF.
CHAN_SET_TOPICLOCK_OFF
	Le vrouillage du topic pour %s est maintenant INACTIF.

# SET PEACE responses
CHAN_SET_PEACE_SYNTAX
	SET canal PEACE {ON | OFF}
CHAN_SET_PEACE_ON
	Le mode 'paix' est ACTIF pour %s.
CHAN_SET_PEACE_OFF
	Le mode 'paix' est INACTIF pour %s.

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET canal PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	L'option priv pour %s est maintenant ACTIVE.
CHAN_SET_PRIVATE_OFF
	L'option priv pour %s est maintenant INACTIVE.

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET canal SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	La scurit des ops pour %s est maintenant ACTIVE.
CHAN_SET_SECUREOPS_OFF
	La scurit des ops sur %s est maintenant INACTIVE.

# SET SECUREFOUNDER responses
CHAN_SET_SECUREFOUNDER_SYNTAX
	SET canal SECUREFOUNDER {ON | OFF}
CHAN_SET_SECUREFOUNDER_ON
	L'option de scurit du propritaire pour %s est ACTIVE.
CHAN_SET_SECUREFOUNDER_OFF
	L'option de scurit du propritaire pour %s est INACTIVE.

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET canal RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Les restrictions d'accs pour %s sont maintenant ACTIVES.
CHAN_SET_RESTRICTED_OFF
	Les restrictions d'accs pour %s sont maintenant INACTIVES.

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET canal SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	L'option de scurit pour %s est ACTIVE.
CHAN_SET_SECURE_OFF
	L'option de scurit pour %s est INACTIVE.

# SET SIGNKICK responses
CHAN_SET_SIGNKICK_SYNTAX
	SET canal SIGNKICK {ON | LEVEL | OFF}
CHAN_SET_SIGNKICK_ON
	Les kicks seront maintenant sign sur %s.
CHAN_SET_SIGNKICK_LEVEL
	Les kicks seront maintenant sign sur %s en fonction de 
	l'accs de l'user sur le canal.
CHAN_SET_SIGNKICK_OFF
	Les kicks ne seront plus sign sur %s.

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET canal OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	L'option 'op-notice' est maintenant ACTVE sur %s.
CHAN_SET_OPNOTICE_OFF
	L'option 'op-notice' est maintenant INACTIVE sur
	%s.

# SET OPNOTICE responses
CHAN_SET_XOP_SYNTAX
	SET canal XOP {ON | OFF}
CHAN_SET_XOP_ON
	Le systme de xOP est maintenant ACTIF sur %s.
CHAN_SET_XOP_OFF
	Le systme de xOP est maintenant INACTIF sur %s.

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET canal NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	Le canal %s n'expirera pas.
CHAN_SET_NOEXPIRE_OFF
	Le canal %s expirera.

# xOP messages
CHAN_XOP_REACHED_LIMIT
	Dsol, vous ne pouvez avoir que %d entres sur les listes des AOPs/SOPs/VOPs d'un canal.
CHAN_XOP_LIST_FORMAT
	  %3d  %s
CHAN_XOP_ACCESS
	Vous ne pouvez pas utiliser cette commande. 
	Utilisez la commandes ACCESS  la place.
	Tapez %R%s HELP ACCESS pour plus d'informations.
CHAN_XOP_NOT_AVAILABLE
	xOP system is not available.

# AOP messages
CHAN_AOP_SYNTAX
	AOP canal {ADD|DEL|LIST|CLEAR} [pseudo [level] | liste-d'entres]
CHAN_AOP_DISABLED
	Dsols, la modification des listes des AOPs des canaux est temporairement dsactive.
CHAN_AOP_NICKS_ONLY
	Les listes des AOPs des canaux ne peuvent contenir que des pseudos enregistrs.
CHAN_AOP_ADDED
	%s ajout  la liste des AOPs de %s.
CHAN_AOP_MOVED
	%s a t boug dans la liste des AOPs de %s.
CHAN_AOP_NO_SUCH_ENTRY
	Entre inexistante (#%d) sur la liste des AOPs de %s.
CHAN_AOP_NOT_FOUND
	%s introuvable sur la liste des AOPs de %s.
CHAN_AOP_NO_MATCH
	Aucune entre correspondante sur la liste des AOPs de %s.
CHAN_AOP_DELETED
	%s supprim de la liste des AOPs de %s.
CHAN_AOP_DELETED_ONE
	1 entre supprime de la liste des AOPs de %s.
CHAN_AOP_DELETED_SEVERAL
	%d entres supprimes de la liste des AOPs de %s.
CHAN_AOP_LIST_EMPTY
	La liste des AOPs de %s est vide.
CHAN_AOP_LIST_HEADER
	Liste des AOPs de %s:
	  Num  Pseudo
CHAN_AOP_CLEAR
	La liste des AOPs de %s est maintenant vide.

# HOP messages
CHAN_HOP_SYNTAX
	HOP canal {ADD|DEL|LIST|CLEAR} [pseudo [level] | liste-d'entres]
CHAN_HOP_DISABLED
	Dsols, la modification des listes des HOPs des canaux est temporairement dsactive.
CHAN_HOP_NICKS_ONLY
	Les listes des HOPs des cannaux ne peuvent contenir que des pseudos enregistrs.
CHAN_HOP_ADDED
	%s ajout  la liste des HOPs de %s.
CHAN_HOP_MOVED
	%s a t boug dans la liste des HOPs de %s.
CHAN_HOP_NO_SUCH_ENTRY
	Entre inexistante (#%d) sur la liste des HOPs de %s.
CHAN_HOP_NOT_FOUND
	%s introuvable sur la liste des HOPs de %s.
CHAN_HOP_NO_MATCH
	Aucune entre correspondante sur la liste des HOPs de %s.
CHAN_HOP_DELETED
	%s supprim de la liste des HOPs de %s.
CHAN_HOP_DELETED_ONE
	1 entre supprime de la liste des HOPs de %s.
CHAN_HOP_DELETED_SEVERAL
	%d entres supprimes de la liste des HOPs de %s.
CHAN_HOP_LIST_EMPTY
	La liste des HOPs de %s est vide.
CHAN_HOP_LIST_HEADER
	Liste des HOPs de %s:
	  Num  Pseudo
CHAN_HOP_CLEAR
	La liste des HOPs de %s est maintenant vide.

# SOP messages
CHAN_SOP_SYNTAX
	SOP canal {ADD|DEL|LIST|CLEAR} [pseudo [level] | liste-d'entres]
CHAN_SOP_DISABLED
	Dsols, la modification des listes des SOPs des cannaux est temporairement dsactive.
CHAN_SOP_NICKS_ONLY
	Les listes des SOPs des cannaux ne peuvent contenir que des pseudos enregistrs.
CHAN_SOP_ADDED
	%s ajout  la liste des SOPs de %s.
CHAN_SOP_MOVED
	%s a t boug dans la liste des SOPs de %s.
CHAN_SOP_NO_SUCH_ENTRY
	Entre inexistante (#%d) sur la liste des SOPs de %s.
CHAN_SOP_NOT_FOUND
	%s introuvable sur la liste des SOPs de %s.
CHAN_SOP_NO_MATCH
	Aucune entre correspondante sur la liste des SOPs de %s.
CHAN_SOP_DELETED
	%s supprim de la liste des SOPs de %s.
CHAN_SOP_DELETED_ONE
	1 entre supprime de la liste des SOPs de %s.
CHAN_SOP_DELETED_SEVERAL
	%d entres supprimes de la liste des SOPs de %s.
CHAN_SOP_LIST_EMPTY
	La liste des SOPs de %s est vide.
CHAN_SOP_LIST_HEADER
	Liste des SOPs de %s:
	  Num  Pseudo
CHAN_SOP_CLEAR
	La liste des SOPs de %s est maintenant vide.

# VOP messages
CHAN_VOP_SYNTAX
	VOP canal {ADD|DEL|LIST|CLEAR} [pseudo [level] | liste-d'entres]
CHAN_VOP_DISABLED
	Dsols, la modification des listes des VOPs des canaux est temporairement dsactive.
CHAN_VOP_NICKS_ONLY
	Les listes des VOPs des canaux ne peuvent contenir que des pseudos enregistrs.
CHAN_VOP_ADDED
	%s ajout  la liste des VOPs de %s.
CHAN_VOP_MOVED
	%s a t boug dans la liste des VOPs de %s.
CHAN_VOP_NO_SUCH_ENTRY
	Entre inexistante (#%d) sur la liste des VOPs de %s.
CHAN_VOP_NOT_FOUND
	%s introuvable sur la liste des VOPs de %s.
CHAN_VOP_NO_MATCH
	Aucune entre correspondante sur la liste des VOPs de %s.
CHAN_VOP_DELETED
	%s supprim de la liste des VOPs de %s.
CHAN_VOP_DELETED_ONE
	1 entre supprime de la liste des VOPs de %s.
CHAN_VOP_DELETED_SEVERAL
	%d entres supprimes de la liste des VOPs de %s.
CHAN_VOP_LIST_EMPTY
	La liste des VOPs de %s est vide.
CHAN_VOP_LIST_HEADER
	Liste des VOPs de %s:
	  Num  Pseudo
CHAN_VOP_CLEAR
	La liste des VOPs de %s est maintenant vide.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS canal {ADD|DEL|LIST|CLEAR} [pseudo [level] | liste-d'entres]
CHAN_ACCESS_XOP
	Vous ne pouvez pas utiliser cette commande.
	Utilisez les commandes AOP, SOP et VOP  la place.
	Tapez %R%s HELP commande pour plus d'informations.
CHAN_ACCESS_XOP_HOP
	You can't use this command. 
	Use the AOP, SOP, HOP and VOP commands instead.
	Type %R%s HELP command for more information.
CHAN_ACCESS_DISABLED
	Dsols, la modification des listes d'accs des canaux est temporairement dsactive.
CHAN_ACCESS_LEVEL_NONZERO
	Le level d'accs doit tre diffrent de zro.
CHAN_ACCESS_LEVEL_RANGE
	Le level d'accs doit tre compris entre %d et %d inclus.
CHAN_ACCESS_NICKS_ONLY
	Les listes d'accs des canaux ne peuvent contenir que des pseudos enregistrs.
CHAN_ACCESS_REACHED_LIMIT
	Dsols, vous ne pouvez avoir que %d entres sur la liste d'accs d'un canal.
CHAN_ACCESS_LEVEL_UNCHANGED
	Le level d'accs de %s sur %s est inchang de %d.
CHAN_ACCESS_LEVEL_CHANGED
	Le level d'accs de %s sur %s est maintenant de %d.
CHAN_ACCESS_ADDED
	%s ajout  la liste d'accs de %s au level %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	Entre inexistante (#%d) sur la liste d'accs de %s.
CHAN_ACCESS_NOT_FOUND
	%s introuvable sur la liste d'accs de %s.
CHAN_ACCESS_NO_MATCH
	Aucune entre correspondante sur la liste d'accs de %s.
CHAN_ACCESS_DELETED
	%s supprim de la liste d'accs de %s.
CHAN_ACCESS_DELETED_ONE
	1 entre supprime de la liste d'accs de %s.
CHAN_ACCESS_DELETED_SEVERAL
	%d entres supprimes de la liste d'accs de %s.
CHAN_ACCESS_LIST_EMPTY
	La liste d'accs de %s est vide.
CHAN_ACCESS_LIST_HEADER
	Liste d'accs de %s:
	  Num   Lev  Pseudo
CHAN_ACCESS_LIST_FOOTER
	Fin de liste d'accs.
CHAN_ACCESS_LIST_XOP_FORMAT
	  %3d   %s  %s
CHAN_ACCESS_LIST_AXS_FORMAT
	  %3d  %4d  %s
CHAN_ACCESS_CLEAR
	La liste d'accs de %s est maintenant vide.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK canal {ADD | STICK | UNSTICK | DEL | LIST | VIEW | ENFORCE | CLEAR} [pseudo-ou-usermask]
CHAN_AKICK_DISABLED
	Dsols, la modification de la liste de kicks automatiques du canal 
	est temporairement dsactive.
CHAN_AKICK_ALREADY_EXISTS
	%s existe dj sur la liste de kicks automatiques de %s.
CHAN_AKICK_REACHED_LIMIT
	Dsols, vous ne pouvez avoir plus de %d entres de kicks automatiques 
	sur un canal.
CHAN_AKICK_ADDED
	%s ajout  la liste de kicks automatiques de %s.
CHAN_AKICK_NO_SUCH_ENTRY
	Entre (#%d) inexistante sur la liste de kicks automatiques de %s.
CHAN_AKICK_NOT_FOUND
	%s introuvable sur la liste de kicks automatiques de %s.
CHAN_AKICK_NO_MATCH
	Aucune entre correspondante sur la liste de kicks automatiques de %s.
CHAN_AKICK_STUCK
	%s est maintenant maintenu en permanence sur le channel %s.
CHAN_AKICK_UNSTUCK
	%s n'est plus maintenu en permanence sur le channel %s.
CHAN_AKICK_DELETED
	%s supprim de la liste de kicks automatiques de %s.
CHAN_AKICK_DELETED_ONE
	1 entre supprime de la liste de kicks automatiques de %s.
CHAN_AKICK_DELETED_SEVERAL
	%d entres supprimes de la liste de kicks automatiques de %s.
CHAN_AKICK_LIST_EMPTY
	la liste de kicks automatiques de %s est vide.
CHAN_AKICK_LIST_HEADER
	Liste de kicks automatiques de %s:
CHAN_AKICK_LIST_FORMAT
	  %3d %s (%s)
CHAN_AKICK_VIEW_FORMAT
	%3d %s (par %s le %s)
	    %s
CHAN_AKICK_VIEW_FORMAT_STUCK
	%3d %s (maintenu) (par %s le %s)
	    %s
CHAN_AKICK_ENFORCE_DONE
	L'application des entres de la liste de kicks automatiques 
	pour %s est termin, %d utilisateurs taient concerns.
CHAN_AKICK_CLEAR
	La liste de kicks automatiques de %s est maintenant vide.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS canal {SET | DIS[ABLE] | LIST | RESET} [option [level]]
CHAN_LEVELS_XOP
	Cette commande est inutile dans ce mode.
CHAN_LEVELS_RANGE
	Le level doit tre compris entre %d et %d inclus.
CHAN_LEVELS_CHANGED
	Le level pour %s du channel %s est maintenant de %d.
CHAN_LEVELS_UNKNOWN
	L'option %s est inconnue.  Tapez %R%s HELP LEVELS DESC pour une 
	liste d'options valides.
CHAN_LEVELS_DISABLED
	Le level %s est maintenant dsactiv sur le canal %s.
CHAN_LEVELS_LIST_HEADER
	Options de level d'accs du channel %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (dsactiv)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (propritaire uniquement)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	Les levels d'accs de %s ont t rinitialiss  leur valeur par dfaut.

# Status Messages
CHAN_STATUS_SYNTAX
	ERREUR STATUS : Erreur de syntaxe.
CHAN_STATUS_NOT_REGGED
	ERREUR STATUS : Le canal %s n'est pas enregistr.
CHAN_STATUS_FORBIDDEN
	ERREUR STATUS : Le canal %s est FORBID.
CHAN_STATUS_NOTONLINE
	ERREUR STATUS : Le pseudo %s n'est pas connect.
CHAN_STATUS_INFO
	STATUS %s %s %d

# INFO responses
CHAN_INFO_SYNTAX
	INFO canal [ALL]
CHAN_INFO_HEADER
	Informations pour le canal %s:
CHAN_INFO_FOUNDER
	        Propritaire: %s (%s)
CHAN_INFO_NO_FOUNDER
	        Propritaire: %s
CHAN_INFO_SUCCESSOR
	          Successeur: %s (%s)
CHAN_INFO_NO_SUCCESSOR
	          Successeur: %s
CHAN_INFO_DESCRIPTION
	         Description: %s
CHAN_INFO_ENTRYMSG
	    Message d'entre: %s
CHAN_INFO_TIME_REGGED
	          Enregistr: %s
CHAN_INFO_LAST_USED
	Dernire utilisation: %s
CHAN_INFO_LAST_TOPIC
	       Dernier topic: %s
CHAN_INFO_TOPIC_SET_BY
	    Topic chang par: %s
CHAN_INFO_URL
	     Adresse du site: %s
CHAN_INFO_EMAIL
	              E-mail: %s
CHAN_INFO_BANTYPE
	         Type de ban: %d
CHAN_INFO_OPTIONS
	             Options: %s
CHAN_INFO_OPT_KEEPTOPIC
	Maintien du topic
CHAN_INFO_OPT_OPNOTICE
	Notice sur OP
CHAN_INFO_OPT_PEACE
	Paix
CHAN_INFO_OPT_PRIVATE
	Confidentialit
CHAN_INFO_OPT_RESTRICTED
	Accs restreint
CHAN_INFO_OPT_SECURE
	Scurit
CHAN_INFO_OPT_SECUREOPS
	Contrle des ops
CHAN_INFO_OPT_SECUREFOUNDER
	Contrle du propritaire
CHAN_INFO_OPT_SIGNKICK
	Kicks signs
CHAN_INFO_OPT_TOPICLOCK
	Verrouillage du topic
CHAN_INFO_OPT_XOP
	Systme de listes de xOPs
CHAN_INFO_OPT_NONE
	Aucune
CHAN_INFO_MODE_LOCK
	     Modes maintenus: %s
CHAN_INFO_EXPIRE
	      Expires in: %s
CHAN_INFO_NO_EXPIRE
	Ce canal n'expirera pas.

# LIST responses
CHAN_LIST_SYNTAX
	LIST modle
CHAN_LIST_SERVADMIN_SYNTAX
	LIST modle [FORBIDDEN] [NOEXPIRE]
CHAN_LIST_HEADER
	Liste d'entres correspondantes  %s:
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	Fin de la liste - %d/%d correspondances affiches.

# CLIST responses
CHAN_INVITE_SYNTAX
	INVITE canal

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN canal
CHAN_UNBANNED
	Vous avez t dbanni de %s.

# TOPIC responses
CHAN_TOPIC_SYNTAX
	TOPIC canal [topic]

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR canal raison
CHAN_CLEARED_BANS
	Tous les bans du canal %s ont t supprims.
CHAN_CLEARED_EXCEPTS
	Tous les excepts du canal %s ont t supprims.
CHAN_CLEARED_MODES
	Tous les modes du canal %s ont t rinitialiss.
CHAN_CLEARED_OPS
	Tous les ops du canal %s ont t enlevs.
CHAN_CLEARED_HOPS
	Tous les halfop du canal %s ont t enlevs.
CHAN_CLEARED_VOICES
	Tous les voices du canal %s ont t enlevs.
CHAN_CLEARED_USERS
	Tous les utilisateurs du canal %s ont t kicks.
CHAN_CLEARED_INVITES
	Toutes les invites du canal %s ont t enlevs.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS canal
CHAN_GETPASS_UNAVAILABLE
	La commande GETPASS est indisponible car l'encryption est utilise.
CHAN_GETPASS_PASSWORD_IS
	Le mot de passe du canal %s est %s.
	
# SENDPASS responses
CHAN_GETKEY_SYNTAX
	GETKEY canal
CHAN_GETKEY_NOKEY
	Le canal %s n'a pas de cl.
CHAN_GETKEY_KEY
	La cl du canal %s est %s.

# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS canal
CHAN_SENDPASS_UNAVAILABLE
	La commande SENDPASS est indisponible car l'encryption est utilise.
CHAN_SENDPASS_SUBJECT
	Mot de passe du canal %s
CHAN_SENDPASS_HEAD
	Bonjour,
CHAN_SENDPASS_LINE_1
	Vous avez demand  recevoir le mot de passe du canal %s par e-mail.
CHAN_SENDPASS_LINE_2
	Le mot de passe est %s. Pour des raisons de scurit, vous devriez le changer ds que vous lisez ce mail.
CHAN_SENDPASS_LINE_3
	Si vous ne savez pas de quoi il retourne dans cet e-mail, il s'agit probablement d'une erreur; nous vous prions de nous excuser et vous demandons d'ignorer cet e-mail.
CHAN_SENDPASS_LINE_4
	NE REPONDEZ PAS A CE MAIL!
CHAN_SENDPASS_LINE_5
	Les administrateurs de %s.
CHAN_SENDPASS_OK
	Le mot de passe de %s a t envoy.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID canal [raison]
CHAN_FORBID_SYNTAX_REASON
	FORBID canal raison
CHAN_FORBID_SUCCEEDED
	Le canal %s est maintenant interdit.
CHAN_FORBID_FAILED
	Impossible d'interdire le canal %s!

# Misc responses
CHAN_FORBID_REASON
	Ce canal a t FORBID.

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND canal [raison]
CHAN_SUSPEND_SYNTAX_REASON
	SUSPEND canal raison
CHAN_SUSPEND_SUCCEEDED
	Le canal %s est maintenant suspendu.
CHAN_SUSPEND_FAILED
	Impossible de suspendre le canal %s!
CHAN_SUSPEND_REASON
	Ce canal est suspendu.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND canal
CHAN_UNSUSPEND_ERROR
	Aucun # trouv devant le nom du canal.
CHAN_UNSUSPEND_SUCCEEDED
	Le canal %s est maintenant liber.
CHAN_UNSUSPEND_FAILED
	Impossible de liberer le canal %s!

# Misc responses
CHAN_EXCEPTED
	%s a trouv un except sur %s et ne peut le bannir tant que l'except n'a pas t retir.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	Vous avez 1 nouveau memo.
MEMO_HAVE_NEW_MEMOS
	Vous avez %d nouveaux memos.
MEMO_TYPE_READ_LAST
	Tapez %R%s READ LAST pour le lire.
MEMO_TYPE_READ_NUM
	Tapez %R%s READ %d pour le lire.
MEMO_TYPE_LIST_NEW
	Tapez %R%s LIST NEW pour les lister.
MEMO_AT_LIMIT
	Attention: Vous avez atteint votre nombre maximum de memos (%d).  Vous ne pourrez plus recevoir de nouveaux memos sauf si vous supprimez quelques uns de vos memos actuels. 
MEMO_OVER_LIMIT
	Attention: Vous avez dpass votre nombre maximum de memos (%d).  Vous ne pourrez plus recevoir de nouveaux memos sauf si vous supprimez quelques uns de vos memos actuels. 
MEMO_X_MANY_NOTICE
	Il y a %d memos sur le canal %s.
MEMO_X_ONE_NOTICE
	Il y a %d memo sur le canal %s.
MEMO_NEW_X_MEMO_ARRIVED
	Il y a un nouveau mmo dans le canal %s.
	Tapez %R%s READ %s %d pour le lire.
MEMO_NEW_MEMO_ARRIVED
	Vous avez un nouveau memo de %s.
	Tapez %R%s READ %d pour le lire.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	Vous n'avez pas de memos.
MEMO_X_HAS_NO_MEMOS
	%s n'a pas de memos.
MEMO_DOES_NOT_EXIST
	Memo %d n'existe pas!
MEMO_LIST_NOT_FOUND
	Aucun memo correspondant trouv.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {pseudo | canal} texte-du-memo
MEMO_SEND_DISABLED
	Dsols, l'envoi de memos est temporairement dsactiv.
MEMO_SEND_PLEASE_WAIT
	Veuillez patienter %d secondes avant d'utiliser la commande SEND  nouveau.
MEMO_X_GETS_NO_MEMOS
	%s ne peut recevoir de memos.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s a trop de memos et ne peut en recevoir plus.
MEMO_SENT
	Memo envoy  %s.
	
# CANCEL responses
MEMO_MASS_SENT
	Un mass memo a t envoy a tout les pseudos enregistrs.
	
# CANCEL responses
MEMO_CANCEL_SYNTAX
	CANCEL {pseudo | canal}
MEMO_CANCEL_DISABLED
	Dsols, l'annulation de memos est temporairement dsactive
MEMO_CANCEL_NONE
	Aucun memo n'tait annulable.
MEMO_CANCELLED
	Le dernier memo envoy  %s a t supprim.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [canal] [liste | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	Vous n'avez pas de nouveaux memos.
MEMO_X_HAS_NO_NEW_MEMOS
	%s n'a pas de nouveaux memos.
MEMO_LIST_MEMOS
	Memos pour %s.  Pour lire, tapez: %R%s READ num
MEMO_LIST_NEW_MEMOS
	Nouveaux memos pour %s.  Pour lire, tapez: %R%s READ num
MEMO_LIST_CHAN_MEMOS
	Memos pour %s.  Pour lire, tapez: %R%s READ %s num
MEMO_LIST_CHAN_NEW_MEMOS
	Nouveaux memos pour %s.  Pour lire, tapez: %R%s READ %s num
MEMO_LIST_HEADER
	 Num  Expditeur        Date/Heure
MEMO_LIST_FORMAT
	%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [canal] {liste | LAST | NEW}
MEMO_HEADER
	Memo %d de %s (%s).  Pour supprimer, tapez: %R%s DEL %d
MEMO_CHAN_HEADER
	Memo %d de %s (%s).  Pour supprimer, tapez: %R%s DEL %s %d
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [canal] {num | liste | ALL}
MEMO_DELETED_NONE
	Aucun memo supprim.
MEMO_DELETED_ONE
	Le memo %d a t supprim.
MEMO_DELETED_SEVERAL
	Les memos %s ont t supprims.
MEMO_DELETED_ALL
	Tous vos memos ont t supprims.

# SET responses
MEMO_CHAN_DELETED_ALL
	Tous les mmos du canal %s ont t supprims.

# SET responses
MEMO_SET_SYNTAX
	SET option paramtres
MEMO_SET_DISABLED
	Dsols, la configuration des options est temporairement dsactive.
MEMO_SET_UNKNOWN_OPTION
	Option SET %s inconnue.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s vous notifiera maintenant des memos quand vous vous connectez et quand ils vous sont envoys.
MEMO_SET_NOTIFY_LOGON
	%s vous notifiera maintenant des memos quand vous vous connectez ou enlevez /AWAY.
MEMO_SET_NOTIFY_NEW
	%s vous notifiera maintenant des memos quand ils vous sont envoys.
MEMO_SET_NOTIFY_OFF
	%s ne vous enverra aucune notification de memos.

# SET LIMIT responses
MEMO_SET_NOTIFY_MAIL
	Vous serez maintenant averti par mail de l'arriv de nouveau(x) memo(s).
MEMO_SET_NOTIFY_NOMAIL
	Vous ne serez plus averti par mail de l'arriv de nouveau(x) memo(s).
MEMO_SET_NOTIFY_INVALIDMAIL
	Vous n'avez configurer aucune adresse email pour votre pseudo.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [canal] limite
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [utilisateur | canal] {limite | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	Vous n'tes pas autoris  changer votre limite de memos.
MEMO_SET_LIMIT_FORBIDDEN
	La limite de memos pour %s ne peut tre change.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	Vous ne pouvez mettre votre limite de memos  plus de %d.
MEMO_SET_LIMIT_TOO_HIGH
	Vous ne pouvez mettre la limite de memos de %s  plus de %d.
MEMO_SET_LIMIT_OVERFLOW
	Limite de memos trop grande, limitation  %d.
MEMO_SET_YOUR_LIMIT
	Votre limite de memos a t place  %d.
MEMO_SET_YOUR_LIMIT_ZERO
	Vous ne pourrez dsormais plus recevoir de memos.
MEMO_UNSET_YOUR_LIMIT
	Votre limite de memos a t dsactive.
MEMO_SET_LIMIT
	Limite de memos de %s dfinie  %d.
MEMO_SET_LIMIT_ZERO
	Limite de memos de %s dfinie  0.
MEMO_UNSET_LIMIT
	Limite de memos de %s dsactive.

# INFO responses
MEMO_INFO_SYNTAX
	INFO [canal]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [pseudo | canal]
MEMO_INFO_NO_MEMOS
	Vous n'avez aucun memo actuellement.
MEMO_INFO_MEMO
	Vous avez actuellement 1 memo.
MEMO_INFO_MEMO_UNREAD
	Vous avez actuellement 1 memo, qui n'a pas encore t lu.
MEMO_INFO_MEMOS
	Vous avez actuellement %d memos.
MEMO_INFO_MEMOS_ONE_UNREAD
	Vous avez actuellement %d memos, desquels 1 n'a pas t lu.
MEMO_INFO_MEMOS_SOME_UNREAD
	Vous avez actuellement %d memos, desquels %d n'ont pas t lus.
MEMO_INFO_MEMOS_ALL_UNREAD
	Vous avez actuellement %d memos, aucun d'entre eux n'a t lu.
MEMO_INFO_LIMIT
	Votre limite de memos est de %d.
MEMO_INFO_HARD_LIMIT
	Votre limite de memos est de %d, et ne peut tre change.
MEMO_INFO_LIMIT_ZERO
	Votre limite de memos est de 0, vous ne recevrez aucun nouveau memo.
MEMO_INFO_HARD_LIMIT_ZERO
	Votre limite de memos est de 0, vous ne recevrez aucun nouveau memo.  Vous ne pouvez pas changer cette limite.
MEMO_INFO_NO_LIMIT
	Vous n'avez aucune limite sur le nombre de memos que vous pouvez garder.
MEMO_INFO_NOTIFY_OFF
	Vous ne serez pas notifi des nouveaux memos.
MEMO_INFO_NOTIFY_ON
	Vous serez notifi de nouveaux memos  la connexion et quand ils arrivent.
MEMO_INFO_NOTIFY_RECEIVE
	Vous serez notifi quand de nouveaux memos arrivent.
MEMO_INFO_NOTIFY_SIGNON
	Vous serez notifi de nouveaux memos  la connexion.
MEMO_INFO_X_NO_MEMOS
	%s n'a actuellement aucun memo.
MEMO_INFO_X_MEMO
	%s a actuellement 1 memo.
MEMO_INFO_X_MEMO_UNREAD
	%s a actuellement 1 memo, qui n'a pas encore t lu.
MEMO_INFO_X_MEMOS
	%s a actuellement %d memos.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s a actuellement %d memos, desquels 1 n'a pas t lu.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s a actuellement %d memos, desquels %d n'ont pas t lus.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s a actuellement %d memos, desquels aucun n'a t lu.
MEMO_INFO_X_LIMIT
	La limite de memos de %s est de %d.
MEMO_INFO_X_HARD_LIMIT
	La limite de memos de %s est de %d, qui ne peut pas tre change.
MEMO_INFO_X_NO_LIMIT
	%s n'a aucune limitation de memos.
MEMO_INFO_X_NOTIFY_OFF
	%s n'est pas notifi de nouveaux memos.
MEMO_INFO_X_NOTIFY_ON
	%s est notifi de nouveaux memos quand ils arrivent et  la connexion.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s est notifi quand de nouveaux memos arrivent.
MEMO_INFO_X_NOTIFY_SIGNON
	%s est notifi de nouveaux memos  la connexion.

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
MEMO_MAIL_SUBJECT
	Nouveau memo
MEMO_MAIL_TEXT1
	Bonjour %s,
MEMO_MAIL_TEXT2
	Vous venez de recevoir un memo de %s. Le numro de ce memo est %d.
MEMO_MAIL_TEXT3
	Memo:

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
MEMO_RSEND_PLEASE_WAIT
	Veuillez attendre %d secondes avant d'utiliser RSEND  nouveau.
MEMO_RSEND_DISABLED
	Dsol, RSEND est dsactiv sur ce rseau.
MEMO_RSEND_SYNTAX
	RSEND {pseudo | canal} memo-text
MEMO_RSEND_NICK_MEMO_TEXT
	[auto-memo] Le memo que vous avez envoy a t vu.
MEMO_RSEND_CHAN_MEMO_TEXT
	[auto-memo] Le memo que vous avez envoy a %s a t vu.
MEMO_RSEND_USER_NOTIFICATION
	Un accus de reception a t envoy a %s pour l'informer que vous avez lu son
	memo.

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
MEMO_CHECK_SYNTAX
	CHECK pseudo
MEMO_CHECK_NOT_READ
	Le dernier mmo que vous avez envoy  %s (le %s) n'a pas encore t lu.
MEMO_CHECK_READ
	Le dernier mmo que vous avez envoy  %s (le %s) a t lu.
MEMO_CHECK_NO_MEMO
	Le pseudo %s n'a aucun memo de votre part.

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
MEMO_NO_RSEND_SELF
	Vous ne pouvez pas recevoir d'accus de reception quand vous vous
	tes envoy un message a vous meme.

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
BOT_DOES_NOT_EXIST
	Le bot %s n'existe pas.
BOT_NOT_ASSIGNED
	Vous devez attribuer un bot au canal avant d'utiliser 
	cette commande.
	Tapez %R%S HELP ASSIGN pour plus d'informations.
BOT_NOT_ON_CHANNEL
	Le bot n'est pas sur le canal %s.
	
# Kick reasons (must be a single line)
BOT_REASON_BADWORD
	Ne dites pas %s sur ce channel!
BOT_REASON_BADWORD_GENTLE
	Surveillez vos paroles!
BOT_REASON_BOLD
	N'utilisez pas de caractres gras sur ce channel!
BOT_REASON_CAPS
	Cessez d'utiliser tant de majuscules!
BOT_REASON_COLOR
	N'utilisez pas de couleurs sur ce channel!
BOT_REASON_FLOOD
	Arrtez d'envoyer autant de messages!
BOT_REASON_REPEAT
	Arrtez de vous rpter!
BOT_REASON_REVERSE
	N'utilisez pas de caractres inverss sur ce channel!
BOT_REASON_UNDERLINE
	N'utilisez pas de caractres souligns sur ce channel!
	
# !seen replies
BOT_SEEN_BOT
	Je suis l, %s!
BOT_SEEN_YOU
	%s est en pleine recherche spirituelle...
BOT_SEEN_ON_CHANNEL
	%s est sur le channel actuellement!
BOT_SEEN_ON_CHANNEL_AS
	%s est sur le channel actuellement (c'est %s) ! 
BOT_SEEN_ON
	%s a t vu pour la dernire fois ici il y a %s.
BOT_SEEN_NEVER
	Je n'ai jamais vu %s sur ce channel.
BOT_SEEN_UNKNOWN
	Je ne sais pas qui est %s.

# BOT responses
BOT_BOT_SYNTAX
	BOT ADD pseudo user host real
	BOT CHANGE ancien-pseudo nouveau-pseudo [user [host [real]]]
	BOT DEL pseudo
BOT_BOT_ALREADY_EXISTS
	Le bot %s existe dj.
BOT_BOT_CREATION_FAILED
	Dsols, la cration du bot a chou.
BOT_BOT_READONLY
	Dsols, la modification des bots est temporairement dsactive.
BOT_BOT_ADDED
	%s!%s@%s (%s) ajout  la liste des bots.
BOT_BOT_ANY_CHANGES
	L'ancienne information est gale  la nouvelle.
BOT_BOT_CHANGED
	Le bot %s a t chang en %s!%s@%s (%s)
BOT_BOT_DELETED
	Le bot %s a t supprim.
	
# BOTLIST responses
BOT_BOTLIST_HEADER
	Liste des bots:
BOT_BOTLIST_PRIVATE_HEADER
	Bots rservs aux oprateurs IRC:
BOT_BOTLIST_FOOTER
	%d bots disponibles.
BOT_BOTLIST_EMPTY
	Il n'y a aucun bot disponible actuellement.
	Demandez  un administrateur des services d'en crer un!
	
# ASSIGN responses
BOT_ASSIGN_SYNTAX
	ASSIGN canal pseudo
BOT_ASSIGN_READONLY
	Dsols, l'attribution des bots est temporairement dsactive.
BOT_ASSIGN_ALREADY
	Le bot %s est dja assign au canal %s.
BOT_ASSIGN_ASSIGNED
	Le bot %s a t attribu  %s.
	
# UNASSIGN responses
BOT_UNASSIGN_SYNTAX
	UNASSIGN canal
BOT_UNASSIGN_UNASSIGNED
	Il n'y a plus de bot attribu  %s.
	
# INFO responses
BOT_INFO_SYNTAX
	INFO {canal | pseudo}
BOT_INFO_NOT_FOUND
	%s n'est pas un bot ou canal enregistr valide.
BOT_INFO_BOT_HEADER
	Information pour le bot %s:
BOT_INFO_BOT_MASK
	      Masque : %s@%s
BOT_INFO_BOT_REALNAME
	    Vrai nom : %s
BOT_INFO_BOT_CREATED
	        Cr : %s
BOT_INFO_BOT_USAGE
	 Utilis sur : %d channel(s)
BOT_INFO_BOT_OPTIONS
	     Options : %s
BOT_INFO_OPT_PRIVATE
	Priv
BOT_INFO_CHAN_HEADER
	Information pour le channel %s:
BOT_INFO_CHAN_BOT
	             Nick du bot : %s
BOT_INFO_CHAN_BOT_NONE
	             Nick du bot : non attribu.
BOT_INFO_CHAN_KICK_BADWORDS
	Kicker de mots interdits : %s
BOT_INFO_CHAN_KICK_BADWORDS_BAN
	Kicker de mots interdits : %s (%d kick(s) pour un ban)
BOT_INFO_CHAN_KICK_BOLDS
	     Kicker de car. gras : %s
BOT_INFO_CHAN_KICK_BOLDS_BAN
	     Kicker de car. gras : %s (%d kick(s) pour un ban)
BOT_INFO_CHAN_KICK_CAPS_ON
	    Kicker de majuscules : %s (minimum %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_BAN
	    Kicker de majuscules : %s (%d kick(s) pour un ban; minimum %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_OFF
	    Kicker de majuscules : %s
BOT_INFO_CHAN_KICK_COLORS
	      Kicker de couleurs : %s
BOT_INFO_CHAN_KICK_COLORS_BAN
	      Kicker de couleurs : %s (%d kick(s) pour un ban)
BOT_INFO_CHAN_KICK_FLOOD_ON
	         Kicker de flood : %s (%d lignes en %ds)
BOT_INFO_CHAN_KICK_FLOOD_BAN
	         Kicker de flood : %s (%d kick(s) pour un ban, %d lignes en %ds)
BOT_INFO_CHAN_KICK_FLOOD_OFF
	         Kicker de flood : %s
BOT_INFO_CHAN_KICK_REPEAT_ON
	    Kicker de rptition : %s (%d fois)
BOT_INFO_CHAN_KICK_REPEAT_BAN
	    Kicker de rptition : %s (%d kick(s) pour un ban, %d fois)
BOT_INFO_CHAN_KICK_REPEAT_OFF
	    Kicker de rptition : %s
BOT_INFO_CHAN_KICK_REVERSES
	      Kicker de reverses : %s
BOT_INFO_CHAN_KICK_REVERSES_BAN
	      Kicker de reverses : %s (%d kick(s) pour un ban)
BOT_INFO_CHAN_KICK_UNDERLINES
	Kicker de car. souligns : %s
BOT_INFO_CHAN_KICK_UNDERLINES_BAN
	Kicker de car. souligns : %s (%d kick(s) pour un ban)
BOT_INFO_ACTIVE
	actif
BOT_INFO_INACTIVE
	inactif
BOT_INFO_CHAN_OPTIONS
	                 Options : %s
BOT_INFO_OPT_DONTKICKOPS
	Protection des ops
BOT_INFO_OPT_DONTKICKVOICES
	Protection des voices
BOT_INFO_OPT_FANTASY
	Fantaisie
BOT_INFO_OPT_GREET
	Message d'accueil
BOT_INFO_OPT_NOBOT
	Pas de bot
BOT_INFO_OPT_SYMBIOSIS
	Symbiose
BOT_INFO_OPT_NONE
	Aucune
	
# SET responses
BOT_SET_SYNTAX
	SET canal option paramtres
BOT_SET_DISABLED
	Dsols, la configuration des options du bot est 
	temporairement dsactive.
BOT_SET_UNKNOWN
	Option %s inconnue.
	Tapez %R%S HELP SET pour plus d'informations.
	
# SET DONTKICKOPS messages
BOT_SET_DONTKICKOPS_SYNTAX
	SET canal DONTKICKOPS {ON|OFF}
BOT_SET_DONTKICKOPS_ON
	Le bot ne kickera pas les ops du canal %s.
BOT_SET_DONTKICKOPS_OFF
	Le bot kickera les ops du canal %s.
	
# SET DONTKICKVOICES messages
BOT_SET_DONTKICKVOICES_SYNTAX
	SET canal DONTKICKVOICES {ON|OFF}
BOT_SET_DONTKICKVOICES_ON
	Le bot ne kickera pas les voices du canal %s.
BOT_SET_DONTKICKVOICES_OFF
	Le bot kickera les voices du canal %s.

# SET FANTASY messages
BOT_SET_FANTASY_SYNTAX
	SET canal FANTASY {ON|OFF}
BOT_SET_FANTASY_ON
	La fantaisie est maintenant active sur le canal %s.
BOT_SET_FANTASY_OFF
	La fantaisie est maintenant dsactive sur le canal %s.
	
# SET GREET messages
BOT_SET_GREET_SYNTAX
	SET canal GREET {ON|OFF}
BOT_SET_GREET_ON
	Le message d'accueil est maintenant activ sur le canal %s.
BOT_SET_GREET_OFF
	Le message d'accueil est maintenant dsactiv sur le canal %s.
	
# SET NOBOT
BOT_SET_NOBOT_SYNTAX
	SET canal NOBOT {ON|OFF}
BOT_SET_NOBOT_ON
	Le mode sans bot est maintenant activ sur le canal %s.
BOT_SET_NOBOT_OFF
	Le mode sans bot est maintenant dsactiv sur le canal %s.

# SET PRIVATE
BOT_SET_PRIVATE_SYNTAX
	SET canal PRIVATE {ON|OFF}
BOT_SET_PRIVATE_ON
	Le mode priv du bot %s est maintenant activ.
BOT_SET_PRIVATE_OFF
	Le mode priv du bot %s est maintenant dsactiv.
	
# SET SYMBIOSIS
BOT_SET_SYMBIOSIS_SYNTAX
	SET canal SYMBIOSIS {ON|OFF}
BOT_SET_SYMBIOSIS_ON
	La symbiose est maintenant active sur le canal %s.
BOT_SET_SYMBIOSIS_OFF
	La symbiose est maintenant dsactive sur le canal %s.
	
# KICK responses
BOT_KICK_SYNTAX
	KICK canal option {ON|OFF} [paramtres]
BOT_KICK_DISABLED
	Dsols, la configuration des kickers est temporairement
	dsactive.
BOT_KICK_UNKNOWN
	Option %s inconnue.
	Tapez %R%S HELP KICK pour plus d'informations.
BOT_KICK_BAD_TTB
	%s ne peut tre pris comme nombre de fois pour un ban.

BOT_KICK_BADWORDS_ON
	Le bot kickera maintenant les mots interdits. Utilisez
	la commande BADWORDS pour ajouter ou supprimer un mot.
BOT_KICK_BADWORDS_ON_BAN
	Le bot kickera maintenant les mots interdits, et mettra
	un ban aprs %d kicks pour le mme utilisateur. Utilisez
	la commande BADWORDS pour ajouter ou supprimer un mot.
BOT_KICK_BADWORDS_OFF
	Le bot ne kickera plus les mots interdits.
BOT_KICK_BOLDS_ON
	Le bot kickera maintenant les caractres gras.
BOT_KICK_BOLDS_ON_BAN
	Le bot kickera maintenant les caractres gras, et mettra
	un ban aprs %d kicks pour le mme utilisateur.
BOT_KICK_BOLDS_OFF
	Le bot ne kickera plus les caractres gras.
BOT_KICK_CAPS_ON
	Le bot kickera maintenant les majuscules (qui doivent
	constituer au moins %d caractres et %d%% du message 
	entier).
BOT_KICK_CAPS_ON_BAN
	Le bot kickera maintenant les majuscules (qui doivent
	constituer au moins %d caractres et %d%% du message 
	entier), et mettra un ban aprs %d kicks pour le mme 
	utilisateur.
BOT_KICK_CAPS_OFF
	Le bot ne kickera plus les majuscules.
BOT_KICK_COLORS_ON
	Le bot kickera maintenant les couleurs.
BOT_KICK_COLORS_ON_BAN
	Le bot kickera maintenant les couleurs, et mettra
	un ban aprs %d kicks pour le mme utilisateur.
BOT_KICK_COLORS_OFF
	Le bot ne kickera plus les couleurs.
BOT_KICK_FLOOD_ON
	Le bot kickera maintenant le flood (%d lignes en %d 
	secondes).
BOT_KICK_FLOOD_ON_BAN
	Le bot kickera maintenant le flood (%d lignes en %d 
	secondes), et mettra un ban aprs %d kicks pour le 
	mme utilisateur.
BOT_KICK_FLOOD_OFF
	Le bot ne kickera plus le flood.
BOT_KICK_REPEAT_ON
	Le bot kickera maintenant les rptitions (les 
	utilisateurs qui disent %d fois la mme chose).
BOT_KICK_REPEAT_ON_BAN
	Le bot kickera maintenant les rptitions (les 
	utilisateurs qui disent %d fois la mme chose), et 
	mettra un ban aprs %d kicks pour le  mme utilisateur.
BOT_KICK_REPEAT_OFF
	Le bot ne kickera plus les rptitions.
BOT_KICK_REVERSES_ON
	Le bot kickera maintenant les reverses.
BOT_KICK_REVERSES_ON_BAN
	Le bot kickera maintenant les reverses, et mettra
	un ban aprs %d kicks pour le mme utilisateur.
BOT_KICK_REVERSES_OFF
	Le bot ne kickera plus les reverses.
BOT_KICK_UNDERLINES_ON
	Le bot kickera maintenant les caractres souligns.
BOT_KICK_UNDERLINES_ON_BAN
	Le bot kickera maintenant les caractres souligns, 
	et mettra un ban aprs %d kicks pour le mme 
	utilisateur.
BOT_KICK_UNDERLINES_OFF
	Le bot ne kickera plus les caractres souligns.
	
# BADWORDS messages
BOT_BADWORDS_SYNTAX
	BADWORDS canal {ADD|DEL|LIST|CLEAR} [mot | liste-d'entres] [SINGLE|START|END]
BOT_BADWORDS_DISABLED
	Dsols, la modification de la liste des mots interdits
	est temporairement dsactive.
BOT_BADWORDS_REACHED_LIMIT
	Dsols, vous ne pouvez avoir que %d entres sur la
	liste des mots interdits.
BOT_BADWORDS_ALREADY_EXISTS
	%s existe dj dans la liste des mots interdits de %s.
BOT_BADWORDS_ADDED
	%s ajout  la liste des mots interdits de %s.
BOT_BADWORDS_NO_SUCH_ENTRY
	Entre (#%d) introuvable sur la liste des mots 
	interdits de %s.
BOT_BADWORDS_NOT_FOUND
	%s introuvable sur la liste des mots interdits de %s.
BOT_BADWORDS_NO_MATCH
	Aucune entre correspondante sur la liste des mots interdits 
	de %s.
BOT_BADWORDS_DELETED
	%s supprim de la liste des mots interdits de %s.
BOT_BADWORDS_DELETED_ONE
	1 entre supprime de la liste des mots interdits de %s.
BOT_BADWORDS_DELETED_SEVERAL
	%d entres supprimes de la liste des mots interdits de %s.
BOT_BADWORDS_LIST_EMPTY
	La liste des mots interdits de %s est vide.
BOT_BADWORDS_LIST_HEADER
	Liste des mots interdits de %s:
	  Num   Mot                            Type
BOT_BADWORDS_LIST_FORMAT
	  %3d   %-30s %s
BOT_BADWORDS_CLEAR
	La liste des mots interdits est maintenant vide.

# SAY responses
BOT_SAY_SYNTAX
	SAY canal texte
	
# ACT responses
BOT_ACT_SYNTAX
	ACT canal texte

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
BOT_EXCEPT
	Utilisateur trouv dans les excepts.

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
BOT_BAD_NICK
	Les pseudos des bots ne peuvent contenir que des caractres valide.
BOT_BAD_HOST
	Les hosts des bots doivent contenir uniquement des caractres valide.
BOT_BAD_IDENT
	Les identds des bots doivent contenir que des caractres valide.
BOT_LONG_IDENT
	Bot Idents may only contain 9 characters.
###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Les Services ne peuvent changer les modes. Vos serveurs sont-ils configurs correctement?
OPER_BOUNCY_MODES_U_LINE
	Les Services ne peuvent changer les modes. Les U:lines de vos serveurs sont-elles configures correctement?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL message

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Option STATS inconnue %s.
OPER_STATS_CURRENT_USERS
	Utilisateurs courants: %d (%d ops)
OPER_STATS_MAX_USERS
	Utilisateurs maximum: %d (%s)
# This is ugly, but at least it's language-portable...
# Note that you can include seconds in any of these--my personal preference
# is to only give resolution to the nearest minute when uptime is one hour
# or more, but just add a %d to get seconds as well.
OPER_STATS_UPTIME_DHMS
	Les services tournent depuis %d jours, %02d:%02d
OPER_STATS_UPTIME_1DHMS
	Les services tournent depuis %d jour, %02d:%02d
OPER_STATS_UPTIME_HMS
	Les services tournent depuis %d heures, %d minutes
OPER_STATS_UPTIME_HM1S
	Les services tournent depuis %d heures, %d minutes
OPER_STATS_UPTIME_H1MS
	Les services tournent depuis %d heures, %d minute
OPER_STATS_UPTIME_H1M1S
	Les services tournent depuis %d heures, %d minute
OPER_STATS_UPTIME_1HMS
	Les services tournent depuis %d heure, %d minutes
OPER_STATS_UPTIME_1HM1S
	Les services tournent depuis %d heure, %d minutes
OPER_STATS_UPTIME_1H1MS
	Les services tournent depuis %d heure, %d minute
OPER_STATS_UPTIME_1H1M1S
	Les services tournent depuis %d heure, %d minute
OPER_STATS_UPTIME_MS
	Les services tournent depuis %d minutes, %d secondes
OPER_STATS_UPTIME_M1S
	Les services tournent depuis %d minutes, %d seconde
OPER_STATS_UPTIME_1MS
	Les services tournent depuis %d minute, %d secondes
OPER_STATS_UPTIME_1M1S
	Les services tournent depuis %d minute, %d seconde
OPER_STATS_BYTES_READ
	Octets lus    : %5d ko
OPER_STATS_BYTES_WRITTEN
	Octets crits : %5d ko
OPER_STATS_USER_MEM
	Utilisateur   : %6d enregistrements, %5d ko
OPER_STATS_CHANNEL_MEM
	Channel       : %6d enregistrements, %5d ko
OPER_STATS_GROUPS_MEM
	Groupes NS    : %6d enregistrements, %5d ko
OPER_STATS_ALIASES_MEM
	Aliases NS    : %6d enregistrements, %5d ko
OPER_STATS_CHANSERV_MEM
	ChanServ      : %6d enregistrements, %5d ko
OPER_STATS_BOTSERV_MEM
	BotServ       : %6d enregistrements, %5d ko
OPER_STATS_OPERSERV_MEM
	OperServ      : %6d enregistrements, %5d ko
OPER_STATS_SESSIONS_MEM
	Sessions      : %6d enregistrements, %5d ko
OPER_STATS_AKILL_COUNT
	Nombre d'AKILLs actuel: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	Temps d'chance des AKILLs par dfaut: %d jours
OPER_STATS_AKILL_EXPIRE_DAY
	Temps d'chance des AKILLs par dfaut: 1 jour
OPER_STATS_AKILL_EXPIRE_HOURS
	Temps d'chance des AKILLs par dfaut: %d heures
OPER_STATS_AKILL_EXPIRE_HOUR
	Temps d'chance des AKILLs par dfaut: 1 heure
OPER_STATS_AKILL_EXPIRE_MINS
	Temps d'chance des AKILLs par dfaut: %d minutes
OPER_STATS_AKILL_EXPIRE_MIN
	Temps d'chance des AKILLs par dfaut: 1 minute
OPER_STATS_AKILL_EXPIRE_NONE
	Temps d'chance des AKILLs par dfaut: Pas d'chance
OPER_STATS_SGLINE_COUNT
	Nombre de SGLINEs actuel: %d
OPER_STATS_SGLINE_EXPIRE_DAYS
	Temps d'chance des SGLINEs par dfaut: %d jours
OPER_STATS_SGLINE_EXPIRE_DAY
	Temps d'chance des SGLINEs par dfaut: 1 jour
OPER_STATS_SGLINE_EXPIRE_HOURS
	Temps d'chance des SGLINEs par dfaut: %d heures
OPER_STATS_SGLINE_EXPIRE_HOUR
	Temps d'chance des SGLINEs par dfaut: 1 heure
OPER_STATS_SGLINE_EXPIRE_MINS
	Temps d'chance des SGLINEs par dfaut: %d minutes
OPER_STATS_SGLINE_EXPIRE_MIN
	Temps d'chance des SGLINEs par dfaut: 1 minute
OPER_STATS_SGLINE_EXPIRE_NONE
	Temps d'chance des SGLINEs par dfaut: Pas d'chance
OPER_STATS_SQLINE_COUNT
	Nombre de SQLINEs actuel: %d
OPER_STATS_SQLINE_EXPIRE_DAYS
	Temps d'chance des SQLINEs par dfaut: %d jours
OPER_STATS_SQLINE_EXPIRE_DAY
	Temps d'chance des SQLINEs par dfaut: 1 jour
OPER_STATS_SQLINE_EXPIRE_HOURS
	Temps d'chance des SQLINEs par dfaut: %d heures
OPER_STATS_SQLINE_EXPIRE_HOUR
	Temps d'chance des SQLINEs par dfaut: 1 heure
OPER_STATS_SQLINE_EXPIRE_MINS
	Temps d'chance des SQLINEs par dfaut: %d minutes
OPER_STATS_SQLINE_EXPIRE_MIN
	Temps d'chance des SQLINEs par dfaut: 1 minute
OPER_STATS_SQLINE_EXPIRE_NONE
	Temps d'chance des SQLINEs par dfaut: Pas d'chance
OPER_STATS_SZLINE_COUNT
	Nombre de SZLINEs actuel: %d
OPER_STATS_SZLINE_EXPIRE_DAYS
	Temps d'chance des SZLINEs par dfaut: %d jours
OPER_STATS_SZLINE_EXPIRE_DAY
	Temps d'chance des SZLINEs par dfaut: 1 jour
OPER_STATS_SZLINE_EXPIRE_HOURS
	Temps d'chance des SZLINEs par dfaut: %d heures
OPER_STATS_SZLINE_EXPIRE_HOUR
	Temps d'chance des SZLINEs par dfaut: 1 heure
OPER_STATS_SZLINE_EXPIRE_MINS
	Temps d'chance des SZLINEs par dfaut: %d minutes
OPER_STATS_SZLINE_EXPIRE_MIN
	Temps d'chance des SZLINEs par dfaut: 1 minute
OPER_STATS_SZLINE_EXPIRE_NONE
	Temps d'chance des SZLINEs par dfaut: Pas d'chance
OPER_STATS_RESET
	Statistiques rinitialises.

# MODE responses
OPER_STATS_UPLINK_SERVER
	Connect : %s
OPER_STATS_UPLINK_CAPAB
	Caractristiques du link: %s
OPER_STATS_UPLINK_SERVER_COUNT
	Serveurs trouvs: %d

# MODE responses
OPER_MODE_SYNTAX
	MODE canal modes

# CLEARMODES responses
OPER_UMODE_SYNTAX
	UMODE pseudo modes

# OLINE responses
OPER_UMODE_SUCCESS
	Mode de %s changs.
OPER_UMODE_CHANGED
	%s a chang vos modes.

# OLINE responses
OPER_OLINE_SYNTAX
	OLINE pseudo flags
OPER_OLINE_SUCCESS
	Une O:LINE avec les flags %s a t ajoute pour %s.

# CLEARMODES responses
OPER_OLINE_IRCOP
	Vous tes maintenant IRCOp.

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES canal [ALL]
OPER_CLEARMODES_DONE
	Les modes binaires et les bans sont supprims de %s.
OPER_CLEARMODES_ALL_DONE
	Tous les modes supprims du channel %s.


# KICK responses
OPER_KICK_SYNTAX
	KICK canal utilisateur raison

# ADMIN responses
OPER_SVSNICK_SYNTAX
	SVSNICK pseudo nouveau-pseudo 
OPER_SVSNICK_NEWNICK
	Le pseudo de %s a t chang en %s.
	
# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD|DEL|LIST|CLEAR} [pseudo | entry-list]
OPER_ADMIN_SKELETON
	Les services sont en mode skeleton, la commande ADMIN n'est pas disponible.
OPER_ADMIN_EXISTS
	%s est dj sur la liste des Services admins.
OPER_ADMIN_REACHED_LIMIT
	Vous ne pouvez avoir que %d Services admins.
OPER_ADMIN_ADDED
	%s a t ajout  la liste des Services admins.
OPER_ADMIN_NOT_FOUND
	%s est introuvable sur la liste des Services admins.
OPER_ADMIN_NO_MATCH
	Aucune entre correspondante sur la liste des Services admins.
OPER_ADMIN_DELETED
	%s a t supprim de la liste des Services admins.
OPER_ADMIN_DELETED_ONE
	1 entre a t supprime de la liste des Services admins.
OPER_ADMIN_DELETED_SEVERAL
	%d entres ont t supprimes de la liste des Services admins.
OPER_ADMIN_LIST_EMPTY
	La liste des Services admins est vide.
OPER_ADMIN_LIST_HEADER
	Liste des Services admins:
	  Num   Pseudo
OPER_ADMIN_LIST_FORMAT
	  %3d   %s
OPER_ADMIN_CLEAR
	La liste des Services admins a t vide.
OPER_ADMIN_MOVED
	%s a t retir de la liste des services admins.

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD|DEL|LIST|CLEAR} [pseudo | entry-list]
OPER_OPER_SKELETON
	Les services sont en mode skeleton, la commande OPER n'est pas disponible.
OPER_OPER_EXISTS
	%s est dj sur la liste des Services oper.
OPER_OPER_REACHED_LIMIT
	Vous ne pouvez avoir que %d Services oper.
OPER_OPER_ADDED
	%s a t ajout  la liste des Services oper.
OPER_OPER_NOT_FOUND
	%s est introuvable sur la liste des Services oper.
OPER_OPER_NO_MATCH
	Aucune entre correspondante sur la liste des Services oper.
OPER_OPER_DELETED
	%s a t supprim de la liste des Services oper.
OPER_OPER_DELETED_ONE
	1 entre a t supprime de la liste des Services oper.
OPER_OPER_DELETED_SEVERAL
	%d entres ont t supprimes de la liste des Services oper.
OPER_OPER_LIST_EMPTY
	La liste des Services oper est vide.
OPER_OPER_LIST_HEADER
	Liste des Services oper:
	  Num   Pseudo
OPER_OPER_LIST_FORMAT
	  %3d   %s
OPER_OPER_CLEAR
	La liste des Services oper a t vide.
OPER_OPER_MOVED
	%s a t boug dans la liste des services oper.

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | CLEAR} [[+chance] {masque | liste d'entres} [raison]]
OPER_AKILL_EXISTS
	%s existe dj sur la liste d'AKILL.
OPER_AKILL_ALREADY_COVERED
	%s est dj couvert par %s.
OPER_AKILL_REACHED_LIMIT
	Dsol, vous ne pouvez avoir que %d AKILLs.
OPER_AKILL_NO_NICK
	Rappel: les masques AKILL ne peuvent contenir de pseudo, assurez vous que vous n'avez pas mis de partie pseudo dans le masque.
OPER_AKILL_ADDED
	%s ajout  la liste d'AKILL.
OPER_AKILL_CHANGED
	L'chance de %s a t change.
OPER_AKILL_NOT_FOUND
	%s introuvable sur la liste d'AKILL.
OPER_AKILL_NO_MATCH
	Aucune entre correspondante sur la liste d'AKILL.
OPER_AKILL_DELETED
	%s supprim de la liste d'AKILL.
OPER_AKILL_DELETED_ONE
	1 entre supprime de la liste d'AKILL.
OPER_AKILL_DELETED_SEVERAL
	%d entres supprimes de la liste d'AKILL.
OPER_AKILL_LIST_EMPTY
	La liste d'AKILL est vide.
OPER_AKILL_LIST_HEADER
	Liste d'AKILL actuelle:
	  Num   Masque                            Raison
OPER_AKILL_LIST_FORMAT
	  %3d   %-32s  %s
OPER_AKILL_VIEW_HEADER
	Liste d'AKILL actuelle:
# number, mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_FORMAT
	%3d  %s (par %s le %s; %s)
	      %s
OPER_AKILL_CLEAR
	La liste d'AKILL a t vide.

# SGLINE responses
OPER_CHANKILL_SYNTAX
	CHANKILL [+expiry] {#canal} [raison]
# SGLINE responses
OPER_SGLINE_SYNTAX
	SGLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+chance] {masque | liste d'entres} [raison]]
OPER_SGLINE_UNSUPPORTED
	Dsol, SGLINE n'est pas disponible sur ce rseau.
OPER_SGLINE_EXISTS
	%s existe dj sur la liste de SGLINEs.
OPER_SGLINE_ALREADY_COVERED
	%s est dj couvert par %s.
OPER_SGLINE_REACHED_LIMIT
	Dsol, vous ne pouvez avoir que %d SGLINEs.
OPER_SGLINE_ADDED
	%s ajout  la liste de SGLINEs.
OPER_SGLINE_CHANGED
	L'chance de %s a t change.
OPER_SGLINE_NOT_FOUND
	%s introuvable sur la liste de SGLINEs.
OPER_SGLINE_NO_MATCH
	Aucune entre correspondante sur la liste de SGLINEs.
OPER_SGLINE_DELETED
	%s supprim de la liste de SGLINEs.
OPER_SGLINE_DELETED_ONE
	1 entre supprime de la liste de SGLINEs.
OPER_SGLINE_DELETED_SEVERAL
	%d entres supprimes de la liste de SGLINEs.
OPER_SGLINE_LIST_EMPTY
	La liste de SGLINEs est vide.
OPER_SGLINE_LIST_HEADER
	Liste de SGLINEs actuelle:
	  Num   Masque                            Raison
OPER_SGLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SGLINE_VIEW_HEADER
	Liste de SGLINEs actuelle:
# number, mask, set-by, set-time, expires, reason
OPER_SGLINE_VIEW_FORMAT
	%3d  %s (par %s le %s; %s)
	      %s
OPER_SGLINE_CLEAR
	La liste de SGLINEs a t vide.

# SQLINE responses
OPER_SQLINE_SYNTAX
	SQLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+chance] {masque | liste d'entres}[:raison]]
OPER_SQLINE_CHANNELS_UNSUPPORTED
	Les SQLINEs de channels ne sont pas supports par votre serveur, vous ne pouvez donc pas les utiliser.
OPER_SQLINE_EXISTS
	%s existe dj sur la liste de SQLINEs.
OPER_SQLINE_ALREADY_COVERED
	%s est dj couvert par %s.
OPER_SQLINE_REACHED_LIMIT
	Dsol, vous ne pouvez avoir que %d SQLINEs.
OPER_SQLINE_ADDED
	%s ajout  la liste de SQLINEs.
OPER_SQLINE_CHANGED
	L'chance de %s a t change.
OPER_SQLINE_NOT_FOUND
	%s introuvable sur la liste de SQLINEs.
OPER_SQLINE_NO_MATCH
	Aucune entre correspondante sur la liste de SQLINEs.
OPER_SQLINE_DELETED
	%s supprim de la liste de SQLINEs.
OPER_SQLINE_DELETED_ONE
	1 entre supprime de la liste de SQLINEs.
OPER_SQLINE_DELETED_SEVERAL
	%d entres supprimes de la liste de SQLINEs.
OPER_SQLINE_LIST_EMPTY
	La liste de SQLINEs est vide.
OPER_SQLINE_LIST_HEADER
	Liste de SQLINEs actuelle:
	  Num   Masque                            Raison
OPER_SQLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SQLINE_VIEW_HEADER
	Liste de SQLINEs actuelle:
# number, mask, set-by, set-time, expires, reason
OPER_SQLINE_VIEW_FORMAT
	%3d  %s (par %s le %s; %s)
	      %s
OPER_SQLINE_CLEAR
	La liste de SQLINEs a t vide.
	
# SZLINE responses
OPER_SZLINE_SYNTAX
	SZLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+chance] {masque | liste d'entres} [raison]]
OPER_SZLINE_UNSUPPORTED
	Dsol, SZLINE n'est pas disponible sur ce rseau.
OPER_SZLINE_EXISTS
	%s existe dj sur la liste de SZLINEs.
OPER_SZLINE_ALREADY_COVERED
	%s est dj couvert par %s.
OPER_SZLINE_REACHED_LIMIT
	Dsol, vous ne pouvez avoir que %d SZLINEs.
OPER_SZLINE_ONLY_IPS
	Rappel: vous ne pouvez ajouter que des masques d'IP  la liste de SZLINEs.
OPER_SZLINE_ADDED
	%s ajout  la liste de SZLINEs.
OPER_SZLINE_CHANGED
	L'chance de %s a t change.
OPER_SZLINE_NOT_FOUND
	%s introuvable sur la liste de SZLINEs.
OPER_SZLINE_NO_MATCH
	Aucune entre correspondante sur la liste de SZLINEs.
OPER_SZLINE_DELETED
	%s supprim de la liste de SZLINEs.
OPER_SZLINE_DELETED_ONE
	1 entre supprime de la liste de SZLINEs.
OPER_SZLINE_DELETED_SEVERAL
	%d entres supprimes de la liste de SZLINEs.
OPER_SZLINE_LIST_EMPTY
	La liste de SZLINEs est vide.
OPER_SZLINE_LIST_HEADER
	Liste de SZLINEs actuelle:
	  Num   Masque                            Raison
OPER_SZLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SZLINE_VIEW_HEADER
	Liste de SZLINEs actuelle:
# number, mask, set-by, set-time, expires, reason
OPER_SZLINE_VIEW_FORMAT
	%3d  %s (par %s le %s; %s)
	      %s
OPER_SZLINE_CLEAR
	La liste de SZLINEs a t vide.

# SET responses
OPER_SET_SYNTAX
	SET option valeur
OPER_SET_IGNORE_ON
	Le code d'ignore sera utilis.
OPER_SET_IGNORE_OFF
	Le code d'ignore ne sera pas utilis.
OPER_SET_IGNORE_ERROR
	La valeur pour IGNORE doit tre ON ou OFF.
OPER_SET_READONLY_ON
	Les Services sont maintenant en mode lecture-seule.
OPER_SET_READONLY_OFF
	Les Services sont maintenant en mode lecture-criture.
OPER_SET_READONLY_ERROR
	La valeur pour READONLY doit tre ON ou OFF.
OPER_SET_LOGCHAN_ON
	Les services reporteront maintenant les logs sur %s.
OPER_SET_LOGCHAN_OFF
	Les services ne reporteront plus les logs sur un canal.
OPER_SET_LOGCHAN_ERROR
	Les valeurs pour LOGCHAN doivent etre ON ou OFF et LogChannel dois etre dfini.
OPER_SET_DEBUG_ON
	Les Services sont maintenant en debug mode.
OPER_SET_DEBUG_OFF
	Les Services sont maintenant en non-debug mode.
OPER_SET_DEBUG_LEVEL
	Les Services sont maintenant en debug mode (level %d).
OPER_SET_DEBUG_ERROR
	La valeur pour DEBUG doit tre ON, OFF, ou un nombre positif.
OPER_SET_NOEXPIRE_ON
	Les Services sont maintenant en mode sans expiration.
OPER_SET_NOEXPIRE_OFF
	Les Services sont maintenant en mode expiration.
OPER_SET_NOEXPIRE_ERROR
	La valeur de NOEXPIRE doit tre ON ou OFF.
OPER_SET_UNKNOWN_OPTION
	Option inconnue %s.
OPER_SET_SQL_ON
	Le code SQL dois etre utilis.
OPER_SET_SQL_OFF
	Le code SQL ne dois pas etre utilis.
OPER_SET_SQL_ERROR
	Les configurations pour SQL doivent etre ON ou OFF.
OPER_SET_SQL_ERROR_INIT
	Erreur durant l'initialisation de SQL, verifier les logs pour corriger l'erreur.
OPER_SET_SQL_ERROR_DISABLED
	SQL n'est pas configur pour ce rseau. Editer le fichier
	de configuration (services.conf) pour l'activer.
OPER_SET_LIST_OPTION_ON
	%s est activ
OPER_SET_LIST_OPTION_OFF
	%s est dsactiv

# NOOP responses
OPER_NOOP_SYNTAX
	NOOP {SET|REVOKE} serveur
OPER_NOOP_SET
	Toutes les O:lines de %s ont t supprimes.
OPER_NOOP_REVOKE
	Toutes les O:lines de %s ont t rinitialises.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE nom-du-serveur [raison]

# RAW responses
OPER_JUPE_HOST_ERROR
	Veuillez indiquer un nom de serveur valide pour JUPE.
	
# RAW responses
OPER_RAW_SYNTAX
	RAW texte

# UPDATE responses
OPER_UPDATING
	Mise  jour des bases de donnes.
	
# RELOAD responses
OPER_RELOAD
	Le fichier de configuration des Services a t recharg.

# RESTART responses
OPER_CANNOT_RESTART
	SERVICES_BIN non dfini, impossible de redmarrer redmarrer.  
	Relancez le script \2configure\2 et recompilez les Services pour 
	activer la commande RESTART.

# LISTIGNORE responses
OPER_IGNORE_SYNTAX
	Syntaxe: IGNORE {ADD|DEL|LIST|CLEAR} [dure] [pseudo]
OPER_IGNORE_VALID_TIME
	Vous devez entrer une dure valide
OPER_IGNORE_TIME_DONE
	%s est ignor pour %s.
OPER_IGNORE_PERM_DONE
	%s est ignor en permanance.
OPER_IGNORE_DEL_DONE
	%s n'est plus ignor
OPER_IGNORE_LIST
	Liste des ignores:
OPER_IGNORE_LIST_NOMATCH
	%s n'a pas t trouv dans la liste des ignores.
OPER_IGNORE_LIST_EMPTY
	La liste des ignores est vide.
	
# KILLCLONES responses
OPER_IGNORE_LIST_CLEARED
	La liste des ignores a t purg.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES pseudo
OPER_KILLCLONES_UNKNOWN_NICK
	Impossible de trouver l'utilisateur %s.
	
# CHANLIST responses
OPER_CHANLIST_HEADER
	Liste des channels:
	Nom                  Users Modes   Topic
OPER_CHANLIST_HEADER_USER
	Liste des channels de %s:
	Nom                  Users Modes   Topic
OPER_CHANLIST_RECORD
	%-20s  %4d +%-6s %s
OPER_CHANLIST_END
	Fin de la liste des channels.
	
# USERLIST responses
OPER_USERLIST_HEADER
	Liste des utilisateurs:
	Nick                 Masque
OPER_USERLIST_HEADER_CHAN
	Liste des utilisateurs de %s:
	Nick                 Masque
OPER_USERLIST_RECORD
	%-20s %s@%s
OPER_USERLIST_END
	Fin de la liste des utilisateurs.

# CACHE responses
OPER_SUPER_ADMIN_ON
	Vous tes maintenant SuperAdmin.
OPER_SUPER_ADMIN_OFF
	Vous n'tes plus SuperAdmin
OPER_SUPER_ADMIN_SYNTAX
	Syntaxe incorrect, spcifiez ON ou OFF.
OPER_SUPER_ADMIN_WALL_ON
	%s est maintenant SuperAdmin
OPER_SUPER_ADMIN_WALL_OFF
	%s n'est plus SuperAdmin

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_SUPER_ADMIN_ONLY
	Seulement les SuperAdmins peuvent utiliser cette commande.

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_STAFF_LIST_HEADER
	On Level Pseudo

# DefCon Messages

OPER_STAFF_FORMAT
	 %c %s  %s
OPER_STAFF_AFORMAT
	 %c %s  %s [%s]

# DefCon Messages

OPER_DEFCON_SYNTAX
	Syntaxe: DEFCON [1|2|3|4|5]
OPER_DEFCON_DENIED
	Ce service est temporairement dsactiv, veuillez ressayer ultrieurement.
OPER_DEFCON_NO_CONF
	Defcon dois etre activ dans le fichier services.conf.
OPER_DEFCON_CHANGED
	Les services sont maintenant sur DEFCON %d.
OPER_DEFCON_WALL
	%s a chang le niveau de DEFCON en %d.
DEFCON_GLOBAL
	Le niveau de DEFCON est maintenant: %d.

# Modules strings

OPER_MODULE_LOADED
	Le module %s a t charg.
OPER_MODULE_UNLOADED
	Le module %s a t dcharg.
OPER_MODULE_LOAD_FAIL
	Impossible de charger le module %s.
OPER_MODULE_REMOVE_FAIL
	Impossible de dchager le module %s.
OPER_MODULE_NO_UNLOAD
	Ce module ne peux pas etre dcharg.
OPER_MODULE_LOAD_SYNTAX
	MODLOAD Fichier
OPER_MODULE_UNLOAD_SYNTAX
	MODUNLOAD Fichier
OPER_MODULE_LIST_HEADER
	Liste des modules courant:
OPER_MODULE_LIST
	Module: %s [%s] [%s]
OPER_MODULE_LIST_FOOTER
	%d Modules changs.
OPER_MODULE_INFO_LIST
	Module: %s Version: %s Auteur: %s charg: %s
OPER_MODULE_CMD_LIST
	Fournir la commande: %R%s %s
OPER_MODULE_MSG_LIST
	Providing IRCD handler for: %s
OPER_MODULE_NO_LIST
	Aucun module n'est charg
OPER_MODULE_NO_INFO
	Aucune information sur le module %s n'est accssible.
OPER_MODULE_INFO_SYNTAX
	MODINFO Fichier

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
MODULE_HELP_HEADER
	Cette commande est charg via un module:

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [paramtres]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+chance] mask limite raison
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {mask | liste}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE num position
OPER_EXCEPTION_DISABLED
	La limitation de sessions est dsactive.
OPER_EXCEPTION_ALREADY_PRESENT
	Le mask %s est dj prsent sur la liste d'exceptions.
OPER_EXCEPTION_TOO_MANY
	La liste des exceptions  la limitation de sessions est pleine!
OPER_EXCEPTION_ADDED
	La limite de sessions de %s est maintenant de %d.
OPER_EXCEPTION_MOVED
	L'exception pour %s (#%d) a t dplace  la position %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	L'entre %d n'existe pas sur la liste des exceptions  la limitation de sessions.
OPER_EXCEPTION_NOT_FOUND
	%s non trouv sur la liste des exceptions  la limitation de sessions.
OPER_EXCEPTION_NO_MATCH
	Aucune entre correspondante sur la liste des exceptions  la limitation de sessions.
OPER_EXCEPTION_DELETED
	%s supprim de la liste des exceptions  la limitation de sessions.
OPER_EXCEPTION_DELETED_ONE
	1 entre supprime de la liste des exceptions  la limitation de sessions.
OPER_EXCEPTION_DELETED_SEVERAL
	%d entres supprimes de la liste des exceptions  la limitation de sessions.
OPER_EXCEPTION_LIST_HEADER
	Liste actuelle des exceptions  la limitation de sessions:
# mask, limit
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d    %s
OPER_EXCEPTION_LIST_COLHEAD
	Num  Limite  Host
# mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (par %s le %s; %s)
	    Limite: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	Limite de session invalide. Elle doit tre un entier valide suprieur ou gal  zero et plus petit que %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	Hostmask invalide. Seuls les hostmasks rels sont valides puisque les exceptions ne sont pas compars aux pseudos et usernames.
OPER_EXCEPTION_EXISTS
	%s existe deja dans la liste des exceptions.
OPER_EXCEPTION_CHANGED
	L'exception pour %s a t chang en %d.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST limite | VIEW host}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST limite
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW host
OPER_SESSION_DISABLED
	La limitation de session est dsactive.
OPER_SESSION_INVALID_THRESHOLD
	Valeur minimale invalide. Elle doit tre un entier valide suprieur  1.
OPER_SESSION_NOT_FOUND
	%s introuvable sur la liste des sessions.
OPER_SESSION_LIST_HEADER
	Hosts ayant au moins %d sessions:
OPER_SESSION_LIST_COLHEAD
	Sessions  Host
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	L'host %s a actuellement %d sessions avec une limite de %d.

# EXCEPTION help

OPER_HELP_EXCEPTION
	Syntax: EXCEPTION ADD [+chance] mask limite raison
	        EXCEPTION DEL {mask | liste}
	        EXCEPTION MOVE num position
	        EXCEPTION LIST [mask | liste]
	        EXCEPTION VIEW [mask | liste]
	
	Permet aux Services admins de manipuler la liste des hosts qui
	ont des limites de session spcifiques - autoriser certaines
	machines, telles que des servers de shell, pour supporter plus
	que le nombre de clients par dfaut  la fois. Une fois qu'une
	host atteint sa limite de session, tous les clients essayant
	de se connecter de cette host seront dconnects. Avant que
	l'utilisateur ne soit dconnect, ils sont avertis, par un
	/NOTICE de %S, de l'endroit o ils pourront trouver de
	l'aide concernant la limitation de session. Le contenu de cette
	notice est une option de configuration.
	
	EXCEPTION ADD ajoute le mask donn  la liste des exceptions.
	Notez que les masks nick!user@host et user@host sont 
	invalides! Seuls les masks d'host rels, tels que box.host.dom 
	et *.host.dom, sont autoriss parce que la limitation de sessions
	ne prend pas en compte le nick ou l'username. limit doit tre un
	nombre suprieur ou gal  zero. Ceci dtermine combien de sessions
	sont supportes  la fois. Une valeur de zero signifie que l'host
	a une limite de sessions illimite. Consultez l'aide de AKILL pour
	les dtails sur le format du paramtre optionnel chance.
	EXCEPTION DEL supprime le mask donn de la liste des exceptions.
	EXCEPTION MOVE dplace l'exception num vers position. Les 
	exceptions se trouvant entre seront dplaces vers le haut ou le
	bas pour combler le trou.
	EXCEPTION LIST et EXCEPTION VIEW montrent toutes les 
	exceptions actuelles; si un mask optionnel est donn, la liste
	est limite aux exceptions correspondantes au mask. La diffrence
	est que EXCEPTION VIEW est plus informative, puisqu'elle affiche
	galement le nick de la personne qui a ajout l'exception, sa 
	limite de sessions, la raison, le mask ainsi que la date d'chance.
	
	Notez qu'un client se connectant "utilisera" la premire 
	exception  laquelle leur host correspond. Les
	grandes listes d'exception et les exceptions utilisant
	excessivement les wildcards entrainent une dgradation des
	performances des Services.
	
	Rserve aux Services admins.

OPER_HELP_SESSION
	Syntax: SESSION LIST minimal
	        SESSION VIEW host
	
	Permet aux Services admins de voir la liste des sessions.
	
	SESSION LIST liste les hosts ayant au minimum minimal
	sessions. La limite minimale doit tre un nombre suprieur 
	1. Ceci pour prvenir d'un listing accidentel d'un large
	nombre d'hosts  session unique.

	SESSION VIEW affiche des informations dtailles sur une
	host spcifique - comprenant le nombre de sessions actuelles
	ainsi que la limite de sessions. La valeur host ne doit
	pas contenir de wildcards.
	    
	Consultez l'aide de EXCEPTION pour plus d'informations 
	concernant la limitation et comment dfinir les limites de
	sessions pour certaines hosts et groupes.
	
	Rserve aux Services admins.

###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_STAFF
	Syntaxe: STAFF

	Affiche tout les pseudos du staff des services avec leur
	niveau d'accs et leur status (online/offline).

OPER_HELP_DEFCON
	Syntax: DEFCON [1|2|3|4|5]

	Le systme defcon utilise et applique des configurations
	pr-definies pour proteger durant une attaque sur le rseau.
	attack on the network.

OPER_HELP_DEFCON_NO_NEW_CHANNELS
	* Enregistrement de nouveaux canaux bloqu
OPER_HELP_DEFCON_NO_NEW_NICKS
	* Enregistrement de nouveaux pseudo bloqu
OPER_HELP_DEFCON_NO_MLOCK_CHANGE
	* Changement des MLOCK bloqu
OPER_HELP_DEFCON_FORCE_CHAN_MODES
	* Application des modes %s sur tout les canaux.
OPER_HELP_DEFCON_REDUCE_SESSION
	* Utilisation du nombre maxi de session a %d
OPER_HELP_DEFCON_NO_NEW_CLIENTS
	* Kill toutes nouvelles connexions client
OPER_HELP_DEFCON_OPER_ONLY
	* Ignore tout les non opers pour les messages
OPER_HELP_DEFCON_SILENT_OPER_ONLY
	* Ignore silencieusement les non-opers
OPER_HELP_DEFCON_AKILL_NEW_CLIENTS
	* AKILL toutes les nouvelles connexions


###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_DEFCON_NO_NEW_MEMOS
	* Aucun(s) nouveau(x) memo(s) envoy(s)
OPER_HELP_CHANKILL
	Syntaxe: CHANKILL [+expire] canal raison

	Inflige un AKILL a toutes les personnes qui sont sur le canal
	spcifi. Ceci utilise le rel identd@host de tout les pseudos. 

###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Logon News - %s] %s
NEWS_OPER_TEXT
	[Oper News - %s] %s

NEWS_RANDOM_TEXT
	[News Alatoire - %s] %s

NEWS_LOGON_SYNTAX
	Syntaxe: LOGONNEWS {ADD|DEL|LIST} [texte|nombre]
NEWS_LOGON_LIST_HEADER
	Articles des logon news:
NEWS_LOGON_LIST_ENTRY
	%5d (%s par %s)
	    %s
NEWS_LOGON_LIST_NONE
	Il n'y a pas de logon news.
NEWS_LOGON_ADD_SYNTAX
	Syntaxe: LOGONNEWS ADD texte
NEWS_LOGON_ADD_FULL
	La liste des News est pleine!
NEWS_LOGON_ADDED
	Ajout un nouvel article de logon news (#%d).
NEWS_LOGON_DEL_SYNTAX
	Syntaxe: LOGONNEWS DEL {num | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Article de logon news #%d non trouv!
NEWS_LOGON_DELETED
	Article de logon news #%d supprim.
NEWS_LOGON_DEL_NONE
	Aucun article de logon news  supprimer!
NEWS_LOGON_DELETED_ALL
	Tous les articles de logon news supprims.

NEWS_OPER_SYNTAX
	Syntaxe: OPERNEWS {ADD|DEL|LIST} [texte|nombre]
NEWS_OPER_LIST_HEADER
	Articles oper news:
NEWS_OPER_LIST_ENTRY
	%5d (%s par %s)
	    %s
NEWS_OPER_LIST_NONE
	Il n'y a pas d'oper news.
NEWS_OPER_ADD_SYNTAX
	Syntaxe: OPERNEWS ADD texte
NEWS_OPER_ADD_FULL
	La liste d'oper news est pleine.
NEWS_OPER_ADDED
	Ajout un nouvel article d'oper news (#%d).
NEWS_OPER_DEL_SYNTAX
	Syntaxe: OPERNEWS DEL {num | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Article oper news #%d non trouv!
NEWS_OPER_DELETED
	Article oper news #%d supprim.
NEWS_OPER_DEL_NONE
	Pas d'articles oper news  supprimer!
NEWS_OPER_DELETED_ALL
	Tous les articles oper news supprims.

NEWS_RANDOM_SYNTAX
	Syntaxe: RANDOMNEWS {ADD|DEL|LIST} [texte|nombre]
NEWS_RANDOM_LIST_HEADER
	Nouvelles alatoires:
NEWS_RANDOM_LIST_ENTRY
	%5d (%s par %s)
	    %s
NEWS_RANDOM_LIST_NONE
	Il n'y a pas de nouvelles alatoires.
NEWS_RANDOM_ADD_SYNTAX
	Syntaxe: RANDOMNEWS ADD texte
NEWS_RANDOM_ADD_FULL
	La liste de nouvelles est pleine!
NEWS_RANDOM_ADDED
	Nouvelle alatoire ajoute (n%d).
NEWS_RANDOM_DEL_SYNTAX
	Syntaxe: RANDOMNEWS DEL {num | ALL}
NEWS_RANDOM_DEL_NOT_FOUND
	Nouvelle alatoire n%d non trouve!
NEWS_RANDOM_DELETED
	Nouvelle alatoire n%d supprime.
NEWS_RANDOM_DEL_NONE
	Aucune nouvelle alatoire  supprimer!
NEWS_RANDOM_DELETED_ALL
	Toutes les nouvelles alatoires ont t supprims.

NEWS_HELP_LOGON
	Syntaxe: LOGONNEWS ADD texte
	         LOGONNEWS DEL {nombre | ALL}
	         LOGONNEWS LIST
	
	Edite ou affiche la liste de messages logon news. Lorsqu'un
	utilisateur se connecte au rseau, ces messages leur seront
	envoys. (Cependant, pas plus de trois messages ne seront
	envoys pour viter le flood des utilisateurs. Si il y a
	plus de trois messages de news, seuls les trois plus rcents
	seront envoys.)
	
	LOGONNEWS LIST peut tre utilise par tout IRC operator pour
	lister les messages de news courants. ADD et DEL peuvent
	uniquement tre utiliss par les Services admins.

NEWS_HELP_OPER
	Syntaxe: OPERNEWS ADD texte
	         OPERNEWS DEL {nombre | ALL}
	         OPERNEWS LIST
	
	Edite ou affiche la liste des messages oper news. Quand un
	utilisateur utilise la commande /OPER, ces messages lui seront
	envoys. (Cependant, pas plus de trois messages ne seront 
	envoys afin de ne pas flooder l'utilisateur. Si il y a plus
	de trois messages news, seuls les trois plus rcents seront
	envoys.)
	
	OPERNEWS LIST peut tre utilise par tout IRC operator pour
	lister les messages oper news actuels. ADD et DEL peuvent 
	uniquement tre utiliss par les Services admins.

NEWS_HELP_RANDOM
	Syntaxe: RANDOMNEWS ADD texte
	         RANDOMNEWS DEL {nombre | ALL}
	         RANDOMNEWS LIST
	
	Edite ou affiche la liste des nouvelles alatoires. Lorsqu'un
	utilisateur se connecte au rseau, une (et une seule) de ces
	nouvelles sera choisie et lui sera envoye.
	
	RANDOMNEWS LIST peut tre utilise par tout oprateur IRC pour
	lister les nouvelles alatoires actuellement dfinies. ADD et 
	DEL ne peuvent tre utiliss que par les administrateurs des
	services.

###########################################################################
#
# HelpServ help message
#
###########################################################################

HELP_HELP
	%S est un service conu pour donner des informations
	sur les Services. Les rubriques d'aide des Services sont
	accessibles par les commandes HELP des diffrents Services:

	%R%s HELP
	     pour des informations sur l'enregistrement des nicks

	%R%s HELP
	     pour des informations sur l'enregistrement et le
	     contrle des channels

	%R%s HELP
	     pour des informations sur l'envoi de messages aux
	     utilisateurs non connects

HELP_HELP_BOT

	%R%s HELP
	     pour des informations sur l'installation d'un bot
	     sur votre channel

HELP_HELP_HOST

	%R%s HELP
	     pour des informations sur la configuration des vhosts.

###########################################################################
#
# NickServ help messages
#
###########################################################################
NICK_HELP_CMD_CONFIRM
	    CONFIRM    Confirme une inscription  NickServ
NICK_HELP_CMD_RESEND
	    RESEND     Renvoie le code de confirmation de 
	               l'inscription  NickServ
NICK_HELP_CMD_REGISTER
	    REGISTER   Enregistre un pseudo
NICK_HELP_CMD_GROUP
	    GROUP      Joint un groupe
NICK_HELP_CMD_IDENTIFY
	    IDENTIFY   Vous identifie avec votre mot de passe
NICK_HELP_CMD_ACCESS
	    ACCESS     Modifie la liste des adresses autorises
NICK_HELP_CMD_SET
	    SET        Configure les options, protection comprise
NICK_HELP_CMD_SASET
	    SASET      Configure des options sur d'autres pseudos
NICK_HELP_CMD_DROP
	    DROP       Annule l'enregistrement d'un pseudo
NICK_HELP_CMD_RECOVER
	    RECOVER    Change le pseudo d'un utilisateur qui a pris 
	               votre pseudo
NICK_HELP_CMD_RELEASE
	    RELEASE    Reprendre la tutelle de votre pseudo
	               aprs un RECOVER
NICK_HELP_CMD_SENDPASS
	    SENDPASS   A utiliser en cas de perte de mot de passe
NICK_HELP_CMD_GHOST
	    GHOST      Deconnect un "ghost irc" utilisant votre pseudo
NICK_HELP_CMD_ALIST
	    ALIST      Liste tout les canaux auquels vous avez un accs
NICK_HELP_CMD_GLIST
	    GLIST      Liste tout les pseudos de votre groupe
NICK_HELP_CMD_INFO
	    INFO       Affiche des informations sur un pseudo
NICK_HELP_CMD_LIST
	    LIST       Liste tout les pseudos en rapport avec la recherche
NICK_HELP_CMD_LOGOUT
	    LOGOUT     Inverse la commande LOGIN
NICK_HELP_CMD_STATUS
	    STATUS     Renvoie le statut de propritaire du pseudo donn
NICK_HELP_CMD_UPDATE
	    UPDATE     Met  jour votre status, ex : verification de nouveau memo
NICK_HELP_CMD_GETPASS
	    GETPASS    Retrouve le mot de passe pour un pseudo
	               (uniquement si l'encryption est dsactive)
NICK_HELP_CMD_GETEMAIL
	    GETEMAIL   Cherche et retourne la liste des pseudos enregistrs
	    avec un certain email
NICK_HELP_CMD_FORBID
	    FORBID     Empche l'utilisation d'un pseudo
NICK_HELP_CMD_SUSPEND
	    SUSPEND    Suspend un pseudo
NICK_HELP_CMD_UNSUSPEND
	    UNSUSPEND  Unsuspend un pseudo

NICK_HELP
	%S vous permet d'enregistrer un pseudo et d'empcher les
	autres de l'utiliser. Les commandes suivantes
	permettent l'enregistrement et la gestion des pseudo. Pour
	les utiliser, tapez %R%S commande. Pour plus
	d'informations sur une certaine commande, tapez
	%R%S HELP commande.
	
NICK_HELP_FOOTER
	REMARQUE: Ce service est conu pour fournir un moyen aux
	utilisateurs IRC d'assurer que leur identit n'est pas
	usurpe. Il n'est PAS destin  faciliter le "vol" des
	pseudos ou autres choses de ce genre. L'abus de %S entranera,
	au minimum, la perte du(des) pseudo(s) faisant l'objet de 
	l'abus.
	
NICK_HELP_EXPIRES
	
	Les nicks qui ne sont plus utiliss sont sujets  
	l'expiration automatique, c'est--dire qu'ils seront effacs
	aprs %d jours de non utilisation.


NICK_HELP_REGISTER
	Syntaxe: REGISTER motdepasse [email]
	
	Enregistre votre pseudo dans la base de donnes de %S. Une fois
	que votre pseudo est enregistr, vous pouvez utiliser les
	commandes SET et ACCESS pour configurer votre pseudo comme
	vous le souhaitez. Rappelez vous bien du mot de passe utilis
	pendant l'enregistrement - vous en aurez besoin pour effectuer
	des changements sur votre pseudo plus tard. (Notez que ANOPE, 
	Anope, et anope sont tous des passwords diffrents!)
	
	Conseils pour choisir un mot de passe:
	
	Les mots de passe ne doivent pas tre trop facilement
	devinables. Par exemple, utiliser votre vrai nom comme
	mot de passe est une mauvaise ide. Utiliser votre pseudo
	comme mot de passe est une ide encore pire ;) et, en
	fait, %S ne le permettra pas. De mme, les mots de passe
	courts sont vulnrables aux recherches mthodiques,
	donc vous devez choisir un mot de passe d'au moins 
	5 caractres. Le caractre espace ne peut tre 
	utilis dans les mots de passe.
	
	Le paramtre email est optionnel et permet de dfinir
	un e-mail immdiatement. Toutefois, il peut tre obligatoire
	sur certains rseaux.
	Votre vie prive est respecte, cet e-mail ne sera pas 
	divulgu  des tierces personnes.
	
	Cette commande cre galement un nouveau groupe pour votre
	pseudo. Celui-ci vous permettra plus tard d'enregistrer
	d'autres nicks en bnficiant de la mme configuration,
	du mme jeu de memos, et des mme privilges sur vos
	channels. Pour plus d'information sur cette fonction, 
	tapez %R%S HELP GROUP.

NICK_HELP_GROUP
	Syntaxe: GROUP cible motdepasse
	
	Cette commande joint votre pseudo au groupe du nick cible.
	motdepasse est le mot de passe du pseudo cible.
	
	Joindre un groupe vous permettra de partager votre configuration,
	vos memos et vos privilges de channel avec tous les nicks
	du groupe, et bien plus encore!
	 
	Un groupe existe tant qu'il est utile. Cela signifie que mme
	si un des pseudos du groupe est effac, les lments partags
	sus-nomms sont conservs pour peu qu'il reste d'autres pseudos
	dans le groupe.
	
	Il est prfrable d'utiliser cette commande avec un pseudo
	non enregistr puisqu'il sera automatiquement enregistr
	lorsque vous utiliserez cette commande. Vous pouvez l'utiliser
	avec un pseudo enregistr (pour changer votre groupe) uniquement
	si vos administrateurs l'autorisent. (%R%S HELP IDENTIFY 
	pour plus d'informations).
	
	Vous ne pouvez tre que dans un groupe  la fois. La fusion
	de groupes n'est pas possible.
	
	Note: tous les pseudos du groupe ont le mme mot de passe.

NICK_HELP_IDENTIFY
	Syntaxe: IDENTIFY motdepasse
	
	Informe %S que vous tes vraiment le propritaire de
	ce pseudo. Beaucoup de commandes demandent que vous soyez
	identifi avec cette commande avant de les utiliser. Le
	mot de passe est celui que vous avez donn avec la commande 
	REGISTER.

NICK_HELP_UPDATE
	Syntax: UPDATE

	Actualise votre session, ex : vrification de l'arriver de
	nouveau(x) memo(s), l'application des modes sur les canaux
	(ModeonID), met	 jour votre vhost et vos flags
	(dernire fois vu, etc).
	
NICK_HELP_LOGOUT
	Syntaxe: LOGOUT
	
	Cette commande inverse l'effet de la commande IDENTIFY,
	c'est--dire qu'elle fait en sorte que vous ne soyez plus
	reconnu en tant que propritaire rel du pseudo. Notez
	cependant que l'on ne vous demandera pas de vous ridentifier.

NICK_HELP_DROP
	Syntaxe: DROP [nick]
	
	Efface votre pseudo de la base de donnes de %S. Un pseudo
	qui a t effac est libre d'tre renregistr par
	n'importe qui.
	
	Vous pouvez effacer un pseudo de votre groupe en le mettant
	dans le paramtre nick.
	
	Pour utiliser cette commande, vous devez d'abord vous
	identifier avec votre mot de passe (%R%S HELP 
	IDENTIFY pour plus d'informations).

NICK_HELP_ACCESS
	Syntaxe: ACCESS ADD mask
	         ACCESS DEL mask
	         ACCESS LIST
	
	Modifie ou affiche la liste d'accs de votre pseudo. C'est
	la liste des adresses qui seront automatiquement reconnue
	par %S comme autorise  utiliser le pseudo. Si vous voulez
	utiliser le pseudo depuis une adresse diffrente, vous devez
	envoyer une commande IDENTIFY pour que %S vous reconnaisse.
	
	Exemples:
	
	    ACCESS ADD anyone@*.bepeg.com
	        Autorise l'accs  l'utilisateur anyone d'une
	        machine avec le domaine bepeg.com.
	
	    ACCESS DEL anyone@*.bepeg.com
	        Inverse la commande prcdente.
	
	    ACCESS LIST
	        Affiche votre liste d'accs.

NICK_HELP_SET
	Syntaxe: SET option paramtres
	
	Configure diverses options du pseudo. option peut tre:
	
	    DISPLAY    Change l'affichage de votre groupe
	                   dans les services
	    PASSWORD   Change le mot de passe de votre pseudo
	    LANGUAGE   Change la langue dans laquelle les Services
	                   vous envoient leurs messages
	    URL        Associe une adresse de site  votre pseudo
	    EMAIL      Associe un e-mail  votre pseudo
	    ICQ        Associe un numro ICQ  votre pseudo
	    GREET      Associe un message d'accueil  votre pseudo
	    KILL       Active ou dsactive la protection
	    SECURE     Active ou dsactive la scurit du pseudo
	    PRIVATE    Empche votre pseudo d'tre affich par
	                   %R%S LIST
	    HIDE       Cache certaines parties des informations du pseudo
	    MSG        Change le mode de communication des Services
	    AUTOOP     Should services op you automatically.    
	
	Pour utiliser cette commande, vous devez d'abord vous
	identifier avec votre mot de passe (%R%S HELP 
	IDENTIFY pour plus d'informations).
	
	Tapez %R%S HELP SET option pour plus d'information
	sur une option spcifique.

NICK_HELP_SET_DISPLAY
	Syntaxe: SET DISPLAY nouvel-affichage
	
	Change l'affichage utilis pour nommer votre groupe de
	pseudos dans les services. Le nouvel affichage DOIT tre un
	pseudo de votre groupe.

NICK_HELP_SET_PASSWORD
	Syntaxe: SET PASSWORD nouveau-mot-de-passe
	
	Change le mot de passe utilis pour vous identifier en tant
	que propritaire du pseudo.

NICK_HELP_SET_LANGUAGE
	Syntaxe: SET LANGUAGE nombre
	
	Change la langue utilise par les services lorsqu'ils vous
	envoient un message (par exemple, quand ils rpondent  une
	commande que vous avez envoy). nombre doit tre choisi
	dans la liste suivante des langues supportes:

NICK_HELP_SET_URL
	Syntaxe: SET URL adresse
	
	Associe l'adresse de votre site web  votre pseudo. Cette adresse 
	sera affiche lorsque quelqu'un demandera des informations sur
	votre pseudo avec la commande INFO.

NICK_HELP_SET_EMAIL
	Syntaxe: SET EMAIL adresse
	
	Associe l'e-mail donn avec votre pseudo. L'email
	sera affich lorsque quelqu'un demandera des informations 
	sur votre pseudo avec la commande INFO.
	
NICK_HELP_SET_ICQ
	Syntaxe: SET ICQ numro
	
	Associe le numro ICQ donn  votre pseudo. Ce numro 
	sera affich lorsque quelqu'un demandera des informations sur
	votre pseudo avec la commande INFO.

NICK_HELP_SET_GREET
	Syntaxe: SET GREET message
	
	Dfinit un message d'accueil pour votre pseudo, qui sera
	affich lorsque vous joignez un channel qui a l'option
	GREET active,  condition d'avoir un niveau d'accs
	suffisant.

NICK_HELP_SET_KILL
	Syntaxe: SET KILL {ON | QUICK | IMMED | OFF}
	
	Active ou dsactive la protection automatique
	pour votre pseudo. Avec la protection active, si
	un autre utilisateur essaie de prendre votre pseudo, il aura
	une minute pour changer de pseudo, aprs quoi son pseudo sera
	chang de force par %S.
	
	Si vous slectionnez QUICK, l'utilisateur aura seulement 20
	secondes pour changer de pseudo au lieu des 60 habituelles. Si
	vous slectionnez IMMED, l'utilisateur verra son pseudo chang 
	immdiatement sans tre d'abord prvenu et sans avoir de chance
	pour changer son pseudo, n'utilisez cette option que si ncessaire.
	Les administrateurs de votre rseau peuvent avoir dsactiv cette option.

NICK_HELP_SET_SECURE
	Syntaxe: SET SECURE {ON | OFF}
	
	Active ou dsactive la scurit de %S pour votre pseudo.
	Si la scurit est active, vous devrez obligatoirement
	entrer votre mot de passe pour tre reconnu en tant que 
	propritaire du pseudo, que votre masque soit dans la liste d'accs
	ou non. Cependant, si vous tes sur la liste d'accs, %S ignorera
	la configuration de la protection offerte par SET KILL.

NICK_HELP_SET_PRIVATE
	Syntaxe: SET PRIVATE {ON | OFF}
	
	Active ou dsactive le mode priv de %S de votre pseudo.
	Si le mode priv est actif, votre pseudo n'apparaitra pas
	dans les listes de pseudos gnres par la commande LIST
	de %S. (Cependant, quiconque connaissant votre pseudo peut
	tout de mme avoir des informations en utilisant
	la commande INFO).

NICK_HELP_SET_HIDE
	Syntaxe: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	Vous permet d'empcher l'affichage de certaines parties
	des informations quand quelqu'un fait un %S INFO sur votre
	pseudo. Vous pouvez cacher votre adresse e-mail (EMAIL), masque
	user@host vu pour la dernire fois (USERMASK), et la dernire
	raison de /QUIT (QUIT). Le second paramtre indique si 
	l'option doit tre affiche (OFF) ou cache (ON).
	
NICK_HELP_SET_MSG
	Syntaxe: SET MSG {ON | OFF}
	
	Vous permet de choisir la faon dont les services communiquent
	avec vous. Si cette option est active, ils utiliseront des
	messages, sinon ils utiliseront des notices.

NICK_HELP_SET_AUTOOP
	Syntax: SET AUTOOP {ON | OFF}
	
	Sets whether you will be opped automatically. Set to ON to 
	allow ChanServ to op you automatically when entering channels.

NICK_HELP_SASET
	Syntaxe: SASET pseudo option parametres.
	
	Configure plusieurs options sur un pseudo.  option dois etre une ci dessou:
	
	    DISPLAY    Affiche les pseudos du groupe du pseudo donn
	    PASSWORD   Change le mot de passe du pseudo donn
	    URL        Associe une url au pseudo donn
	    EMAIL      Associe un email au pseudo donn
	    ICQ        Associe un compte ICQ au pseudo donn
	    GREET      Associe un message de greet au pseudo donn
	    KILL       Active ou dsactive l'option kill du pseudo donn
	    SECURE     Active ou dsactive la securit du pseudo donn
	    PRIVATE    Empche le pseudo d'apparatre dans un
	                   %R%S LIST
	    HIDE       Cache certaine informations personnel au pseudo
	    MSG        Change le mode de communication des services
	    NOEXPIRE   Empche le pseudo d'expirer
	
	Taper %R%S HELP SASET option pour plus d'information
	sur une option spcifique. L'option devra etre mise avec le pseudo
	en prefix. 
	
	Limit aux Services admins.

NICK_HELP_SASET_DISPLAY
	Syntaxe: SASET pseudo DISPLAY nouvel-affichage
	
	Change l'affichage utilis pour nommer le groupe du
	pseudos dans les services. Le nouvel affichage DOIT tre un
	pseudo de votre groupe.
	
	Limit aux Services admins.

NICK_HELP_SASET_PASSWORD
	Syntaxe: SASET pseudo PASSWORD nouveau-mot-de-passe
	
	Change le mot de passe utilis pour s'identifier comme propitaire
	du pseudo.
	
	Limit aux Services admins.

NICK_HELP_SASET_URL
	Syntaxe: SASET pseudo URL url
	
	Associe l'URL donn au pseudo. Cette URL sera affich
	a toutes les personnes demandant des informations sur
	le pseudo via la commande INFO.
	
	Limit aux Services admins.

NICK_HELP_SASET_EMAIL
	Syntaxe: SASET pseudo EMAIL adresse-email
	
	Associe l'E-mail donn au pseudo.
	
	Limit aux Services admins.
	
NICK_HELP_SASET_ICQ
	Syntaxe: SASET pseudo ICQ numro
	
	Associe le numro ICQ donn au pseudo. Ce numro ICQ sera affich
	a toutes les personnes demandant des informations sur le pseudo
	via la commande INFO.
	
	Limit aux Services admins.
	
NICK_HELP_SASET_GREET
	Syntaxe: SASET pseudo GREET message
	
	Dfinit un message d'accueil au pseudo, qui sera
	affich lorsqu'il joint un channel qui a l'option
	GREET active,  condition d'avoir un niveau d'accs
	suffisant.
	
	Limit aux Services admins.

NICK_HELP_SASET_KILL
	Syntaxe: SASET pseudo KILL {ON | QUICK | IMMED | OFF}
	
	Active ou dsactive la protection automatique pour le pseudo donn.
	Avec la protection active, si un autre utilisateur essaie de 
	prendre son pseudo, il aura une minute pour changer de pseudo,
	aprs quoi son pseudo sera chang de force par %S.
	
	Si vous slectionnez QUICK, l'utilisateur aura seulement 20
	secondes pour changer de pseudo au lieu des 60 habituelles. Si
	vous slectionnez IMMED, l'utilisateur verra son pseudo chang
	immdiatement sans tre d'abord prvenu et sans avoir de chance
	pour changer son pseudo, n'utilisez cette option que si ncessaire.
	Les administrateurs de votre rseau peuvent avoir dsactiv cette option.
	
	Limit aux Services admins.

NICK_HELP_SASET_SECURE
	Syntaxe: SASET pseudo SECURE {ON | OFF}
	
	Active ou dsactive la scurit de %S pour le pseudo donn.
	Si la scurit est active, il devra obligatoirement
	entrer son mot de passe pour tre reconnu en tant que
	propritaire du pseudo, que son masque soit dans la liste d'accs
	ou non. Cependant, si vous tes sur la liste d'accs, %S ignorera
	la configuration de la protection offerte par SET KILL.
	
	Limit aux Services admins.

NICK_HELP_SASET_PRIVATE
	Syntaxe: SASET pseudo PRIVATE {ON | OFF}
	
	Active ou dsactive le mode priv de %S du pseudo donn.
	Si le mode priv est actif, son pseudo n'apparaitra pas
	dans les listes de pseudos gnres par la commande LIST
	de %S. (Cependant, quiconque connaissant son pseudo peut
	tout de mme avoir des informations en utilisant
	la commande INFO).
	
	Limit aux Services admins.

NICK_HELP_SASET_HIDE
	Syntaxe: SASET pseudo HIDE {EMAIL | STATUS | USERMASK | QUIT} {ON | OFF}
	
	Vous permet d'empcher l'affichage de certaines parties
	des informations quand quelqu'un fait un %R%S INFO sur le pseudo
	donn. Vous pouvez cacher son adresse e-mail (EMAIL), masque
	user@host vu pour la dernire fois (USERMASK), et la dernire
	raison de /QUIT (QUIT). Le second paramtre indique si
	l'option doit tre affiche (OFF) ou cache (ON).
	
	Limit aux Services admins.
	
NICK_HELP_SASET_MSG
	Syntaxe: SASET pseudo MSG {ON | OFF}
	
	Vous permet de choisir la faon dont les services communiquent
	le pseudo donn. Si cette option est active, ils utiliseront des
	messages, sinon ils utiliseront des notices.
	
	Limit aux Services admins.

NICK_HELP_SASET_NOEXPIRE
	Syntaxe: SASET pseudo NOEXPIRE {ON | OFF}
	
	Permet d'activer le mode NOEXPIRE au pseudo donn.
	Configurez ce paramtres sur ON pour que le 
	pseudo n'expire pas.
	
	Limit aux Services admins.

NICK_HELP_SASET_AUTOOP
	Syntax: SASET nickname AUTOOP {ON | OFF}
	
	Sets whether the given nickname will be opped automatically.
	Set to ON to allow ChanServ to op you automatically when joining
	channels.
	
	Limited to Services admins.

NICK_HELP_RECOVER
	Syntaxe: RECOVER pseudo [motdepasse]
	
	Vous permet de rcuprer votre pseudo si quelqu'un d'autre
	l'a pris, c'est quivalent  ce que ce que %S fait 
	automatiquement si quelqu'un essaie d'utiliser un pseudo
	protg par SET KILL.
	
	Quand vous utilisez cette commande, %S connectera un faux
	utilisateur avec le mme pseudo que l'utilisateur dont
	vous essayez de rcuprer le pseudo. Cela provoque la dconnexion
	par les serveurs IRC de l'autre utilisateur. Ce faux utilisateur
	restera connect pendant une minute pour s'assurer que l'autre
	utilisateur ne se reconnecte pas immdiatement. Aprs cette
	minute, vous pouvez reprendre votre pseudo. Alternativement,
	utilisez la commande RELEASE (%R%S HELP RELEASE) pour
	reprendre votre pseudo plus tt.
	
	Pour utiliser la commande RECOVER pour un pseudo, l'adresse
	telle qu'elle est montre dans un /WHOIS doit tre sur la
	liste d'accs du pseudo, vous devez tre identifi et dans
	le groupe du pseudo, ou vous devez fournir le mot de passe
	correct du pseudo.

NICK_HELP_RELEASE
	Syntaxe: RELEASE pseudo [motdepasse]
	
	Ordonne  %S de supprimer toute tutelle sur votre pseudo
	provoque par la protection de SET KILL ou 
	l'utilisation de la commande RECOVER. Par dfaut, les
	tutelles durent une minute, cette commande les
	arrte plus tt.
	
	Pour utiliser la commande RELEASE pour un pseudo, l'adresse
	telle qu'elle est montre dans un /WHOIS doit tre sur la
	liste d'accs du pseudo, vous devez tre identifi et dans
	le groupe du pseudo, ou vous devez fournir le mot de passe
	correct du pseudo.

NICK_HELP_GHOST
	Syntaxe: GHOST pseudo [motdepasse]
	
	Arrte une session IRC "fantme" utilisant votre pseudo. Une
	session "fantme" est un utilisateur non connect 
	actuellement, mais dont le serveur IRC croit qu'il l'est
	toujours pour une raison ou une autre. Habituellement,
	ceci arrive lorsque votre ordinateur plante ou que votre connexion
	 Internet s'arrte lorsque vous tes sur IRC.
	
	Pour utiliser la commande GHOST pour un pseudo, l'adresse
	telle qu'elle est montre dans un /WHOIS doit tre sur la
	liste d'accs du pseudo, ou vous devez fournir le mot de passe
	correct pour le pseudo.

NICK_HELP_INFO
	Syntaxe: INFO pseudo [ALL]
	
	Affiche des informations sur le pseudo donn, telles que
	le propritaire du pseudo, l'adresse avec laquelle il tait
	connect pour la dernire fois, et les options du pseudo. Si
	vous tes identifi pour le pseudo pour lequel vous demandez
	des informations et que ALL est spcifi, toutes
	les informations seront affiches, qu'elles soient caches
	ou non.

NICK_HELP_LIST
	Syntaxe: LIST modle
	
	Liste tous les pseudos enregistrs qui correspondent
	au modle donn, dans le format pseudo!user@host. Les
	pseudos avec l'option PRIVATE active ne seront pas
	affichs.
	
	Exemples:
	
	    LIST *!joeuser@foo.com
	        Liste tous les pseudos appartenant  joeuser@foo.com.
	
	    LIST *Bot*!*@*
	        Liste tous les pseudo enregistrs avec Bot dans leurs
	        noms (ne diffrencie pas minuscules et majuscules).
	
	    LIST *!*@*.bar.org
	        Liste tous les pseudo appartenant aux utilisateurs dans le
	        domaine bar.org.
	        
NICK_HELP_ALIST
	Syntaxe: ALIST [level]
	
	Liste tout les canaux auquels vous avez accs. Optionnelement, vous
	pouvez spcifier un niveau au format XOP ou ACCESS. Le rsultat
	retournera uniquement les canaux auquels vous avez un accs suprieur
	ou gale au niveau donn.
	
	Exemples:
	    ALIST Founder
	        Liste tout les canaux auquels vous avez un accs
		FOUNDER.

	    ALIST AOP
	        Liste tout les canaux ou vous avez un accs AOP ou plus.

	    ALIST 10
	        Liste tout les canaux ou vous avez un accs 10 ou plus.
	
	Les canaux ayant l'option NOEXPIRE active seront retourn avec un point 
	d'exclamation devant.
	
NICK_HELP_GLIST
	Syntaxe: GLIST
	
	Liste tous les pseudos dans votre groupe.

NICK_HELP_STATUS
	Syntaxe: STATUS nick...
	
	Retourne si l'utilisateur utilisant le pseudo donn est reconnu
	en tant que propritaire du pseudo. La rponse a ce format:
	
	    pseudo code-status
	
	o pseudo est le pseudo envoy avec la commande, et
	code-status peut tre l'un des suivants:
	
	    0 - cet utilisateur n'est pas online ou le pseudo n'est pas 
	        enregistr
	    1 - utilisateur non reconnu comme propritaire
	    2 - utilisateur reconnu comme propritaire uniquement via
	        la liste d'accs
	    3 - utilisateur reconnu comme propritaire via l'identification
	
	Jusqu' seize pseudos peuvent tre envoys avec chaque commande,
	le reste sera ignor. Si aucun pseudo n'est donn, votre status
	sera retourn.

NICK_HELP_SENDPASS
	Syntaxe: SENDPASS pseudo
	
	Envoie le mot de passe du pseudo donn  l'adresse e-mail 
	qui a t dfinie pour ce pseudo. Cette commande est trs
	utile pour rgler les problmes de mots de passe perdus.
	
	Peut tre limite aux IRC operators sur certains
	rseaux.
	
	Cette commande est indisponible quand l'encryption est
	active.

NICK_HELP_CONFIRM
	Syntax: CONFIRM passcode
	
	This is the second step of nickname registration process.
	You must perform this command in order to get your nickname
	registered with %S. The passcode (or called auth code also)
	is sent to your e-mail address in the first step of the
	registration process. For more information about the first
	stage of the registration process, type: %R%S HELP REGISTER

NICK_SERVADMIN_HELP
	
	Les Services admins peuvent galement effacer n'importe quel
	pseudo sans avoir besoin de s'identifier pour le nick, et 
	peuvent voir l'access list pour n'importe quel pseudo
	(%R%S ACCESS LIST nick).
	
NICK_SERVADMIN_HELP_LOGOUT
	Syntaxe: LOGOUT [pseudo [REVALIDATE]]
	
	Sans paramtre, inverse l'effet de la commande IDENTIFY,
	c'est--dire qu'elle fait en sorte que vous ne soyez plus
	reconnu en tant que propritaire rel du pseudo. Notez
	cependant que l'on ne vous demandera pas de vous ridentifier.
	
	Avec un paramtre, fait la mme chose avec le pseudo donn. Si
	vous spcifiez galement REVALIDATE, les Services demanderont
	au pseudo donn de se r-identifier. Cette utilisation est 
	rserve aux Services admins.

NICK_SERVADMIN_HELP_DROP
	Syntaxe: DROP [pseudo]
	
	Sans paramtre, efface votre pseudo de la base de donnes
	de %S.
	
	Avec un paramtre, efface le pseudo donn de la base de
	donnes. Vous pouvez effacer n'importe quel pseudo de votre
	groupe sans privilges particuliers. La possibilit 
	d'effacer n'importe quel pseudo est cependant rserve aux 
	Services admins.

NICK_SERVADMIN_HELP_INFO
	
	Les services admins peuvent utiliser le paramtre ALL 
	avec n'importe quel pseudo.

NICK_SERVADMIN_HELP_LIST
	Syntaxe: LIST modle [FORBIDDEN] [NOEXPIRE] [UNCONFIRMED]
	
	Liste tous les pseudos enregistrs qui correspondent au modle
	donn, de format nick!user@host. Les pseudos ayant l'option
	PRIVATE ne seront affichs qu'aux Services admins. Les
	pseudos ayant l'option NOEXPIRE seront prfixs par un !
	devant leur pseudo pour les Services admins. 
	
	Si les option FORBIDDEN, NOEXPIRE ou UNCONFIRMED sont donn,
	les pseudos qui sont FORBID, NON CONFIRMER ou ont l'option
	NOEXPIRE seront affich. Si les 3 options sont indiques,
	tout les pseudos correspondant aux 3 critres seront affichs.
	Rserv aux Services admins.  
	
	Exemples:
	
	    LIST *!joeuser@foo.com
	        Liste tous les pseudos enregistrs appartenant  
	        joeuser@foo.com.
	
	    LIST *Bot*!*@*
	        Liste tous les pseudos enregistrs ayant Bot dans
	        leur nom (ne respecte pas les majuscules).
	
	    LIST * NOEXPIRE
	        Liste tous les pseudos qui n'expireront pas.

NICK_SERVADMIN_HELP_ALIST
	Syntax: ALIST [pseudo] [level]
	
	Sans aucun paramtres, retourne la liste des canaux ou vous avez un accs.
	pseudo liste les canaux auquel le pseudo donn a accs
	   level liste les canaux auquel le pseudo donn a un accs suprieur
	             ou gale au level donn

	Rserv aux Services admins.

NICK_SERVADMIN_HELP_GLIST
	Syntaxe: GLIST [nick]
	
	Sans paramtre, liste tous les pseudos qui sont dans
	votre groupe.
	
	Avec un paramtre, liste tous les pseudos qui sont dans
	le groupe du pseudo donn.
	Cette utilisation est limite aux administrateurs des 
	Services.

NICK_SERVADMIN_HELP_GETPASS
	Syntaxe: GETPASS nick
	
	Retourne le mot de passe du pseudo donn. Notez que pour
	chaque utilisation de cette commande, un message comprenant
	la personne qui a mis la commande et le pseudo sur lequel
	il a t utilis sera enregistr et envoy en WALLOPS/GLOBOPS.
	
	Rserve aux Services admins.
	
	Cette commande est indisponible quand l'encryption est active.

NICK_SERVADMIN_HELP_GETEMAIL
	Syntax: GETEMAIL user@emailhost

	Retourne la liste des pseudos enregistr avec l'email donn.
	Note vous ne pouvez pas utiliser de wildcards pour plusieurs
	         pseudos. 
		 Lorsque cette commande est utilis, un message incluant
		 le pseudo de la personne qui a utilis la commande et
		 vers quel email a t destin la commande dans les logs.

	Limit aux Services admins.

NICK_SERVADMIN_HELP_FORBID
	Syntaxe: FORBID nick [raison]
	
	Empche un pseudo d'tre enregistr ou utilis par 
	quelqu'un. Peut tre annul en effaant le pseudo.
	
	Sur certains rseaux, la raison est requise.
	
	Rserve aux Services admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################

NICK_SERVADMIN_HELP_SUSPEND
	Syntaxe: SUSPEND pseudo raison / UNSUSPEND pseudo

	Suspend / libere le pseudo pseudo spcifi.
		
	Limit aux Services admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################

NICK_SERVADMIN_HELP_UNSUSPEND
	Syntaxe: UNSUSPEND pseudo

	Libere un pseudo suspendu.

	Limit aux Services admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################
CHAN_HELP_CMD_GETPASS
	    GETPASS    Retrouve le mot de passe du propritaire pour
	               un channel 
CHAN_HELP_CMD_FORBID
	    FORBID     Empche un channel d'tre utilis
CHAN_HELP_CMD_SUSPEND
	    SUSPEND    Suspend un canal pour ne pas qu'il soit utilis
	               tout en conservant les donnes et configurations.
CHAN_HELP_CMD_UNSUSPEND
	    UNSUSPEND  Libre un canal suspendu
CHAN_HELP_CMD_STATUS
	    STATUS     Retourne le level d'accs courant d'un
	               utilisateur sur un channel
CHAN_HELP_CMD_REGISTER
	    REGISTER   Enregistre un channel
CHAN_HELP_CMD_IDENTIFY
	    IDENTIFY   Vous identifie avec votre mot de passe
CHAN_HELP_CMD_SET
	    SET        Configure les options et informations du 
	               channel
CHAN_HELP_CMD_AOP
	    AOP        Modifie la liste des utilisateurs AOPs
CHAN_HELP_CMD_SOP
	    SOP        Modifie la liste des utilisateurs SOPs
CHAN_HELP_CMD_ACCESS
	    ACCESS     Modifie la liste des utilisateurs privilgis
CHAN_HELP_CMD_LEVELS
	    LEVELS     Redfinit la signification des levels d'accs
CHAN_HELP_CMD_AKICK
	    AKICK      Gre la liste des kicks automatiques
CHAN_HELP_CMD_DROP
	    DROP       Annule l'enregistrement d'un channel
CHAN_HELP_CMD_SENDPASS
	    SENDPASS   Aide  retrouver les mots de passe gars
CHAN_HELP_CMD_BAN
	    BAN        Ban un pseudo spcifi dans un canal
CHAN_HELP_CMD_CLEAR
	    CLEAR      Ordonne  ChanServ de nettoy certain paramtres
	               sur un canal
CHAN_HELP_CMD_DEVOICE
	    DEVOICE    Devoice le pseudo spcifi sur un canal
CHAN_HELP_CMD_GETKEY
	    GETKEY     Retourne la cl du canal specifi
CHAN_HELP_CMD_INFO
	    INFO       Liste les informations sur un canal enregistr
CHAN_HELP_CMD_INVITE
	    INVITE     Ordone  ChanServ de vous inviter ou d'inviter un pseudo
	               sur un canal
CHAN_HELP_CMD_KICK
	    KICK       Kick le pseudo spcifi d'un canal
CHAN_HELP_CMD_LIST
	    LIST       Liste tout les canaux enregistr en rapport avec la recherche
CHAN_HELP_CMD_LOGOUT
	    LOGOUT     Cette commande inverse la commande IDENTIFY
CHAN_HELP_CMD_OP
	    OP         Donne l'Op au pseudo spcifi sur un canal
CHAN_HELP_CMD_TOPIC
	    TOPIC      Change le topic sur un canal spcifi
CHAN_HELP_CMD_UNBAN
	    UNBAN      Retire tout les bans vous empechant d'entrer sur un canal
CHAN_HELP_CMD_VOICE
	    VOICE      Donne un voice au pseudo spcifi sur un canal
CHAN_HELP_CMD_VOP
	    VOP        Configure la liste des VOP pour un canal (VOicePeople)
CHAN_HELP_CMD_DEHALFOP
	    DEHALFOP   Dehalfop le pseudo spcifi sur un canal
CHAN_HELP_CMD_DEOWNER
	    DEOWNER    Retire votre status d'owner sur un canal
CHAN_HELP_CMD_DEPROTECT
	    DEPROTECT  Deprotge le pseudo donn sur un canal
CHAN_HELP_CMD_HALFOP
	    HALFOP     Donne le status d'halfop au pseudo donn sur un canal
CHAN_HELP_CMD_HOP
	    HOP        Configure la liste de HOP d'un canal (HalfOP)
CHAN_HELP_CMD_OWNER
	    OWNER      Vous donne votre accs owner sur un canal
CHAN_HELP_CMD_PROTECT
	    PROTECT    Protge le pseudo spcifi sur un canal
CHAN_HELP_CMD_ADMIN
	    ADMIN      Protge le pseudo spcifi sur un canal
CHAN_HELP_CMD_DEADMIN
	    DEADMIN    Deprotge le pseudo donn sur un canal
CHAN_HELP_CMD_DEOP
	    DEOP       Deop le pseudo spcifi sur un canal

CHAN_HELP
	%S vous permet d'enregistrer et de contrler divers
	aspects des canaux. %S empche souvent de malicieux
	utilisateurs de faire des "take overs" sur les canaux
	en limitant ceux qui sont autoriss  tre channel
	operator. Les commandes disponibles sont listes ci-dessous,
	pour les utiliser, tapez %R%S commande. Pour plus 
	d'informations sur une commande spcifique, tapez
	%R%S HELP commande.
	 
	
CHAN_HELP_EXPIRES
	
	Notez que tout canal non utilis pendant %d jours
	(c'est--dire une priode pendant laquelle aucun
	utilisateur figurant sur la liste d'accs du canal
	ne vient sur le canal) sera automatiquement effac.

CHAN_HELP_REGISTER
	Syntaxe: REGISTER canal motdepasse description
	
	Enregistre un canal dans la base de donnes de %S. Pour
	utiliser cette commande, vous devez d'abord tre un
	oprateur sur le canal que vous essayez 
	d'enregistrer. Le mot de passe est utilis avec la commande
	IDENTIFY pour permettre  d'autres de faire des changements
	dans la configuration du canal plus tard. Le dernier
	paramtre, qui doit tre inclus, est une description
	gnrale du canal.
	
	Quand vous enregistrez un canal, vous tes enregistr
	comme "propritaire" du canal. Le propritaire du canal peut
	tout changer dans la configuration du canal, %S donnera
	aussi automatiquement au propritaire les droits d'oprateur
	du canal quand il ou elle joint le canal.
	Consultez la commande ACCESS (%R%S HELP ACCESS) pour
	savoir comment donner un sous ensemble de ces droits 
	d'autres utilisateurs du canal.
	
	REMARQUE: Pour enregistrer un canal, vous devez
	d'abord enregistrer votre pseudo. Si ce n'est pas dj fait,
	tapez %R%s HELP pour savoir comment faire.

CHAN_HELP_IDENTIFY
	Syntaxe: IDENTIFY canal motdepasse
	
	Certifie  %S que vous tes autoris  modifier le canal donn.
	Beaucoup de commandes demandent que vous utilisiez cette
	commande avant de les utiliser si vous n'tes pas le propritaire. 
	Le mot de passe est le mme que celui que vous avez envoy avec la
	commande REGISTER.
	
CHAN_HELP_LOGOUT
	Syntaxe: LOGOUT canal pseudo
	
	Cette commande supprime l'identification du pseudo slectionn
	pour le canal donn.
	
	Si vous tes le propritaire du canal, vous pouvez utiliser
	la commande sur n'importe qui, sinon vous ne pouvez que
	l'utiliser sur vous mme.

CHAN_HELP_DROP
	Syntaxe: DROP canal
	
	Efface le canal donn. Peut uniquement tre utilis par
	le propritaire du canal, qui doit utiliser la commande
	IDENTIFY d'abord.

CHAN_HELP_SET
	Syntaxe: SET canal option paramtres
	
	Permet au propritaire du canal de configurer diverses options
	du canal et d'autres informations.
	
	Options disponibles:
	
	    FOUNDER       Dfinit le propritaire d'un canal
	    SUCCESSOR     Dfinit le successeur d'un canal
	    PASSWORD      Dfinit le mot de passe du canal
	    DESC          Dfinit la description du canal
	    URL           Associe un site avec un canal
	    EMAIL         Associe un E-mail avec le canal
	    ENTRYMSG      Dfinit un message envoy aux utilisateurs
	                      qui entrent sur le canal
	    TOPIC         Change le topic du canal
	    BANTYPE       Dfinit comment les services mettent les bans
	                      sur le canal
	    MLOCK         Oblige ou interdit des modes de canal
	    KEEPTOPIC     Maintient le topic quand le canal n'est
	                      pas utilis
	    OPNOTICE      Envoie une notice quand OP/DEOP sont utiliss
	    PEACE         Rgule l'utilisation de commandes sensibles
	    PRIVATE       Cacher le canal de la commande LIST
	    RESTRICTED    Restreindre l'accs au canal
	    SECURE        Active les fonctions de scurit de %S
	    SECUREOPS     Contrle plus strict du status de chanop
	    SECUREFOUNDER Contrle plus strict du status de propritaire 
	                      du canal
	    SIGNKICK      Signe les kicks gnrs par la commande KICK
	    TOPICLOCK     Le topic peut uniquement tre chang avec
	                      TOPIC
	    XOP           Change le systme de privilges utilisateurs
	
	Tapez %R%S HELP SET option pour plus d'informations sur
	une option particulire.

CHAN_HELP_SET_FOUNDER
	Syntaxe: SET canal FOUNDER pseudo
	
	Change le propritaire d'un canal. Le nouveau pseudo doit tre
	enregistr.

CHAN_HELP_SET_SUCCESSOR
	Syntaxe: SET canal SUCCESSOR pseudo
	
	Change le successeur d'un canal. Si le pseudo du propritaire
	expire ou est effac alors que le canal est toujours
	enregistr, le successeur deviendra le nouveau propritaire du
	canal. Cependant, si le successeur a dj trop de canaux
	enregistrs (%d), le canal sera tout de mme effac, comme
	si aucun successeur n'avait t nomm. Le nouveau pseudo
	doit tre enregistr.

CHAN_HELP_SET_PASSWORD
	Syntaxe: SET canal PASSWORD motdepasse
	
	Dfinit le mot de passe utilis pour s'identifier en tant
	que propritaire du canal.

CHAN_HELP_SET_DESC
	Syntaxe: SET canal DESC description
	
	Dfinit la description du canal, qui apparait dans les
	commandes LIST et INFO.

CHAN_HELP_SET_URL
	Syntaxe: SET canal URL [adresse]
	
	Associe l'adresse de site web donne avec le canal. Cette adresse 
	sera affiche  chaque fois que quelqu'un demande des informations
	sur le canal avec la commande INFO. Si aucun paramtre
	n'est donn, supprime l'adresse de site du canal.

CHAN_HELP_SET_EMAIL
	Syntaxe: SET canal EMAIL [adresse]
	
	Associe l'e-mail donn avec le canal. Cet
	e-mail sera affich lorsque quelqu'un demande des informations
	sur le canal avec la commande INFO. Si aucun paramtre
	n'est donn, supprime l'e-mail actuel du canal.

CHAN_HELP_SET_ENTRYMSG
	Syntaxe: SET canal ENTRYMSG [message]
	
	Dfinit le message qui sera envoy en /notice aux 
	utilisateurs quand ils entrent dans un canal. Si aucun
	paramtre n'est donn, aucun message n'est envoy 
	l'entre.
	
CHAN_HELP_SET_BANTYPE
	Syntaxe: SET canal BANTYPE typedeban
	
	Dfinit le type de ban qui sera utilis par les services
	lorsqu'ils doivent bannir quelqu'un de votre canal.
	
	typedeban est un nombre entre 0 et 3 qui signifie:
	
	0: ban de style *!user@host
	1: ban de style *!*user@host
	2: ban de style *!*@host
	3: ban de style *!*user@*.domain

CHAN_HELP_SET_KEEPTOPIC
	Syntaxe: SET canal KEEPTOPIC {ON | OFF}
	
	Active ou dsactive l'option de maintien du topic pour
	un canal. Lorsque le maintien du topic est dfini, le 
	topic pour le canal sera retenu par %S mme aprs que le
	dernier utilisateur quitte le canal, et sera restaur la
	prochaine fois que le canal est cr. 

CHAN_HELP_SET_TOPICLOCK
	Syntaxe: SET canal TOPICLOCK {ON | OFF}
	
	Active ou dsactive l'option de verrouillage du topic pour
	un caanal. Lorsque le verrouillage du topic est actif,
	%S ne permettra pas le changement du topic du canal sauf
	avec la commande TOPIC.

CHAN_HELP_SET_MLOCK
	Syntaxe: SET canal MLOCK modes
	
	Configure les modes maintenus sur le canal. %S vous permet de
	toujours garder certains modes, d'empcher l'utilisation d'autres
	modes et de laisser les modes restants en libre utilisation par
	les oprateurs du canal.
	
	Le paramtre modes est construit de la mme faon que dans la 
	commande /MODE, les modes prcds d'un + tant toujours gards, 
	et ceux prcds d'un - ne pouvant tre utiliss. Notez cependant
	que, contrairement  la commande /MODE, chaque utilisation de 
	SET MLOCK rinitialisera les modes maintenus avant de mettre en 
	place les nouveaux!
	
	Remarque: Si vous choisissez de toujours garder le mode +k, 
	comme dans le second exemple ci-dessous, vous devez galement 
	activer l'option RESTRICTED du canal (HELP SET 
	RESTRICTED pour plus d'informations), sinon toute personne 
	entrant sur le canal lorsqu'il est vide verra la clef!  
	
	Exemples:
	
	    SET #canal MLOCK +nt-iklps
	      Garde toujours les modes n et t, et empche l'utilisation 
	      des modes i, k, l, p, et s. Le mode m est libre d'tre 
	      mis ou retir.
	
	    SET #canal MLOCK +knst-ilmp ma-clef
	      Garde toujours les modes k, n, s, et t, et dsactive 
	      les modes i, l, m, et p. La clef du canal sera 
	      "ma-clef".
	
	    SET #canal MLOCK +
	      Rinitialise tous les modes prcdemment maintenus, qui
	      pourront dsormais tre librement utiliss.

CHAN_HELP_SET_PEACE
	Syntaxe: SET canal PEACE {ON | OFF}
	
	Active ou dsactive l'option de paix pour un canal.
	Quand elle est active, cette option empche un 
	utilisateur de kicker, bannir ou enlever un privilge
	de canal d'un user qui a un niveau suprieur ou
	gal au sien via les commandes de %S.

CHAN_HELP_SET_PRIVATE
	Syntaxe: SET canal PRIVATE {ON | OFF}
	
	Active ou dsactive l'option private pour un canal.
	Si private est dfini, un %R%S LIST ne comprendra
	le canal dans aucune liste.

CHAN_HELP_SET_RESTRICTED
	Syntaxe: SET canal RESTRICTED {ON | OFF}
	
	Active ou dsactive l'option d'accs restreint pour un
	canal. Lorsque l'accs restreint est actif, les
	utilisateurs qui n'auraient normalement pas la permission
	d'tre oprateur du canal (les utilisateurs avec un niveau
	d'accs ngatif et, si le contrle des ops est actif, les utilisateurs
	qui ne sont pas sur la liste d'accs) seront kicks et bannis
	du canal.

CHAN_HELP_SET_SECURE
	Syntaxe: SET canal SECURE {ON | OFF}
	
	Active ou dsactive %S caractristiques de scurit
	pour un canal. Lorsque la scurit est active, seuls les
	utilisateurs qui ont enregistr leurs pseudos avec %s et
	qui sont identifis avec leur mot de passe auront accs
	au canal sous contrle de la liste d'accs.

CHAN_HELP_SET_SECUREOPS
	Syntaxe: SET canal SECUREOPS {ON | OFF}
	
	Active ou dsactive le contrle des ops sur un canal.
	Lorsque le contrle des ops est actif, les utilisateurs 
	qui ne sont pas sur la liste d'accs ne pourront tre op.
	
CHAN_HELP_SET_SECUREFOUNDER
	Syntaxe: SET canal SECUREFOUNDER {ON | OFF}
	
	Active ou dsactive l'option contrle du propritaire pour un canal.
	Lorsque le contrle du propritaire est activ, seul le vrai 
	propritaire pourra effacer le canal, changer son mot de passe, 
	son propritaire et son successeur, et non pas ceux qui sont identifis 
	avec %S.
	
CHAN_HELP_SET_SIGNKICK
	Syntaxe: SET canal SIGNKICK {ON | LEVEL | OFF}
	
	Active ou dsactive les kicks signs sur un canal.
	Quand cette option est utilise, les kicks gnrs
	par la commande %S KICK auront le pseudo qui a utilis
	la commande dans leur raison.
	
	Si vous slectionnez LEVEL, ceux qui ont un level qui est
	suprieur ou gal au level SIGNKICK sur le canal ne 
	gnreront pas de kicks signs. Consultez %R%S HELP LEVELS
	pour plus d'informations.

CHAN_HELP_SET_XOP
	Syntaxe: SET canal XOP {ON | OFF}
	
	Active ou dsactive le systme de listes de xOPs pour
	un canal. Si vous choisissez ce systme, vous devez
	utiliser les commandes AOP/SOP/VOP pour donner
	des privilges aux utilisateurs, sinon vous devez
	utiliser la commande ACCESS.
	
	Info technique: quand vous passez du systme de liste 
	d'accs au systme de listes de xOPs, les dfinitions de 
	niveaux et les niveaux des utilisateurs seront changs, et 
	donc vous ne les rcuprerez pas tels quels si vous repassez 
	au systme de liste d'accs!

	Vous devriez galement vrifier que les utilisateurs sont
	dans la bonne liste de xOPs aprs tre pass du systme
	de liste d'accs  celui de listes de xOPs, car la
	conversion n'est pas parfaite  tous les coups... en fait,
	elle est dconseille si vous avez chang les dfinitions
	des niveaux avec la commande LEVELS.
	
	Passer du systme de listes de xOPs au systme de liste
	d'accs ne pose aucun problme par contre.

CHAN_HELP_SET_OPNOTICE
	Syntaxe: SET canal OPNOTICE {ON | OFF}
	
	Active ou dsactive l'option notice sur OP/DEOP pour un canal.
	Lorsque notice sur OP/DEOP est dfini, %S enverra un notice au
	canal  chaque fois que les commandes OP ou DEOP sont
	utilises par un utilisateur sur le canal.

CHAN_HELP_AOP
	Syntaxe: AOP canal ADD pseudo
	         AOP canal DEL {pseudo | liste d'entres | liste}
	         AOP canal LIST [masque | liste]
	         AOP canal CLEAR
	
	Gre la liste des AOPs (AutoOPs) d'un canal. La liste des
	AOPs donne aux utilisateurs le droit de recevoir le 
	status d'oprateur automatiquement sur votre canal, 
	de se dbannir ou de s'inviter en cas de besoin, d'avoir
	leur message d'accueil affich  leur arrive, etc.
	
	La commande AOP ADD ajoute le pseudo donn  la liste des
	AOPs.
	
	La commande AOP DEL supprime le pseudo donn de
	la liste des AOPs. Si une liste de numros d'entres est 
	donne, ces entres sont supprimes. (Consultez l'exemple
	pour LIST ci-dessous.)
	
	La commande AOP LIST affiche la liste des AOPs. Si un
	masque joker est donn, seules les entres correspondantes
	au masque sont affiches. Si une liste de numros d'entres
	est donne, seules ces entres sont affiches, par exemple:

	   AOP #canal LIST 2-5,7-9
	        Liste toutes les entres comprises entre 2 et 5 et
	        entre 7 et 9.
	
	La commande AOP CLEAR supprime toutes les entres
	de la liste des AOPs.
	
	Les commandes AOP ADD et AOP DEL sont utilisables
	en tant SOP ou plus, alors que la commande AOP CLEAR
	ne peut tre utilise que par le propritaire du canal.
	Cependant, la commande AOP LIST peut tre utilise
	en tant AOP ou plus.
	
	Cette commande peut avoir t dsactive pour votre canal,
	et vous devrez dans ce cas utiliser la liste d'accs. Tapez
	%R%S HELP ACCESS pour savoir comment utiliser la liste
	d'accs, et %R%S HELP SET XOP pour savoir comment 
	passer du systme de liste d'accs  celui de liste des xOPs.

CHAN_HELP_HOP
	Syntaxe: HOP canal ADD pseudo
	         HOP canal DEL {pseudo | liste d'entres | liste}
	         HOP canal LIST [masque | liste]
	         HOP canal CLEAR
	
	Gre la liste des HOPs (HalfOPs) d'un canal. La liste des
	HOPs donne aux utilisateurs le droit de recevoir le 
	status de semi-oprateur automatiquement sur votre canal.
	
	La commande HOP ADD ajoute le pseudo donn  la liste des
	HOPs.
	
	La commande HOP DEL supprime le pseudo donn de
	la liste des HOPs. Si une liste de numros d'entres est 
	donne, ces entres sont supprimes. (Consultez l'exemple
	pour LIST ci-dessous.)
	
	La commande HOP LIST affiche la liste des HOPs. Si un
	masque joker est donn, seules les entres correspondantes
	au masque sont affiches. Si une liste de numros d'entres
	est donne, seules ces entres sont affiches, par exemple:

	   HOP #canal LIST 2-5,7-9
	        Liste toutes les entres comprises entre 2 et 5 et
	        entre 7 et 9.
	
	La commande HOP CLEAR supprime toutes les entres
	de la liste des HOPs.
	
	Les commandes HOP ADD, HOP DEL et HOP LIST sont 
	utilisables en tant AOP ou plus, alors que la commande 
	HOP CLEAR ne peut tre utilise que par le propritaire 
	du canal.
	
	Cette commande peut avoir t dsactive pour votre canal,
	et vous devrez dans ce cas utiliser la liste d'accs. Tapez
	%R%S HELP ACCESS pour savoir comment utiliser la liste
	d'accs, et %R%S HELP SET XOP pour savoir comment 
	passer du systme de liste d'accs  celui de liste des xOPs.

CHAN_HELP_SOP
	Syntaxe: SOP canal ADD pseudo
	         SOP canal DEL {pseudo | liste d'entres | liste}
	         SOP canal LIST [masque | liste]
	         SOP canal CLEAR
	
	Gre la liste des SOPs (SuperOPs) d'un canal. La liste 
	des SOPs donne aux utilisateurs tous les droits donns
	par la liste des AOPs, et ajoute ceux de pouvoir
	utiliser la liste de kicks automatiques et de mots
	interdits, de pouvoir lire et envoyer des memos de
	canal, etc.
	
	La commande SOP ADD ajoute le nick donn  la liste des
	SOPs.
	
	La commande SOP DEL supprime le pseudo donn de
	la liste des SOPs. Si une liste de numros d'entres est 
	donne, ces entres sont supprimes. (Consultez l'exemple
	pour LIST ci-dessous.)
	
	La commande SOP LIST affiche la liste des SOPs. Si un
	masque joker est donn, seules les entres correspondantes
	au masque sont affiches. Si une liste de numros d'entres
	est donne, seules ces entres sont affiches, par exemple:

	   SOP #canal LIST 2-5,7-9
	        Liste toutes les entres comprises entre 2 et 5 et
	        entre 7 et 9.
	
	La commande SOP CLEAR supprime toutes les entres
	de la liste des SOPs.
	
	Les commandes SOP ADD, SOP DEL et SOP CLEAR ne sont 
	utilisables que par le propritaire du canal.
	Cependant, la commande SOP LIST peut tre utilise
	en tant AOP ou plus.
	
	Cette commande peut avoir t dsactive pour votre canal,
	et vous devrez dans ce cas utiliser la liste d'accs. Tapez
	%R%S HELP ACCESS pour savoir comment utiliser la liste
	d'accs, et %R%S HELP SET AOP pour savoir comment 
	passer du systme de liste d'accs  celui de liste des xOPs.

CHAN_HELP_VOP
	Syntaxe: VOP canal ADD pseudo
	         VOP canal DEL {pseudo | liste d'entres | liste}
	         VOP canal LIST [masque | liste]
	         VOP canal CLEAR
	
	Gre la liste des VOPs (VOicePeople) d'un canal. La 
	liste des VOPs permet aux utilisateurs d'obtenir le status
	de voice automatiquement ou de se l'attribuer s'ils
	ne l'ont pas encore.
	
	La commande VOP ADD ajoute le pseudo donn  la liste des
	VOPs.
	
	La commande VOP DEL supprime le pseudo donn de
	la liste des VOPs. Si une liste de numros d'entres est 
	donne, ces entres sont supprimes. (Consultez l'exemple
	pour LIST ci-dessous.)
	
	La commande VOP LIST affiche la liste des VOPs. Si un
	masque joker est donn, seules les entres correspondantes
	au masque sont affiches. Si une liste de numros d'entres
	est donne, seules ces entres sont affiches, par exemple:

	   VOP #canal LIST 2-5,7-9
	        Liste toutes les entres comprises entre 2 et 5 et
	        entre 7 et 9.
	
	La commande VOP CLEAR supprime toutes les entres
	de la liste des VOPs.
	
	Les commandes VOP ADD, VOP DEL et VOP LIST sont 
	utilisables en tant AOP ou plus, alors que la commande 
	VOP CLEAR ne peut tre utilise que par le propritaire 
	du canal.
	
	Cette commande peut avoir t dsactive pour votre canal,
	et vous devrez dans ce cas utiliser la liste d'accs. Tapez
	%R%S HELP ACCESS pour savoir comment utiliser la liste
	d'accs, et %R%S HELP SET AOP pour savoir comment 
	passer du systme de liste d'accs  celui de liste des xOPs.

CHAN_HELP_ACCESS
	Syntaxe: ACCESS canal ADD pseudo level
	         ACCESS canal DEL {pseudo | numros d'entre | liste}
	         ACCESS canal LIST [mask | liste]
	         ACCESS canal CLEAR
	
	Gre la liste d'accs d'un canal. La liste d'accs
	dtermine quels utilisateurs ont le status d'oprateur ou
	ont accs aux commandes de %S pour le canal. Diffrents
	levels utilisateur donnent accs  diffrents lots de 
	privilges, %R%S HELP ACCESS LEVELS pour des informations
	plus dtailles. Tout pseudo qui n'est pas sur la liste
	d'accs a un level utilisateur de 0.
	
	La commande ACCESS ADD ajoute le pseudo donn  la liste
	d'accs avec le level utilisateur choisi, si le pseudo est
	dj prsent dans la liste, son niveau d'accs est remplac
	par le level spcifi dans la commande. Le level spcifi
	doit tre infrieur que celui qui utilise la commande, et
	si le pseudo est dj dans la liste d'accs, le level
	d'accs actuel de ce nick doit tre infrieur  celui de
	la personne utilisant la commande.
	
	La commande ACCESS DEL supprime le pseudo donn de
	la liste d'accs. Si une liste de numros d'entres est 
	donne, ces entres sont supprimes. (Consultez l'exemple
	pour LIST ci-dessous.)
	
	La commande ACCESS LIST affiche la liste d'accs. Si un
	mask joker est donn, seules les entres correspondantes
	au mask sont affiches. Si une liste de numros d'entre
	est donne, seules ces entres sont affiches, par exemple:

	   ACCESS #canal LIST 2-5,7-9
	        Liste toutes les entres comprises entre 2 et 5 et
	        entre 7 et 9.
	
	La commande ACCESS CLEAR supprime toutes les entres
	de la liste d'accs.

CHAN_HELP_ACCESS_LEVELS
	Levels d'accs utilisateur
	
	Par dfaut, les levels d'accs suivants sont dfinis:
	
	   Proprio   Plein accs aux fonctions de %S, Op 
	               automatique ds l'entre sur le canal.
	               Notez que seule une personne peut
	               avoir le status de propritaire (il ne peut
	               tre donn en utilisant la commande
	               ACCESS).
	        10   Accs  la commande AKICK, Op automatique.
	         5   Op automatique.
	         3   Voice automatique.
	         0   Aucun privilge particulier.
	        <0   Ne doit pas tre op.
	
	Ces levels peuvent tre changs, ou de nouveaux ajouts,
	en utilisant la commande LEVELS; tapez %R%S HELP LEVELS
	pour plus d'informations.

CHAN_HELP_AKICK
	Syntaxe: AKICK canal ADD masque [raison]
	         AKICK canal STICK masque
	         AKICK canal UNSTICK masque
	         AKICK canal DEL masque
	         AKICK canal LIST [masque]
	         AKICK canal VIEW [masque]
	         AKICK canal ENFORCE
	         AKICK canal CLEAR
	
	Gre la liste de kicks automatiques d'un canal. Si 
	un utilisateur figurant sur la liste de kicks automatiques tente
	de joindre un canal, %S bannira cet utilisateur du canal, 
	et kickera ensuite l'utilisateur.
	
	La commande AKICK ADD ajoute le pseudo donn ou le
	mask d'utilisateur  la liste de kicks automatiques. Si une 
	raison est donne avec la commande, cette raison sera utilise 
	lorsque l'utilisateur est kick, sinon, la raison par dfaut est
	"Vous n'tes plus le bienvenue sur ce canal". 
	
	La commande AKICK DEL supprime le pseudo ou le masque donn
	de la liste de kicks automatiques. Cependant, il n'enlve pas 
	les bans placs par une des entres, ceux-l doivent tre supprims
	manuellement.
	
	La commande AKICK STICK bannit en permanence le masque
	donn sur le canal. Si quelqu'un essaie d'enlever le
	ban, %S le remettra automatiquement. Vous ne pouvez l'utiliser
	sur des pseudos enregistrs.
	
	La commande AKICK UNSTICK annule les effets de la commande
	AKICK STICK, et vous pourrez donc  nouveau enlever le
	ban du canal.
	
	La commande AKICK LIST affiche la liste de kicks 
	automatiques, ou optionnellement seulement les entres de la liste 
	de kicks automatiques qui correspondent au mask donn.
	
	La commande AKICK VIEW est une version plus dtaille de
	la commande AKICK LIST.
	
	La commande AKICK ENFORCE force %S  bannir tous les
	utilisateurs prsents sur le canal qui sont concerns 
	par une des entres de la liste de kicks automatiques.
	
	La commande AKICK CLEAR supprime toutes les entres
	de la liste de kicks automatiques.

CHAN_HELP_LEVELS
	Syntaxe: LEVELS canal SET type level
	         LEVELS canal {DIS | DISABLE} type
	         LEVELS canal LIST
	         LEVELS canal RESET
	
	La commande LEVELS permet un contrle prcis de la 
	signification des levels d'accs utiliss pour les canaux.
	Avec cette commande, vous pouvez dfinir le level d'accs
	requis pour la majorit des fonctions de %S. (Les commandes
	SET FOUNDER et SET PASSWORD, ainsi que cette commande,
	sont toujours rserves au propritaire du canal.)
	
	LEVELS SET permet au level d'accs pour une fonction ou un
	groupe de fonctions d'tre chang. LEVELS DISABLE (ou DIS
	en abrg) dsactive une fonction automatique ou empche l'accs
	 une fonction par quiconque sauf le propritaire du canal.
	LEVELS LIST montre les levels courants pour chaque fonction
	ou groupe de fonctions. LEVELS RESET rinitialise les levels
	avec les levels par dfaut d'un canal fraichement cr 
	(consultez HELP ACCESS LEVELS).

	Pour une liste de caractristiques et fonctions pour lesquels
	des levels peuvent tre dfinis, consultez HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	Les noms de caractristiques/fonctions suivants sont utiliss.
	Notez que les levels pour AUTODEOP et NOJOIN sont des levels
	maximum, alors que tous les autres sont des levels minimum.

CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s

CHAN_HELP_INFO
	Syntaxe: INFO canal [ALL]
	
	Liste les informations concernant le canal nomm
	enregistr, dont son propritaire, la date d'enregistrement,
	la date de dernire utilisation, la description, et
	les modes bloqus, si il y en a. Si ALL est donn, le 
	message d'entre et le successeur seront galement affichs.
	
	Par dfaut, l'option ALL est limite  ceux ayant un accs 
	de propritaire sur le canal.

CHAN_HELP_LIST
	Syntaxe: LIST modle
	
	Liste tous les canaux enregistrs correspondants au
	modle donn. (Les canaux avec l'option PRIVATE ne
	sont pas lists.)

CHAN_HELP_OP
	Syntaxe: OP [#canal [pseudo]]
	
	Op le pseudo slectionn sur un canal. Si pseudo n'est pas
	donn, vous oppera sur le canal donn. Si pseudo et
	#canal ne sont pas donns, vous oppera sur tous
	les canaux o vous tes.
	
	Par dfaut, limit aux AOPs ou  ceux ayant un niveau
	d'accs de 5 ou plus sur le canal.

CHAN_HELP_DEOP
	Syntaxe: DEOP [#canal [pseudo]]
	
	Deop le pseudo slectionn sur un canal. Si pseudo n'est pas
	donn, vous deoppera sur le canal donn. Si pseudo et
	#canal ne sont pas donns, vous deoppera sur tous
	les canaux o vous tes.

	Par dfaut, limit aux AOPs ou  ceux ayant un niveau 
	d'accs de 5 ou plus sur le canal.
	
CHAN_HELP_VOICE
	Syntaxe: VOICE [#canal [pseudo]]
	
	Voice le pseudo slectionn sur un canal. Si pseudo n'est pas
	donn, vous voicera sur le canal donn. Si pseudo et
	canal ne sont pas donns, vous voicera sur tous
	les canaux o vous tes.
	
	Par dfaut, limit aux AOPs ou  ceux ayant un level d'accs 
	de 5 ou plus sur le canal, ou aux VOPs ou  ceux ayant un 
	niveau d'accs de 3 ou plus en cas de voice de soi-mme.

CHAN_HELP_DEVOICE
	Syntaxe: DEVOICE [#canal [pseudo]]
	
	Devoice le pseudo slectionn sur un canal. Si pseudo n'est pas
	donn, vous devoicera sur le canal donn. Si pseudo et
	#canal ne sont pas donns, vous devoicera sur tous
	les canaux o vous tes.

	Par dfaut, limit aux AOPs ou  ceux ayant un level d'accs 
	de 5 ou plus sur le canal, ou aux VOPs ou  ceux ayant un 
	niveau d'accs de 3 ou plus en cas de devoice de soi-mme.
	
CHAN_HELP_HALFOP
	Syntaxe: HALFOP [#canal [pseudo]]
	
	Halfop le pseudo slectionn sur un canal. Si pseudo n'est pas
	donn, vous halfoppera sur le canal donn. Si pseudo et
	#canal ne sont pas donns, vous halfoppera sur tous
	les canaux o vous tes.
	
	Par dfaut, limit aux AOPs ou  ceux ayant un level d'accs 
	de 5 ou plus sur le canal, ou aux HOPs ou  ceux ayant un 
	niveau d'accs de 4 ou plus en cas de halfop de soi-mme.

CHAN_HELP_DEHALFOP
	Syntaxe: DEHALFOP [#canal [pseudo]]
	
	Dehalfop le pseudo slectionn sur un canal. Si pseudo n'est pas
	donn, vous dehalfoppera sur le canal donn. Si pseudo et
	#canal ne sont pas donns, vous dehalfoppera sur tous
	les canaux o vous tes.

	Par dfaut, limit aux AOPs ou  ceux ayant un level d'accs 
	de 5 ou plus sur le canal, ou aux HOPs ou  ceux ayant un 
	niveau d'accs de 4 ou plus en cas de dehalfop de soi-mme.
	
CHAN_HELP_PROTECT
	Syntaxe: PROTECT [#canal [pseudo]]
	
	Protge le pseudo slectionn sur un canal. Si pseudo n'est pas
	donn, vous protgera sur le canal donn. Si pseudo et
	#canal ne sont pas donns, vous protgera sur tous
	les canaux o vous tes.
	
	Par dfaut, limit au propritaire du channel, ou aux SOPs 
	ou  ceux ayant un niveau d'accs de 10 ou plus en cas de 
	protection de soi-mme.

CHAN_HELP_DEPROTECT
	Syntaxe: DEPROTECT [#canal [pseudo]]
	
	Enlve la protection du pseudo slectionn sur un canal. Si 
	pseudo n'est pas donn, vous dprotgera sur le canal 
	donn. Si pseudo et #canal ne sont pas donns, vous 
	dprotgera sur tous les canaux o vous tes.

	Par dfaut, limit au propritaire du canal, ou aux SOPs 
	ou  ceux ayant un niveau d'accs de 10 ou plus en cas de 
	suppression de protection pour soi-mme.

CHAN_HELP_OWNER
	Syntaxe: OWNER [#canal]
	
	Vous donne le status de propritaire sur le canal donn. 
	Si #canal n'est pas donn, vous donnera le status de
	propritaire sur tous les canaux o vous tes,  condition
	bien sr d'y avoir droit.
	
	Limit  ceux ayant un accs de propritaire sur le canal.

CHAN_HELP_DEOWNER
	Syntaxe: DEOWNER [#canal]
	
	Vous supprime le status de propritaire sur le canal 
	donn. Si canal n'est pas donn, vous donnera le status 
	de propritaire sur tous les canaux o vous tes,  
	condition bien sr d'y avoir droit.
	
	Limit  ceux ayant un accs de propritaire sur le canal.

CHAN_HELP_INVITE
	Syntaxe: INVITE canal
	
	Demande  %S de vous inviter sur le canal donn. 
	
	Par dfaut, limit aux AOPs ou  ceux ayant un niveau 
	d'accs de 5 ou plus sur le canal.

CHAN_HELP_UNBAN
	Syntaxe: UNBAN canal
	
	Demande  %S d'enlever tous les bans vous empchant
	d'entrer sur le canal donn. 

	Par dfaut, limit aux AOPs ou  ceux ayant un niveau 
	d'accs de 5 ou plus sur le canal.

CHAN_HELP_KICK
	Syntaxe: KICK [#canal [pseudo [raison]]]
	
	Kicke le pseudo slectionn sur un canal. Si pseudo n'est pas
	donn, vous kickera sur le canal donn. Si pseudo et
	#canal ne sont pas donns, vous kickera sur tous
	les canaux o vous tes.

	Par dfaut, limit aux AOPs ou  ceux ayant un niveau 
	d'accs de 5 ou plus sur le canal.

CHAN_HELP_BAN
	Syntaxe: BAN [#canal [pseudo [raison]]]
	
	Bannit le pseudo slectionn sur un canal. Si pseudo n'est pas
	donn, vous bannira sur le canal donn. Si pseudo et
	canal ne sont pas donns, vous bannira sur tous
	les canaux o vous tes.

	Par dfaut, limit aux AOPs ou  ceux ayant un niveau 
	d'accs de 5 ou plus sur le canal.

CHAN_HELP_TOPIC
	Syntaxe: TOPIC canal [topic]
	
	%S change le topic du canal pour celui spcifi. Si 
	topic n'est pas donn, alors le topic du canal sera 
	supprim. Cette commande est surtout utile en conjonction
	avec la commande SET TOPICLOCK. Consultez 
	%R%S HELP SET TOPICLOCK pour plus d'informations.
	
	Par dfault, limit  ceux ayant un accs de propritaire
	sur le canal.

CHAN_HELP_CLEAR
	Syntaxe: CLEAR canal quoi
	
	Demande  %S d'enlever certains aspects d'un canal. 
	quoi peut tre un des suivants:
	
	     MODES   Rinitialise tous les modes d'un canal
	     BANS    Enlve tous les bans d'un canal.
	     EXCEPTS Enlve tous les excepts d'un canal.
	     OPS     Enlve le status d'oprateur du canal 
	             tous les oprateurs du canal.
	     HOPS    Enlve le status d'halfop (mode +h) a tout les halfop
	             du canal.
	     VOICES  Enlve le status de "voice" (mode +v)  toute
	             personne ayant ce mode.
	     USERS   Kicke tous les utilisateurs d'un canal.
	
	Par dfault, limit  ceux ayant un accs de propritaire
	sur le canal.
	
CHAN_HELP_GETKEY
	Syntaxe: GETKEY canal
	
	Retourne la clef du canal donn. GETKEY est une commande
	qui est principalement destin  tre utilise par des
	bots ou des scripts, pour cela, la rponse a le format
	suivant:
	
	KEY <canal> <clef>
	
	La clef sera "NO KEY" si aucune clef n'est dfinie.
	
CHAN_HELP_SENDPASS
	Syntaxe: SENDPASS canal
	
	Envoie le mot de passe du canal donn  l'adresse e-mail 
	qui a t dfinie pour le propritaire de ce canal. Cette 
	commande est trs utile pour rgler les problmes de mots 
	de passe perdus.
	
	Peut tre limite aux IRC operators sur certains
	rseaux.
	
	Cette commande est indisponible quand l'encryption est
	active.

CHAN_SERVADMIN_HELP
	
	Les Services admins peuvent aussi effacer tout canal sans
	avoir besoin de s'identifier avec un mot de pass, et peuvent
	voir l'access, AKICK, et level lists de tout canaux.

CHAN_SERVADMIN_HELP_LOGOUT
	Syntaxe: LOGOUT canal [pseudo]
	
	Cette commande supprime l'identification du pseudo slectionn
	pour le canal donn.
	
	Si vous tes le propritaire du canal, vous pouvez utiliser
	la commande sur n'importe qui, sinon vous ne pouvez que
	l'utiliser sur vous mme.
	
	Si vous tes un Services admin, vous pouvez utiliser
	cette commande sur n'importe qui pour n'importe quel 
	canal sans avoir besoin d'tre le propritaire du canal.
	Vous pouvez galement omettre le paramtre pseudo, cela aura
	pour effet de supprimer l'identification pour tous les 
	utilisateurs identifis au canal.

CHAN_SERVADMIN_HELP_DROP
	Syntaxe: DROP canal
	
	Efface le canal nomm. Seuls les Services admins
	peuvent effacer un canal pour lequel ils n'ont
	pas t identifis.

CHAN_SERVADMIN_HELP_SET
	
	Les Services admins peuvent aussi dfinir l'option 
	NOEXPIRE, avec lequel les canaux peuvent tre empchs
	d'expirer. De plus, les Services admins peuvent dfinir
	les options de tout canal sans s'identifier avec le
	mot de passe du canal. 

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	Syntaxe: SET canal NOEXPIRE {ON | OFF}
	
	Dfinit si le canal donn expirera. Mettre ceci  ON
	empche le canal d'expirer.
	
	Rserve aux Services admins.

CHAN_SERVADMIN_HELP_INFO
	
	Les services admins peuvent utiliser le paramtre ALL 
	avec n'importe quel canal.

CHAN_SERVADMIN_HELP_LIST
	Syntaxe: LIST modle
	
	Liste tous les canaux enregistrs correspondants au modle
	donn. Les canaux avec l'option PRIVATE seront uniquement
	affichs aux Services admins. Les canaux ayant l'option 
	NOEXPIRE seront prfixs par un ! pour les Services admins. 
	
	Si les options FORBIDDEN ou NOEXPIRE sont donnes, seuls 
	les canaux qui, respectivement, sont interdits ou ont l'option
	NOEXPIRE active seront affichs. Si les deux options sont
	donnes, les deux types de canaux seront affichs. Ces options
	sont rserves aux Services admins.

CHAN_SERVADMIN_HELP_GETPASS
	Syntaxe: GETPASS canal
	
	Retourne le mot de passe du canal donn. Notez que
	lorsque cette commande est utilise, un message comprenant
	la personne qui a utilis cette commande et le canal
	pour lequel elle a t utilise sera logge et envoye en
	un WALLOPS/GLOBOPS.
	
	Rserve aux Services admins.

CHAN_SERVADMIN_HELP_FORBID
	Syntaxe: FORBID canal [raison]
	
	Empche toute personne d'enregistrer ou d'utiliser le
	canal donn. Peut tre annul en effacant le canal.
	
	La raison peut tre requise sur certains rseaux.
	
	Rserve aux Services admins.

CHAN_SERVADMIN_HELP_SUSPEND
	Syntax: SUSPEND canal [raison]
	
	Dsactive l'enregistrement du canal donn. Ceci peu
	etre invers via la commande UNSUSPEND et recuprer
	les donnes et configurations.
	
	Une raison peut etre demand sur certain rseaux.
	
	Limit aux Services admins.

CHAN_SERVADMIN_HELP_UNSUSPEND
	Syntax: UNSUSPEND canal
	
	Libre un canal qui a t suspendu. Toutes les donnes
	et configurations seront restaur tel qu'elles etait
	avant la suspension.
	
	Limit aux Services admins.

CHAN_SERVADMIN_HELP_STATUS
	Syntaxe: STATUS canal pseudo
	
	Retourne le level d'accs actuel du pseudo donn pour le 
	canal donn. La rponse est de la forme:
	
	    STATUS canal pseudo access-level
	
	Si une erreur se produit, la rponse sera de la forme:
	
	    STATUS ERROR error-message
	
	Rserve aux Services admins.

###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP_CMD_SEND
	    SEND   Envoie un memo  un pseudo ou un canal
MEMO_HELP_CMD_CANCEL
	    CANCEL Annule le dernier memo que vous avez envoy
MEMO_HELP_CMD_LIST
	    LIST   Liste vos memos
MEMO_HELP_CMD_READ
	    READ   Lit un ou des memos
MEMO_HELP_CMD_DEL
	    DEL    Efface un ou des memos
MEMO_HELP_CMD_SET
	    SET    Dfinit des options relatifs aux memos
MEMO_HELP_CMD_INFO
	    INFO   Affiche des informations  propos de vos memos
MEMO_HELP_CMD_RSEND
	    RSEND  Envoie un memo et demande un accus de reception
MEMO_HELP_CMD_CHECK
	    CHECK  Vrifie si le dernier memo envoy a un pseudo a t
	           lu
MEMO_HELP_CMD_SENDALL
	    SENDALL  Envoie un memo a tout les pseudos enregistr
MEMO_HELP_CMD_STAFF
	    STAFF  Envoie un memo  tout les opers/admins

MEMO_HELP_HEADER
	%S est un utilitaire permettant aux utilisateurs IRC
	d'envoyer de courts messages aux autres utilisateurs IRC,
	qu'ils soient online  ce moment l ou non, ou aux 
	canaux(*). Le pseudo de l'expditeur ET du destinataire ou
	du canal doivent tre enregistrs pour pouvoir envoyer un
	memo.
	
	Les commandes de %S sont:
	

MEMO_HELP_ADMIN
	not used.
MEMO_HELP_OPER
	not used.
MEMO_HELP_FOOTER

	Tapez %R%S HELP commande pour de l'aide sur
	une des commandes ci-dessus.

	(*) Par dfaut, tout utilisateur avec au moins un level d'accs
	    de 10 sur un canal peut lire ces memos du canal. Ceci
	    peut tre chang avec la commande LEVELS de %s.

MEMO_HELP_SEND
	Syntaxe: SEND {pseudo | canal} texte du memo
	
	Envoie un memo au pseudo ou canal nomm contenant
	texte du memo. En envoyant  un pseudo, le destinataire
	sera inform qu'il/elle a un nouveau memo. Le pseudo/canal
	destinataire doit tre enregistr.
	
MEMO_HELP_CANCEL
	Syntaxe: CANCEL {pseudo | canal}
	
	Supprime le dernier memo que vous avez envoy  un pseudo ou
	canal donn,  condition qu'il n'ait pas t lu lorsque vous
	utilisez la commande.

MEMO_HELP_LIST
	Syntaxe: LIST [canal] [liste | NEW]
	
	Liste tous les memos que vous avez actuellement. Avec NEW,
	liste uniquement les nouveaux memos (non lus). Les memos non
	lus sont marqus avec un "*"  gauche du numro du memo. Vous
	pouvez galement spcifier une liste de numros, comme dans
	l'exemple ci dessous:

	   LIST 2-5,7-9
	      Liste les memos 2  5 et 7  9.

MEMO_HELP_READ
	Syntaxe: READ [canal] {nombre | liste | LAST | NEW}
	
	Vous envoie le texte des memos spcifis. Si LAST est donn,
	vous envoie le dernier memo reu. Si NEW est donn, vous
	envoie tous vos nouveaux memos. Sinon, vous envoie le memo
	numro nombre. Vous pouvez galement donner une liste
	de nombres, comme dans cet exemple:
	
	   READ 2-5,7-9
	      Affiche les memos 2  5 et 7  9.

MEMO_HELP_DEL
	Syntaxe: DEL [canal] {nombre | liste | LAST | ALL}
	
	Supprime le ou les memos spcifis. Vous pouvez
	fournir plusieurs numros de memos ou des ordres de nombres
	au lieu d'un nombre unique, comme dans le second exemple
	ci-dessous.
	
	Si LAST est donn, le dernier mmo sera supprim.
	Si ALL est donn, cela supprimera tous vos memos.
	
	Exemples:
	
	   DEL 1
	      Supprime votre premier memo.
	
	   DEL 2-5,7-9
	      Supprime les memos compris entre 2 et 5 et entre 7 et 9.

MEMO_HELP_SET
	Syntaxe: SET option paramtres
	
	Dfinit plusieurs options de memo. option peut tre:
	
	    NOTIFY      Dfinit si vous serez notifis de vos
	                  nouveaux memos (seulement pour les 
	                  pseudos)
	    LIMIT       Dfinit le nombre de memos maximum que 
	                  vous pouvez recevoir
	
	Tapez %R%S HELP SET option pour plus 
	d'informations sur une option spcifique.

MEMO_HELP_SET_NOTIFY
	Syntaxe: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	Change quand vous serez notifi de vos nouveaux
	memos:
	
	    ON     Vous serez notifis lorsque vous vous connectez,
	           lorsque vous enlevez /AWAY, et quand ils vous
	           sont envoys.	
	    LOGON  Vous serez uniquement notifis des memos lorsque
	           vous vous connectez ou quand vous enlevez
	           /AWAY.
	    NEW    Vous serez uniquement notifis des memos 
	           lorsqu'ils vous sont envoys.
	    OFF    Vous ne recevrez aucune notification.
	
	ON est la combination de LOGON et NEW.

MEMO_HELP_SET_LIMIT
	Syntaxe: SET LIMIT [canal] limite
	
	Dfinit le nombre maximum de memos que vous (ou le canal
	donn) est autoris  avoir. Si vous dfinissez ceci  0,
	personne ne pourra vous envoyer de memos. Cependant, vous
	ne pouvez pas dfinir ceci  plus que %d.

MEMO_HELP_INFO
	Syntaxe: INFO [canal]
	
	Affiche des informations sur le nombre de memos que vous
	avez, combien sont non lus, et combien de memos vous pouvez
	recevoir au total. Avec un paramtre, affiche la mme
	information pour le canal donn.

MEMO_SERVADMIN_HELP_SET_LIMIT
	Syntaxe: SET LIMIT [utilisateur | canal] {limite | NONE} [HARD]
	
	Dfinit le nombre maximum de memos qu'un utilisateur ou
	un canal est autoris  avoir. Dfinir la limite  0
	empche l'utilisateur de recevoir des memos, dfinir ceci
	 NONE permet  l'utilisateur de recevoir et garder
	autant de memos qu'ils veulent. Si vous ne donnez pas de
	pseudo ou de canal, votre propre limite est dfinie.
	
	Ajouter HARD empche l'utilisateur de changer cette limite.
	Ne pas ajouter HARD a l'effet inverse, permettant  
	l'utilisateur de changer cette limite (mme si une limite
	antrieure a t dfinie avec HARD).
	
	Cette utilisation de la commande SET LIMIT est rserve aux
	Services admins. Les autres utilisateurs peuvent uniquement
	entrer une limite pour eux-mmes ou un canal sur lequel ils
	ont de tels privilges, ne peuvent supprimer %d limite, et
	ne peuvent dfinir de limite stricte.

MEMO_SERVADMIN_HELP_INFO
	Syntaxe: INFO [pseudo | canal]
	
	Sans paramtre, affiche les informations sur le nombre
	de memos que vous avez, combien sont non lus, et combien
	de memos vous pouvez recevoir au total.
	
	Avec un paramtre de canal, affiche la mme information
	pour le canal donn.
	
	Avec un paramtre de pseudo, affiche la mme information 
	pour le pseudo donn. Cette utilisation rserve aux Services
	admins.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_STAFF
	Syntaxe: STAFF texte

	Envoie un memo  tout le staff des services contenant le
	texte.
	Note: Si vous avez un bot ou des clones dans la liste des
	oper et admins, ils recevront aussi un memo.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_SENDALL
	Syntaxe: SENDALL texte

	Envoie un memo a tout les pseudos enregistr contenant le texte.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_RSEND
	Syntaxe: RSEND {pseudo | canal} texte
	
	Envoie un memo au pseudo ou canal donn contenant le texte.
	Lorsque c'est envoy a un pseudo, le destinataire recevra une notice
	l'avertissant de l'arriv de nouveau(x) memo(s). Le destinataire dois
	etre un pseudo ou un canal enregistr.
	Une fois le memo lu, un accus de rception vous est automatiquement
	envoy afin de vous assur que le memo a t lu.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_CHECK
	Syntaxe: CHECK pseudo
	
	Vrifie si le dernier memo que vous avez envoy au pseudo donn
	a t lu ou non.
	Note: Cela fonctionne uniquement avec un pseudo et non pas avec un
	canal.

###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP_CMD_GLOBAL
	    GLOBAL      Envoie un message  tous les utilisateurs
OPER_HELP_CMD_STATS
	    STATS       Affiche le status des Services et du rseau
OPER_HELP_CMD_OPER
	    OPER        Modifie la liste des oprateurs des Services
OPER_HELP_CMD_ADMIN
	    ADMIN       Modifie la liste des administrateurs des Services
OPER_HELP_CMD_STAFF
	    STAFF       Affiche le staff des services et leurs status 
OPER_HELP_CMD_MODE
	    MODE        Change les modes d'un canal
OPER_HELP_CMD_KICK
	    KICK        Expulse un utilisateur d'un canal
OPER_HELP_CMD_CLEARMODES
	    CLEARMODES  Supprime tous les modes d'un canal
OPER_HELP_CMD_KILLCLONES
	    KILLCLONES  Dconnecte tous les utilisateurs ayant un
	                certain hostname
OPER_HELP_CMD_AKILL
	    AKILL       Contrle la liste des AKILLs
OPER_HELP_CMD_SGLINE
	    SGLINE      Contrle la liste des SGLINEs
OPER_HELP_CMD_SQLINE
	    SQLINE      Contrle la liste des SQLINEs
OPER_HELP_CMD_SZLINE
	    SZLINE      Contrle la liste des SZLINEs
OPER_HELP_CMD_CHANLIST
	    CHANLIST    Liste tous les canaux
OPER_HELP_CMD_USERLIST
	    USERLIST    Liste tous les utilisateurs
OPER_HELP_CMD_LOGONNEWS
	    LOGONNEWS   Dfinit les messages affichs aux utilisateurs
	                 la connexion
OPER_HELP_CMD_RANDOMNEWS
	    RANDOMNEWS  Dfinit les messages affichs alatoirement
	                aux utilisateurs  la connexion
OPER_HELP_CMD_OPERNEWS
	    OPERNEWS    Dfinit les messages affichs aux utilisateurs
	                qui deviennent IRCops
OPER_HELP_CMD_SESSION
	    SESSION     Affiche la liste des sessions par host
OPER_HELP_CMD_EXCEPTION
	    EXCEPTION   Modifie la liste d'exceptions  la limite de
	                session
OPER_HELP_CMD_NOOP
	    NOOP        Supprime temporairement toutes les O:lines
	                d'un serveur
OPER_HELP_CMD_JUPE
	    JUPE        "Jupiter" un serveur
OPER_HELP_CMD_IGNORE
	    IGNORE      Modifier la liste d'ignore des services
OPER_HELP_CMD_SET
	    SET         Configure des options globales des Services
OPER_HELP_CMD_RELOAD
	    RELOAD      Recharge le fichier de configuration des Services
OPER_HELP_CMD_UPDATE
	    UPDATE      Oblige les bases de donnes des Services
	                 tre sauvegardes immdiatement.
OPER_HELP_CMD_RESTART
	    RESTART     Sauvegarde les bases de donnes et relance les
	                Services.
OPER_HELP_CMD_QUIT
	    QUIT        Arrte les Services sans sauvegarde
OPER_HELP_CMD_SHUTDOWN
	    SHUTDOWN    Arrte les Services avec sauvegarde
OPER_HELP_CMD_DEFCON
	    DEFCON      Active/Dsactive DefCon
OPER_HELP_CMD_CHANKILL
	    CHANKILL    Kill tout les utilisateurs d'un canal spcifique
OPER_HELP_CMD_OLINE
	    OLINE       Donne les flags d'un Oper  un utilisateur
OPER_HELP_CMD_UMODE
	    UMODE       Change un mode d'un utilisateur
OPER_HELP_CMD_SVSNICK
	    SVSNICK     Force le changement de pseudo d'un utilisateur
OPER_HELP_CMD_MODLOAD
	    MODLOAD     Charge un module
OPER_HELP_CMD_MODUNLOAD
	    MODUNLOAD   Dcharge un module
OPER_HELP_CMD_MODINFO
	    MODINFO     Liste les informations sur un module charg
OPER_HELP_CMD_MODLIST
	    MODLIST     Liste les modules chargs

OPER_HELP
	Commandes %S:

OPER_HELP_LOGGED
	Remarque: Toutes les commandes envoyes  %S sont enregistres!

OPER_HELP_GLOBAL
	Syntaxe: GLOBAL message
	
	Permet aux IRCops d'envoyer des messages  tous les 
	utilisateurs du rseau. Le message sera envoy avec
	le pseudo %s.

OPER_HELP_STATS
	Syntaxe: STATS [AKILL | ALL | RESET | MEMORY | UPLINK]
	
	Sans option, affiche le nombre d'utilisateurs et d'IRCops
	actuellement online (Services exclus), le plus grand nombre
	d'utilisateurs online depuis le dmarrage des Services, et
	le nombre d'heures durant lesquelles les Services ont tourn.
	
	Avec l'option AKILL, affiche la taille actuelle de la liste
	d'AKILL et le temps d'chance par dfaut.
	
	L'option ALL est rserve uniquement aux Services admins,
	et affiche des informations sur l'utilisation de la mmoire
	par les Services. L'utilisation de cette commande peut geler
	les Services pendant un court instant sur de grands rseaux,
	donc n'en abusez pas!
	
	L'option RESET rinitialise le nombre maximum d'utilisateurs
	au nombre courant d'utilisateurs sur le rseau.

	L'option MEMORYaffiche les informations sur l'utilisation
	de la mmoire par les services. L'utilisation de cette commande
	peut paralyser les Services durant un court instant sur les gros
	rseaux; n'en abuser pas!
		
	L'option UPLINK affiche les informations sur le serveur qui est
	utilis pour linker Anope au rseau.
	
	UPTIME est l'quivalent de STATS.

OPER_HELP_OPER
	Syntaxe: OPER ADD pseudo
	         OPER DEL {pseudo | entre | liste}
	         OPER LIST [mask | liste]
	         OPER CLEAR
	
	Permet aux Services admins d'ajouter ou de supprimer des
	pseudo  ou de la liste des Services operators. Un utilisateur 
	dont le pseudo est dans la liste des Services operators et qui est 
	identifi auprs de %s aura accs aux commandes de Services
	operateur.
	
	La commande OPER ADD ajoute le pseudo donn  la liste
	des Services operateurs.
	
	La commande OPER DEL supprime le pseudo donn de
	la liste des Services operateurs. Si une liste de numros 
	d'entres est donne, ces entres sont supprimes. (Consultez 
	l'exemple pour LIST ci-dessous.)
	
	La commande OPER LIST affiche la liste des Services operateurs. 
	Si un mask joker est donn, seules les entres correspondantes
	au mask sont affiches. Si une liste de numros d'entre
	est donne, seules ces entres sont affiches, par exemple:

	   OPER LIST 2-5,7-9
	        Liste toutes les entres comprises entre 2 et 5 et
	        entre 7 et 9.
	
	La commande OPER CLEAR supprime toutes les entres
	de la liste des Services operateurs.
	
	Un oprateur IRC peut utiliser la forme OPER LIST de 
	la commande. Toutes les autres utilisations sont rserves 
	aux Services admins.

OPER_HELP_ADMIN
	Syntaxe: ADMIN ADD pseudo
	         ADMIN DEL {pseudo | entre | liste}
	         ADMIN LIST [mask | liste]
	         ADMIN CLEAR
	
	Permet au Services root d'ajouter ou de supprimer des
	pseudos  ou de la liste des Services admins. Un utilisateur 
	dont le pseudo est dans la liste des Services admins et qui est 
	identifi auprs de %s aura accs aux commandes de Services
	admin.
	
	La commande ADMIN ADD ajoute le pseudo donn  la liste
	des Services admins.
	
	La commande ADMIN DEL supprime le pseudo donn de
	la liste des Services admins. Si une liste de numros 
	d'entres est donne, ces entres sont supprimes. (Consultez 
	l'exemple pour LIST ci-dessous.)
	
	La commande ADMIN LIST affiche la liste des Services admins. 
	Si un mask joker est donn, seules les entres correspondantes
	au mask sont affiches. Si une liste de numros d'entre
	est donne, seules ces entres sont affiches, par exemple:

	   ADMIN LIST 2-5,7-9
	        Liste toutes les entres comprises entre 2 et 5 et
	        entre 7 et 9.
	
	La commande ADMIN CLEAR supprime toutes les entres
	de la liste des Services admins.
	
	Un oprateur IRC peut utiliser la forme ADMIN LIST de 
	la commande. Toutes les autres utilisations sont rserves au 
	Services root.

OPER_HELP_IGNORE
	Syntaxe: IGNORE {ADD|DEL|LIST} [time] [pseudo]

	Autorise les ServicesAdmin a poser des ignores envers les services
	sur les utilisateurs pendant une dure dfinie jusqu'a que les 
	soient redmarrs. La dure est indique en secondes par dfaut.
	Units reconnues: s pour les secondes, m pour les minutres, 
	h pour les heures et d pour les jours. Vous ne pouvez PAS les combiner.
	0 = Permanent

OPER_HELP_MODE
	Syntaxe: MODE canal modes
	
	Permet aux Services operateurs de dfinir les modes d'un
	canal. Les paramtres sont les mmes que pour la commande
	/MODE normale.
	
	Rserve aux Services operateurs.

OPER_HELP_UMODE
	Syntaxe: UMODE pseudo modes
	
	Permet aux ServicesAdmin de changer un mode d'un utilisateur.

OPER_HELP_OLINE
	Syntaxe: OLINE pseudo flags
	
	Permet de mettre un OperFlag  un utilisateur.
	Prfixes: "+" et "-". Pour tout supprimer, spcifiez "-"

	Limit aux ServicesAdmins.

OPER_HELP_CLEARMODES
	Syntaxe: CLEARMODES canal [ALL]
	
	Enlve tous les modes binaires (i,k,l,m,n,p,s,t) et les bans
	d'un canal. Si ALL est donn, enlve galement tous les
	ops et voices (modes +o et +v) du canal.
	
	Rserve aux Services operators.

OPER_HELP_KICK
	Syntaxe: KICK canal utilisateur raison
	
	Permet aux IRCops de kicker un utilisateur d'un canal.
	Les paramtres sont les mmes que pour la commande /KICK
	normale. Le message de kick sera prfix du pseudo de
	l'IRCop ayant utilis la commande KICK, par exemple:
	
	*** SpamMan a t kick du canal #canal par %S (Alcan (Flood))
	
	Rserve aux Services operators.

OPER_HELP_SVSNICK
	Syntaxe: SVSNICK pseudo nouveau-pseudo
	
	Force le changement de pseudo d'un pseudo.
	
	Limit aux Services admins

OPER_HELP_AKILL
	Syntaxe: AKILL ADD [+chance] masque raison
	         AKILL DEL {masque | numro d'entre | liste}
	         AKILL LIST [masque | liste]
	         AKILL VIEW [masque | liste]
	         AKILL CLEAR
	
	Permet aux oprateurs des Services de manipuler la liste
	d'AKILL. Si un utilisateur correspondant  un masque d'AKILL
	tente de se connecter, les Services enverront un KILL pour
	cet utilisateur et, sur les serveurs le supportant, demandera
	 tous les serveurs d'ajouter un ban (K-line) du masque
	qui correspondait.
	
	AKILL ADD ajoute le masque user@host donn  la liste 
	d'AKILL pour la raison prcise (qui doit tre donne).
	chance est un nombre entier suivi par un d (jours), h
	(heures), ou m (minutes). Les combinaisons (telles que
	1h30m) ne sont pas permises. Si l'unit n'est pas incluse,
	la valeur est en jours par dfaut (donc +30 est quivalent
	 30 jours). Pour ajouter une AKILL qui n'expire pas, utilisez
	+0. Si le masque utilisateur  ajouter commence par un +,
	une chance doit tre donne, mme si c'est la mme que
	celle par dfaut. L'chance par dfaut pour les AKILLs peut 
	tre consulte par la commande STATS AKILL.
	
	La commande AKILL DEL supprime le masque donn de la liste
	d'AKILL si il existe. Si une liste de numros d'entres
	est donne, ces entres sont supprimes. (Voyez l'exemple
	pour LIST ci-dessous.)
	
	La commande AKILL LIST affiche la liste d'AKILL. Si un
	masque joker est donn, seules les entres correspondantes
	au masque sont affiches. Si une liste de numros d'entres
	est donne, seules ces entres sont affiches, par exemple:

	   AKILL LIST 2-5,7-9
	      Liste les entres de la liste d'AKILL numro 2  5 
	      et 7  9.
	      
	AKILL VIEW est une version plus dtaille de AKILL LIST, 
	et affichera par qui et quand a t ajoute une AKILL et
	sa date d'expiration, en plus du masque user@host et de la 
	raison. 
	
	AKILL CLEAR vide toutes les entres de la liste d'AKILL.
	
	Rsrve aux oprateurs des Services.

OPER_HELP_SGLINE
	Syntaxe: SGLINE ADD [+chance] masque:raison
	         SGLINE DEL {masque | numro d'entre | liste}
	         SGLINE LIST [masque | liste]
	         SGLINE VIEW [masque | liste]
	         SGLINE CLEAR
	
	Permet aux oprateurs des Services de manipuler la liste
	de SGLINEs. Si un utilisateur ayant un vrai nom correspondant 
	 un masque de SGLINE tente de se connecter, les Services ne
	lui permettront pas de continuer sa session IRC.
	
	SGLINE ADD ajoute le masque de vrai nom donn  la liste 
	de SGLINEs pour la raison prcise (qui doit tre donne).
	chance est un nombre entier suivi par un d (jours), h
	(heures), ou m (minutes). Les combinaisons (telles que
	1h30m) ne sont pas permises. Si l'unit n'est pas incluse,
	la valeur est en jours par dfaut (donc +30 est quivalent
	 30 jours). Pour ajouter une SGLINE qui n'expire pas, utilisez
	+0. Si le masque de vrai nom  ajouter commence par un +,
	une chance doit tre donne, mme si c'est la mme que
	celle par dfaut. L'chance par dfaut pour les SGLINEs peut 
	tre consulte par la commande STATS AKILL.
	Note: puisque le masque de vrai nom peut contenir des espaces,
	le sparateur entre lui et la raison est un deux points.
	
	La commande SGLINE DEL supprime le masque donn de la liste
	de SGLINEs si il existe. Si une liste de numros d'entres
	est donne, ces entres sont supprimes. (Voyez l'exemple
	pour LIST ci-dessous.)
	
	La commande SGLINE LIST affiche la liste des SGLINEs. Si un
	masque joker est donn, seules les entres correspondantes
	au masque sont affiches. Si une liste de numros d'entres
	est donne, seules ces entres sont affiches, par exemple:

	   SGLINE LIST 2-5,7-9
	      Liste les entres de la liste de SGLINEs numro 2  5 
	      et 7  9.
	      
	SGLINE VIEW est une version plus dtaille de SGLINE LIST, 
	et affichera par qui et quand a t ajoute une SGLINE et
	sa date d'expiration, en plus du masque de vrai nom et de la 
	raison. 
	
	SGLINE CLEAR vide toutes les entres de la liste de SGLINEs.
	
	Rsrve aux oprateurs des Services.

OPER_HELP_SQLINE
	Syntaxe: SQLINE ADD [+chance] masque raison
	         SQLINE DEL {masque | numro d'entre | liste}
	         SQLINE LIST [masque | liste]
	         SQLINE VIEW [masque | liste]
	         SQLINE CLEAR
	
	Permet aux oprateurs des Services de manipuler la liste
	de SQLINEs. Si un utilisateur ayant un nick correspondant 
	 un masque de SQLINE tente de se connecter, les Services ne
	lui permettront pas de continuer sa session IRC.
	
	Si le premier caractre du masque est un #, les services
	empcheront l'utilisation des channels correspondants (sur
	les IRCds le supportant).
	
	SQLINE ADD ajoute le masque donn  la liste de SQLINEs pour 
	la raison prcise (qui doit tre donne).
	chance est un nombre entier suivi par un d (jours), h
	(heures), ou m (minutes). Les combinaisons (telles que
	1h30m) ne sont pas permises. Si l'unit n'est pas incluse,
	la valeur est en jours par dfaut (donc +30 est quivalent
	 30 jours). Pour ajouter une SQLINE qui n'expire pas, utilisez
	+0. Si le masque  ajouter commence par un +,
	une chance doit tre donne, mme si c'est la mme que
	celle par dfaut. L'chance par dfaut pour les SQLINEs peut 
	tre consulte par la commande STATS AKILL.
	
	La commande SQLINE DEL supprime le masque donn de la liste
	de SQLINEs si il existe. Si une liste de numros d'entres
	est donne, ces entres sont supprimes. (Voyez l'exemple
	pour LIST ci-dessous.)
	
	La commande SQLINE LIST affiche la liste des SQLINEs. Si un
	masque joker est donn, seules les entres correspondantes
	au masque sont affiches. Si une liste de numros d'entres
	est donne, seules ces entres sont affiches, par exemple:

	   SQLINE LIST 2-5,7-9
	      Liste les entres de la liste de SQLINEs numro 2  5 
	      et 7  9.
	      
	SQLINE VIEW est une version plus dtaille de SQLINE LIST, 
	et affichera par qui et quand a t ajoute une SQLINE et
	sa date d'expiration, en plus du masque et de la raison. 
	
	SQLINE CLEAR vide toutes les entres de la liste de SQLINEs.
	
	Rsrve aux oprateurs des services.
	
OPER_HELP_SZLINE
	Syntaxe: SZLINE ADD [+chance] masque raison
	         SZLINE DEL {masque | numro d'entre | liste}
	         SZLINE LIST [masque | liste]
	         SZLINE VIEW [masque | liste]
	         SZLINE CLEAR
	
	Permet aux oprateurs des Services de manipuler la liste
	de SZLINEs. Si un utilisateur ayant une IP correspondante 
	 un masque de SZLINE tente de se connecter, les Services ne
	lui permettront pas de continuer sa session IRC (et ce,
	mme si l'IP a un PTR RR).
	
	SZLINE ADD ajoute le masque d'IP donn  la liste 
	de SZLINEs pour la raison prcise (qui doit tre donne).
	chance est un nombre entier suivi par un d (jours), h
	(heures), ou m (minutes). Les combinaisons (telles que
	1h30m) ne sont pas permises. Si l'unit n'est pas incluse,
	la valeur est en jours par dfaut (donc +30 est quivalent
	 30 jours). Pour ajouter une SZLINE qui n'expire pas, utilisez
	+0. Si le masque de vrai nom  ajouter commence par un +,
	une chance doit tre donne, mme si c'est la mme que
	celle par dfaut. L'chance par dfaut pour les SZLINEs peut 
	tre consulte par la commande STATS AKILL.
	
	La commande SZLINE DEL supprime le masque donn de la liste
	de SZLINEs si il existe. Si une liste de numros d'entres
	est donne, ces entres sont supprimes. (Voyez l'exemple
	pour LIST ci-dessous.)
	
	La commande SZLINE LIST affiche la liste des SZLINEs. Si un
	masque joker est donn, seules les entres correspondantes
	au masque sont affiches. Si une liste de numros d'entres
	est donne, seules ces entres sont affiches, par exemple:

	   SZLINE LIST 2-5,7-9
	      Liste les entres de la liste de SZLINEs numro 2  5 
	      et 7  9.
	      
	SZLINE VIEW est une version plus dtaille de SZLINE LIST, 
	et affichera par qui et quand a t ajoute une SZLINE et
	sa date d'expiration, en plus du masque d'IP et de la 
	raison.
	
	SZLINE CLEAR vide toutes les entres de la liste de SZLINEs.
	
	Rsrve aux oprateurs des Services.

OPER_HELP_SET
	Syntaxe: SET option valeur
	
	Contrle diffrentes options globales aux Servies. 
	Les noms des options actuelles sont:
	
	    READONLY   Active ou dsactive le mode lecture seule.
	    LOGCHAN    Report des logs sur un canal
	    DEBUG      Active ou dsactive le mode de dboguage
	    NOEXPIRE   Active ou dsactive le mode sans expiration
	    SUPERADMIN Active ou dsactive le mode super-admin
	    SQL   	   Active ou dsactive le mode SQL
	    IGNORE     Active ou dsactive le mode ignore
	    LIST       Liste les options
	
	Rserve aux Services admins.

OPER_HELP_SET_READONLY
	Syntaxe: SET READONLY {ON | OFF}
	
	Active ou dsactive le mode lecture seule. Dans le mode 
	lecture-seule, les utilisateurs normaux ne seront pas 
	autoriss  modifier les donnes des Services, comprenant
	les access lists des canaux et pseudos, etc. Les IRCops
	ayant suffisamment de droits sur les Services pourront 
	modifier l'AKILL list des services et effacer ou interdire
	des pseudos et canaux, mais de tels changements ne seront
	pas sauvegards  moins que le mode lecture seule ne soit
	dsactiv avant que les Services ne soient arrts ou
	relancs.
	
	Cette option est quivalente  l'option de la ligne de commande
	-readonly.

OPER_HELP_SET_LOGCHAN
	Syntaxe: SET LOGCHAN {ON | OFF}

	Permet d'envoyer les logs sur un canal en plus d'crire dans le
	fichier de log. LogChannel doit tre dfini dans le fichier
	de configuration des services.

	Note: En mettant cette option sur OFF vous renforcerez la scurit...

OPER_HELP_SET_DEBUG
	Syntaxe: SET DEBUG {ON | OFF | nombre}
	
	Active ou dsactive le debug mode. Dans le debug mode, toutes
	les donnes envoyes vers et par les Services ainsi qu'un bon
	nombre d'autres messages de dboguage sont crits dans le 
	fichier de log. Si nombre est donn, le debug mode est activ,
	avec le niveau de dboguage  nombre.
	
	Cette option est quivalente  l'option de la ligne de commande
	-debug.
	
OPER_HELP_SET_NOEXPIRE
	Syntaxe: SET NOEXPIRE {ON | OFF}
	
	Active ou dsactive le mode sans expiration. Dans le mode 
	sans expiration, les pseudos, canaux, akills et exceptions 
	n'expireront pas jusqu' ce que l'option soit dsactive.
	
	Cette option est quivalente  l'option de la ligne de commande
	-noexpire.

OPER_HELP_SET_SUPERADMIN
	Syntax: SET SUPERADMIN {ON | OFF}

	Vous permet d'avoir tous les privilges comme le droit d'tre reconnu
	"founder" de toutes les canaux...

	Utilisation temporaire.

OPER_HELP_SET_SQL
	Syntaxe: SET SQL {ON | OFF}

	Activer cette option fera utiliser SQL a anope, cette option est 
	utilis pour activ ou dsactiver mysql lorsque votre serveur est
	down et que les services sont en cour de fonctionnement.
	
OPER_HELP_SET_IGNORE
	Syntaxe: SET IGNORE {ON | OFF}

	Activer ou dsactiv cette option pour l'utilisation de l'ignore.

OPER_HELP_SET_LIST
	Syntaxe: SET LIST

	Afficher diverse option  propos de OperServ

OPER_HELP_NOOP
	Syntaxe: NOOP SET serveur
	         NOOP REVOKE serveur
	
	NOOP SET supprime toutes les O:lines du serveur
	donn et dconnecte tous les IRCops qui sont dessus
	actuellement pour les empcher de rehasher le serveur
	(car cela annulerait les effets).
	
	NOOP REVOKE remet en place toutes les O:lines 
	supprimes du serveur donn.
	
	Note: Le paramtre serveur n'est en aucun cas 
	vrifi par les Services.

	Rserve aux administrateurs des Services.

OPER_HELP_JUPE
	Syntaxe: JUPE serveur [raison]
	
	Demande aux Services de juper un serveur -- c'est  dire,
	crer un faux serveur connect aux Services ce qui empche
	le vrai serveur ayant ce nom de se connecter. Le jupe peut
	tre enlev en utilisant un SQUIT normal. Si une raison
	est donne, elle est place dans le champ d'information du
	serveur, sinon, l'information du serveur contiendra le 
	texte "Juped by <pseudo>", laissant paratre le pseudo
	de la personne qui a jup le serveur.
	
	Rserve aux Services admins.

OPER_HELP_RAW
	Syntaxe: RAW texte
	
	Envoie une chane de texte directement au serveur sur 
	lequel les Services sont connects. Cette commande a un
	champ d'utilisation trs limit, et peut causer des
	troubles dans un rseau en cas de mauvaise utilisation.
	N'UTILISEZ PAS CETTE COMMANDE  moins d'tre absolument
	sr de ce que vous faites!
	
	Rserve aux Services admins.

OPER_HELP_UPDATE
	Syntaxe: UPDATE
	
	Provoque la mise  jour de toutes les bases de donnes ds
	que vous le demandez.
	
	Rserve aux Services admins.
	
OPER_HELP_RELOAD
	Syntaxe: RELOAD
	
	Provoque le rechargement du fichier de configuration des
	Services. Notez que certaines directives demandent tout
	de mme le redmarrage des Services pour prendre effet
	(comme le nom des services, l'activation de la limite
	de sessions, etc.)
	
	Rserve aux Services admins.

OPER_HELP_QUIT
	Syntaxe: QUIT
	
	Provoque un arrt immdiat des services, les bases de donnes
	ne sont pas sauvegardes. Cette commande ne devrait pas tre
	utilise  moins que des dommages dans la copie en mmoire des
	bases de donnes ne soient souponns. Pour des arrts normaux,
	utilisez la commande SHUTDOWN.
	
	Rserve aux Services admins.

OPER_HELP_SHUTDOWN
	Syntaxe: SHUTDOWN
	
	Provoque la sauvegarde de toutes les bases de donnes puis
	l'arrt des services.
	
	Rserve aux Services admins.

OPER_HELP_RESTART
	Syntaxe: RESTART
	
	Provoque la sauvegarde de toutes les bases de donnes et
	le redmarrage des Services (c'est  dire qu'il arrte
	le programme et le relance immdiatement).
	
	Rserve aux Services admins.

OPER_HELP_KILLCLONES
	Syntaxe: KILLCLONES pseudo
	
	Dconnecte tous les utilisateurs qui ont la mme host que
	pseudo. Une AKILL temporaire, de la forme *@host, est
	ajoute pour empcher les clients de se reconnecter
	immdiatement. Un wallops est galement envoy indiquant
	qui a utilis la commande, quelle host est affecte et
	combien d'utilisateurs ont t dconnects. Elle est
	utile pour supprimer un nombre important de clones du
	rseau.
	
	Rserve aux Services admins.
	
OPER_HELP_CHANLIST
	Syntaxe: CHANLIST [{modle | pseudo} [SECRET]]
	
	Liste tous les channels actuellement utiliss sur le rseau IRC, qu'ils
	soient enregistrs ou non.
	
	Si modle est donn, seuls les canaux correspondants sont lists. Si
	un pseudo est donn, les canaux sur lesquels est l'utilisateur ayant
	ce pseudo seront lists. Si SECRET est spcifi, liste seulement les canaux 
	correspondants  modle qui ont le mode +s ou +p.
	
	Rserve aux Services admins.
	
OPER_HELP_USERLIST
	Syntaxe: USERLIST [{modle | canal} [INVISIBLE]]
	
	Liste tous les utilisateurs connects sur le rseau IRC, enregistrs
	ou non.
	
	Si modle est donn (format nick!user@host), seuls les utilisateurs 
	correspondants seront lists. Si canal est donn, seuls les 
	utilisateurs du canal seront lists. +i INVISIBLE est spcifi,
	seuls les utilisateurs avec le mode +i seront lists.
	
	Rserve aux Services admins.

OPER_HELP_MODLOAD
	Syntaxe: MODLOAD Fichier

	Cette commande charge le module depuis le fichier situ dans le repertoire
	des modules.

	Limit aux Services Roots.

OPER_HELP_MODUNLOAD
	Syntaxe: MODUNLOAD Fichier

	Cette commande dcharge le module depuis le fichier situ dans le repertoire
	des modules.

	Limit aux Services Roots.

OPER_HELP_MODINFO
	Syntaxe: MODINFO Fichier

	Cette commande donne des informations sur un module charg.

	Limit aux Services Roots.

OPER_HELP_MODLIST
	Syntaxe: MODLIST

	Liste les modules actuelement chargs.

	Limit aux Services Roots.


###########################################################################
#
# BotServ help messages
#
###########################################################################

BOT_HELP_CMD_BOTLIST
	BOTLIST            Liste les bots disponibles
BOT_HELP_CMD_ASSIGN
	ASSIGN             Attribue un bot  un canal
BOT_HELP_CMD_SET
	SET                Configure les options du bot
BOT_HELP_CMD_KICK
	KICK               Configure les kickers
BOT_HELP_CMD_BADWORDS
	BADWORDS           Gre la liste des mots interdits
BOT_HELP_CMD_ACT
	ACT                Fait faire au bot l'quivalent de la commande /me
BOT_HELP_CMD_INFO
	INFO               Vous permet de voir des informations a propos de BotServ sur
	                   un canal ou un bot
BOT_HELP_CMD_SAY
	SAY                Fait dire au bot le texte donn sur un canal
BOT_HELP_CMD_UNASSIGN
	UNASSIGN           Retire le bot d'un canal
BOT_HELP_CMD_BOT
	BOT                Gre la liste des bots du rseau

BOT_HELP
	%S vous permet d'avoir un bot sur votre canal.
	Il a t conu pour les utilisateurs qui ne 
	peuvent hberger ou configurer un bot, ou pour
	tre utilis sur les rseaux qui n'autorisent pas
	un bot d'un utilisateur. Les commandes disponibles
	sont listes ci-dessous, pour les utiliser, tapez
	%R%S command. Pour plus d'information sur
	une commande spcifique, tapez %R%S HELP command.
	
BOT_HELP_FOOTER
	Le bot joindra un canal ds qu'il y aura au moins
	%d utilisateur(s) dessus.

BOT_HELP_BOTLIST
	Syntaxe: BOTLIST
	
	Liste tous les bots disponibles sur ce rseau.
	
BOT_HELP_ASSIGN
	Syntaxe: ASSIGN canal pseudo
	
	Attribue le bot dsign par pseudo au canal. Vous
	pouvez ensuite configurer le bot pour qu'il convienne 
	vos besoins.
	
BOT_HELP_UNASSIGN
	Syntaxe: UNASSIGN canal
	
	Retire le bot d'un canal. Si vous utilisez cette commande,
	le bot ne joindra plus le canal. Cependant, la configuration
	du bot est conserve donc vous aurez toujours la possibilit
	de rattribuer un bot plus tard sans avoir  le reconfigurer
	entirement.
	
BOT_HELP_INFO
	Syntax: INFO {canal | pseudo}
	
	Vous permet de voir les informations %S pour un canal
	ou un bot. Si le paramtre est un canal, vous verrez
	des informations sur le canal tels que les kickers
	actifs. Si le paramtre est un pseudo, vous verrez des
	informations  propos d'un bot, comme le temps de
	cration ou le nombre de canaux auxquels il a t
	attribu.
	
BOT_HELP_SET
	Syntaxe: SET canal option paramtres
	
	Configure les options du bot.  option peut tre:
	
	    DONTKICKOPS      Pour protger les ops des kicks du bot
	    DONTKICKVOICES   Pour protger les voices des kicks du bot
	    FANTASY          Active les commandes fantaisistes
	    GREET            Active les messages d'accueil
	    SYMBIOSIS        Permet au bot d'agir comme un vrai bot
	
	Tapez %R%S HELP SET option pour plus d'infos
	sur une option spcifique.
	
BOT_HELP_SET_DONTKICKOPS
	Syntaxe: SET canal DONTKICKOPS {ON|OFF}
	
	Active ou dsactive la protection des ops sur un 
	canal. Quand elle est active, cette option empche
	le bot de kicker les ops mme s'ils ne sont pas concerns
	par le level NOKICK.
	
BOT_HELP_SET_DONTKICKVOICES
	Syntaxe: SET canal DONTKICKVOICES {ON|OFF}
	
	Active ou dsactive la protection des voices sur un 
	canal. Quand elle est active, cette option empche
	le bot de kicker les voices mme s'ils ne sont pas concerns
	par le level NOKICK.
	
BOT_HELP_SET_FANTASY
	Syntaxe: SET canal FANTASY {ON|OFF}
	
	Active ou dsactive le mode fantaisie sur un
	canal. Quand elle est active, cette option
	permet aux utilisateurs d'utiliser les commandes
	!op, !deop, !voice, !devoice, !kick, !kb, !unban 
	et !seen sur un canal (trouvez comment les utiliser; 
	essayez avec ou sans pseudo pour chacune, et avec 
	une raison pour certaines?).
	
	Notez que les utilisateurs souhaitant utiliser
	les commandes fantaisistes DOIVENT avoir
	suffisamment d'accs pour les levels FANTASIA
	et un autre level qui dpend de la commande
	(par exemple, pour utiliser !op, un utilisateur
	doit avoir suffisamment d'accs pour le level
	OPDEOP).
	
BOT_HELP_SET_GREET
	Syntaxe: SET canal GREET {ON|OFF}
	
	Active ou dsactive le mode message d'accueil
	sur un canal. Quand elle est active, cette option
	fait afficher au bot le message d'accueil de chaque
	utilisateur qui a un accs suffisant au canal.
	
BOT_HELP_SET_SYMBIOSIS
	Syntax: SET canal SYMBIOSIS {ON|OFF}
	
	Active ou dsactive la symbiose sur un canal.
	Quand elle est active, cette option fait faire
	au bot tout ce qui est normalement effectu
	par %s sur les canaux, tels que les MODEs,
	les KICKs, et mme le message d'entre.
	
BOT_HELP_KICK
	Syntaxe: KICK canal option paramtres
	
	Configure les kickers du bot.  option peut etre:
	
	    BOLDS         Dtermine si le bot kicke les
	                     caractres gras
	    BADWORDS      Dtermine si le bot kicke les mots 
	                     interdits
	    CAPS          Dtermine si le bot kicke les majuscules
	    COLORS        Dtermine si le bot kicke les couleurs
	    FLOOD         Dtermine si le bot kicke les utilisateurs
	                     qui floodent
	    REPEAT        Dtermine si le bot kicke les rptitions
	    REVERSES      Dtermine si le bot kicke les reverses
	    UNDERLINES    Dtermine si le bot kicke les caractres
	                     souligns
	
	Tapez %R%S HELP KICK option pour plus d'informations
	sur une option en particulier.

BOT_HELP_KICK_BOLDS
	Syntaxe: KICK canal BOLDS {ON|OFF} [ttb]

	Active ou dsactive le kicker de caractres gras. Quand
	elle est active, cette option demande au bot
	de kicker les utilisateurs qui utilisent des 
	caractres gras.

	ttb est le nombre de fois qu'un utilisateur peut
	se faire kicker avant d'tre banni. Ne donnez
	pas ttb ou mettez le  0 pour dsactiver le systme
	de ban une fois activ.

BOT_HELP_KICK_COLORS
	Syntaxe: KICK canal COLORS {ON|OFF} [ttb]

	Active ou dsactive le kicker de couleurs. Quand
	elle est active, cette option demande au bot
	de kicker les utilisateurs qui utilisent des 
	couleurs.

	ttb est le nombre de fois qu'un utilisateur peut
	se faire kicker avant d'tre banni. Ne donnez
	pas ttb ou mettez le  0 pour dsactiver le systme
	de ban une fois activ.

BOT_HELP_KICK_REVERSES
	Syntaxe: KICK canal REVERSES {ON|OFF} [ttb]

	Active ou dsactive le kicker de reverses. Quand
	elle est active, cette option demande au bot
	de kicker les utilisateurs qui utilisent des 
	reverses.

	ttb est le nombre de fois qu'un utilisateur peut
	se faire kicker avant d'tre banni. Ne donnez
	pas ttb ou mettez le  0 pour dsactiver le systme
	de ban une fois activ.

BOT_HELP_KICK_UNDERLINES
	Syntaxe: KICK canal UNDERLINES {ON|OFF} [ttb]

	Active ou dsactive le kicker de caractres souligns. 
	Quand elle est active, cette option demande au bot
	de kicker les utilisateurs qui utilisent des 
	caractres souligns.

	ttb est le nombre de fois qu'un utilisateur peut
	se faire kicker avant d'tre banni. Ne donnez
	pas ttb ou mettez le  0 pour dsactiver le systme
	de ban une fois activ.
	
BOT_HELP_KICK_CAPS
	Syntaxe: KICK canal CAPS {ON|OFF} [ttb [min [percent]]]

	Active ou dsactive le kicker de majuscules. Quand 
	elle est active, cette option demande au bot
	de kicker les utilisateurs qui parlent en MAJUSCULES
	sur le canal.

	Le bot ne kicke que s'il y a au minimum min majuscules
	et qu'elles constituent au moins percent%% de la
	ligne de texte entire (si ces paramtres ne sont pas
	donns, les valeurs par dfaut 10 caractres et 25%% 
	seront utiliss).

	ttb est le nombre de fois qu'un utilisateur peut
	se faire kicker avant d'tre banni. Ne donnez
	pas ttb ou mettez le  0 pour dsactiver le systme
	de ban une fois activ.

BOT_HELP_KICK_FLOOD
	Syntaxe: KICK canal FLOOD {ON|OFF} [ttb [ln [secs]]]

	Active ou dsactive le kicker de flood. Quand 
	elle est active, cette option demande au bot
	de kicker les utilisateurs qui floodent le canal
	en utilisant au moins ln lignes en secs secondes
	(si ces paramtres ne sont pas donns, les valeurs
	par dfaut sont 6 lignes en 10 secondes).
	
	ttb est le nombre de fois qu'un utilisateur peut
	se faire kicker avant d'tre banni. Ne donnez
	pas ttb ou mettez le  0 pour dsactiver le systme
	de ban une fois activ.

BOT_HELP_KICK_REPEAT
	Syntaxe: KICK #canal REPEAT {ON|OFF} [ttb [num]]

	Active ou dsactive le kicker de rptitions. Quand 
	elle est active, cette option demande au bot
	de kicker les utilisateurs qui se rptent num fois
	(si num n'est pas donn, la valeur par dfaut est 3).

	ttb est le nombre de fois qu'un utilisateur peut
	se faire kicker avant d'tre banni. Ne donnez
	pas ttb ou mettez le  0 pour dsactiver le systme
	de ban une fois activ.
	
BOT_HELP_KICK_BADWORDS
	Syntaxe: KICK #canal BADWORDS {ON|OFF} [ttb]

	Active ou dsactive le kicker de mots interdits. 
	Quand elle est active, cette option demande au bot
	de kicker les utilisateurs qui disent certains mots 
	sur le canal.

	Vous pouvez dfinir les mots interdits pour votre
	channel en utilisant la commande BADWORDS. Tapez
	%R%S HELP BADWORDS pour plus d'informations.

	ttb est le nombre de fois qu'un utilisateur peut
	se faire kicker avant d'tre banni. Ne donnez
	pas ttb ou mettez le  0 pour dsactiver le systme
	de ban une fois activ.

BOT_HELP_BADWORDS
	Syntaxe: BADWORDS canal ADD mot [SINGLE | START | END]
	         BADWORDS canal DEL {mot | entry-num | liste}
	         BADWORDS canal LIST [mask | liste]
	         BADWORDS canal CLEAR
	
	Gre la liste des mots interdits d'un canal. La liste
	des mots interdits dtermine quels mots doivent tre kicks
	quand le kicker de mots interdits est activ. Pour plus
	d'information, tapez %R%S HELP KICK BADWORDS.
	
	La commande BADWORDS ADD ajoute le mot donn  la liste
	de mots interdits. Si SINGLE est donn, un kick ne sera
	effectu que si un utilisateur dit le mot en entier. Si
	START est donn, un kick ne sera effectu que si un
	utilisateur dit un mot qui commande par mot. Si END
	est spcifi, un kick ne sera effectu que si un utilisateur
	dit un mot qui se termine par mot. Si vous ne spcifiez
	rien, un kick sera effectu chaque fois que mot est dit
	par un utilisateur.
	
	La commande BADWORDS DEL supprime le mot donn de la liste
	des mots interdits. Si une liste de numro d'entres est
	donn, ces entres seront supprimes. (Voyez l'exemple pour
	LIST ci-dessous.)
	
	La commande BADWORDS LIST affiche la liste des mots 
	interdits. Si un mask joker est donn, seules les entres
	correspondantes au mask seront affiches. Si une liste
	de numro d'entres est donne, seules ces entres seront
	affiches, par exemple:

	   BADWORDS #canal LIST 2-5,7-9
	      Liste les mots interdits 2  5 et 7  9.
	      
	La commande BADWORDS CLEAR supprime toutes les entres
	de la liste des mots interdits.

BOT_HELP_SAY
	Syntaxe: SAY canal texte
	
	Fait dire au bot le texte donn sur le canal donn.

BOT_HELP_ACT
	Syntaxe: ACT canal texte
	
	Fait faire au bot l'quivalent d'une commande "/me"
	sur le canal donn avec le texte donn.

BOT_SERVADMIN_HELP_BOT
	Syntax: BOT ADD pseudo user host real
	        BOT CHANGE ancien-pseudo nouveau-pseudo [user [host [real]]]
	        BOT DEL pseudo
	
	Permet aux Services admins de crer, modifier, et
	supprimer les bots que les utilisateurs pourront
	utiliser sur leurs canaux.
	
	BOT ADD ajoute un bot avec le pseudo, username, hostname
	et realname donn. Aucun test d'intgrit ne sont effectus
	pour ces donnes, donc faites trs attention.
	BOT CHANGE permet de changer le pseudo, username, hostname
	ou realname d'un bot tout en conservant les donnes qui
	lui sont associes.
	BOT DEL supprime le bot donn de la liste des bots.  
	
	Note: si vous crez un bot ayant un pseudo enregistr
	avec NickServ, il sera effac. De plus, si un utilisateur
	utilise le pseudo du bot lors de sa cration ou modification,
	il sera dconnect.
	
BOT_SERVADMIN_HELP_SET
	
	Ces options sont rserves aux Services admins:
	
	    NOBOT            Empche un bot d'tre attribu 
	                         un canal
	    PRIVATE          Empche un bot d'tre attribu par
	                         des non-oprateurs IRC

BOT_SERVADMIN_HELP_SET_NOBOT
	Syntaxe: SET canal NOBOT {ON|OFF}
	
	Cette option empche un bot d'tre attribu au canal.
	Si un bot est dj attribu, il est enlev automatiquement
	quand vous activez l'option.
	
	Rserve aux administrateurs des services.

BOT_SERVADMIN_HELP_SET_PRIVATE
	Syntaxe: SET nick-du-bot PRIVATE {ON|OFF}
	
	Cette option empche un bot d'tre attribu  un
	canal par des utilisateurs qui ne sont pas oprateurs
	IRC.
	
	Rserve aux administrateurs des services.
HOST_EMPTY
	Liste des vhost vide.
HOST_ENTRY
	#%d Pseudo:%s, vhost:%s (%s - %s)
HOST_IDENT_ENTRY
	#%d Pseudo:%s, vhost:%s@%s (%s - %s)
HOST_SET
	Le vhost pour %s enregistre en %s.
HOST_IDENT_SET
	Le vhost pour %s enregistre en %s@%s.
HOST_SETALL
	Le vhost pour le groupe %s enregistre en %s.
HOST_DELALL
	Le vhosts pour le groupe %s a t supprim.
HOST_DELALL_SYNTAX
	Syntaxe: DELALL <pseudo>.
HOST_IDENT_SETALL
	Le vhost pour le groupe %s enregistre en %s@%s.
HOST_SET_ERROR
	Erreur! Une vhost peut seulement contenir les caratres A-Z, a-z, 0-9, '.' et '-'.
HOST_SET_IDENT_ERROR
	L'identd du vhost dois etre dans un format d'identd valide
HOST_SET_TOOLONG
	Erreur! Le vhost est top longue, veuillez entrer moins de %d caratres.
HOST_SET_IDENTTOOLONG
	Erreur! l'Ident est trop long, veuillez entrer moins de %d caratres.
HOST_NOREG
	L'utilisateur %s n'a pas t trouv dans la base de donnes de NickServ.
HOST_SET_SYNTAX
	Syntaxe %R%s set <pseudo> <hostmask>.
HOST_SETALL_SYNTAX
	Syntaxe %R%s setall <pseudo> <hostmask>.
HOST_DENIED
	Accs refus.
HOST_NOT_ASSIGNED
	Contactez un oprateur afin d'avoir une vhost sous ce pseudo.
HOST_ACTIVATED
	Votre vhost %s est active.
HOST_IDENT_ACTIVATED
	Votre vhost %s@%s est active.
HOST_ID
	Veuillez vous identifier avant d'utiliser cette commande.
HOST_NOT_REGED
	Vous devez tre enregistr avant d'utiliser cette commande.
HOST_DEL
	Le vhost pour %s a t supprim.
HOST_DEL_SYNTAX
	Syntaxe: %R%s del <pseudo>.

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_OFF_UNREAL
	Votre vhost a t enleve. Pour ractiver la protection de votre IP, tapez /mode %s +%s
HOST_NO_VIDENT
	L'IRCD utilis ne support par la modification de l'ident.

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_GROUP
	Toutes les vhost du groupe %s ont t enregistres en %s
HOST_IDENT_GROUP
	Toutes les vhost du groupe %s ont t enregistres en %s@%s

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_LIST_FOOTER
	Affiche tout les enregistrement (Nb: %d) 
HOST_LIST_RANGE_FOOTER
	Affiche les enregistrement de %d  %d
HOST_LIST_KEY_FOOTER
	Affiche les enregistrement contenant %s (Nb: %d)

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_HELP_CMD_ON
	    ON          Active une vhost
HOST_HELP_CMD_OFF
	    OFF         Dsactive une vhost
HOST_HELP_CMD_GROUP
	    GROUP       Synchronise toutes les vhosts d'un group
HOST_HELP_CMD_SET
	    SET         Configure la vhost d'un pseudo
HOST_HELP_CMD_SETALL
	    SETALL      Configure la vhost pour tous les pseudos d'un groupe
HOST_HELP_CMD_DEL
	    DEL         Supprime la vhost d'un pseudo
HOST_HELP_CMD_DELALL
	    DELALL      Supprime la vhost pour tout les pseudo d'un groupe
HOST_HELP_CMD_LIST
	    LIST        Recherche une vhost
HOST_OPER_HELP
	not used.

HOST_ADMIN_HELP
	not used.

HOST_HELP
	%S commandes:

HOST_HELP_ON
	Syntaxe: ON

	Active la vhost actuellement configure pour ce pseudo.
	Vous verrez cette vhost dans votre /whois  la place de
	votre host actuelle.

HOST_HELP_SET
	Syntaxe: SET <pseudo> <hostmask>.

	Configure la vhost donne pour le pseudo indiqu.
	Si l'ircd supporte la modification de l'ident, utilisez
	SET <nick> <ident>@<hostmask>

	Limit aux ServicesOprateurs.

HOST_HELP_DELALL
	Syntaxe: DELALL <pseudo>.

	Supprime tout les vhosts pour tout les pseudos du meme
	groupe que le pseudo donn.

	Limit aux Services Oper.


HOST_HELP_SETALL
	Syntaxe: SETALL <pseudo> <hostmask>.

	Configure la vhost pour toutes les pseudos d'un mme
	groupe.	Si l'ircd supporte la modification de l'ident, utilisez
	SET <pseudo> <ident>@<hostmask>

	Limit aux ServicesOprateurs.

HOST_HELP_OFF
	Syntaxe: OFF

	Dsactive la vhost que vous avez actuellement. L'utilisation
	de cette commande rendra visible votre IP.

HOST_HELP_DEL
	Syntaxe: DEL <pseudo>

	Supprime la vhost pour le pseudo indiqu.

	Limit aux ServicesOprateurs.

HOST_HELP_LIST
	Syntaxe: LIST [<cl>|<#X-Y>]

	Cette commande liste tout les vhosts enregistr, si une cl
	est spcifi, seulement les rsultats contenant le pseudo ou
	le vhosts seront afficher, par exemple : Rob* pour toute les
	entre contenant "Rob"

	Si le style #X-Y est utilis, seul les entre entre X et Y
	seront affich, par exemple: #1-3 affichera les 3 premires
	entre.
	
	La liste utilise la valeur de NSListMax pour une limite hard
	du nombre de rsultats affichs en une fois.

	Limit aux Services operateurs.

HOST_HELP_GROUP
	Syntaxe: GROUP

	Permet d'enregistrer la vHost du pseudo actuellement
	utilis pour tous les pseudos du groupe. 

OPER_SVSNICK_UNSUPPORTED
	Dsol, SVSNICK n'est pas accssibe sur ce rseau.

OPER_SQLINE_UNSUPPORTED
	Dsol, SQLINE n'est pas accssible sur ce rseau.

OPER_SVSO_UNSUPPORTED
	Dsol, OLINE n'est pas accssible sur ce rseau.

OPER_UMODE_UNSUPPORTED
	Dsol, UMODE n'est pas accssible sur ce rseau.

OPER_SUPER_ADMIN_NOT_ENABLED
	L'option SuperAdmin n'est pas activ dans le services.conf

