#!/bin/sh

set -x

output="$1"
pic="$2"
shift 2

if [ -f "$output".flac ]; then
    echo Ausgabedatei "$output".flac existiert bereits.
    exit 1
fi;
 
if ! [ -f "$pic" ]; then
    echo Bilddatei existiert nicht.
    exit 1
fi;
 
shntool cue "$@" > "$output.cue"
shntool join -a "$output" -o "flac" "$@"

for i in "$@"; do
    TITLE=$(metaflac --show-tag=TITLE "$i" | cut -c 7-)
    ALBUM=$(metaflac --show-tag=ALBUM "$i" | cut -c 7-)
    ARTIST=$(metaflac --show-tag=ARTIST "$i" | cut -c 8-)
    YEAR=$(metaflac --show-tag=DATE "$i" | cut -c 6-)
    TRACKNUMBER=$(metaflac --show-tag=TRACKNUMBER "$i" | cut -c 13-)

    if [ "$TRACKNUMBER" ]; then
	if [ "$TITLE" ]; then echo "TITLE($TRACKNUMBER)=$TITLE"; fi
	if [ "$ALBUM" ]; then
	    echo "ALBUM($TRACKNUMBER)=$ALBUM";
	    echo "ALBUM=$ALBUM";
	fi
	if [ "$ARTIST" ]; then
	    echo "ARTIST($TRACKNUMBER)=$ARTIST";
	    echo "ARTIST=$ARTIST";
	fi
	if [ "$YEAR" ]; then
	    echo "DATE($TRACKNUMBER)=$YEAR";
	    echo "DATE=$YEAR";
	fi
    fi
done | metaflac --import-tags-from=- "$output".flac

metaflac --export-tags-to=- "$output".flac | sort | uniq | metaflac --remove-all-tags --import-tags-from=- "$output".flac

metaflac --import-cuesheet-from="$output".cue --import-picture-from="$pic" "$output".flac

