/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.FontUIResource;
import snmp.SNMPv1CommunicationInterface;

public class AirportBaseStationHangup
extends JFrame
implements ActionListener,
Runnable,
WindowListener {
    JButton hangupModemButton;
    JButton connectModemButton;
    JButton newHostButton;
    JTextArea messagesArea;
    JScrollPane messagesScroll;
    JTextField hostIDField;
    JTextField modemStatusField;
    JTextField timeField;
    JLabel authorLabel;
    JLabel hostIDLabel;
    JLabel modemStatusLabel;
    JLabel timeLabel;
    JLabel connectTimeCaveatLabel;
    MenuBar theMenubar;
    Menu fileMenu;
    MenuItem quitItem;
    SNMPv1CommunicationInterface comInterface;
    String community;
    InetAddress hostAddress;
    int version;
    DatagramSocket dSocket;
    final int OSU_NMS_PORT = 192;
    boolean minimized;
    Thread statusThread;
    static /* synthetic */ Class class$AirportBaseStationHangup;

    public AirportBaseStationHangup() {
        this.setUpDisplay();
        try {
            this.community = "public";
            this.version = 0;
            this.hostAddress = InetAddress.getByName(this.hostIDField.getText());
            this.dSocket = new DatagramSocket();
            this.dSocket.setSoTimeout(2000);
            InetAddress inetAddress = InetAddress.getByName(this.hostIDField.getText());
            this.statusThread = new Thread(this);
            this.statusThread.start();
        }
        catch (Exception exception) {
            this.messagesArea.setText("Exception during modem status polling startup:  " + exception + "\n");
        }
    }

    private void setUpDisplay() {
        Object object;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getRootPane().setBorder(new BevelBorder(0));
        UIManager uIManager = new UIManager();
        FontUIResource fontUIResource = new FontUIResource("SansSerif", 0, 10);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).indexOf("font") <= -1 && ((String)object).indexOf("Font") <= -1) continue;
            UIManager.put(object, fontUIResource);
        }
        this.addWindowListener(this);
        this.hostIDLabel = new JLabel("Address:");
        this.hostIDField = new JTextField(10);
        this.hostIDField.setText("10.0.1.1");
        this.hostIDField.setEditable(false);
        this.modemStatusLabel = new JLabel("Connection status:");
        this.modemStatusField = new JTextField(16);
        this.modemStatusField.setEditable(false);
        this.timeLabel = new JLabel("Connection time:");
        this.timeField = new JTextField(16);
        this.timeField.setEditable(false);
        this.authorLabel = new JLabel(" Version 1.5        J. Sevy, March 2002");
        this.authorLabel.setFont(new Font("SansSerif", 2, 8));
        this.hangupModemButton = new JButton("Disconnect");
        this.hangupModemButton.setActionCommand("hangup modem");
        this.hangupModemButton.addActionListener(this);
        this.connectModemButton = new JButton("Connect");
        this.connectModemButton.setActionCommand("connect modem");
        this.connectModemButton.addActionListener(this);
        this.newHostButton = new JButton("Set address");
        this.newHostButton.setActionCommand("new host");
        this.newHostButton.addActionListener(this);
        this.messagesArea = new JTextArea(3, 30);
        this.messagesScroll = new JScrollPane(this.messagesArea);
        object = (class$AirportBaseStationHangup == null ? (class$AirportBaseStationHangup = AirportBaseStationHangup.class$("AirportBaseStationHangup")) : class$AirportBaseStationHangup).getResource("iconImage.gif");
        ((Frame)this).setIconImage(Toolkit.getDefaultToolkit().getImage((URL)object));
        this.minimized = false;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.setTitle("AirPort Modem/PPPoE Utility");
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.hangupModemButton, gridBagConstraints);
        panel.add(this.hangupModemButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.connectModemButton, gridBagConstraints);
        panel.add(this.connectModemButton);
        gridBagConstraints.fill = 0;
        Panel panel2 = new Panel();
        panel2.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.hostIDLabel, gridBagConstraints);
        panel2.add(this.hostIDLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.hostIDField, gridBagConstraints);
        panel2.add(this.hostIDField);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.newHostButton, gridBagConstraints);
        panel2.add(this.newHostButton);
        Panel panel3 = new Panel();
        panel3.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.modemStatusLabel, gridBagConstraints);
        panel3.add(this.modemStatusLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.modemStatusField, gridBagConstraints);
        panel3.add(this.modemStatusField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.timeLabel, gridBagConstraints);
        panel3.add(this.timeLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.timeField, gridBagConstraints);
        panel3.add(this.timeField);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        this.getContentPane().add(panel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.getContentPane().add(panel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(panel3, gridBagConstraints);
        this.getContentPane().add(panel3);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.minimized = true;
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.minimized = false;
        this.setTitle("AirPort Modem/PPPoE Utility");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = actionEvent.getActionCommand();
        if (string2 == "quit") {
            System.exit(0);
        }
        if (string2 == "new host" && (string = JOptionPane.showInputDialog("Input new host:")) != null) {
            try {
                this.hostAddress = InetAddress.getByName(string);
                this.hostIDField.setText(string);
            }
            catch (UnknownHostException unknownHostException) {
                JOptionPane.showMessageDialog(this, "Unknown host name supplied.");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error setting new host.");
            }
        }
        if (string2 == "hangup modem") {
            this.hangupModem();
        }
        if (string2 == "connect modem") {
            this.connectModem();
        }
    }

    private void hangupModem() {
        try {
            this.messagesArea.setText("Hanging up modem....");
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(5000);
            byte[] byArray = new byte[116];
            byArray[0] = 6;
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, 192);
            datagramSocket.send(datagramPacket);
            this.messagesArea.append("please wait for modem to disconnect.\n");
        }
        catch (Exception exception) {
            this.messagesArea.append("Exception during hangup:  " + exception + "\n");
        }
    }

    private void connectModem() {
        try {
            this.messagesArea.setText("Dialing modem....");
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(5000);
            byte[] byArray = new byte[116];
            byArray[0] = 7;
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, 192);
            datagramSocket.send(datagramPacket);
            this.messagesArea.append("please wait for modem to connect.\n");
        }
        catch (Exception exception) {
            this.messagesArea.append("Exception during modem connect:  " + exception + "\n");
        }
    }

    private String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = string + Integer.toHexString(n2 / 16);
        string = string + Integer.toHexString(n2 % 16);
        return string;
    }

    public void run() {
        while (true) {
            try {
                byte[] byArray = new byte[116];
                byArray[0] = 8;
                byArray[1] = 1;
                byArray[2] = 3;
                byArray[3] = 16;
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, 192);
                this.dSocket.send(datagramPacket);
                byte[] byArray2 = new byte[128];
                DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, byArray2.length);
                this.dSocket.receive(datagramPacket2);
                byArray2 = datagramPacket2.getData();
                int n = datagramPacket2.getLength();
                OSUNMSInfoHash oSUNMSInfoHash = new OSUNMSInfoHash(byArray2, n);
                int n2 = oSUNMSInfoHash.get(new Integer(785)).getIntegerValue();
                switch (n2) {
                    case 4: {
                        int n3;
                        this.hangupModemButton.setEnabled(true);
                        this.connectModemButton.setEnabled(false);
                        String string = "Connected";
                        Object object = oSUNMSInfoHash.get(new Integer(789));
                        if (((OSUNMSInfoElement)object).length == 6 && (n3 = ((OSUNMSInfoElement)object).getIntegerValue()) > 0) {
                            string = string + "  (" + n3 + " bps)";
                        }
                        this.modemStatusField.setText(string);
                        n3 = oSUNMSInfoHash.get(new Integer(790)).getIntegerValue();
                        int n4 = n3 / 3600;
                        int n5 = n3 / 60 % 60;
                        int n6 = n3 % 60;
                        String string2 = new String();
                        string2 = string2 + n4;
                        if (string2.length() < 2) {
                            string2 = "0" + string2;
                        }
                        String string3 = new String();
                        if ((string3 = string3 + n5).length() < 2) {
                            string3 = "0" + string3;
                        }
                        String string4 = new String();
                        if ((string4 = string4 + n6).length() < 2) {
                            string4 = "0" + string4;
                        }
                        String string5 = string2 + ":" + string3 + ":" + string4;
                        this.timeLabel.setText("Connection time:");
                        this.timeField.setText(string5);
                        if (this.minimized) {
                            this.setTitle(string5);
                        }
                        break;
                    }
                    case 5: {
                        this.modemStatusField.setText("Temporarily disabled");
                        if (this.minimized) {
                            this.setTitle("Disabled");
                        }
                        this.hangupModemButton.setEnabled(false);
                        this.connectModemButton.setEnabled(true);
                        this.timeLabel.setText("Time remaining:");
                        int n7 = oSUNMSInfoHash.get(new Integer(793)).getIntegerValue();
                        Object object = Integer.toString(n7);
                        if (((String)object).length() < 2) {
                            object = "0" + (String)object;
                        }
                        this.timeField.setText("0:" + (String)object);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.modemStatusField.setText("Connecting...");
                        if (this.minimized) {
                            this.setTitle("Connecting...");
                        }
                        this.hangupModemButton.setEnabled(true);
                        this.connectModemButton.setEnabled(false);
                        this.timeLabel.setText("Connection time:");
                        this.timeField.setText("");
                        break;
                    }
                    default: {
                        this.modemStatusField.setText("Unconnected");
                        if (this.minimized) {
                            this.setTitle("Unconnected");
                        }
                        this.hangupModemButton.setEnabled(false);
                        this.connectModemButton.setEnabled(true);
                        this.timeLabel.setText("Connection time:");
                        this.timeField.setText("");
                        break;
                    }
                }
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Exception exception) {
                this.messagesArea.setText("Exception during modem status polling:  " + exception + "\n");
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            AirportBaseStationHangup airportBaseStationHangup = new AirportBaseStationHangup();
            airportBaseStationHangup.pack();
            airportBaseStationHangup.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

