#!/bin/sh
AIPO_HOME=default_folder
AIPO_POSTGRES_USER=default_user
s_port_num=default_server_port
port_num=default_db_port
aipo_version=Aipo_Version

export JRE_HOME=$AIPO_HOME/jre

addr=""
. $AIPO_HOME/bin/install.conf

addr=""
if [ -e /etc/sysconfig/network-scripts/ifcfg-${netitf} ]; then
	. /etc/sysconfig/network-scripts/ifcfg-${netitf}
	addr=$IPADDR
fi

if [ "$addr" = "" ]; then
	addr=`ifconfig ${netitf} | grep "inet addr" | cut -f 2 -d :| cut -f 1 -d " "`
fi

if [ "$addr" = "" ]; then
	addr=`ifconfig eth0 | grep "inet addr" | cut -f 2 -d :| cut -f 1 -d " "`
fi

if [ -d $AIPO_HOME/tomcat/work/Catalina/localhost/_ ]; then
	rm -fr $AIPO_HOME/tomcat/work/Catalina/localhost/_
fi
if [ -d $AIPO_HOME/tomcat/work/Catalina/localhost/aipo ]; then
	rm -fr $AIPO_HOME/tomcat/work/Catalina/localhost/aipo
fi
cp -f $AIPO_HOME/backup/xreg/*.xreg $AIPO_HOME/tomcat/webapps/aipo/WEB-INF/conf/

#postgreSQLの起動コードをここに記述
sudo -u $AIPO_POSTGRES_USER $AIPO_HOME/postgres/bin/pg_ctl -D $AIPO_HOME/postgres/data -o "-i -p $port_num" start &>/dev/null &
###############################################
prc_name="$AIPO_HOME/postgres/bin/pg_ctl"
count=0
while [ $count -lt 255 ]; do
	tmp_str=`ps auxww | grep $prc_name`
	tmp_str=`echo $tmp_str`
	pid_str=`echo "$tmp_str" | cut -f 2 -d " "`
	tmp_str=`netstat -nap | grep "ESTABLISHED $pid_str"`
	if [ "$tmp_str" != "" ]; then
		#echo $tmp_str
		break
	fi
	count=`expr $count + 1`
done
################################################

if [ -e $AIPO_HOME/tomcat/temp ]; then
	echo "found temp directory"
else
	mkdir -p $AIPO_HOME/tomcat/temp
	if [ $? -ne 0 ]; then
	  echo "can't make temp directory";
	else
	  echo "making temp directory successful";
	fi
fi

sh $AIPO_HOME/tomcat/bin/startup.sh

echo "Starting Aipo Version $aipo_version"
echo "Aipo URL: http://$addr:$s_port_num/aipo/"