/*
 * Postscript definitions.
 *
 * This file is part of abcm2ps.
 *
 * Copyright (C) 1998-2012 Jean-François Moine
 * Adapted from abc2ps, Copyright (C) 1996,1997 Michael Methfessel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Suite 500, Boston, MA  02110-1335  USA
 */

#include <string.h>

#include "abc2ps.h"

static char ps_head[] =
	"/xymove{/x 2 index def/y 1 index def M}!\n"

	/* str showc - center at current pt */
	"/showc{dup stringwidth pop .5 mul neg 0 RM show}!\n"

	/* str showr - show right-aligned */
	"/showr{dup stringwidth pop neg 0 RM show}!\n"

	/* str showb - show in box */
	"/showb{	dup currentpoint 3 -1 roll show\n"
	"	.6 SLW\n"
	"	exch 2 sub exch 3 sub 3 -1 roll\n"
#if 1
	"	stringwidth pop 4 add\n"
	"	currentfont /ScaleMatrix get 0 get .8 mul\n"
	"	4 add rectstroke}!\n"
#else
	"	stringwidth pop 4 add fh 4 add rectstroke}!\n"
#endif

#if 0
	"/showcb{ % usage: str showcb - show centered in box\n"
	"	dup stringwidth pop dup .5 mul neg 0 RM currentpoint 4 -1 roll show\n"
	"	.6 SLW\n"
	"	exch 2 sub exch 3 sub 3 -1 roll\n"
	"	4 add fh 4 add rectstroke}!\n"
#endif

	/* x y tclef - treble clef */
	"/utclef{<95200072\n"
	"	0000ff2e01c2030c\n"
	"	00ac0056\n"
	"	0064007f006400f400e00112\n"
	"	0176011c01bc0056013a0012\n"
	"	00c8ffde002700120015009a\n"
	"	0006014f0072017f00f101e8\n"
	"	0149023f0140026d012f02ba\n"
	"	00fc029900d1025100d60200\n"
	"	00e700f500fa008a0107ffc2\n"
	"	010dff6200f4ff3c00baff3b\n"
	"	006aff3a003cff98007dffc0\n"
	"	00d2ffe90102ff5b009cff57\n"
	"	00b3ff4600f8ff3200f6ffb3\n"
	"	00ec009200cf010900c4021c\n"
	"	00c4027600c402be01240304\n"
	"	015c02bc0163021e013a01e3\n"
	"	00f001790039013b003b00a7\n"
	"	0044000e00cfffee01370022\n"
	"	018d0063015400e200e700d2\n"
	"	00a000c6007e008f00ac0056\n"
	"	><0b000132050a>}cvlit def\n"
	"/tclef{gsave T -10 0 T .045 dup scale utclef ufill grestore}!\n"
	"/stclef{gsave T -10 0 T .037 dup scale utclef ufill grestore}!\n"

	/* x y octu - upper '8' */
	"/octu{/Times-Roman 12 selectfont M -1.5 36 RM(8)show}!\n"
	/* x y octl - lower '8' */
	"/octl{/Times-Roman 12 selectfont M -3.5 -19 RM(8)show}!\n"

	/* x y bclef - bass clef */
	"/ubclef{<95200046\n"
	"	00000050019a0244\n"
	"	00010057\n"
	"	007d007a00df00a500ff0143\n"
	"	012a022700580239003f01aa\n"
	"	007a01fa00dc0194009b015c\n"
	"	005d012d00280172003101b4\n"
	"	00460241013f023c01430180\n"
	"	014200d100d9007800010057\n"
	"	01660151\n"
	"	016601750199017301990151\n"
	"	0199012c0166012d01660151\n"
	"	016401d2\n"
	"	016401f6019701f4019701d2\n"
	"	019701ac016401ad016401d2\n"
	"	><0b000126050a0122050a0122050a>}cvlit def\n"
	"/bclef{gsave T -10 0 T .045 dup scale ubclef ufill grestore}!\n"
	"/sbclef{gsave T -10 3 T .037 dup scale ubclef ufill grestore}!\n"

	/* x y cclef */
	"/ucclef{<95200066\n"
	"	006effbe01e70256\n"
	"	00d10108\n"
	"	00d10002\n"
	"	00c40002\n"
	"	00c40213\n"
	"	00d10213\n"
	"	00d10113\n"
	"	00ea012700fa013701100180\n"
	"	011e0161011d014d0148013a\n"
	"	01a2011801a80244011f01f3\n"
	"	015301e0013a01a3011401a6\n"
	"	00ba01cc01350256019f01eb\n"
	"	01e7019c01a000fa01190131\n"
	"	0109010a\n"
	"	011900e4\n"
	"	01a0011b01e70079019f002a\n"
	"	0135ffbe00ba00490114006f\n"
	"	013a007201530035011f0022\n"
	"	01a8ffd101a200fd014800db\n"
	"	011d00c8011b00bd0110009b\n"
	"	00fa00e400ea00f400d10108\n"
	"	006e0213\n"
	"	00a70213\n"
	"	00a70002\n"
	"	006e0002\n"
	"	006e0213\n"
	"	><0b000125032605220326050a0124030a>}cvlit def\n"
	"/cclef{gsave T -12 0 T .045 dup scale ucclef ufill grestore}!\n"
	"/scclef{gsave T -12 2 T .037 dup scale ucclef ufill grestore}!\n"

	/* x y pclef */
	"/pclef{	exch 2.7 sub exch 2 add 5.4 20\n"
	"	1.4 SLW rectstroke}!\n"
	"/spclef{pclef}!\n"

	/* t dx dy x y bm - beam, depth t */
	"/bm{	M 3 copy RL neg 0 exch RL\n"
	"	neg exch neg exch RL 0 exch RL fill}!\n"

	/* str x y bnum - tuplet number / ratio */
	"/bnum{M/Times-Italic 12 selectfont showc}!\n"
	/* same with clearing below the number */
	"/bnumb{	currentgray/Times-Italic 12 selectfont\n"
	"	3 index stringwidth pop 4 add\n"
	"	dup .5 mul neg 4 index add 3 index 3 -1 roll 8\n"
	"	1.0 setgray rectfill setgray M showc}!\n"

	/* dx dy x y tubr - tuplet bracket */
	"/tubr{3 sub M 0 3 RL RL 0 -3 RL dlw stroke}!\n"
	"/tubrl{3 add M 0 -3 RL RL 0 3 RL dlw stroke}!\n"

	/* x y r00 - longa rest */
	"/r00{	xymove\n"
	"	-1.5 -6 RM currentpoint 3 12 rectfill}!\n"

	/* x y r0 - breve rest */
	"/r0{	xymove\n"
	"	-1.5 0 RM currentpoint 3 6 rectfill}!\n"

	/* x y r1 - rest */
	"/r1{	xymove\n"
	"	-3.5 3 RM currentpoint 7 3 rectfill}!\n"

	/* x y r2 - half rest */
	"/r2{	xymove\n"
	"	-3.5 0 RM currentpoint 7 3 rectfill}!\n"

	/* x y r4 - quarter rest */
	"/r4{	xymove\n"
	"	-1 8.5 RM\n"
	"	3.6 -5.1 RL\n"
	"	-2.1 -5.2 RL\n"
	"	2.2 -4.3 RL\n"
	"	-2.6 2.3 -5.1 0 -2.4 -2.6 RC\n"
	"	-4.8 3 -1.5 6.9 1.4 4.1 RC\n"
	"	-3.1 4.5 RL\n"
	"	1.9 5.1 RL\n"
	"	-1.5 3.5 RL\n"
	"	fill}!\n"

	/* 1/8 .. 1/64 rest element */
	"/r8e{	-1.5 -1.5 -2.4 -2 -3.6 -2 RC\n"
	"	2.4 2.8 -2.8 4 -2.8 1.2 RC\n"
	"	0 -2.7 4.3 -2.4 5.9 -0.6 RC\n"
	"	fill}!\n"

	/* x y r8 - eighth rest */
	"/r8{	xymove\n"
	"	.5 SLW 3.3 4 RM\n"
	"	-3.4 -9.6 RL stroke\n"
	"	x y M 3.4 4 RM r8e}!\n"

	/* x y r16 - 16th rest */
	"/r16{	xymove\n"
	"	.5 SLW 3.3 4 RM\n"
	"	-4 -15.6 RL stroke\n"
	"	x y M 3.4 4 RM r8e\n"
	"	x y M 1.9 -2 RM r8e}!\n"

	/* x y r32 - 32th rest */
	"/r32{	xymove\n"
	"	.5 SLW 4.8 10 RM\n"
	"	-5.5 -21.6 RL stroke\n"
	"	x y M 4.9 10 RM r8e\n"
	"	x y M 3.4 4 RM r8e\n"
	"	x y M 1.9 -2 RM r8e}!\n"

	/* x y r64 - 64th rest */
	"/r64{	xymove\n"
	"	.5 SLW 4.8 10 RM\n"
	"	-7 -27.6 RL stroke\n"
	"	x y M 4.9 10 RM r8e\n"
	"	x y M 3.4 4 RM r8e\n"
	"	x y M 1.9 -2 RM r8e\n"
	"	x y M 0.4 -8 RM r8e}!\n"

	/* x y r128 - 128th rest */
	"/r128{	xymove\n"
	"	.5 SLW 5.8 16 RM\n"
	"	-8.5 -33.6 RL stroke\n"
	"	x y M 5.9 16 RM r8e\n"
	"	x y M 4.4 10 RM r8e\n"
	"	x y M 2.9 4 RM r8e\n"
	"	x y M 1.4 -2 RM r8e\n"
	"	x y M -0.1 -8 RM r8e}!\n"

	/* dx dy dt - dot relative to head */
	"/dt{x y M RM currentpoint 1.2 0 360 arc fill}!\n"

	/* x y hld - fermata */
	"/hld{	1.5 add 2 copy 1.5 add M currentpoint 1.3 0 360 arc\n"
	"	M -7.5 0 RM\n"
	"	0 11.5 15 11.5 15 0 RC\n"
	"	-0.25 0 RL\n"
	"	-1.25 9 -13.25 9 -14.5 0 RC\n"
	"	fill}!\n"

	/* x y dnb - down bow */
	"/dnb{	dlw M -3.2 2 RM\n"
	"	0 7.2 RL\n"
	"	6.4 0 RM\n"
	"	0 -7.2 RL\n"
	"	currentpoint stroke M\n"
	"	-6.4 4.8 RM\n"
	"	0 2.4 RL\n"
	"	6.4 0 RL\n"
	"	0 -2.4 RL\n"
	"	fill}!\n"

	/* x y upb - up bow */
	"/upb{	dlw M -2.6 9.4 RM\n"
	"	2.6 -8.8 RL\n"
	"	2.6 8.8 RL\n"
	"	stroke}!\n"

	/* x y grm - gracing mark */
	"/grm{	M -5 2.5 RM\n"
	"	5 8.5 5.5 -4.5 10 2 RC\n"
	"	-5 -8.5 -5.5 4.5 -10 -2 RC fill}!\n"

	/* x y stc - staccato mark */
	"/stc{3 add M currentpoint 1.2 0 360 arc fill}!\n"

	/* x y emb - emphasis bar */
	"/emb{	1.2 SLW 1 setlinecap M\n"
	"	-2.5 3 RM 5 0 RL stroke 0 setlinecap}!\n"

	/* x y cpu - roll sign above head */
	"/cpu{	M -6 0 RM\n"
	"	0.4 7.3 11.3 7.3 11.7 0 RC\n"
	"	-1.3 6 -10.4 6 -11.7 0 RC fill}!\n"

	/* x y sld - slide */
	"/sld{	M -7.2 -4.8 RM\n"
	"	1.8 -0.7 4.5 0.2 7.2 4.8 RC\n"
	"	-2.1 -5 -5.4 -6.8 -7.6 -6 RC fill}!\n"

	/* x y trl - trill sign */
	"/trl{	/Times-BoldItalic 16 selectfont\n"
	"	M -4 2 RM(tr)show}!\n"

	/* x y umrd - upper mordent */
	"/umrd{	4 add M\n"
	"	2.2 2.2 RL 2.1 -2.9 RL 0.7 0.7 RL\n"
	"	-2.2 -2.2 RL -2.1 2.9 RL -0.7 -0.7 RL\n"
	"	-2.2 -2.2 RL -2.1 2.9 RL -0.7 -0.7 RL\n"
	"	2.2 2.2 RL 2.1 -2.9 RL 0.7 0.7 RL fill}!\n"

	/* x y lmrd - lower mordent */
	"/lmrd{	2 copy umrd M\n"
	"	.6 SLW 0 8 RL stroke}!\n"

	/* str x y fng - finger (0-5) */
	"/fng{/Bookman-Demi 8 selectfont M -3 1 RM show}!\n"

	/* str x y dacs - D.C. / D.S. */
	"/dacs{/Times-Roman 16 selectfont 3 add M showc}!\n"

	/* x y brth - breath */
	"/brth{/Times-BoldItalic 30 selectfont 6 add M(,)show}!\n"

	/* str x y pf - p, f, pp, .. */
	"/pf{/Times-BoldItalic 16 selectfont 5 add M show}!\n"

	/* str x y sfz */
	"/sfz{	M -7 5 RM pop\n"
	"	/Times-Italic 14 selectfont(s)show\n"
	"	/Times-BoldItalic 16 selectfont(f)show\n"
	"	/Times-Italic 14 selectfont(z)show}!\n"

	/* x y coda - coda */
	"/coda{	1 SLW 2 add 2 copy M 0 20 RL\n"
	"	2 copy M -10 10 RM 20 0 RL stroke\n"
	"	10 add 6 0 360 arc 1.7 SLW stroke}!\n"

	/* x y sgno - segno */
	"/sgno{	M 0 3 RM currentpoint currentpoint currentpoint\n"
	"	1.5 -1.7 6.4 0.3 3 3.7 RC\n"
	"	-10.4 7.8 -8 10.6 -6.5 11.9 RC\n"
	"	4 1.9 5.9 -1.7 4.2 -2.6 RC\n"
	"	-1.3 -0.7 -2.9 1.3 -0.7 2 RC\n"
	"	-1.5 1.7 -6.4 -0.3 -3 -3.7 RC\n"
	"	10.4 -7.8 8 -10.6 6.5 -11.9 RC\n"
	"	-4 -1.9 -5.9 1.7 -4.2 2.6 RC\n"
	"	1.3 0.7 2.9 -1.3 0.7 -2 RC\n"
	"	fill\n"
	"	M 0.8 SLW -6 1.2 RM 12.6 12.6 RL stroke\n"
	"	7 add exch 6 sub exch 1.2 0 360 arc fill\n"
	"	8 add exch 6 add exch 1.2 0 360 arc fill}!\n"

	/* w x y cresc - crescendo */
	"/cresc{	1 SLW M dup 5 RM\n"
	"	defl 1 and 0 eq\n"
	"	{dup neg 4 RL 4 RL}\n"
	"	{dup neg 2.2 RL 0 3.6 RM 2.2 RL}\n"
	"	ifelse stroke}!\n"

	/* w x y dim - diminuendo */
	"/dim{	1 SLW 5 add M\n"
	"	defl 2 and 0 eq\n"
	"	{dup 4 RL neg 4 RL}\n"
	"	{dup 2.2 RL 0 3.6 RM neg 2.2 RL}\n"
	"	ifelse stroke}!\n"

	/* x y dplus - plus */
	"/dplus{	1.2 SLW 0.5 add M 0 6 RL\n"
	"	-3 -3 RM 6 0 RL stroke}!\n"

	/* x y accent - accent */
	"/accent{1.2 SLW M -4 2 RM\n"
	"	8 2 RL -8 2 RL stroke}!\n"

	/* x y turn - turn */
	"/turn{	M 5.2 8 RM\n"
	"	1.4 -0.5 0.9 -4.8 -2.2 -2.8 RC\n"
	"	-4.8 3.5 RL\n"
	"	-3 2 -5.8 -1.8 -3.6 -4.4 RC\n"
	"	1 -1.1 2 -0.8 2.1 0.1 RC\n"
	"	0.1 0.9 -0.7 1.2 -1.9 0.6 RC\n"
	"	-1.4 0.5 -0.9 4.8 2.2 2.8 RC\n"
	"	4.8 -3.5 RL\n"
	"	3 -2 5.8 1.8 3.6 4.4 RC\n"
	"	-1 1.1 -2 0.8 -2.1 -0.1 RC\n"
	"	-0.1 -0.9 0.7 -1.2 1.9 -0.6 RC\n"
	"	fill}!\n"

	/* x y trnx - turn with line through it */
	"/turnx{	2 copy turn M\n"
	"	.6 SLW 0 1.5 RM 0 9 RL stroke}!\n"

	/* x y lphr - longphrase */
	"/lphr{1.2 SLW M 0 -18 RL stroke}!\n"

	/* x y mphr - mediumphrase */
	"/mphr{1.2 SLW M 0 -12 RL stroke}!\n"

	/* x y sphr - shortphrase */
	"/sphr{1.2 SLW M 0 -6 RL stroke}!\n"

	/* w x y ltr - long trill */
	"/ltr{	gsave 4 add T\n"
	"	0 6 3 -1 roll{\n"
	/*		% first loop draws left half of squiggle; second draws right\n*/
	"		2{\n"
	"			0 0.4 M\n"
	"			2 1.9 3.4 2.3 3.9 0 C\n"
	"			2.1 0 L\n"
	"			1.9 0.8 1.4 0.7 0 -0.4 C\n"
	"			fill\n"
	"			180 rotate -6 0 T\n"
	"		}repeat\n"
	/*		% shift axes right one squiggle*/
	"		pop 6 0 T\n"
	"	}for\n"
	"	grestore}!\n"

	/* h x ylow arp - arpeggio */
	"/arp{gsave 90 rotate exch neg ltr grestore}!\n"

	/* x y wedge - wedge */
	"/wedge{1 add M -1.5 5 RL 3 0 RL -1.5 -5 RL fill}!\n"

	/* x y opend - 'open' sign */
	"/opend{dlw M currentpoint 3 add 2.5 -90 270 arc stroke}!\n"

	/* x y snap - 'snap' sign */
	"/snap{	dlw 2 copy M -3 6 RM\n"
	"	0 5 6 5 6 0 RC\n"
	"	0 -5 -6 -5 -6 0 RC\n"
	"	5 add M 0 -6 RL stroke}!\n"

	/* x y thumb - 'thumb' sign */
	"/thumb{	dlw 2 copy M -2.5 7 RM\n"
	"	0 6 5 6 5 0 RC\n"
	"	0 -6 -5 -6 -5 0 RC\n"
	"	2 add M 0 -4 RL stroke}!\n"

	/* n x y trem - <n> tremolo on one note */
	"/trem{	M -4.5 0 RM{\n"
	"		currentpoint\n"
	"		9 3 RL 0 -3 RL -9 -3 RL 0 3 RL\n"
	"		fill 5.4 sub M\n"
	"	}repeat}!\n"

	/* x y hl - ledger line */
	"/hl{	.8 SLW M -6 0 RM 12 0 RL stroke}!\n"
	/* x y hl1 - longer ledger line */
	"/hl1{	.8 SLW M -7 0 RM 14 0 RL stroke}!\n"
	/* x y hl2 - more longer ledger line */
	"/hl2{	.7 SLW M -9 0 RM 18 0 RL stroke}!\n"

	/* -- accidentals -- */
	/* glyphs 1000 */
	"/usharp{<95200024\n"		/* width 460 */
	"	003cff42019a02ee\n"
	"	008802be\n"
	"	0088ff44\n"
	"	00a8ff44\n"
	"	00a802be\n"
	"	0128ff76\n"
	"	0148ff76\n"
	"	014802ee\n"
	"	012802ee\n"
	"	004001d0\n"
	"	0040015c\n"
	"	019201bc\n"
	"	01920230\n"
	"	00400076\n"
	"	00400002\n"
	"	01920064\n"
	"	019200d6\n"
	"	><0b000123030a0123030a0123030a0123030a>}cvlit def\n"
	"/uflat{<95200028\n"		/* width 400 */
	"	0064000001b802ee\n"
	"	006402ea\n"
	"	008402ea\n"
	"	0084000c\n"
	"	00640008\n"
	"	00840154\n"
	"	00b2019c011c01ae01540168\n"
	"	01b800fa00dc00220084000c\n"
	"	00840028\n"
	"	00ba0028014c00f60106014a\n"
	"	00d401860084014e00840128\n"
	"	><0b00010303030a0105050105050a>}cvlit def\n"
	"/unat{<95200022\n"		/* width 380 */
	"	003cff42013602ee\n"
	"	006002ee\n"
	"	004002ee\n"
	"	00400022\n"
	"	0060002a\n"
	"	01160060\n"
	"	0116ff46\n"
	"	0136ff46\n"
	"	01360208\n"
	"	011401fe\n"
	"	006001cc\n"
	"	006002ee\n"
	"	0060009e\n"
	"	0060015c\n"
	"	01160190\n"
	"	011600d4\n"
	"	><0b00012a030a0123030a>}cvlit def\n"
	"/udblesharp{<95200046\n"	/* width 460 */
	"	003c006e019001c2\n"
	"	00f0011a\n"
	"	01180140013a015e018e015e\n"
	"	018e01be\n"
	"	012e01be\n"
	"	012e016a0110014800ea0122\n"
	"	00c2014800a4016a00a401be\n"
	"	004401be\n"
	"	0044015e\n"
	"	009a015e00bc014000e2011a\n"
	"	00bc00f4009a00d6004400d6\n"
	"	00440076\n"
	"	00a40076\n"
	"	00a400ca00c200ec00ea0112\n"
	"	011000ec012e00ca012e0076\n"
	"	018e0076\n"
	"	018e00d6\n"
	"	013a00d6011800f400f0011a\n"
	"	><0b0001050303050503030505030305050303050a>}cvlit def\n"
	"/udbleflat{<9520004c\n"	/* width 500 */
	"	00140000022602ee\n"
	"	001402ea\n"
	"	002c02ea\n"
	"	002c000c\n"
	"	00140008\n"
	"	002c0154\n"
	"	004e019c009e01ae00c80168\n"
	"	011300fa00660022002c000c\n"
	"	002c0028\n"
	"	0054002800c200f6008d014a\n"
	"	00680186002c014e002c0128\n"
	"	010e02ea\n"
	"	012602ea\n"
	"	0126000c\n"
	"	010e0008\n"
	"	01260154\n"
	"	0148019c019801ae01c20168\n"
	"	020d00fa016000220126000c\n"
	"	01260028\n"
	"	014e002801bc00f60187014a\n"
	"	016201860126014e01260128\n"
	"	><0b000123030a0105050105050a0123030a0105050105050a>}cvlit def\n"

	/* x y sh0 - sharp sign */
	"/sh0{	gsave T -4 -5 T .018 dup scale usharp ufill grestore}!\n"
	/* x y ft0 - flat sign */
	"/ft0{	gsave T -3.5 -3.5 T .018 dup scale uflat ufill grestore}!\n"
	/* x y nt0 - natural sign */
	"/nt0{	gsave T -3 -5 T .018 dup scale unat ufill grestore}!\n"
	/* x y dsh0 - double sharp */
	"/dsh0{	gsave T -4 -5 T .018 dup scale udblesharp ufill grestore}!\n"
	/* x y dft0 - double flat sign */
	"/dft0{	gsave T -4 -3.5 T .018 dup scale udbleflat ufill grestore}!\n"
	/* ancillary function for grace note accidentals */
	"/gsc{gsave y T .7 dup scale 0 0}!\n"

	/* some microtone accidentals */
	/* 1/4 ton sharp */
	"/sh1{	gsave T .9 SLW\n"
	"	0 -7.8 M 0 15.4 RL stroke\n"
	"	-1.8 -2.7 M 3.6 1.1 RL 0 -2.2 RL -3.6 -1.1 RL 0 2.2 RL fill\n"
	"	-1.8 3.7 M 3.6 1.1 RL 0 -2.2 RL -3.6 -1.1 RL 0 2.2 RL fill\n"
	"	grestore}!\n"
	/* 3/4 ton sharp */
	"/sh513{	gsave T .8 SLW\n"
	"	-2.5 -8.7 M 0 15.4 RL\n"
	"	0 -7.8 M 0 15.4 RL\n"
	"	2.5 -6.9 M 0 15.4 RL stroke\n"
	"	-3.7 -3.1 M 7.4 2.2 RL 0 -2.2 RL -7.4 -2.2 RL 0 2.2 RL fill\n"
	"	-3.7 3.2 M 7.4 2.2 RL 0 -2.2 RL -7.4 -2.2 RL 0 2.2 RL fill\n"
	"	grestore}!\n"
	/* 1/4 ton flat */
	"/ft1{gsave -1 1 scale exch neg exch ft0 grestore}!\n"
	/* x y ftx - narrow flat sign */
	"/ftx{	-1.4 2.7 RM\n"
	"	5.7 3.1 5.7 -3.6 0 -6.7 RC\n"
	"	3.9 4 4 7.6 0 5.8 RC\n"
	"	currentpoint fill M\n"
	"	dlw 0 7.1 RM 0 -12.4 RL stroke}!\n"
	/* 3/4 ton flat */
	"/ft513{2 copy gsave -1 1 scale exch neg 3 add exch M ftx grestore\n"
	"	M 1.5 0 RM ftx}!\n"

	/* str gcshow - guitar chord */
	"/gcshow{show}!\n"
	/* x y w h box - draw a box */
	"/box{.6 SLW rectstroke}!\n"
	/* set the start of a guitar chord in a box */
	"/boxstart{currentpoint pop/x exch def}!\n"
	/* mark the end of a guitar chord in a box */
	"/boxmark{currentpoint pop dup x gt\n"
	"	{/x exch def}{pop}ifelse}!\n"
	/* x y dy boxdraw - draw a box around a guitar chord */
	"/boxdraw{x 3 index sub 2 add exch box}!\n"
	/* w str gxshow - expand a guitar chord */
	"/gxshow{0 9 3 -1 roll widthshow}!\n"

	/* str anshow - annotation */
	"/anshow{show}!\n"

	/* -- lyrics under notes -- */
	/* l x y wln - underscore line */
	"/wln{M .8 SLW 0 RL stroke}!\n"
	/* l x y hyph - hyphen */
	"/hyph{	.8 SLW 3 add M\n"
	"	dup cvi 40 idiv 1 add 1 index exch div\n"	/* l dx */
	"	dup 3 sub 3 1 roll\n"		/* (dx-3) l dx */
	"	dup .5 mul dup 1.5 sub 0 RM\n"	/* (dx-3) l dx (dx/2) */
	"	exch 3 -1 roll\n"		/* (dx-3) (dx/2) dx l */
	"	{pop 3 0 RL dup 0 RM}for stroke pop}!\n"
	/* str lyshow - lyrics */
	"/lyshow{show}!\n"

	/* -- bars -- */
	/* h x y bar - thin bar */
	"/bar{M dlw 0 exch RL stroke}!\n"
	/* h x y dotbar - dotted bar */
	"/dotbar{[5] 0 setdash bar [] 0 setdash}!\n"
	/* h x y thbar - thick bar */
	"/thbar{3 -1 roll 3 exch rectfill}!\n"
	/* x y rdots - repeat dots */
	"/rdots{	2 copy 9 add M currentpoint 1.2 0 360 arc\n"
	"	15 add M currentpoint 1.2 0 360 arc fill}!\n"

	/* x y csig - C timesig */
	"/csig{	M\n"
	"	1 17.3 RM\n"
	"	0.9 0 2.3 -0.7 2.4 -2.2 RC\n"
	"	-1.2 2 -3.6 -0.1 -1.6 -1.7 RC\n"
	"	2 -1 3.8 3.5 -0.8 4.7 RC\n"
	"	-2 0.4 -6.4 -1.3 -5.8 -7 RC\n"
	"	0.4 -6.4 7.9 -6.8 9.1 -0.7 RC\n"
	"	-2.3 -5.6 -6.7 -5.1 -6.8 0 RC\n"
	"	-0.5 4.4 0.7 7.5 3.5 6.9 RC\n"
	"	fill}!\n"

	/* x y ctsig - C| timesig */
	"/ctsig{dlw 2 copy csig 4 add M 0 16 RL stroke}!\n"

	/* x y xxsig - old time signatures ('o', 'o.', 'c' 'c.') */
	"/pmsig{0.3 SLW 12 add M currentpoint 5 0 360 arc stroke}!\n"
	"/pMsig{2 copy pmsig 12 add M currentpoint 1.3 0 360 arc fill}!\n"
	"/imsig{0.3 SLW 12 add 2 copy 5 add M 5 90 270 arc stroke}!\n"
	"/iMsig{2 copy imsig 12 add M currentpoint 1.3 0 360 arc fill}!\n"

	/* (top) (bot) x y tsig - time signature */
	"/tsig{	M gsave/Times-Bold 16 selectfont 1.2 1 scale\n"
	"	0 1 RM currentpoint 3 -1 roll showc\n"
	"	12 add M showc grestore}!\n"

	/* (meter) x y stsig - single time signature */
	"/stsig{	M gsave/Times-Bold 18 selectfont 1.2 1 scale\n"
	"	0 7 RM showc grestore}!\n"

	/* width n x y staff - staff with n lines*/
	"/staff{	dlw M{dup 0 RL dup neg 6 RM}repeat\n"
	"	pop stroke}!\n"

	/* l x sep0 - hline separator */
	"/sep0{dlw 0 M 0 RL stroke}!\n"

	"/hbrce{	-2.5 1 RM\n"
	"	-4.5 -4.6 -7.5 -12.2 -4.4 -26.8 RC\n"
	"	3.5 -14.3 3.2 -21.7 -2.1 -24.2 RC\n"
	"	7.4 2.4 7.3 14.2 3.5 29.5 RC\n"
	"	-2.7 9.5 -1.5 16.2 3 21.5 RC\n"
	"	fill}!\n"
	/* h x y brace */
	"/brace{	gsave T 0 0 M .01 mul 1 exch scale hbrce\n"
	"	0 -100 M 1 -1 scale hbrce grestore}!\n"

	/* h x y bracket */
	"/bracket{M -5 2 RM currentpoint\n"
	"	-1.7 2 RM 10.5 -1 12 4.5 12 3.5 RC\n"
	"	0 -1 -3.5 -5.5 -8.5 -5.5 RC fill\n"
	"	3 SLW M 0 2 RM\n"
	"	0 exch neg 8 sub RL currentpoint stroke\n"
	"	M -1.7 0 RM\n"
	"	10.5 1 12 -4.5 12 -3.5 RC\n"
	"	0 1 -3.5 5.5 -8.5 5.5 RC fill}!\n"

	/* nb_measures x y mrest */
	"/mrest{	gsave T 1 SLW\n"
	"	-20 6 M 0 12 RL 20 6 M 0 12 RL stroke\n"
	"	5 SLW -20 12 M 40 0 RL stroke\n"
	"	/Times-Bold 15 selectfont 0 28 M showc grestore}!\n"

	/* x y mrep - measure repeat */
	"/mrep{	2 copy 2 copy\n"
	"	M -5 15 RM currentpoint 1.4 0 360 arc\n"
	"	M 5 9 RM currentpoint 1.4 0 360 arc\n"
	"	M -7 6 RM 11 12 RL 3 0 RL -11 -12 RL -3 0 RL\n"
	"	fill}!\n"

	/* x y mrep2 - measure repeat 2 times */
	"/mrep2{	2 copy 2 copy\n"
	"	M -5 18 RM currentpoint 1.4 0 360 arc\n"
	"	M 5 6 RM currentpoint 1.4 0 360 arc fill\n"
	"	M 1.8 SLW\n"
	"	-7 4 RM 14 10 RL -14 -4 RM 14 10 RL\n"
	"	stroke}!\n"

	/* x y srep - sequence repeat */
	"/srep{	M -1 6 RM 11 12 RL 3 0 RL -11 -12 RL -3 0 RL\n"
	"	fill}!\n"

	/* str dy bracket_type dx x y repbra - repeat bracket */
	"/repbra{gsave dlw T 0 -20 M\n"
	"	0 20 3 index 1 ne{RL}{RM}ifelse 0 RL 0 ne{0 -20 RL}if stroke\n"
	"	4 exch M show grestore}!\n"

	/* pp2x pp1x p1 pp1 pp2 p2 p1 SL - slur / tie */
	"/SL{M RC RL RC closepath fill}!\n"

	/* pp2x pp1x p1 pp1 pp2 p2 p1 dSL - dotted slur / tie */
	"/dSL{	M [4] 0 setdash .8 SLW\n"
	"	RC stroke [] 0 setdash}!\n"

	/* -- text -- */
	"/strw{stringwidth pop w add/w exch def}!\n"
	"/jshow{w 0 32 4 -1 roll widthshow}!\n"

	/* -- note heads -- */
	/* x y hd - full head */
	"/uhd{{	100 -270 640 280\n"
	"	560 82\n"
	"	474 267 105 105 186 -80\n"
	"	267 -265 636 -102 555 82\n"
	"	}<0b000122050a>}cvlit def\n"
	"/hd{	/x 2 index def/y 1 index def\n"
	"	gsave T -7.4 0 T .02 dup scale uhd ufill grestore}!\n"
	/* x y Hd - open head for half */
	"/Hd{	xymove\n"
	"	3 1.6 RM\n"
	"	-1 1.8 -7 -1.4 -6 -3.2 RC\n"
	"	1 -1.8 7 1.4 6 3.2 RC\n"
	"	0.5 0.3 RM\n"
	"	2 -3.8 -5 -7.6 -7 -3.8 RC\n"
	"	-2 3.8 5 7.6 7 3.8 RC\n"
	"	fill}!\n"
	/* x y HD - open head for whole */
	"/HD{	xymove\n"
	"	-2.7 1.4 RM\n"
	"	1.5 2.8 6.9 0 5.3 -2.7 RC\n"
	"	-1.5 -2.8 -6.9 0 -5.3 2.7 RC\n"
	"	8.3 -1.4 RM\n"
	"	0 1.5 -2.2 3 -5.6 3 RC\n"
	"	-3.4 0 -5.6 -1.5 -5.6 -3 RC\n"
	"	0 -1.5 2.2 -3 5.6 -3 RC\n"
	"	3.4 0 5.6 1.5 5.6 3 RC\n"
	"	fill}!\n"
	/* x y HDD - round breve */
	"/HDD{	dlw HD\n"
	"	x y M -6 -4 RM 0 8 RL\n"
	"	12 0 RM 0 -8 RL stroke}!\n"
	/* x y breve - square breve */
	"/breve{	xymove\n"
	"	2.5 SLW -6 -2.7 RM 12 0 RL\n"
	"	0 5.4 RM -12 0 RL stroke\n"
	"	dlw x y M -6 -5 RM 0 10 RL\n"
	"	12 0 RM 0 -10 RL stroke}!\n"
	/* x y longa */
	"/longa{	xymove\n"
	"	2.5 SLW -6 -2.7 RM 12 0 RL\n"
	"	0 5.4 RM -12 0 RL stroke\n"
	"	dlw x y M -6 -5 RM 0 10 RL\n"
	"	12 0 RM 0 -16 RL stroke}!\n"

	/* -- default percussion heads -- */
	/* x y pshhd - percussion sharp head */
	"/pshhd{/x 2 index def/y 1 index def dsh0}!\n"
	/* x y pfthd - percussion flat head */
	"/pfthd{/x 2 index def/y 1 index def dsh0\n"
	"	.7 SLW x y 4 0 360 arc stroke}!\n"
	/* same for dble sharp/flat */
	"/pdshhd{pshhd}!\n"
	"/pdfthd{pfthd}!\n"

	/* x y ghd - grace note head */
	"/ghd{	xymove\n"
	"	1.7 1 RM\n"
	"	-1 1.7 -4.5 -0.2 -3.4 -2 RC\n"
	"	1 -1.7 4.5 0.2 3.4 2 RC fill}!\n"

	/* dx dy gua / gda - acciaccatura */
	"/gua{x y M -1 4 RM RL stroke}!\n"
	"/gda{x y M -5 -4 RM RL stroke}!\n"

	/* x y ghl - grace note ledger line */
	"/ghl{	.6 SLW M -3 0 RM 6 0 RL stroke}!\n"

	/* x1 y2 x2 y2 x3 y3 x0 y0 gsl - grace note slur */
	"/gsl{dlw M RC stroke}!\n"

	/* extra characters (accidentals) range c280 .. c29f */
	"/c280_c29f[\n"
	"	/.notdef	/sharp		/flat		/natural\n"
	"	/dsharp		/dflat]def\n"

	"/extra-draw{\n"
	"	/sharp{460 0 setcharwidth usharp ufill}bind def\n"
	"	/flat{460 0 setcharwidth uflat ufill}bind def\n"
	"	/natural{400 0 setcharwidth unat ufill}bind def\n"
	"	/dsharp{460 0 setcharwidth udblesharp ufill}bind def\n"
	"	/dflat{500 0 setcharwidth udbleflat ufill}bind def\n"
	" }def\n"

	/* latin characters range c2a0 .. c5bf */
	"/c2a0_c5bf[\n"
	/*% c2a0..c2bf */
	"/LA140000	/exclamdown	/cent		/sterling\n"
	"/currency	/yen		/brokenbar	/section\n"
	"/dieresis	/copyright	/ordfeminine	/guillemotleft\n"
	"/logicalnot	/LI120000	/registered	/LI180000\n"
	"/degree	/plusminus	/twosuperior	/threesuperior\n"
	"/acute		/LO200000	/paragraph	/SA070000\n"
	"/cedilla	/onesuperior	/ordmasculine	/guillemotright\n"
	"/onequarter	/onehalf	/threequarters	/questiondown\n"
	/* c380..c3bf */
	"/Agrave	/Aacute		/Acircumflex	/Atilde\n"
	"/Adieresis	/Aring		/AE		/Ccedilla\n"
	"/Egrave	/Eacute		/Ecircumflex	/Edieresis\n"
	"/Igrave	/Iacute		/Icircumflex	/Idieresis\n"
	"/Eth		/Ntilde		/Ograve		/Oacute\n"
	"/Ocircumflex	/Otilde		/Odieresis	/multiply\n"
	"/Oslash	/Ugrave		/Uacute		/Ucircumflex\n"
	"/Udieresis	/Yacute		/Thorn		/germandbls\n"
	"/agrave	/aacute		/acircumflex	/atilde\n"
	"/adieresis	/aring		/ae		/ccedilla\n"
	"/egrave	/eacute		/ecircumflex	/edieresis\n"
	"/igrave	/iacute		/icircumflex	/idieresis\n"
	"/eth		/ntilde		/ograve		/oacute\n"
	"/ocircumflex	/otilde		/odieresis	/divide\n"
	"/oslash	/ugrave		/uacute		/ucircumflex\n"
	"/udieresis	/yacute		/thorn		/ydieresis\n"
	/* c480..c4bf */
	"/Amacron	/amacron	/Abreve		/abreve\n"
	"/Aogonek	/aogonek	/Cacute		/cacute\n"
	"/Ccircumflex	/ccircumflex	/Cdotaccent	/cdotaccent\n"
	"/Ccaron	/ccaron		/Dcaron		/dcaron\n"
	"/Dcroat	/dcroat		/Emacron	/emacron\n"
	"/Ebreve	/ebreve		/Edotaccent	/edotaccent\n"
	"/Eogonek	/eogonek	/Ecaron		/ecaron\n"
	"/Gcircumflex	/gcircumflex	/Gbreve		/gbreve\n"
	"/Gdotaccent	/gdotaccent	/Gcommaaccent	/gcommaaccent\n"
	"/Hcircumflex	/hcircumflex	/Hbar		/hbar\n"
	"/Itilde	/itilde		/Imacron	/imacron\n"
	"/Ibreve	/ibreve		/Iogonek	/iogonek\n"
	"/Idotaccent	/dotlessi	/IJ		/ij\n"
	"/Jcircumflex	/jcircumflex	/Kcedilla	/kcedilla\n"
	"/kgreenlandic	/Lacute		/lacute		/Lcedilla\n"
	"/lcedilla	/Lcaron		/lcaron		/Ldot\n"
	/* c580..c5bf */
	"/ldot		/Lslash		/lslash		/Nacute\n"
	"/nacute	/Ncedilla	/ncedilla	/tmacron\n"
	"/ncaron	/napostrophe	/Eng		/eng\n"
	"/Omacron	/omacron	/Obreve		/obreve\n"
	"/Ohungarumlaut	/ohungarumlaut	/OE		/oe\n"
	"/Racute	/racute		/Rcommaaccent	/rcommaaccent\n"
	"/Rcaron	/rcaron		/Sacute		/sacute\n"
	"/Scircumflex	/scircumflex	/Scedilla	/scedilla\n"
	"/Scaron	/scaron		/Tcedilla	/tcedilla\n"
	"/Tcaron	/tcaron		/Tbar		/tbar\n"
	"/Utilde	/utilde		/Umacron	/umacron\n"
	"/Ubreve	/ubreve		/Uring		/uring\n"
	"/Uhungarumlaut	/uhungarumlaut	/Uogonek	/uogonek\n"
	"/Wcircumflex	/wcircumflex	/Ycircumflex	/ycircumflex\n"
	"/Ydieresis	/Zacute		/zacute		/Zdotaccent\n"
	"/zdotaccent	/Zcaron		/zcaron		/longs\n"

	"/.notdef	/.notdef	/.notdef	/.notdef\n"
	"/.notdef	/.notdef	/.notdef	/.notdef\n"
	"/.notdef	/.notdef	/.notdef	/.notdef\n"
	"/.notdef	/.notdef	/.notdef	/.notdef\n"
	"/.notdef	/.notdef	/.notdef	/.notdef\n"
	"/.notdef	/.notdef	/.notdef	/.notdef\n"
	"/.notdef	/.notdef	/.notdef	/.notdef\n"
	"/.notdef	/.notdef	/.notdef	/.notdef\n"
	"]def\n"

	/* font for c2a0..c5bf encoding */
	"/latinfontdef{\n"
	"  /latinfont curfont findfont dup length\n"
	"	dict begin\n"
	"		{1 index/FID ne{def}{pop pop}ifelse}forall\n"
	"		/Encoding c2a0_c5bf def\n"
	"		currentdict\n"
	"	end\n"
	"  definefont}def\n"

	/* error font */
	"/Error<<\n"
	"	/FontType 3\n"
	"	/FontMatrix[.001 0 0 .001 0 0]\n"
	"	/Encoding 256 array\n"
	"	/FontBBox[0 0 1000 1000]\n"
	"	/BuildChar{\n"
	"		500 0 setcharwidth 50 setlinewidth\n"
	"		100 500 moveto 300 0 rlineto stroke\n"
	"		(char: )print = pop\n"
	"	}\n"
	"  >>definefont pop\n"

	/* stub for utf-8 with 3 bytes */
	"/compe000def{/Error findfont}def\n"
	"/compe100def{/Error findfont}def\n"
	"/compe200def{/Error findfont}def\n"
#ifdef HAVE_PANGO
	"/glypharray{{glyphshow}forall}!\n"
#endif

	/* x y showerror */
	"/showerror{	gsave 1 0.7 0.7 setrgbcolor 2.5 SLW newpath\n"
	"	30 0 360 arc stroke grestore}!\n"

	"/pdfmark where{pop}{userdict/pdfmark/cleartomark load put}ifelse\n"

	"0 setlinecap 0 setlinejoin\n";

/* -- output the common CMAP -- */
/* This output must occurs after user PostScript definitions because
 * these ones may change the default behaviour */
void define_cmap(void)
{
	static char mkfont[] =

	/* extra characters (accidentals) range c280 .. c29f */
	"/ExtraFont 10 dict begin\n"
	"	/FontType 3 def\n"
	"	/FontMatrix[.001 0 0 .001 0 0]def\n"
	"	/Encoding[256{/.notdef}repeat]def\n"
	"	Encoding 0 c280_c29f putinterval\n"
	"	/FontBBox[0 0 1000 1000]def\n"
	"	/BuildChar{\n"
	"		1 index/Encoding get exch get\n"
	"		1 index/BuildGlyph get exec\n"
	"	}bind def\n"
	"	/CharProcs 3 dict def\n"
	"		CharProcs begin\n"
	"			/.notdef{}def\n"
	"			extra-draw\n"
	"		end\n"
	"	/BuildGlyph{\n"
	"		exch /CharProcs get exch\n"
	"		2 copy known not{pop /.notdef}if\n"
	"		get exec\n"
	"	}bind def\n"
	"	currentdict\n"
	"    end\n"
	" definefont pop\n"

	/* newfont basefont mkfont-utf8 */
	"/mkfont-utf8{\n"
	"	/curfont exch def\n"
	/* composite font first level */
	"	<<\n"
	"	/FontType 0\n"
	"	/FontMatrix[1 0 0 1 0 0]\n"
	"	/FMapType 4\n"			/* 1/7 mapping*/
	"	/Encoding[0 1]\n"
	"	/FDepVector[\n"
	"		curfont findfont\n"
	/* composite font second level */
	"		/compfont2<<\n"
	"			/FontType 0\n"
	"			/FontMatrix[1 0 0 1 0 0]\n"
	"			/FMapType 6\n"	/* SubsVector mapping */
	/*	/SubsVector
	 *		4280	% 8000
	 *		0020	% c280 ->	c280..c29f -> 0..1f
	 *		00c0	% c2a0 ->	c2a0..c2bf -> 0..1f
	 *		00c0	% c360 ->	c380..c3bf -> 20..5f
	 *		00c0	% c420 ->	c480..c4bf -> 60..9f
	 *		00e0	% c4e0 ->	c580..c5bf -> a0..df
	 *		1a40	% c5c0		c680..dfbf -> error
	 *		0100	% e000		compe000
	 *		0100	% e100		compe100
	 *		0100	% e200		compe200
	 *			% e300		e30000..   -> error */
	"	/SubsVector<01 4280 0020 00c0 00c0 00c0 00e0 1a40 0100 0100 0100>\n"
	"			/Encoding[0 1 2 2 2 2 0 3 4 5 0]\n"
	"			/FDepVector[\n"
	"				/Error findfont\n"
	"				/ExtraFont findfont\n"
	"				latinfontdef\n"
	"				compe000def\n"
	"				compe100def\n"
	"				compe200def\n"
	"			]\n"
	"		>>definefont pop\n"
	"		/compfont2 findfont\n"
	"	]\n"
	"	>>definefont pop}bind def\n";

	fputs(mkfont, fout);
}

/* -- define a font -- */
void define_font(char name[],
		 int num,
		 int enc)
{
	if (enc == 0)		/* utf-8 */
		fprintf(fout, "/%s-utf8/%s mkfont-utf8\n"
			"/F%d{/%s-utf8 exch selectfont}!\n",
			name, name, num, name);
	else			/* native encoding */
		fprintf(fout, "/F%d{/%s exch selectfont}!\n",
			num, name);
}

/* -- output the symbol definitions -- */
void define_symbols(void)
{
	fputs(ps_head, fout);

	/* len su - up stem */
	fprintf(fout, "/su{dlw x y M %.1f %.1f RM %.1f sub 0 exch RL stroke}!\n",
		STEM_XOFF, STEM_YOFF, STEM_YOFF);

	/* len sd - down stem */
	fprintf(fout, "/sd{dlw x y M %.1f %.1f RM %.1f add 0 exch RL stroke}!\n",
		-STEM_XOFF, -STEM_YOFF, STEM_YOFF);

	/* n len sfu - stem and n flags up */
	fprintf(fout, "/sfu{	dlw x y M %.1f %.1f RM\n"
		"	%.1f sub 0 exch RL currentpoint stroke\n"
		"	M dup 1 eq{\n"
		"		pop\n"
		"		0.6 -5.6 9.6 -9 5.6 -18.4 RC\n"
		"		1.6 6 -1.3 11.6 -5.6 12.8 RC\n"
		"		fill\n"
		"	  }{\n"
		"		1 sub{	currentpoint\n"
		"			0.9 -3.7 9.1 -6.4 6 -12.4 RC\n"
		"			1 5.4 -4.2 8.4 -6 8.4 RC\n"
		"			fill 5.4 sub M\n"
		"		}repeat\n"
		"		1.2 -3.2 9.6 -5.7 5.6 -14.6 RC\n"
		"		1.6 5.4 -1 10.2 -5.6 11.4 RC\n"
		"		fill\n"
		"	  }ifelse}!\n",
		STEM_XOFF, STEM_YOFF, STEM_YOFF);

	/* n len sfd - stem and n flags down */
	fprintf(fout, "/sfd{	dlw x y M %.1f %.1f RM\n"
		"	%.1f add 0 exch RL currentpoint stroke\n"
		"	M dup 1 eq{\n"
		"		pop\n"
		"		0.6 5.6 9.6 9 5.6 18.4 RC\n"
		"		1.6 -6 -1.3 -11.6 -5.6 -12.8 RC\n"
		"		fill\n"
		"	  }{\n"
		"		1 sub{	currentpoint\n"
		"			0.9 3.7 9.1 6.4 6 12.4 RC\n"
		"			1 -5.4 -4.2 -8.4 -6 -8.4 RC\n"
		"			fill 5.4 add M\n"
		"		}repeat\n"
		"		1.2 3.2 9.6 5.7 5.6 14.6 RC\n"
		"		1.6 -5.4 -1 -10.2 -5.6 -11.4 RC\n"
		"		fill\n"
		"	  }ifelse}!\n",
		-STEM_XOFF, -STEM_YOFF, STEM_YOFF);

	/* n len sfs - stem and n straight flag down */
	fprintf(fout, "/sfs{	dup 0 lt{\n"
		"		dlw x y M -%.1f -%.1f RM\n"
		"		%.1f add 0 exch RL currentpoint stroke\n"
		"		M{	currentpoint\n"
		"			7 %.1f RL\n"
		"			0 %.1f RL\n"
		"			-7 -%.1f RL\n"
		"			fill 5.4 add M\n"
		"		}repeat\n"
		"	}{\n"
		"		dlw x y M %.1f %.1f RM\n"
		"		%.1f sub 0 exch RL currentpoint stroke\n"
		"		M{	currentpoint\n"
		"			7 -%.1f RL\n"
		"			0 -%.1f RL\n"
		"			-7 %.1f RL\n"
		"			fill 5.4 sub M\n"
		"		}repeat\n"
		"	}ifelse}!\n",
		STEM_XOFF, STEM_YOFF, STEM_YOFF,
		BEAM_DEPTH, BEAM_DEPTH, BEAM_DEPTH,
		STEM_XOFF, STEM_YOFF, STEM_YOFF,
		BEAM_DEPTH, BEAM_DEPTH, BEAM_DEPTH);

	/* len gu - grace note stem up */
	fprintf(fout, "/gu{	.6 SLW x y M\n"
		"	%.1f 0 RM 0 exch RL stroke}!\n"

	/* len gd - grace note stem down */
		"/gd{	.6 SLW x y M\n"
		"	%.1f 0 RM 0 exch RL stroke}!\n",
		GSTEM_XOFF, -GSTEM_XOFF);

	/* n len sgu - gnote stem and n flag up */
	fprintf(fout, "/sgu{	.6 SLW x y M %.1f 0 RM\n"
		"	0 exch RL currentpoint stroke\n"
		"	M dup 1 eq{\n"
		"		pop\n"
		"		0.6 -3.4 5.6 -3.8 3 -10 RC\n"
		"		1.2 4.4 -1.4 7 -3 7 RC\n"
		"		fill\n"
		"	  }{\n"
		"		{	currentpoint\n"
		"			1 -3.2 5.6 -2.8 3.2 -8 RC\n"
		"			1.4 4.8 -2.4 5.4 -3.2 5.2 RC\n"
		"			fill 3.5 sub M\n"
		"		}repeat\n"
		"	  }ifelse}!\n",
		GSTEM_XOFF);

	/* n len sgd - gnote stem and n flag down */
	fprintf(fout, "/sgd{	.6 SLW x y M %.1f 0 RM\n"
		"	0 exch RL currentpoint stroke\n"
		"	M dup 1 eq{\n"
		"		pop\n"
		"		0.6 3.4 5.6 3.8 3 10 RC\n"
		"		1.2 -4.4 -1.4 -7 -3 -7 RC\n"
		"		fill\n"
		"	  }{\n"
		"		{	currentpoint\n"
		"			1 3.2 5.6 2.8 3.2 8 RC\n"
		"			1.4 -4.8 -2.4 -5.4 -3.2 -5.2 RC\n"
		"			fill 3.5 add M\n"
		"		}repeat\n"
		"	  }ifelse}!\n",
		-GSTEM_XOFF);

	/* n len sgs - gnote stem and n straight flag up */
	fprintf(fout, "/sgs{	.6 SLW x y M %.1f 0 RM\n"
		"	0 exch RL currentpoint stroke\n"
		"	M{	currentpoint\n"
		"		3 -1.5 RL 0 -2 RL -3 1.5 RL\n"
		"		closepath fill 3 sub M\n"
		"	}repeat}!\n",
		GSTEM_XOFF);
}
