#ifndef _FontCreator_hh_
#define _FontCreator_hh_

#include "GraphConfig.hh"

enum TextDirection { tdNorth, tdEast, tdSouth, tdWest };
enum FontShape { fsRegular, fsOblique, fsSmallRegular, fsSmallOblique };
const FontShapeCount = 4;

class FontCreator {
  protected:
    virtual Pixel_t * CreateNorthFontImage(const char * text, Pixel_t color,
			      FontShape fontshape, int& W, int& H) = 0;
  public:
    FontCreator() { };
    virtual ~FontCreator() { };
    virtual Pixel_t * CreateFontImage(const char * text, Pixel_t color,
			      TextDirection direction, FontShape fontshape, int& W, int& H);
};

extern FontCreator * fontcreator;

#endif
