#include "XlibFontCreator.hh"
#include "Utils.hh"
#include "XlibGlobal.hh"
#include <string.h>

XlibFontCreator::XlibFontCreator(XDrawable * _pixmap, XBuffer * _buffer)
    : pixmap(_pixmap), buffer(_buffer)
{
  for (int i=0; i<FontShapeCount; i++) {
    XGCValues Values; // ?
    fontgc[i] = XCreateGC(pixmap->GetDisplay(), pixmap->GetDrawable(),
		       0, &Values);
    font[i] = XLoadFont(pixmap->GetDisplay(), global_FontName[i]);
    XSetFont(pixmap->GetDisplay(), fontgc[i], font[i]);
    XSetBackground (pixmap->GetDisplay(), fontgc[i], 0);
    fontstr[i] = XQueryFont(pixmap->GetDisplay(), font[i]);
  }
}

XlibFontCreator::~XlibFontCreator()
{
  for (int i=0; i<FontShapeCount; i++) {
    XFreeFont(pixmap->GetDisplay(), fontstr[i]);
    XUnloadFont(pixmap->GetDisplay(), font[i]);
    XFreeGC(pixmap->GetDisplay(), fontgc[i]);
  }
  delete pixmap;
  delete buffer;
}

Pixel_t * XlibFontCreator::CreateNorthFontImage(const char * text, Pixel_t color,
						FontShape fontshape, int& W, int& H)
{  
  const int slen = strlen(text);
  GC fngc = fontgc[fontshape];
  XFontStruct * fnstr = fontstr[fontshape];
  XSetForeground (pixmap->GetDisplay(), fngc, 0);
  H = fnstr->ascent+fnstr->descent;
  W = XTextWidth(fnstr, text, slen)+3; //fnstr->max_bounds.width*slen;
  W = Min(W, buffer->WindowSizeX);
  XFillRectangle(pixmap->GetDisplay(), pixmap->GetDrawable(),
		 fngc, 0, 0, W, H);
  int c = color.GetColor();
  XSetForeground (pixmap->GetDisplay(), fngc, c);
  XDrawString (pixmap->GetDisplay(), pixmap->GetDrawable(),
	       fngc, 0, fnstr->ascent, text, strlen(text));
  XSync(pixmap->GetDisplay(), FALSE); // needed?
  buffer->GetWindow(0, 0, W, H);
  Pixel_t * src = buffer->buffer;  
  const int sizes = buffer->WindowSizeX;  
  Pixel_t * retbuf = new Pixel_t[W*H];
  Pixel_t * dst = retbuf;
  const int sized = W;
  for (int i=0; i<H; i++) {
    memcpy(dst, src, sized*sizeof(Pixel_t));
    src += sizes;
    dst += sized;
  }
  return retbuf; 
}

