#include "Menu.hh"

Submenu::Submenu(const char * _text, Group * _submenu=0,
		 TextDirection _direction=tdNorth, FontShape _fontshape=fsOblique)
    : Label(_text, cmInvalid, TRUE, _direction, _fontshape), submenu(_submenu)
{
  if (submenu)
    submenu->SetHidden(TRUE);
}

void Submenu::Choose()
{
  if (submenu) {
    parent->SetHidden(TRUE);
    submenu->SetHidden(FALSE);
    submenu->Show();
    submenu->Select();
    Event e(parent);
    e.type = evnCommand;
    e.command = cmSetUpmenu;
    e.to = submenu;
    PutEvent(e);
  }
}

Menu::Menu(const Align _align=VAVertical)
    : Group(_align), upmenu(0)
{
  AutoCenter = TRUE;
}
    
bool Menu::HandleEvent(Event& event)
{
  if ((!Visible) || Hidden)
    return TRUE;
  if (!Group::HandleEvent(event))
    return FALSE;
  if ((event.type == evnCommand) && (event.command == cmCancel) && upmenu) {
    if (!parent)
      Hide();
    else {
      SetHidden(TRUE);
      if (upmenu) {
	upmenu->SetHidden(FALSE);
	upmenu->Show();
	upmenu->Select();
      }
    }
    return FALSE;
  }
  if ((event.type == evnCommand) && (event.command == cmHideMenu) &&
      (event.creator != this)) {
    SetHidden(TRUE);
    return FALSE;
  }
  if ((event.type == evnCommand) && (event.command == cmSetUpmenu) &&
    (event.to == this)) {
    upmenu = (Group *) event.creator;
  }
  return TRUE;
}

void Menu::ShowMenu()
{
  if (parent) {
    parent->Select();
    Event e(this);
    e.type = evnCommand;
    e.command = cmHideMenu;
    parent->HandleEvent(e);
    upmenu = (Group *) parent->GetCurrent();
  }
  SetHidden(FALSE);
  Show();
  Select();
}

MenuItem::MenuItem(const char * _text, const CommandType _cc2 /* = cmInvalid */,
	  FontShape _fontshape = fsOblique)
    : Label(_text, _cc2, TRUE, tdNorth, _fontshape)
{
}

