#include "TargaPicture.hh"
#include "Utils.hh"
#include <string.h>
#include "Compat.hh"

// Adapted from Abuse, game by Crack Dot Com

struct TargaHeader {
  unsigned char id;
  unsigned char color_map;
  unsigned char im_type;
  char gap[9];
  unsigned short W;
  unsigned short H;
  unsigned char bpp;
  unsigned char im_des;
};

#if 0
TargaPicture::TargaPicture(const char * filename)
{
  filebuf fb;
  istream is(fb.open(filename, "r"));

  TargaHeader th;
  is.read(&th, sizeof(th));
  
  char * error_str = new char[strlen(filename)+100];
  strcpy(error_str, "While loading ");
  strcat(error_str, filename);
  char * error_str_end = error_str + strlen(error_str);
  strcpy(error_str_end, " - Invalid targa file");
  Assert(th.color_map, error_str);
  Assert((!(th.im_type==2 || th.im_type==10)), error_str);
  strcpy(error_str_end, " - Invalid bpp (not 24/32) value");
  Assert((th.bpp!=32) && (th.bpp!=24), error_str);
  
  W = th.W;
  H = th.H;
  
  data = new Pixel_t[W*H];
  
  unsigned char ctrl;
  unsigned char bgra[4];
  Pixel_t c = RGB(0, 0, 0);
  Pixel_t * sl;
  
  for (int y=0; y<H; y++) {
    sl=data+y*W; //im->scan_line(h-y-1);
    for (int x=0;x<W;) {
      if (th.im_type == 2) {
	bgra[3] = 1; // for bpp == 24
	is.read(&bgra, (th.bpp == 32 ? 4 : 3));
	c = (bgra[3] ? RGB(bgra[2], bgra[1], bgra[0]) : RGB(0, 0, 0));
	*(sl++) = c;
	x++;
      } else {
	is >> ctrl;
	// RLE decompression
	if (ctrl&0x80) {
	  is.read(bgra, (th.bpp == 32 ? 4 : 3));
	  ctrl &= (~0x80);
	  ctrl++;
	  c = (bgra[3] ? RGB(bgra[2], bgra[1], bgra[0]) : RGB(0, 0, 0));
	  while (ctrl--) {
	    *(sl++) = c;
	    x++;
	  }
	} else {
	  // not compressed?
	  ctrl++;
	  while (ctrl--) {
	    bgra[3] = 1;
	    is.read(&bgra, (th.bpp==32 ? 4 : 3));
	    c = (bgra[3] ? RGB(bgra[2], bgra[1], bgra[0]) : RGB(0, 0, 0));
	    *(sl++) = c;
	    x++;
	  }
	}
      }
    }
  }
}
#endif

#include <stdio.h>
TargaPicture::TargaPicture(const char * filename)
{
  FILE * is = fopen(filename, "r");
  if (NULL == is)
    {
      fprintf(stderr, "Unable to open Targa image \"%s\"\n", filename);
      return;
    }
  TargaHeader th;
  fread(&th, sizeof(th), 1, is);
  
  char * error_str = new char[strlen(filename)+100];
  strcpy(error_str, "While loading ");
  strcat(error_str, filename);
  char * error_str_end = error_str + strlen(error_str);
  strcpy(error_str_end, " - Invalid targa file");
  Assert(th.color_map, error_str);
  Assert((!(th.im_type==2 || th.im_type==10)), error_str);
  strcpy(error_str_end, " - Invalid bpp (not 24/32) value");
  Assert((th.bpp!=32) && (th.bpp!=24), error_str);
  
  W = byteswapshort(th.W);
  H = byteswapshort(th.H);
  
  data = new Pixel_t[W*H];
  
  unsigned char ctrl;
  unsigned char bgra[4];
  Pixel_t c = RGB(0, 0, 0);
  Pixel_t * sl;
  
  for (int y=0; y<H; y++) {
    sl=data+y*W; //im->scan_line(h-y-1);
    for (int x=0;x<W;) {
      if (th.im_type == 2) {
	bgra[3] = 1; // for bpp == 24
	fread(&bgra, (th.bpp == 32 ? 4 : 3), 1, is);
	c = (bgra[3] ? RGB(bgra[2], bgra[1], bgra[0]) : RGB(0, 0, 0));
	*(sl++) = c;
	x++;
      } else {
	fread(&ctrl, sizeof(ctrl), 1, is);
	// RLE decompression
	if (ctrl&0x80) {
	  fread(&bgra, (th.bpp == 32 ? 4 : 3), 1, is);
	  ctrl &= (~0x80);
	  ctrl++;
	  c = (bgra[3] ? RGB(bgra[2], bgra[1], bgra[0]) : RGB(0, 0, 0));
	  while (ctrl--) {
	    *(sl++) = c;
	    x++;
	  }
	} else {
	  // not compressed?
	  ctrl++;
	  while (ctrl--) {
	    bgra[3] = 1;
	    fread(&bgra, (th.bpp==32 ? 4 : 3), 1, is);
	    c = (bgra[3] ? RGB(bgra[2], bgra[1], bgra[0]) : RGB(0, 0, 0));
	    *(sl++) = c;
	    x++;
	  }
	}
      }
    }
  }
  fclose(is);
}
