#ifndef _Connection_hh_
#define _Connection_hh_

#include "Compat.hh"
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h> 

class Connection {
  protected:
    char * hostname;
    char * client_hostname;
    int our_port;
    int peer_port;
    bool connected;
    bool any_addr;
    bool server;
    int timeout_usec;
    Connection(bool _server);
    int socket_fd;
  public:
    virtual ~Connection();
    virtual void SetHostname(const char * _name);
    void SetPeerPort(const int _port) { peer_port = _port; };
    void SetOurPort(const int _port) { our_port = _port; };
    virtual bool Connect() = 0;
    virtual bool Listen() = 0;
    virtual void Disconnect() = 0;
    virtual bool Send(char * buffer, int bufsize) = 0;
    virtual int SendReceive(char * sendbuffer, int bufsize, char * recvbuffer, int maxsize) = 0;
    virtual int Receive(char * buffer, int maxsize, bool Wait=TRUE) = 0;
    bool IsConnected() { return connected; };
    const char * GetPeerHostname() { return client_hostname; };
    int GetPeerPort() { return peer_port; };
    int GetOurPort() { return our_port; };
    void SetTimeout(int _timeout_usec) { timeout_usec = _timeout_usec; };
    int GetFD() { return socket_fd; };
};

class Multiplexor {
  public:
    static const int MaxFD = 255; // max filedescriptors
  protected:
    int timeout_usec;
    Connection * fd2con[MaxFD];
    fd_set init_fdset;
    fd_set current_fdset;
    int max_fd;
  public:
    Multiplexor();
    void Reset();
    void AddConnection(Connection * c);
    void RemoveConnection(Connection *c);
    Connection * WaitForConnection();
    void ReWaitConnection(Connection *c);
    void SetTimeout(int _timeout_usec) { timeout_usec = _timeout_usec; };
};

#endif
