#include "GGIFrontBuffer.hh"
#include <stdio.h>

#define UseDB 1

#define No2ndBuffer

#ifdef Color8
#define GGI_color_depth GT_8BIT
#endif
#ifdef Color16
#define GGI_color_depth GT_16BIT
#endif
#ifdef Color24
#define GGI_color_depth GT_24BIT
#endif

GGIFrontBuffer::GGIFrontBuffer()
{
  printf("Initializing libGGI\n");
  if (ggiInit())
    ggiPanic("Unable to initialize libGGI\n");
  printf("Opening default visual\n");
  if (!(vis = ggiOpen(0)))
    ggiPanic("Failed to open libGGI visual\n");
  printf("Setting %ix%ix%i graph mode\n", WindowSizeX, WindowSizeY, ColorDepth);
  if (ggiSetGraphMode(vis, WindowSizeX, WindowSizeY, WindowSizeX, WindowSizeY, GGI_color_depth) < 0)
    ggiPanic("Couldn't set graph mode %ix%ix%i\n", WindowSizeX, WindowSizeY, GGI_color_depth);
  ggiSetGCBackground(vis, 0);
  ggiSetFlags(vis, GGIFLAG_ASYNC);
  ggi_directbuffer_t dir_buffer = 0;
  if (UseDB && !ggiDBGetBuffer(vis, &dir_buffer) && dir_buffer && ggiDBGetLayout(dir_buffer) == blPixelLinearBuffer) {
    ggi_pixellinearbuffer * plb = ggiDBGetPLB(dir_buffer);
    if (plb->write && !plb->page_size && plb->access&(ColorDepth/8) && plb->align&(ColorDepth/8)
	&& !plb->swap) {
      printf("Using DirectBuffer\n");
      buffer = ((Pixel_t *) plb->write)+(plb->origin.x+plb->origin.y*plb->stride);
      stride = plb->stride;
      UsingDB = TRUE;
      return;
    }
  }
  printf("Can't use DirectBuffer\n");
#ifdef No2ndBuffer
  buffer = new Pixel_t[WindowSizeX*WindowSizeY];
  if (!buffer)
    ggiPanic("Couldn't allocate memory for framebuffer\n");
  printf("Allocating framebuffer memory (%i bytes)\n", sizeof(Pixel_t)*WindowSizeX*WindowSizeY);
#else
  printf("Opening framebuffer in display-memory\n");
  vis_mem = ggiOpen("display-memory", 0);
  if (!vis_mem)
    ggiPanic("Can't open display-memory visual\n");
  if (ggiSetGraphMode(vis_mem, WindowSizeX, WindowSizeY, WindowSizeX, WindowSizeY, GGI_color_depth))
    ggiPanic("Couldn't set mode in display-memory visual\n");
  buffer = ggiGetFB(vis_mem); //!!!
#endif
  stride = WindowSizeX;
  UsingDB = FALSE;
};

GGIFrontBuffer::~GGIFrontBuffer()
{
  if (!UsingDB) {
#ifdef No2ndBuffer
    delete buffer;
#else
    ggiClose(vis_mem);
#endif
  }
  ggiClose(vis);
  ggiExit();
}

void GGIFrontBuffer::UpdateScreen()
{
  if (!UsingDB) {
    for (DirtyWindow * p = dw; p != last; p++) {
      int X = p->X;
      int Y = p->Y;
      int W = p->W;
      int H = p->H;
#ifdef No2ndBuffer
      for (Pixel_t * buf = buffer+Y*WindowSizeX+X; H; H--, Y++, buf += WindowSizeX)
	ggiPutHLine(vis, X, Y, W, buf);
#else
      ggiCrossBlit(vis_mem, X, Y, W, H, vis, X, Y, W, H);
#endif
    }
  }
  ggiFlush(vis);
}

void GGIFrontBuffer::ShowWindow()
{
};
