#include "TaskSwitch.hh"
#include "WormApp.hh"
#include "Game/Players.hh"
#include "FrontBuffer.hh"
#include "Network/NetConnector.hh"
#include "Network/NetMessage.hh"
#include "Compat.hh"
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include "Debug.hh"
#include <stdio.h> // for sprintf
#include "FontCreator.hh"
#include "Network/NetworkTimings.hh"

#define DEBGT(x)
//#define DEBGT(x) x

const int update_time = 100;
const int min_waittime = usec2sec/100*2;

TaskSwitch::TaskSwitch(WormApp * _app, Players * _players,
		       FrontBuffer * _frontb, NetConnector * _network)
    : app(_app), players(_players), frontb(_frontb),
  network(_network), FPS(init_FPS), frametime(usec2sec/FPS)
{
  app->Initialize();
  players->NewGame();
}

TaskSwitch::~TaskSwitch()
{
}

void TaskSwitch::UpdateFPS(int wait)
{
  int oldFPS = FPS;
  if (wait > 0) {
    if (FPS < app->currentMaxFPS) {
      if (network->NetworkGame()) {
	nmSetGameFPS faster(FPS+1);
	network->SendMsg(&faster);
      } else
	FPS++;
    } else {
      if (FPS > app->currentMaxFPS) {
	if (network->NetworkGame()) {
	  nmSetGameFPS slower(FPS-1);
	  network->SendMsg(&slower);
	} else
	  FPS--;
      }
    }
/*    if (network->NetworkGame()) {
      if (wait > min_waittime)
	microsleep(wait-min_waittime);
    } else */
      microsleep(wait);
  } else
    if (FPS > min_FPS) {
      if (network->NetworkGame()) {
	nmSetGameFPS slower(FPS-1);
	network->SendMsg(&slower);
      } else
	FPS--;
    }
  nmSetGameFPS * f = (nmSetGameFPS *) network->GetMsg(mtSetGameFPS);
  if (f) {
    FPS = f->wantFPS;
    delete f;
  }
  if (FPS != oldFPS) {
    app->currentFPS = FPS;
    if (app->ShowFPS)
      app->PaintFPS();
    frametime = usec2sec/FPS;
    network->connection->SetTimeout(frametime);
  }
}

void TaskSwitch::Run()
{
  players->NewRound(); // show background
  frontb->ShowWindow();
  frontb->Show();
  timeval start;
  gettimeofday(&start, 0);
  DEBGT(timeval a); DEBGT(timeval  b); DEBGT(timeval c);
  DEBGT(timeval d); DEBGT(timeval e); DEBGT(timeval f);
  DEBGT(timeval g);
  while (!app->WantQuit) {
    DEBGT(gettimeofday(&a, 0));
    app->UpdateGame1();
    DEBGT(gettimeofday(&b, 0));
    while (!network->SendMessages()) {
      frontb->Show();
      for(int i=0; i<update_time; i++)
	if (!app->Run())
	  break;
    }
    DEBGT(gettimeofday(&c, 0));
    frontb->Show(); // update local players
    DEBGT(gettimeofday(&d, 0));
    for (int i=TaskSwitchTimeout/frametime; i>0; i--) {
      frontb->Show();
      for(int j=update_time; j>0; j--)
	if (!app->Run())
	  break;	
      if (network->ReceiveMessages(TRUE))
	break;
      if (i == 1) // last loop... disconnect server!
	app->Disconnect();
    }
    DEBGT(gettimeofday(&e, 0));
    app->UpdateGame2();
    DEBGT(gettimeofday(&f, 0));
    frontb->Show();
    timeval end1;
    gettimeofday(&end1, 0);
    int delta;
    if (end1.tv_usec < start.tv_usec)
      delta = usec2sec - start.tv_usec + end1.tv_usec;
    else
      delta = end1.tv_usec - start.tv_usec;
    int wait = frametime - delta;
    UpdateFPS(wait);
    network->DeleteMessages();
    DEBGT(gettimeofday(&g, 0));
//    DEBUGP(start.tv_usec << "-" << end1.tv_usec << "  " << wait << " " << FPS);
    DEBGT(PrintErr << b.tv_usec-a.tv_usec << " " << c.tv_usec-b.tv_usec << " " \
       << d.tv_usec-c.tv_usec << " " << e.tv_usec-d.tv_usec << " " \
	 << f.tv_usec-e.tv_usec << " " << g.tv_usec-f.tv_usec << " " << FPS << nl);
    gettimeofday(&start, 0);
  }
}

  
