#ifndef _PlayerSelectorItem_hh_
#define _PlayerSelectorItem_hh_

#include "XVision/Group.hh"
#include "PlayerTypeView.hh"
#include "PlayerControlView.hh"
#include "FillerSelector.hh"
#include "Game/Worm.hh"

const CommandType cmSlotCaptured = 3200;

class PlayerSelectorItem : public Group {
  protected:
    Pixel_t savecolor;
    void TypeChanged();
    void SendChanged();
  public:
    PlayerTypeView * type;
    Label * name;
    PlayerControlView * control;
    FillerSelector * filler;
    PlayerSelectorItem();
    bool HandleEvent(Event& event);
    void Change(PlayerType_t _type, FillerType_t _filler,
		int _filler_opt1, int _filler_opt2, const char * _name);
    void GetPlayer(PlayerType_t& _type, FillerType_t& _filler,
		int& _filler_opt1, int& _filler_opt2, const char ** _name);
};

#endif
