#include <iostream.h>
#include <string.h>

struct TargaHeader {
  unsigned char id;
  unsigned char color_map;
  unsigned char im_type;
  char gap[9];
  unsigned short W;
  unsigned short H;
  unsigned char bpp;
  unsigned char im_des;
} ;

int main(int argc, char ** argv) {
  
  filebuf fb;
  istream is(fb.open(argv[1], "rb"));
  
  char h1, h2;
  is >> h1 >> h2;
  if ((h1 != 'P') || (h2 != '6')) {
    cerr << "not pnm or unsupported file (" << h1 << h2 <<  ")\n";
    exit(1);
  }
  
  TargaHeader th;
  th.id = 0;
  th.color_map = 0;
  th.im_type = 2; // not compressed
  bzero(th.gap, sizeof(th.gap));
//  th.W = ;
//  th.H = ;
  th.bpp = 24;
  th.im_des = 32; // ???
  
  is >> th.W >> th.H;
  int maxcolor;
  is >> maxcolor;
  cerr << "size is " << th.W << "x" << th.H << ", max color is " << maxcolor << "\n";
  
  filebuf fb2;
  ostream os(fb2.open(argv[2], "w+"));

  char d;
  is.read(&d, sizeof(d));
  int depth = th.bpp/8;
  
  int size = th.W*th.H;
  char * buffer = new char[size*depth];
  is.read(buffer, size*depth);
  
  typedef unsigned char uc;
  struct _bgr { uc b; uc g; uc r; } bgr;
  struct _rgb { uc r; uc g; uc b; } rgb;
  
  for (int i=0; i<size; i++) {
    bgr = *((_bgr *)(buffer+i*depth));
    // *topnm creates FF00FF instead of 000000???
    if ((bgr.r == 0xff) && (bgr.g == 0) && (bgr.b == 0xff)) {
      rgb.r = 0;
      rgb.g = 0;
      rgb.b = 0;
    } else {
      rgb.r = bgr.r;
      rgb.g = bgr.g;
      rgb.b = bgr.b;
    }
    *((_rgb *)(buffer+i*depth)) = rgb;
  };
  os.write(&th, sizeof(th));
  os.write(buffer, size*depth);
}
