#ifndef _Group_hh_
#define _Group_hh_

#include "View.hh"

class Group : public View {
  protected:
    friend class View;
    View * first, * last, * current;
  public:
    Align ChildAlign;
    Group(const Align _align=VAVertical);
    ~Group();
    void Insert(View * view);
    void Delete(View * view);
    void Replace(View * old, View * newv);
    void Draw();
    void ReArrange(bool CallParent=TRUE, View * except=0);
    void Show();
    void Hide();
    void Select();
    void Deselect();
    bool SelectNext(bool Forward);
    bool HandleEvent(Event& event);
    void PutEvent(Event& event);
    void SetHidden(bool _hidden, bool rearrange=TRUE);
    void DrawPartBG(View * child);
    View * GetCurrent() { return current; };
};

class _creategroupclass; // defined in Group.cc

Group * CreateGroup(Group * root, _creategroupclass * item);
_creategroupclass * CreateItem(View * item, _creategroupclass * next);

#endif
