#include "GameServer.hh"
#include "Network/NetworkTimings.hh"
#include "Utils.hh"
#include <stdlib.h>
#include <unistd.h>

#define prg_name "Wormz-server"
#define option_s argv[1]
#define port_s argv[2]

void Help()
{
  PrintErr << "Usage: " << prg_name << " [-p PORT]" << nl;
  PrintErr << "PORT is udp port, on which server waits for incoming connections from clients" << nl;
  PrintErr << "if -p options is not set, server will use default port " << ServerDefaultPort << nl;
  exit(1);
}

int main(int argc, char ** argv)
{
  PrintErr << "Wormz network game server" << nl;
  int port;
  if (argc == 1)
    port = ServerDefaultPort;
  else {
    if (argc != 3)
      Help();
    if (strcmp(option_s, "-p"))
      Help();
    char * endptr;
    if (!strlen(port_s))
      Help();
    port = strtol(port_s, &endptr, 10);
    if (*endptr)
      Help();
  }
  GameServer * gs = new GameServer(port);
  gs->Run();
  delete gs;
}
