#include "T1FontCreator.hh"
#include "Utils.hh"
#include "PathConfig.hh"
#include "GraphConfig.hh"
#include <string.h>
#include <t1lib.h>
#include <unistd.h>

#ifdef USE_GGI

T1FontCreator::T1FontCreator()
{
//   T1_SetLogLevel(T1LOG_DEBUG);
//   chdir("/"); // T1lib doesn't like absolute paths!
   if (T1_InitLib(NO_LOGFILE | IGNORE_FONTDATABASE | IGNORE_CONFIGFILE) == NULL) {
      printf("T1FontCreator: T1_InitLib error\n");
      exit(1);
   }
   fontid_reg = T1_AddFont(LibInstallPath "bchr.pfb");
   if (fontid_reg<0) {
      printf("T1FontCreator: T1_AddFont can't load regular font (bchr.pfb)\n");
      exit(1);
   }
   fontid_ob = T1_AddFont(LibInstallPath "bchri.pfb");
   if (fontid_ob<0) {
      printf("T1FontCreator: T1_AddFont can't load oblique font (bchri.pfb)\n");
      exit(1);
   }
   T1_AASetBitsPerPixel(ColorDepth);
}

T1FontCreator::~T1FontCreator()
{
   T1_CloseLib();
}

Pixel_t * T1FontCreator::CreateNorthFontImage(const char * text, Pixel_t color,
					   FontShape fontshape, int& W, int& H)
{
   return 0;
}

Pixel_t * T1FontCreator::CreateFontImage(const char * text, Pixel_t color,
				       TextDirection direction, FontShape fontshape, int& W, int& H)
{
#undef T1_Antialias
#ifdef T1_Antialias
   Pixel_t color1 = color;
   color1.AlphaBlend(Pixel_t_Black);
   Pixel_t color2 = color1;
   color2.AlphaBlend(Pixel_t_Black);
   Pixel_t color3 = color2;
   color3.AlphaBlend(Pixel_t_Black);
   T1_AASetGrayValues(Pixel_t_Zero.Data(),
		      color3.Data(),
		      color2.Data(),
		      color1.Data(),
		      color.Data());
#endif
   int dir;
   switch (direction) {
    case tdNorth:
      dir = 0; break;
    case tdSouth:
      dir = 180; break;
    case tdEast:
      dir = 90; break;
    default: //case tdWest:
      dir = 270;
   }
   int fontid, fsize;
   switch (fontshape) {
    case fsRegular:
      fontid = fontid_reg; fsize = 50;
    case fsOblique:
      fontid = fontid_ob; fsize = 50;
    case fsSmallRegular:
      fontid = fontid_reg; fsize = 24;
    default: //case fsSmallOblique:
      fontid = fontid_ob; fsize = 24;
   }
#ifdef T1_Antialias
   GLYPH * glyph = T1_AASetString(fontid, (char *) text, 0, 0, 0, fsize, dir);
#else
   GLYPH * glyph = T1_SetString(fontid, (char *) text, 0, 0, 0, fsize, dir);
#endif
   if (glyph) {
      int h = glyph->metrics.ascent + glyph->metrics.descent;
      int w = glyph->metrics.rightSideBearing - glyph->metrics.leftSideBearing;
      char * buf = glyph->bits;
      H = h;
      W = w;
      Pixel_t * buf2 = new Pixel_t[w*h];      
#ifdef T1_Antialias      
      memcpy(buf2, buf, w*h*(ColorDepth/8));
#else
      // in buf is bitmap
      Pixel_t * b2 = buf2;
      int b = 0;
      for(int y=0; y<h; y++) {
	 for(int x=0; x<w; x++) {
	    if (!(x%8))
	      b = *buf++;
	    if (b & (1 << (x % 8))) /* pixel */
	      *b2++ = color;
	    else /* no pixel */
	      *b2++ = Pixel_t_Zero;
	 }
      }
#endif
      return buf2;
   } else {
      W = 1;
      H = fsize;
      Pixel_t * buf2 = new Pixel_t[H];
      memset(buf2, 0, sizeof(Pixel_t)*H);
      return buf2;
   }
}

#endif
