#include "Utils.hh"
//#include <iostream.h>
#include <stdlib.h>

extern MyErrStream PrintErr;

bool Rectangle::Inside(const Point& p) const
{
  return (Origin.X <= p.X) && (p.X <= Origin.X+Size.X) &&
	  (Origin.Y <= p.Y) && (p.Y <= Origin.Y+Size.Y);
}
  
bool Rectangle::Intersect(const Rectangle& second) const
{
  return (Inside(second.Origin) ||
	  Inside(Point(second.Origin.X, second.Bottom())) ||
	  Inside(Point(second.Right(), second.Origin.Y)) ||
	  Inside(Point(second.Right(), second.Bottom())));
}

void Die(const char * text)
{
  Error(text);
  exit(1);
}

void Error(const char * text)
{
  PrintErr << "error: " << text << nl;
}

void Print(const char * text)
{
  PrintErr << text << nl;
}

void StdError(const char * text)
{
  PrintErr << "error: ";
  perror(text);
}

int Rand(int Max)
{
//  int a = int(double(Max)*double(rand())/(RAND_MAX+1.0));
   int a  = rand() % Max;
//  PrintErr << a; 
  return a;
}


