#include "PlayerSelectorItem.hh"
#include "FillerSelector.hh"
#include "PlayerControlView.hh"
#include "PlayerTypeView.hh"
#include "PlayerSelectorItem.hh"
#include "Game/Worm.hh"
#include "Network/NetMessage.hh"

PlayerSelectorItem::PlayerSelectorItem()
    : Group(VAHorizontal),
  type(new PlayerTypeView),
  name(new InputLine(" ", nmPlayerSetup::NameSize)),
  control(new PlayerControlView)
{
  AutoResize = TRUE;
  Insert(type);
  Insert(new Padding(VAHorizontal));  
  filler = new FillerSelector;
  filler->SetEnabled(FALSE);
  Insert(filler);  
  Insert(new Padding(VAHorizontal));
  name->SetEnabled(FALSE);
  savecolor = name->GetColor(ciDisabledFG);
  Insert(name);
  Insert(new Padding(VAHorizontal));
  control->SetEnabled(FALSE);
  Insert(control);
  SetColor(RGB(0, 0x70, 0), ciHighlightedBG);
}

bool PlayerSelectorItem::HandleEvent(Event& event)
{
  if (!Group::HandleEvent(event))
    return FALSE;
  if ((event.type == evnCommand) && (event.command == cmDataChanged)
      && (event.creator == type) && (event.to == this)) {
    TypeChanged();
    return FALSE;
  }
  if ((event.type == evnCommand) && (event.command == cmDataChanged)
      && (event.to == this) &&
      ((event.creator == name) || (event.creator == filler))) {
    PlayerType_t t = PlayerType_t(type->GetItem());
    if ((t != ptNone) && (t != ptNetwork))
      SendChanged();
    return FALSE;
  }  
  return TRUE;
}

void PlayerSelectorItem::TypeChanged()
{
  PlayerType_t pltype = PlayerType_t(type->GetItem());
  bool E = ((pltype == ptAI) || (pltype == ptHuman));
  if (int(pltype) == int(ptNone)+1) // EEK!
    filler->SetRandomFiller();
  if (pltype == ptNone) {
    filler->SetNumFiller(ftFlat);
    filler->GetFiller()->SetFirstOption(0);
  }    
  if (pltype != ptNetwork)
    // send to other players message about capture of this slot
    SendChanged();
  filler->SetEnabled(E);
  name->SetEnabled(E);
  control->SetEnabled(pltype == ptHuman);
  name->SetColor(
		 (pltype == ptNone) ? savecolor : name->GetColor(ciForeground),
		 ciDisabledFG);
  if (pltype != ptHuman)
    control->SetKeys(ktInvalid, ktInvalid, TRUE);
}

void PlayerSelectorItem::Change(PlayerType_t _type, FillerType_t _filler,
	    int _filler_opt1, int _filler_opt2, const char * _name)
{
  bool c = !(type->GetItem() == int(_type));
  type->SetItem(_type);
  if (c)
    TypeChanged(); // needed?
  if (_type != ptNone) {
    filler->SetNumFiller(_filler);
    filler->GetFiller()->SetFirstOption(_filler_opt1);
    filler->GetFiller()->SetSecondOption(_filler_opt2);
  } else {
    filler->SetNumFiller(ftFlat);
    filler->GetFiller()->SetFirstOption(0);
  }
  filler->Redraw();
  name->SetText(_name);
}

void PlayerSelectorItem::GetPlayer(PlayerType_t& _type, FillerType_t& _filler,
				   int& _filler_opt1, int& _filler_opt2, const char ** _name)
{
  _type = PlayerType_t(type->GetItem());
  Filler * f = filler->GetFiller();
  _filler = f->GetType();
  _filler_opt1 = f->GetFirstOption();
  _filler_opt2 = f->GetSecondOption();
  *_name = name->GetText();
}

void PlayerSelectorItem::SendChanged()
{
  Event e(this);
  e.type = evnCommand;
  e.command = cmSlotCaptured;
  e.to = parent;
  parent->HandleEvent(e);
}
