#include "MainGlobal.hh"
#include "PathConfig.hh"
#include "PaintInterface/TargaPicture.hh"

#define IMGDIR LibInstallPath

static TargaPicture tptNone(IMGDIR "None.tga");
static TargaPicture tptAI(IMGDIR "CPUChip.tga");
static TargaPicture tptHuman(IMGDIR "Human.tga");
static TargaPicture tptNetwork(IMGDIR "Network.tga");

Picture * global_TypePictures[PlayerType_t_count] = {
  &tptNone, &tptAI, &tptHuman, &tptNetwork };

static TargaPicture gpfGrass(IMGDIR "grass.tga");
static TargaPicture gpfParquet(IMGDIR "parquet.tga");
static TargaPicture gpfPlasma3(IMGDIR "plasma3-mosaic.tga");
static TargaPicture gpfPlasma(IMGDIR "plasma.tga");
static TargaPicture gpfPlasmaCub(IMGDIR "plasma2-cubism.tga");
static TargaPicture gpfPlasmaMos(IMGDIR "plasma2-mosaic.tga");
static TargaPicture gpfPlasma2(IMGDIR "plasma2.tga");
static TargaPicture gpfDarkWood(IMGDIR "darkwood.tga");
static TargaPicture gpfLinux(IMGDIR "linux.tga");
static TargaPicture gpfBlueWood(IMGDIR "blue-wood.tga");

const int global_PictureFillers_count = 10;

Picture * global_PictureFillers[global_PictureFillers_count] = {
  &gpfGrass, &gpfParquet, &gpfPlasma3, &gpfPlasma,
  &gpfPlasmaCub, &gpfPlasmaMos, &gpfPlasma2, &gpfDarkWood,
  &gpfLinux, &gpfBlueWood };

static TargaPicture gpfChecker(IMGDIR "checker.tga");
Picture * global_Background = &gpfChecker;

static TargaPicture galArrowLeft(IMGDIR "ArrowL.tga");
Picture * global_ArrowLeft = &galArrowLeft;

static TargaPicture galArrowRight(IMGDIR "ArrowR.tga");
Picture * global_ArrowRight = &galArrowRight;

Picture * global_Wall = &gpfBlueWood;
