#include "FillerSelector.hh"
#include "Fillers.hh"
#include "MainGlobal.hh"
#include "XVision/Application.hh"
#include "Utils.hh"

FillerSelector::FillerSelector()
    : actual(0), actualtype(FillerType_t(-12343728))
{
  AutoResize = TRUE;
  Selectable = TRUE;
  SetRandomFiller();
}

FillerSelector::~FillerSelector()
{
  delete actual;
}

const int fillerselector_shift = 2;
const int fillerselector_maxsizey = 20;
const int fillerselector_maxsizex = 20;

void FillerSelector::Draw()
{
  if (app_global->fb) {
    int X = GetX() + fillerselector_shift;
    int Y = GetY() + fillerselector_shift;
    int W = Min(actual->ImageWidth, fillerselector_maxsizex);
    int H = Min(actual->ImageHS + actual->ImageSize, fillerselector_maxsizey);
    app_global->fb->PutMaskImage_sd(X, Y, W, H,
				    actual->GetImage(0, 0), actual->ImageWidth);
  }
}

void FillerSelector::SetFiller(Filler * _filler)
{
  Filler * f = _filler->CreateCopy();
  delete actual;
  actual = f;
  actualtype = f->type;
  MinSize. X = fillerselector_maxsizex  + 2*fillerselector_shift;
  MinSize.Y = fillerselector_maxsizey + 2*fillerselector_shift;
  SetSize(MinSize);
  if (parent)
    parent->DrawPartBG(this);
  Redraw();
}

void FillerSelector::SetRandomFiller()
{
  SetNumFiller(FillerType_t(Rand(FillerType_t_count)));
}

bool FillerSelector::HandleEvent(Event& event)
{
  if ((!Visible) || Hidden)
    return SelectableView::HandleEvent(event);
  if (Selected) {
    if ((event.type == evMouseclick) &&
	((event.key == (ktMouseButtonStart + 2)) || (event.key == (ktMouseButtonStart + 3)))) {
      Point p = RelativePoint(event.mousepos);
      if (Area.Inside(p)) {
	if (event.key == (ktMouseButtonStart + 2))
	  actual->CircleFirstOption();
	else
	  actual->CircleSecondOption();
	Redraw();
	SendDataChanged();
	return FALSE;
      }
    }
    if ((event.type == evKeypress) &&
	((event.key == ktLeft) || (event.key == ktRight))) {
      if (event.key == ktLeft)
	actual->CircleFirstOption();
      else
	actual->CircleSecondOption();
      Redraw();
      SendDataChanged();
      return FALSE;
    }
  }
  return SelectableView::HandleEvent(event);
}

void FillerSelector::Choose()
{
  SetNumFiller(FillerType_t(int(actualtype)+1));
}

void FillerSelector::SetNumFiller(FillerType_t _actualtype)
{
  if (_actualtype < 0)
    _actualtype = FillerType_t(FillerType_t_count-1);
  else
    if (_actualtype >= FillerType_t_count)
      _actualtype = FillerType_t(0);
  if (actualtype == _actualtype)
    return;
  actualtype = _actualtype;
  Filler * f = CreateNumFiller(actualtype);
  SetFiller(f);
  int r = Rand(100);
  actual->SetFirstOption(r);
  r = Rand(100);
  actual->SetSecondOption(r);  
  delete f;
  Redraw();
  SendDataChanged();
}

Filler * FillerSelector::CreateNumFiller(FillerType_t type)
{
  switch (type) {
  case ftFlat:
    return new FlatFiller;
  case ftCircle:
    return new CircleFiller;
  case ftChecker:
    return new CheckerFiller;
  default: //case ftPicture:
    return new PictureFiller(global_PictureFillers_count, global_PictureFillers);
  }
}

