#######################################################################
#
# Basic compilation rules. Should not need to be changed 8-).
#
#######################################################################
# Make sure debug/release flags are set correctly.
debug: release: error( Can't be both in debug and release mode )

debug {
    message(----------- DEBUG compilation ----------------)
    DEFINES *= DEBUG 
    # Add all the Qt's check flags. This the default, but add them in any case.
    DEFINES *= QT_DEBUG QT_FATAL_ASSERT
    TARGET = $$TARGET-debug
    
    win32 {
        OBJECTS_DIR = Debug/Obj/
    } else {
        OBJECTS_DIR = .debug.obj/
    }
}

release {
    message(+++++++++++ RELEASE compilation ++++++++++++++)
    # Remove all Qt's checking code, and all Q_ASSERT().
    # *BUT* still do Q_CHECK_PTR !
    DEFINES *= QT_NO_DEBUG QT_NO_CHECK QT_CHECK_NULL

    win32 {
        OBJECTS_DIR = Release/Obj/
    } else {
        OBJECTS_DIR = .release.obj/
    }
}

win32 {
    MOC_DIR = Generated/
} else {
    MOC_DIR = .generated/
}
UI_DIR  = $${MOC_DIR}

#######################################################################
#
# Specific compiler rules. Might need to be twicked to achieve what
# you really need...
#
#######################################################################

win32: DEFINES -= UNICODE
win32: DEFINES *= WIN32=1

win32-msvc {
    message( Compile using MSVC6 )
    # Make sur to have C++ files, PentiumPro code, few warnings
    # add support to RTTI and Exceptions,
    # and generate debug info "program database" :
    QMAKE_CXXFLAGS = -TP -G6 -W1 -GR -GX -EHsc -Zi -Fo$$OBJECTS_DIR -FR$$OBJECTS_DIR -Fd$$OBJECTS_DIR
    # Optimise for speed, and expand any suitable inlines :
    QMAKE_CXXFLAGS_RELEASE = -Ot -Ox
    # Optimise for debug :
    QMAKE_CXXFLAGS_DEBUG   = -Od
}

win32-msvc.net* {
    message( Compile using .NET )
    # Make sur to have C++ files, PentiumPro code, few warnings
    # add support to RTTI, use exceptions, use ANSI C++ for scope,
    # and generate debug info "program database", and compile using intrisic functions
    QMAKE_CXXFLAGS = -TP -G6 -G7 -GR -EHsc -Zc:forScope -Zi -Oi
    QMAKE_CXXFLAGS += -MT -Fd$$OBJECTS_DIR
    
    # Full Optimise, Global optimize, Optimise for speed, 
    # omit frame pointer, and expand any suitable inlines :
    QMAKE_CXXFLAGS_RELEASE  = -Ox -Og -Ot -Oy -Ob2
    
    # Optimise for debug, and generate navigation file
    QMAKE_CXXFLAGS_DEBUG    = -Od -Fr
    
    
    # Bugs in Qt's .h and mkspecs/qmake.conf :
    # warning 4251 : ncessite une interface DLL pour tre utilis(e)
    #                (issues in QGLViewer)
    # warning 4305 : troncation de 'double'  'float'
    # warning 4189 : variable locale initialise mais non rfrence
    QMAKE_CXXFLAGS_WARN_ON = -W3 -wd4100 -wd4251 -wd4305 -wd4189
    
    # Links flags :
    # Add checksum, and machine code X86.
    QMAKE_LFLAGS += -machine:x86
    release {
        QMAKE_LFLAGS *= /RELEASE
        QMAKE_LFLAGS -= /DEBUG
    }
    
    # Note: Changing output directory (-Fo) is incompatible with Installer of MSVC.NET
}

win32-borland {
    message( Compile using Borland C++ compiler )
    DEFINES *= BORLAND=1
    # Force C++, Pentium Pro code, with RTTI
    QMAKE_CXXFLAGS -= -RT
    QMAKE_CXXFLAGS *= -P -6
    QMAKE_CXXFLAGS_DEBUG *= -v
    # Shutup warnings:
    CONFIG *= warn_off
}

win32-icc {
	message( Compile using Intel C++ Compiler ICC )
	DEFINES *= WIN32_ICC=1
	QMAKE_CFLAGS = -nologo -Zm200 -W3 -MD -Od -Ob1 -arch:SSE2 -Qms2 -GA -EHsc -Zc:forScope -Qunroll500 -fast -Qprec -Qip -Qipo -Qparallel -Qopenmp -Ot -Oy -QaxKNBP -G7 -GX -GX -GR
	QMAKE_CXXFLAGS *= $$QMAKE_CFLAGS

	QMAKE_LFLAGS = /libpath:"C:/Intel/CPP/Compiler80/Ia32/Lib" \
	/libpath:"C:/Program Files/Fichiers communs/Intel/Shared Files/Ia32/Lib" \
	/libpath:"C:\Program Files\Microsoft Visual Studio .NET\Vc7\lib" \
	/libpath:"C:\Program Files\Microsoft Visual Studio .NET\Vc7\ATLMFC\LIB" \
	/libpath:"C:\Program Files\Microsoft Visual Studio .NET\Vc7\PlatformSDK\lib\prerelease" \
	/libpath:"C:\Program Files\Microsoft Visual Studio .NET\Vc7\PlatformSDK\lib" \
	/libpath:"C:\Program Files\Microsoft Visual Studio .NET\FrameworkSDK\lib" \
	-nologo /DELAYLOAD:zlib.dll -nologo -Od -Ob1 -arch:SSE2 -Qms2 -GA -EHsc -Zc:forScope -Qunroll500 -fast -Qprec -Qip -Qipo -Qparallel -Qopenmp -Ot -Oy -QaxKNBP -G7
}

# Common part for all G++ compilers :
*-g++* {
    # Get more warnings on all G++ compilers.
    QMAKE_CXXFLAGS_WARN_ON *= -Wall -W -Woverloaded-virtual -Wimplicit

    # Keep some optimisations while in debug mode.
    QMAKE_CXXFLAGS_DEBUG = -O1 -fno-omit-frame-pointer -g
    QMAKE_LFLAGS_DEBUG += -g

    # Use most agressive AND standard 'optimizing for speed' option.
    QMAKE_CXXFLAGS_RELEASE = -O3
}

linux-g++* {
    message( Compile using Linux platform specifics )
    DEFINES *= LINUX=1
    CONFIG *= linux

    # On usual linux Qt distribution, only the thread-safe version of the 
    # lib is compiled and installed...
    CONFIG *= thread
}

irix-cc {
    message( Compile using Irix platform specifics )
    DEFINES *= SGI=1
    CONFIG *= sgi
    QMAKE_CXXFLAGS += -LANG:std -woff 1460,3284,1061
    QMAKE_CXXFLAGS_RELEASE = -Ofast=IP35 -IPA:alias=ON -IPA:addressing=ON \
                -IPA:aggr_cp
                rop=ON -OPT:Olimit=0 -OPT:reorg_common=ON \
                -OPT:rsqrt=ON -OPT:swp=ON -OPT:unroll_size=40000 \
                -OPT:unroll_times_max=720 -LNO:auto_dist=ON -pca -apo
    QMAKE_LFLAGS += -LANG:std
    release: QMAKE_LFLAGS += $$QMAKE_CXXFLAGS_RELEASE

    # MIPS is BigEndian
    DEFINES += WORDS_BIGENDIAN=1
}

macx {
    # ALSO the g++ compiler !
    DEFINES *= MACX=1

    # Adapt to PowerPC architectures :
    !G5: !G4: !G3: CONFIG += G5
    G5: ARCH_PPC = -mtune=G5 -mpowerpc64 -mpowerpc-gpopt
    G4: ARCH_PPC = -mtune=G4 -mpowerpc   -mpowerpc-gpopt -force_cpusubtype_ALL
    G3: ARCH_PPC = -mtune=G3 -mpowerpc   -mpowerpc-gpopt -force_cpusubtype_ALL
    QMAKE_CXXFLAGS_PPC += $$ARCH_PPC
    QMAKE_CFLAGS_PPC   += $$ARCH_PPC

    # And to x86 arch too !
    ARCH_X86 = -mtune=pentiumpro -msse2 -mfpmath=sse
    QMAKE_CXXFLAGS_X86 += $$ARCH_X86
    QMAKE_CFLAGS_X86   += $$ARCH_X86

    QMAKE_CXXFLAGS_RELEASE = -g -O3 -ffast-math -funroll-loops -finline -fobey-inline
    QMAKE_CFLAGS_RELEASE   = -g -O3 -ffast-math -funroll-loops -finline -fobey-inline
    QMAKE_CXXFLAGS_DEBUG   = -g -O1 -fno-inline
    QMAKE_CFLAGS_DEBUG     = -g -O1 -fno-inline
    QMAKE_LFLAGS += -g
    
    # PowerPC is BigEndian
    DEFINES *= WORDS_BIGENDIAN=1
}

# Added HAVE_INT_TYPES and HAVE_UINT_TYPES in tiff.h, to avoid double-typedef 
# of int32/uint32 etc. errors on some systems.
#
aix-xlc* {
    DEFINES *= HAVE_INT_TYPES=1 HAVE_AIX=1
}

# Common to all unix platforms
unix {
	DEFINES *= UNIX=1
	exists( /usr/include/string.h ): DEFINES *= HAVE_STRING_H=1
	exists( /usr/include/unistd.h ): DEFINES *= HAVE_UNISTD_H=1
}

##############################################################################
# Auto-detect Qt3 or Qt4 support mode...

isEmpty(QTDIR) : QTDIR=$$(QTDIR)
isEmpty(QTDIR) : error( QTDIR not set. Qt environement not installed correctly )

!macx: CORE_INCLUDE = $(QTDIR)/include/QtCore
 macx: CORE_INCLUDE = /Library/Frameworks/QtCore.framework

!qt3: exists( $$CORE_INCLUDE ) : CONFIG *= qt4
qt4 {
    message( Compiling for Qt4 )
    # Strange link error encontered on some windows variants:
    # win32: QMAKE_LFLAGS += /NODEFAULTLIB:LIBCMT
    # win32: QMAKE_LFLAGS += /NODEFAULTLIB:MSVCRTD
} else {
    !exists( $$QTDIR/include/qconfig.h ) : error( **** Qt3 (or QTDIR) badly installed )
    message( Compiling for Qt3 )
     CONFIG *= qt3
}

# If you have several versions of Qt installed, make sure the QTDIR's one
# is the one used by the Makefile !
unix {
    QMAKE_UIC=$$QTDIR/bin/uic
    QMAKE_MOC=$$QTDIR/bin/moc
}
