////////////////////////////////////////////////////////////////////////
/*! 
 *  \file   demo.cpp
 *  \brief  TiffIO plugin test application.
 *  \author JD Gascuel
 * 
 * Copyright JD Gascuel, 2005.
 * 
 * Jean-Dominique.Gascuel@imag.fr
 *
 * This software is a computer program whose purpose is to add TIFF image
 * read/write capabilities to the Qt library, hence to any Qt application.
 * 
 * This software is governed by the CeCILL  license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 * 
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 * 
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 * TiffIO is based on the libtiff 3.7.1, with the following copyright :
 *      Copyright (c) 1988-1997 Sam Leffler
 *      Copyright (c) 1991-1997 Silicon Graphics, Inc.
 * See the libtiff-3.7.1/ subdirectory.
 */
////////////////////////////////////////////////////////////////////////
// File History:
//
// $Id: demo.cpp,v 1.4 2006/01/12 18:57:07 gascuel Exp $
//
// 2006-01-12 : Creation.

#include <qapplication.h>
#include <qmessagebox.h>

#if QT_VERSION < 0x040000
#   include "TiffIODemo.h"
#else
#   include "TiffIODemo4.h"
#define mainWidget activeWindow
#define setMainWidget setActiveWindow
#endif

////////////////////////////////////////////////////////////////////////

static void
demoMsgHandler(QtMsgType type, const char *msg)
{
	// fprintf(stdout, "Trapped message = '%s'\n", msg);
    switch( type ) {
#if QT_VERSION >= 0x040000
        case QtSystemMsg: // aka. QtCriticalMsg
            QMessageBox::critical(qApp->mainWidget(), 
                "System error...", msg, 
                QMessageBox::Ignore, QMessageBox::NoButton);
            break;
#endif
        case QtFatalMsg:
            QMessageBox::critical(qApp->mainWidget(), 
                "Fatal error...", msg, 
                QMessageBox::Ignore, QMessageBox::NoButton);
            break;
        case QtWarningMsg:
            QMessageBox::warning(qApp->mainWidget(), 
                "Warning...", msg, 
                QMessageBox::Ignore, QMessageBox::NoButton);
            break;
        case QtDebugMsg:
            QMessageBox::information(qApp->mainWidget(), 
                "Info...", msg, 
                QMessageBox::Ignore, QMessageBox::NoButton);
            break;
    }
}

//////////////////////////////////////////////////////////////////////////////
// Make sure handler is loaded.
//
// On Qt4 : we have a way to ask for the plugin.
// For Qt3, this is done by hand inside TiffIO_Qt3.cpp.

#ifdef QT_STATICPLUGIN
Q_IMPORT_PLUGIN(TIFFIOPlugin)
#endif

//////////////////////////////////////////////////////////////////////////////
//

int main(int argc, char *argv[])
{
    QApplication app(argc, argv, true);
    qInstallMsgHandler(demoMsgHandler);

    TiffIODemo* main = new TiffIODemo(0, "tiffIODemo");
    app.setMainWidget(main);
    main->show();
    return app.exec();
}
