////////////////////////////////////////////////////////////////////////
/*! 
 *  \file   TiffIO_Qt3.cpp
 *  \brief  Plugin to enable TIFF I/O in Qt 3.x and 4.x.
 *  \author JD Gascuel
 * 
 * Copyright JD Gascuel, 2005.
 * 
 * Jean-Dominique.Gascuel@imag.fr
 *
 * This software is a computer program whose purpose is to add TIFF image
 * read/write capabilities to the Qt library, hence to any Qt application.
 * 
 * This software is governed by the CeCILL  license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 * 
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 * 
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 * TiffIO is based on the libtiff 3.7.2, with the following copyright :
 *      Copyright (c) 1988-1997 Sam Leffler
 *      Copyright (c) 1991-1997 Silicon Graphics, Inc.
 * See the libtiff-3.7.2/ subdirectory.
 */
////////////////////////////////////////////////////////////////////////
// File History:
//
// $Id: TiffIO_Qt3.cpp,v 1.4 2006/01/12 15:05:15 gascuel Exp $
//
// 2005-09-24 : Creation for Qt 4.0 port.

#include <qglobal.h>
#if QT_VERSION >= 0x040000
#error This file should compile only with Qt 3.x or lower. There is an error in the .pri/qmake processing.
#endif

#include <qregexp.h>
#include <qstringlist.h>
#include <qimage.h>
#include <qimageformatplugin.h>

extern void commonReadTIFF (QImageIO* handler, QImage& img, int& status);
extern void commonWriteTIFF(QImageIO* handler, const QImage& img, int& status);

////////////////////////////////////////////////////////////////////////

class TIFFIOPlugin : public QImageFormatPlugin
{
public:
    virtual QStringList keys() const
    {
        QStringList list;
            list += "tiff";
        return  list;
    }

    virtual bool installIOHandler(const QString& format)
    {
        if( format=="tiff" )
        {
            // Beware in QRegExp: null chars are \x01 to avoid terminating
            //        the string.
            QImageIO::defineIOHandler("TIFF",
                    "^"                         // Start at header begining!
                    "(MM\\x01[\\x2a\\x2b])"     // TIFF, or Big TIFF, in
                    "|(II[\\x2a\\x2b]\\x01)"    // Big or little endian modes.
                    "|(DP\\x01[\\x2a\\x2b])"    // MDI_LITTLEENDIAN
                    "|(PD[\\x2a\\x2b]\\x01)"    // MDI_BIGENDIAN
                    ,
                    0,
                    readTIFF,
                    writeTIFF);
            return true;
        }
        else
            return false;
    }

    static void readTIFF(QImageIO* io)
    {
        int status;
        QImage img;
        commonReadTIFF(io, img, status);
        io->setStatus(status);
        if( ! img.isNull() ) io->setImage(img);
    }

    static void writeTIFF(QImageIO* io)
    {
        int status;
        commonWriteTIFF(io, io->image(), status);
        io->setStatus(status);
    }
};

////////////////////////////////////////////////////////////////////////
/*! If Q_STATIC_PLUGIN is defined, then add initialisation-time code
    that mimic plugin load.
    See for instance test.pro to see an exemple of that.
 */
#ifdef Q_STATIC_PLUGIN
struct TIFFIOStaticLoader : public TIFFIOPlugin
{
    TIFFIOStaticLoader()
    {
        // qDebug("Installing Qt3 IO Handler for TIFF QImages");
        installIOHandler("tiff");
    }
};
static TIFFIOStaticLoader tiffIOStaticLoader;
#else
Q_EXPORT_PLUGIN(TIFFIOPlugin);
#endif
