////////////////////////////////////////////////////////////////////////
/*! 
 *  \file   test.cpp
 *  \brief  TiffIO plugin self-test
 *  \author JD Gascuel
 * 
 * Copyright JD Gascuel, 2005.
 * 
 * Jean-Dominique.Gascuel@imag.fr
 *
 * This software is a computer program whose purpose is to add TIFF image
 * read/write capabilities to the Qt library, hence to any Qt application.
 * 
 * This software is governed by the CeCILL  license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 * 
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 * 
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 * TiffIO is based on the libtiff 3.7.1, with the following copyright :
 *      Copyright (c) 1988-1997 Sam Leffler
 *      Copyright (c) 1991-1997 Silicon Graphics, Inc.
 * See the libtiff-3.7.1/ subdirectory.
 */
////////////////////////////////////////////////////////////////////////
// File History:
//
// $Id: TiffIODemo4.h,v 1.4 2006/02/06 19:40:41 gascuel Exp $
//
// 2006-01-06 : Creation.

#include <QApplication>
#include <QMessageBox>
#include <QFileDialog>
#include <QImage>
#include <QImageReader>
#include <QPixmap>

////////////////////////////////////////////////////////////////////////
//
// Single inheritance model:
//
#include "ui_TiffIODemo4.h"

class TiffIODemo : public QMainWindow
{
private:
    Q_OBJECT
    Ui::TiffIODemo ui;
public:
    TiffIODemo(QWidget* parent, const char*)
    : QMainWindow(parent)
    {
        ui.setupUi(this);

        // See QStyleSheet class reference:
        ui.pixmap->setText("<qt><html>"
            "<blockquote><big>"
            "<p>This demo is intended just to give a way to test Tiff image reading,"
            "as integrated along with standatd <i>Qt3</i> or <i>Qt4</i> image tools."

            "<p>Use the <b><i>Open...</i></b> menu to load an image."

            "<p><font color=\"red\"><i>Save as...</i></font> is not implemented yet."
            "</big></blockquote></html></qt>"
        );
    }
private slots:
    inline void on_fileOpenAction_activated();
    inline void on_fileSaveAsAction_activated();
    inline void on_fileExitAction_activated();
};

//////////////////////////////////////////////////////////////////////////////
// Format image types for file dialogs ";;"-separated list:
//
static QString formats(const QList<QByteArray>& in)
{
    QString all = "Images (";
    for(int i=0; i<(int)in.count(); ++i)
    {
        QString ext = QString(in.at(i)).toLower();
        all += QString("*.%1 ").arg(ext);

        // Add equivalent format in stupid WIN32 8.3 convention:
        if( ext == "tiff" )
            all += "*.tif ";
        else if( ext == "jpeg" )
            all += "*.jpg ";
    }
    all += ")";

    for(int i=0; i<(int)in.count(); ++i)
    {
        QString ext = QString(in.at(i)).toLower();

        QString fmt  = QString(";;Image %1 (*.%2")
            .arg( ext )
            .arg( ext );

        // Add equivalent format in stupid WIN32 8.3 convention:
        if( ext == "tiff" )
            fmt += " *.tif";
        else if( ext == "jpeg" )
            fmt += " *.jpg";

        all += ")" + fmt;
    }

    return all;
}

//////////////////////////////////////////////////////////////////////////////

inline void TiffIODemo::on_fileOpenAction_activated()
{
    QString s = QFileDialog::getOpenFileName(this,
        "Choose an image to open",
        QDir::current().path(),
        formats( QImageReader::supportedImageFormats() ));

    if( ! s.isEmpty() )
    {
        // Retain new current directory:
        QDir::setCurrent( s.section('/', 0, -2) );

        QImage img(s);
        if( img.isNull() )
        {
            ui.pixmap->setText(QString("Error while loading image '%1'")
                .arg(s));
        }
        else
        {
            ui.pixmap->setPixmap( QPixmap::fromImage( img ) );
            ui.pixmap->updateGeometry();
        }
    }
}

//////////////////////////////////////////////////////////////////////////////

inline void TiffIODemo::on_fileSaveAsAction_activated()
{
}

inline void TiffIODemo::on_fileExitAction_activated()
{
    close();
}
