###############################################################################
# a spec file for TiffIO
#
# rpmbuild -bs XXX.spec : create /usr/src/RPM/SRPMS/%{dist}-%{ver}-%{rel}.src.rpm
# rpmbuild -bb XXX.spec : create /usr/src/RPM/SPMS/%{dist}-%{ver}-%{rel}.$ARCH.rpm
#                            /usr/src/RPM/SPMS/%{dist}-devel-%{ver}-%{rel}.$ARCH.rpm
# rpmbuild -ba XXX.spec : creates both
#
###############################################################################
#
%define dist TiffIO
%define major 1
%define minor 2
%define beta  0
%define rel   e
#
%define ver %{major}%{minor}%{beta}
%define tar  %{dist}-%{ver}%{rel}
#
%define INSTBASE /usr
%define QTDIR	%{INSTBASE}/lib/qt3
%define INSTDIR	%{QTDIR}/plugins/imageformats
%define  DOCDIR %{INSTBASE}/share/doc/TiffIO
%define TESTDIR %{INSTBASE}/share/doc/TiffIO
#
%define PLUGIN *TiffIO*
#
###############################################################################
#
Name: %dist
Version: %{ver}
Release: %rel
### Copyright: Licence_CeCILL_V1-fr.txt
License: Licence_CeCILL_V1-fr.txt
Source: ftp://tiffio.sourceforge.net/%{tar}.tgz
URL: http://artis.inrialpes.fr/Logiciels/TiffIO
Packager: Jean-Dominique.Gascuel@imag.fr
BuildRoot: /tmp/%{name}-%{ver}-buildRoot
Prefix: %{INSTBASE}
### No standard provides for both Qt3 and Qt4... Requires: Qt >= 3

###############################################################################

Summary: Plugin to add TIFF images read/write capabilities to the Qt3 and Qt4
Group: System/Libraries

%description
TiffIO is a plugin that add TIFF images read/write capabilities to the Qt3 and 
Qt4 QImage class.

Adding the generated plugin in the Qt's tree enable any Qt application to 
manipulate TIFF images. TiffIO come with a self-test suite, and have been 
compiled and used successfully on a variety of windows and unixes platforms.

All TIFF operations are based on libtiff 3.7.2, this plugin is just a wrapper 
that enable to use it transparently from the QImage class, and the QImageIO 

###############################################################################

%package test
Requires: TiffIO
Summary: Self-test procedure for TiffIO's Tiff extension to Qt.
Group: System/Libraries

%description test
This little programes comes with several combinations of Tiff possible formats,
and just make sure Qt get able to read and write them successfully.

###############################################################################
#
%prep

# Use standard macro, that make a tar extract into Build/TiffIO-%{Version}
%setup -n %{dist}-%{ver}%{rel}

###############################################################################
#
%build

# Use: %ifos/%ifnos/%endif/%else to test linux, irix, etc.
#      %ifarch/%ifnarch to test i386/ix86/sparc/ppc/noarch/...

echo "Run test sequence..."
%{QTDIR}/bin/qmake test.pro
%{__make} clean first
./test
STATUS=$?
if [ $STATUS -ne 0 ]; then
	echo "TiffIO self test failed..."
	exit $STATUS
fi
echo "Self test succeded".

echo "Compiling plugin"
%{QTDIR}/bin/qmake TiffIO.pro
%{__make}

###############################################################################
#
%install

# Make sure its clean:
%{__rm} -rf ${RPM_BUILD_ROOT}%{DOCDIR}
%{__rm} -rf ${RPM_BUILD_ROOT}%{TESTDIR}
%{__mkdir} -p ${RPM_BUILD_ROOT}%{DOCDIR}
%{__mkdir} -p ${RPM_BUILD_ROOT}%{TESTDIR}

# Copy the plugin into the QTDIR/plugins/imageformat dir:
# Note: TiffIO.pro do it already in RPM_BUILD_ROOT.
%{__make} install

# Copy documentation:
%{__cp} README* Licence* ${RPM_BUILD_ROOT}%{DOCDIR}/

# Copy the test programmes and examples, for the test package:
%{__cp} -r test Examples/ ${RPM_BUILD_ROOT}%{TESTDIR}/

###############################################################################
#
# Files for the standard package...
#
# Note: rpm automatically insert the ${RPM_BUILD_ROOT}/

%files
%attr(-,root,root) %{INSTDIR}/%{PLUGIN}
%attr(-,root,root) %docdir %{DOCDIR}
%attr(-,root,root) %doc %{DOCDIR}/Licence*
%attr(-,root,root) %doc %{DOCDIR}/README*

%files test
%attr(-,root,root) %dir %{TESTDIR}
%attr(-,root,root) %{TESTDIR}/test
%attr(-,root,root) %{TESTDIR}/Examples/

###############################################################################
#
%clean 
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && %{__rm} -rf $RPM_BUILD_ROOT

###############################################################################
#
%post
echo "TiffIO %{ver}%{rel} installed in %{INSTDIR} and %{DOCDIR}."

%post test
cd %{TESTDIR}
./test
echo "TiffIO %{ver}%{rel} self-test and examples installed in %{TESTDIR}."

###############################################################################
#

%changelog
* Wed Feb 10 2006 <Jean-Dominique.Gascuel@imag.fr>
- Added support for Lab 3x16 and RGBA 4x32 color schemes.
* Mon Feb 06 2006 <Jean-Dominique.Gascuel@imag.fr>
- Upgrade to libtiff 3.8.0++ (beta CVS), to cure crash
  with uncommon features of TIFF (YCrCb color space, 
  multipage, etc.)
- FIX bug preventing Qt4.1 version to have tiff/tif in the Qt's
  stringlist of recognized format.
* Wed Jan 11 2006 <Jean-Dominique.Gascuel@imag.fr>
- Upgrade to libtiff 3.8.0, patched against compile error & crashe.
- Fix mix-up between bit and byte order for bitmaps.
- Added image viewer demo.
- Added more test image in the regression test.
* Fri Oct 14 2005 <Jean-Dominique.Gascuel@imag.fr>
- First version ov the spec file for TiffIO 1.1.0 rel 3
