# TiffIO.pri : define evrything common to TiffIO and TiffIO-debug
#
# $Id: TiffIO.pri,v 1.16 2006/01/12 18:25:22 gascuel Exp $
#
#-----------------------------------------------------------------------------
# qmake runtime options:
#
#   DEFINES+=Q_STATIC_PLUGIN=1 (Qt3) or QT_STATICPLUGIN=1 (Qt4)
#                   : if defined at compile time, and TiffIO.pri is included
#                     in your project, then the codec is linked within your
#                     project, and initialised automatically at run time.
#                     (See test.pro for an example).
#
#   CONFIG+=no-zlib : Do not support zlib (even if found)
#   CONFIG+=no-jpeg : Do not support lib jpeg (even if found)
#   CONFIG+=no-lzw  : Do not support lzw compression from libtiff sources.
#
#-----------------------------------------------------------------------------
#
# I *strongly* urge you not to compile with a different version of LibTiff...
# Nevertheless, some of your folks have to live dangerously for whatever 
# reason, so the config file enable you to do that :
#
#  qmake TIFF=/home/me/libtiff-3.7.4/src TiffIO.pro
#       compiles using a different directory to look for tiff's sources.
#
#  qmake CONFIG+=libtiff TiffIO.pro
#       compiles using a precompiled tiff library, located in the TIFF_ROOT
#       (command line argument, or env var) directory.
#
#       TIFF_ROOT defaults to "/usr", hence using the unix standard
#       "/usr/include/tiffio.h" and "/usr/lib/libtiff.so" (or .a) files.
#
#-----------------------------------------------------------------------------
#
# Using your own version of the jpeg lib (eg. from $QTDIR/src/3rdparty/libjpeg)
# for win32 :
#
#   - Compile the lib, in order to have a directory with both the jpeglib.h
#     and libjpeg.lib
#
#   - run qmake with the 'JPEG=$QTDIR/src/3rdparty/libjpeg' option (or your
#     own directory).
#
# This is helpfull, because even you you install Qt3 or Qt4 with jpeg support,
# they are inside a dll (Qt of plugin), where jpeg symbols are not exported,
# hence you can't link against them.
# 
#-----------------------------------------------------------------------------

CONFIG -= debug_and_release debug_and_release_target
CONFIG += qt

# Note: we have our own error handler, no needs to compile TIFF's own
#       (that generates link error on Qt4/nmake compiles).
DEFINES += TIF_PLATFORM_CONSOLE=1

SOURCES += \
    TiffIO.cpp

qt3: SOURCES += TiffIO_Qt3.cpp
qt4: SOURCES += TiffIO_Qt4.cpp

#----------------------------------------------------------------------
# Manage to get access to Qt's own ZLib
#
!no-zlib {

    # Try to get ZLib from environement, or from the Qt's distribution.
    isEmpty( ZLIB ) : ZLIB = $$(ZLIB)
    isEmpty( ZLIB ) : ZLIB = $$(QTDIR)/src/3rdparty/zlib

    # Try to get ZLib from known place on various systems.
    # WARNING: On my SGI IRIX 6.5.18f, /usr/include/zlib.h is complete trash,
    # hence things won't compile if /usr/include is before /usr/local/include!
    unix: !exists( $${ZLIB}/zlib.h ) : ZLIB = /usr/local/include
    unix: !exists( $${ZLIB}/zlib.h ) : ZLIB = /usr/include

    # Check we have it :
    exists( $${ZLIB}/zlib.h ) {
        message( +++++ Using ZLIB support from $$ZLIB )

        INCLUDEPATH *= $${ZLIB}
        INCLUDEPATH -= /usr/include

        # Do we need to link something for it ?
        # (or is it included in Qt's dll, or as a plugin ?)
        win32 : exists( $${ZLIB}/zlib.lib )    : LIBS += $${ZLIB}/zlib.lib
        win32 : exists( $${ZLIB}/nt/zlib.lib ) : LIBS += $${ZLIB}/zlib.lib
        unix  {
             exists( $${ZLIB}/zlib.a   ) : LIBS += $${ZLIB}/zlib.a
            !exists( $${ZLIB}/zlib.a   ) : LIBS += -lz
        }
    } else {
        CONFIG += no-zlib
    }
}
no-zlib {
	DEFINES *= NO_ZLIB=1
	message( No ZLIB support compiled in TiffIO )
}

#----------------------------------------------------------------------
# Manage to get access to Qt's own JPEGLib, or other provided lib.
#

# Note: by default, don't know how to compile for JPEG on Win32 Qt distribution
# (Or you will have to make all change 3rdparty/libjpeg to export DLL symbols)...
win32: isEmpty(JPEG): CONFIG += no-jpeg

!no-jpeg {

    # Try to get JPEG from environement
    isEmpty( JPEG ) : JPEG = $$(JPEG)

    # Try to get libjpeg from known place on various systems:
    unix: !exists( $${JPEG}/jpeglib.h ) : JPEG = /usr/local/include
    unix: !exists( $${JPEG}/jpeglib.h ) : JPEG = /usr/include

    # Everything else failed: try the Qt's sources :
    !exists( $${JPEG}/jpeglib.h ) : JPEG = $$(QTDIR)/src/3rdparty/libjpeg

    # Check we have it :
    exists( $${JPEG}/jpeglib.h ) {
        message( +++++ Using JPEG support from $$JPEG )

        INCLUDEPATH *= $${JPEG}
        INCLUDEPATH -= /usr/include

        # Do we need to link something for it ?
        # (or is it included in Qt's dll, or as a plugin ?)
        win32 : exists( $${JPEG}/libjpeg.lib ): LIBS += $${JPEG}/libjeg.lib
        linux : LIBS += -ljpeg
    } else {
        CONFIG += no-jpeg
    }
}

no-jpeg {
    DEFINES *= NO_JPEG=1
    message( No JPEG support compiled in TiffIO )
}

#----------------------------------------------------------------------
# Auto detect, for linux, if a tiff plateform was required

!libtiff {
    isEmpty(TIFF): TIFF=$$(TIFF)
    isEmpty(TIFF): TIFF=libtiff-3.8.0
    !exists( $$TIFF/tiffio.h ) : error( Unable to find libtiff )
    
    INCLUDEPATH = $$TIFF $$INCLUDEPATH

	message( +++++ Using internal $$TIFF sources )

	HEADERS += \
        $$TIFF/tiffio.h        \
    	$$TIFF/tiff.h          \
    	$$TIFF/tiffiop.h       \
    	$$TIFF/tiffvers.h      \
    	$$TIFF/tif_config.h

	SOURCES += \
    	$$TIFF/tif_aux.c       \
    	$$TIFF/tif_close.c     \
    	$$TIFF/tif_codec.c     \
    	$$TIFF/tif_color.c     \
    	$$TIFF/tif_compress.c  \
    	$$TIFF/tif_dir.c       \
    	$$TIFF/tif_dirinfo.c   \
    	$$TIFF/tif_dirread.c   \
    	$$TIFF/tif_dirwrite.c  \
    	$$TIFF/tif_dumpmode.c  \
    	$$TIFF/tif_error.c     \
    	$$TIFF/tif_extension.c \
    	$$TIFF/tif_fax3.c      \
    	$$TIFF/tif_fax3sm.c    \
    	$$TIFF/tif_flush.c     \
    	$$TIFF/tif_getimage.c  \
    	$$TIFF/tif_luv.c       \
    	$$TIFF/tif_next.c      \
    	$$TIFF/tif_open.c      \
    	$$TIFF/tif_packbits.c  \
    	$$TIFF/tif_predict.c   \
    	$$TIFF/tif_print.c     \
    	$$TIFF/tif_read.c      \
    	$$TIFF/tif_strip.c     \
    	$$TIFF/tif_swab.c      \
    	$$TIFF/tif_thunder.c   \
    	$$TIFF/tif_tile.c      \
    	$$TIFF/tif_version.c   \
    	$$TIFF/tif_warning.c   \
    	$$TIFF/tif_write.c

	!no-zlib: SOURCES *= $$TIFF/tif_zip.c $$TIFF/tif_pixarlog.c
	!no-lzw:  SOURCES *= $$TIFF/tif_lzw.c
 	 no-lzw:  DEFINES *= NO_LZW=1
	!no-jpeg: SOURCES *= $$TIFF/tif_jpeg.c

	win32: SOURCES *= $$TIFF/tif_win32.c
	unix : SOURCES *= $$TIFF/tif_unix.c
	
	# Add our internal lfind() for libtiff/port,
	# or get unix's one ?
	unix: exists(/usr/include/search.h) : DEFINES *= HAVE_SEARCH_H
	else: SOURCES *= $$TIFF/lfind.c

} else {
	# Looks if there is a TIFF_ROOT env variable. If so, use it:
	isEmpty(TIFF_ROOT): TIFF_ROOT=$$(TIFF_ROOT)
	isEmpty(TIFF_ROOT): TIFF_ROOT=/usr

	!exists( $$TIFF_ROOT/include/tiffio.h ) : error( Unable to use $${TIFF_ROOT}. Please set TIFF_ROOT )

    # Make sure the tiff include dir comes first (and once)
    INCLUDEPATH -= $$TIFF_ROOT/include
    INCLUDEPATH = $$TIFF_ROOT/include $$INCLUDEPATH
    
    # Where to look for the tiff lib :
    LIBPATH *= $$TIFF_ROOT/lib
	LIBS *= -ltiff

	message( +++++ Using pre-compiled library $$TIFF_ROOT )
}

