#! /bin/bash

mkdir new/

lab="Tiff-100x100-lab16-lzw.tif"
rgba="Tiff-100x100-rgb16-lzw-mac.tif"

# Endianness :
tiffcp -B -c packbits $lab "new/Tiff-100x100-lab16-bigendian.tif"
tiffcp -L -c packbits $lab "new/Tiff-100x100-lab16-litleendian.tif"

# 16bits compression schemes :
for compression in lzw:1 lzw:2 zip packbits
do
    tiffcp -i -c $compression $lab "new/Tiff-100x100-lab16-$compression.tif"
done

# 8bits compression schemes :
for compression in lzw zip jpeg packbits
do
    tiff2rgba -c $compression -r 16    $rgba "new/Tiff-100x100-rgba8-$compression.tif"
    tiff2rgba -c $compression -r 16 -n $rgba "new/Tiff-100x100-rgb8-$compression.tif"
done

# Gray images
rgb="new/Tiff-100x100-rgb8-lzw.tif"
for compression in lzw zip packbits
do
    tiff2bw -c $compression $rgb "new/Tiff-100x100-g8-$compression.tif"
done

# Paletted schemes :
for colors in 256 64 16 4
do
    tiffmedian -C $colors -c packbits -f $rgba "new/Tiff-100x100-color$colors-lwz.tif"
done

# bitmaps
bw="new/Tiff-100x100-g8-lzw.tif"
for compression in packbits zip lzw g3 g4
do
    for bitorder in lsb2msb msb2lsb
    do
        tiffdither -c $compression -f $bitorder $bw "new/Tiff-100x100-bitmap-$compression-$bitorder.tif"
    done
done

