/*
 * Name: smb_abstraction.h
 * Description: Interface to the smb abstraction layer.
 * Author: Christian Starkjohann <cs@hal.kph.tuwien.ac.at>
 * Date: 1996-12-31
 * Copyright: GNU-GPL
 * Tabsize: 4
 */

typedef struct smba_connect_parameters{
	char	*server_ipname;
	char	*server_name;
	char	*client_name;
	char	*service;
	char	*root_path;
	char	*username;
	char	*password;
	int		max_xmit;
	int		port;
}smba_connect_parameters_t;

typedef struct smba_stat{
	unsigned	is_dir		:1;
	unsigned	is_wp		:1;
	unsigned	is_hidden	:1;
	unsigned	is_system	:1;
	unsigned	is_volid	:1;
	int			size;
	long		atime;
	long		ctime;
	long		mtime;
}smba_stat_t;

typedef struct smba_server	smba_server_t;
typedef struct smba_file	smba_file_t;

typedef int	(*smba_callback_t)(void *d, int fpos, int nextpos,
														char *name, int eof);


int	smba_connect(smba_connect_parameters_t *p, int use_E, smba_server_t **res);
int	smba_disconnect(smba_server_t *server);
int	smba_open(smba_server_t *server, const char *name, smba_file_t **file);
int	smba_close(smba_file_t *file);
int	smba_file_importance(smba_file_t *f);
int	smba_write(smba_file_t *file, char *data, long len, long offset);
int	smba_read(smba_file_t *file, char *data, long len, long offset);
int	smba_getattr(smba_file_t *file, smba_stat_t *data);
int	smba_setattr(smba_file_t *file, smba_stat_t *data);
int	smba_touch(smba_file_t *file);
int	smba_name(smba_file_t *file, char **name);
int	smba_readdir(smba_file_t *f, long offs, void *d, smba_callback_t callback);
int	smba_create(smba_file_t *dir, const char *name, smba_stat_t *attr);
int	smba_mkdir(smba_file_t *dir, const char *name, smba_stat_t *attr);
int	smba_remove(smba_server_t *s, char *path);
int	smba_rmdir(smba_server_t *s, char *path);
int	smba_rename(smba_server_t *s, char *from, char *to);
int	smba_statfs(smba_server_t *s, long *bsize, long *blocks, long *bfree);
void	smba_regular(void);
void	smba_init(void);

/*
 * ####fixme:
 * truncate at close
 */
