#ifndef _SUBNET_H
#define _SUBNET_H



/* headers we depend upon
 */
#include "../types/types.h"
#if !defined(NETRAMET)
#    include "../intel/timestmp.h"
#endif



/* conditional compile switches
 */
#define USE_PATRICIA_TREE       FALSE



/* manifest constants
 */
#define MAX_ADDR_BITS           32
#define MAX_AS_PATH_WIDTH       20

typedef int boolean;

typedef struct Subnet_ Subnet;
struct Subnet_
{
    Bit32 addr;             /* in network byte order */
    Bit32 mask;             /* in network byte order */
    Bit32 nexthop_addr;     /* our router that peers with exit AS */
    char *as_path;          /* allocated from heap so free me later! */
    unsigned line;          /* where in routing table was this?  (aids user debugging) */
    unsigned short src_as;  /* source AS number (owner of subnet) */
    unsigned short exit_as; /* exit AS number (whose network gets it after us) (may be same as source AS) */
};

/* user function called during walk with user-defined arguments
 */
typedef boolean (*WalkSubnetFunction)( boolean is_before, Subnet *external, void *args );



/* prototypes for exported support functions
 */
#define bits_in_mask(x) (MAX_ADDR_BITS-lsb_of_long(x))

#if 1
    boolean InitSubnet( void );
    unsigned lsb_of_long( Bit32 value );
    Subnet *FindSubnet( register Bit32 address );

    unsigned lsb_of_array( Bit8 *array, unsigned length );
    int msb_of_native_long( Bit32 value );
    int msb_of_native_short( Bit16 value );
    boolean InitSubnet2( void );
#if !NETRAMET
    PentiumClock GetLastFindSubnetTiming( void );
#endif
    unsigned GetLastFindSubnetRefcnt( void );
    boolean DeleteSubnet( Subnet *external );
    boolean InsertSubnet( Subnet *external );
    boolean WalkSubnets( WalkSubnetFunction function, void *args );
    unsigned PrintSubnets( char *buffer, unsigned max_size );
    void DumpRawSubnets( void );
    unsigned GetSubnetNodeCount( void );
    void ShowSubnetStatistics( void );
    void SetSubnetExternalBase( Subnet *base );
    void ForceSubnetCaching( void );
#else
    unsigned lsb_of_array();
    unsigned lsb_of_long();
    int msb_of_short();
    boolean InitSubnet();
    boolean InitSubnet2();
    Subnet *FindSubnet();
    unsigned GetLastFindSubnetRefcnt();
    boolean DeleteSubnet();
    boolean InsertSubnet();
    boolean WalkSubnets();
    unsigned PrintSubnets();
    void DumpRawSubnets();
    unsigned GetSubnetNodeCount();
    void ShowSubnetStatistics();
    void SetSubnetExternalBase();
    void ForceSubnetCaching();
#endif



#if USE_PATRICIA_TREE
#    include "../integrat/subnetp.h"
#else
#    include "../integrat/subnetd.h"
#endif



#endif      /* not included yet */
