#define ALLOW_INFINITE_RESULTS  FALSE



/* functions for doing global stat reporting */

double variance(int n, double sum, double sum2);

#if 0  /* Never called by NeTraMet! */
void update_stats( struct hashrec * hr, float duration );
#endif

int init_stats( void );

int report_stats( tcp_Socket *sock, float istamp, float trace_duration );

/* forces argument to be 1 if it is zero
 * (to avoid floating point division by zero)
 */
#if ALLOW_INFINITE_RESULTS
#define nonzero(x) (x)
#else
#define nonzero(x) ((x)?(x):1)
#endif



#define IP_LEN_SHIFT    0        /* measured in bits, controls granularity of histogram */
#define IP_LEN_COUNT    (65536 >> IP_LEN_SHIFT)
#define IP_PREC_COUNT   8
#define IP_PREC_MASK    (IP_PREC_COUNT - 1)
#define IP_PREC_SHIFT   5        /* helps extract the bits from IP TOS byte */

extern u_int ip_length_usage[ IP_LEN_COUNT ];
extern u_int ip_precedence_usage[ IP_PREC_COUNT ];
