/* 1145, Wed 10 Sep 96

   SNMPAPI.H:  Global declarations for SNMP API.
               NeTraMet version, based on CMU SNMPv2 (see below).

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: snmpapi.h,v $
 * Revision 1.1.1.2.2.9  2002/02/23 01:57:39  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.5  2000/08/08 19:44:58  nevil
 * 44b8 release
 *
 * Revision 1.1.1.2.2.3  2000/06/06 03:38:29  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2  1999/10/03 21:06:32  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.3  1999/09/24 02:58:44  nevil
 * Polish up code to get rid of warning messages from Borland (DOS) compiler.
 * Make manager PeerAddress buffers NSAP_ADDR_LEN bytes long.
 * Add asn_lookup variable - only call FindSubnet if ruleset uses ASNs.
 *
 * Revision 1.1.1.1.2.2  1999/09/22 05:38:48  nevil
 * Improve code to work properly on 64-bit machines
 * - Add OS=ALPHA handling to configure.in
 * - Clean up the Alpha compiler warnings
 * - Change all the snmp-related code to use Bit32 instead of unsigned long
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:39  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1  1998/11/16 03:57:32  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:02  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:31  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2.2.2  1998/10/22 01:28:09  nevil
 * Community data wasn't being copied when PDUs were cloned, which gave
 * unpredictable results when the cloned pdu was freed.  Added code to
 * copy community data properly.  Also added PDU_MALLOC_CHECK define
 * to trace malloc() and Free() operations on pdus.
 *
 * Revision 1.1.3.2.2.1  1998/10/19 02:30:40  nevil
 * Use log_msg() to report errors instead of fprintf(stderr ..)
 *
 * Revision 1.1.3.2  1998/10/14 04:13:48  nevil
 * Merge Nicolai's patches into 4.2.1 distribution
 *
 * Revision 1.1.1.1  1998/10/13 01:35:01  nevil
 * Import of NeTraMet 4.2.1
 *
 * Revision 1.1.1.1  1998/08/24 12:09:30  nguba
 * NetraMet 4.2 Original Distribution
 */

/***********************************************************
    Copyright 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/*
 * snmp_api.h - API for access to snmp.
 */

#ifdef __cplusplus
extern "C" {
#endif

#ifdef DOS
typedef long  fd_mask;
#define NBBY  8  /* Bits per byte */
typedef struct fd_set {
   fd_mask fds_bits[1];
   } fd_set;
#define NFDBITS (sizeof(fd_mask) * NBBY)    /* bits per mask */
#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)  memset((char *)(p), 0, sizeof(*(p)))

struct timeval { long tv_sec, tv_usec; };
struct timezone { int tz_minuteswest, tz_dsttime; };
void gettimeofday(struct timeval *tp, struct timezone *tzp);
#define timerisset(tvp)     ((tvp)->tv_sec || (tvp)->tv_usec)
#define timercmp(tvp, uvp, cmp) \
    ((tvp)->tv_sec cmp (uvp)->tv_sec || \
     (tvp)->tv_sec == (uvp)->tv_sec && (tvp)->tv_usec cmp (uvp)->tv_usec)
#define timerclear(tvp)     (tvp)->tv_sec = (tvp)->tv_usec = 0
#endif

void shift_array(u_char *begin, int length, int shift_amount);

typedef struct sockaddr_in  ipaddr;

/*
 * Set fields in session and pdu to the following to get a default or unconfigured value.
 */
#define SNMP_DEFAULT_COMMUNITY_LEN  0   /* to get a default community name */
#define SNMP_DEFAULT_RETRIES        -1
#define SNMP_DEFAULT_TIMEOUT        -1
#define SNMP_DEFAULT_REMPORT        0
#define SNMP_DEFAULT_REQID      0
#define SNMP_DEFAULT_ERRSTAT        -1
#define SNMP_DEFAULT_ERRINDEX       -1
#define SNMP_DEFAULT_ADDRESS        0
#define SNMP_DEFAULT_PEERNAME       NULL
#define SNMP_DEFAULT_ENTERPRISE_LENGTH  0
#define SNMP_DEFAULT_TIME       0
#define SNMP_DEFAULT_VERSION        -1

extern int snmp_errno;
/* Error return values */
#define SNMPERR_GENERR      -1
#define SNMPERR_BAD_LOCPORT -2  /* local port was already in use */
#define SNMPERR_BAD_ADDRESS -3
#define SNMPERR_BAD_SESSION -4
#define SNMPERR_TOO_LONG    -5

#define non_repeaters   errstat   /* !!!!!!! Nevil */
#define max_repetitions errindex

struct snmp_pdu {
   int version;
   int pdu_len;            /* Nevil, 7 Jun 00 */

   ipaddr address;         /* Address of peer */
   u_char *community;      /* community for outgoing requests. */
   int community_len;      /* Length of community name. */

   int command;            /* Type of this PDU */

   Int32 reqid;            /* Request id */
   Int32 errstat;          /* Error status (non_repeaters in GetBulk) */
   Int32 errindex;         /* Error index (max_repetitions in GetBulk) */

   /* Trap information */
   oid *enterprise;        /* System OID */
   int enterprise_length;
   ipaddr agent_addr;      /* Address of object generating trap */
   Bit32 trap_type;        /* Trap type */
   Bit32 specific_type;    /* Specific type */
   Bit32 time;             /* Uptime */

   struct variable_list *variables;
   };


struct variable_list {
   struct variable_list *next_variable;    /* NULL for last variable */
   oid      *name;  /* Object identifier of variable */
   int      name_length;    /* number of subid's in name */
   u_char  type;   /* ASN type of variable */
   union { /* value of variable */
      Int32     *integer;
      Bit32     *u_int;
      u_char    *string;
      oid       *objid;
      u_char    *bitstring;
      counter64 *counter64;
      } val;
   int      val_len;
   };

struct snmp_session {
   u_char  *community;  /* community for outgoing requests. */
   int      community_len;  /* Length of community name. */
   int      retries;    /* Number of retries before timeout. */
   long    timeout;    /* Number of uS until first timeout, then exponential backoff */
   char    *peername;   /* Domain name or dotted IP address of default peer */
   u_short remote_port;/* UDP port number of peer. */
   u_short local_port; /* My UDP port number, 0 for default, picked randomly */
   /* Authentication function or NULL if null authentication is used */
   u_char    *(*authenticator)(
      u_char *pdu, int *length, u_char *community, int community_len);
   int      (*callback)(  /* Function to interpret incoming data */
      int operation, struct snmp_session *session, int reqid,
      struct snmp_pdu *pdu, void *magic);
   /* Pointer to data that the callback function may consider important */
   void    *callback_magic;
   int      version;
   };

struct snmp_session *snmp_open(struct snmp_session *session);

/*
 * Sets up the session with the snmp_session information provided
 * by the user.  Then opens and binds the necessary UDP port.
 * A handle to the created session is returned (this is different than
 * the pointer passed to snmp_open()).  On any error, NULL is returned
 * and snmp_errno is set to the appropriate error code.
 */


int snmp_close(struct snmp_session *session);

/*
 * Close the input session.  Frees all data allocated for the session,
 * dequeues any pending requests, and closes any sockets allocated for
 * the session.  Returns 0 on error, 1 otherwise.
 */


int snmp_send(struct snmp_session *session, struct snmp_pdu *pdu);
/*
 * Sends the input pdu on the session after calling snmp_build to create
 * a serialized packet.  If necessary, set some of the pdu data from the
 * session defaults.  Add a request corresponding to this pdu to the list
 * of outstanding requests on this session, then send the pdu.
 * Returns the request id of the generated packet if applicable, otherwise 1.
 * On any error, 0 is returned.
 * The pdu is freed by snmp_send() unless a failure occured.
 */


void snmp_read(fd_set *fdset);

/*
 * Checks to see if any of the fd's set in the fdset belong to
 * snmp.  Each socket with it's fd set has a packet read from it
 * and snmp_parse is called on the packet received.  The resulting pdu
 * is passed to the callback routine for that session.  If the callback
 * routine returns successfully, the pdu and it's request are deleted.
 */


void snmp_free_pdu(struct snmp_pdu *pdu);
void snmp_free_internal_pdu(struct snmp_pdu *pdu);

/*
 * Frees the pdu and any malloc'd data associated with it.
 */

int snmp_select_info(int *numfds, fd_set *fdset,
   struct timeval *timeout, int *block);

/*
 * Returns info about what snmp requires from a select statement.
 * numfds is the number of fds in the list that are significant.
 * All file descriptors opened for SNMP are OR'd into the fdset.
 * If activity occurs on any of these file descriptors, snmp_read
 * should be called with that file descriptor set.
 *
 * The timeout is the latest time that SNMP can wait for a timeout.  The
 * select should be done with the minimum time between timeout and any other
 * timeouts necessary.  This should be checked upon each invocation of select.
 * If a timeout is received, snmp_timeout should be called to check if the
 * timeout was for SNMP.  (snmp_timeout is idempotent)
 *
 * Block is 1 if the select is requested to block indefinitely, rather than time out.
 * If block is input as 1, the timeout value will be treated as undefined, but it must
 * be available for setting in snmp_select_info.  On return, if block is true, the value
 * of timeout will be undefined.
 *
 * snmp_select_info returns the number of open sockets.  (i.e. The number of sessions open)
 */


void snmp_timeout(void);

/*
 * void snmp_timeout();
 *
 * snmp_timeout should be called whenever the timeout from snmp_select_info expires,
 * but it is idempotent, so snmp_timeout can be polled (probably a cpu expensive
 * proposition).  snmp_timeout checks to see if any of the sessions have an
 * outstanding request that has timed out.  If it finds one (or more), and that
 * pdu has more retries available, a new packet is formed from the pdu and is
 * resent.  If there are no more retries available, the callback for the session
 * is used to alert the user of the timeout.
 */


/*
 * This routine must be supplied by the application:
 *
 * u_char *authenticator(pdu, length, community, community_len)
 * u_char *pdu;     The rest of the PDU to be authenticated
 * int *length;     The length of the PDU (updated by the authenticator)
 * u_char *community;   The community name to authenticate under.
 * int  community_len   The length of the community name.
 *
 * Returns the authenticated pdu, or NULL if authentication failed.
 * If null authentication is used, the authenticator in snmp_session can be
 * set to NULL(0).
 */

/*
 * This routine must be supplied by the application:
 *
 * int callback(operation, session, reqid, pdu, magic)
 * int operation;
 * struct snmp_session *session;    The session authenticated under.
 * int reqid;               The request id of this pdu (0 for TRAP)
 * struct snmp_pdu *pdu;        The pdu information.
 * void *magic              A link to the data for this routine.
 *
 * Returns 1 if request was successful, 0 if it should be kept pending.
 * Any data in the pdu must be copied because it will be freed elsewhere.
 * Operations are defined below:
 */
#define RECEIVED_MESSAGE   1
#define TIMED_OUT      2


extern int snmp_dump_packet;

#ifdef __cplusplus
}           // end extern "C"
#endif
