
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>

#define ALPHA  0  /* Intel, SPARC, etc. */

typedef unsigned char  Bit8;
typedef unsigned short  Bit16;
#if !ALPHA
typedef unsigned long  Bit32;
#else
typedef unsigned int Bit32;
#endif

/* typedef unsigned int  Bit32;  /* sizeof(long) = 8 */

union rule_address {
   Bit8   rule[6];
   Bit8   adj[6];
   Bit8   peer[4];
   Bit16  trans;
   Bit8   byte;
   };
struct key {
   Bit32 PeerAddress[1];                                   /*  0.. 3 */
   Bit32 AdjAddr_high;  Bit16 AdjAddr_low;                 /*  4.. 9 */
   Bit16 TransAddress;                                     /* 10..11 */
   Bit8 Interface, PeerMaskVal, TransMaskVal, AdjMaskVal;  /* 12..15 */
   Bit8 AdjAddrType, Class, Kind, Rsrv;                    /* 16..19 */
   };

Bit8 b8;  Bit16 b16;  Bit32 b32;
long long ll = 1234567890123456LL;

union rule_address a,b;

struct key k;

#define DAGT_S(dts)   (long)((dts) >> 32)
#define DAGT_US(dts)  (long)((((dts) & 0xffffffffLL) * 1000000) >> 32)

void fmt_ts(char *t_buf, long long t)
{
   sprintf(t_buf, "%lu.%06lu", DAGT_S(t),DAGT_US(t));
   }

int main(int argc, char *argv[])
{
   int j;
   union rule_address *up;
   struct key *kp;
   Bit8 *bp;
   Bit16 sec;

   printf("ll=%lld\n", ll);
   printf("sizes: b8=%d, b16=%d, b32=%d, ll=%d, "
      "sizeof(rule)=%d, siezof(key)=%d\n\n",
      sizeof(b8), sizeof(b16), sizeof(b32), sizeof(ll),
      sizeof(union rule_address), sizeof(struct key));

   a.rule[0] = 1; a.rule[1] = 2; a.rule[2] = 3; 
   a.rule[3] = 4; a.rule[4] = 5; a.rule[5] = 6; 
   printf("a.adj = ");
   for (j = 0; j != 5; ++j) printf("%d.", a.adj[j]);
   printf("%d, a.trans=%d (%04x)\n\n", a.adj[5], a.trans, a.trans);

   up = &a;
   b.trans = htons(80);   /* http port number */
   printf("b.rule=%d.%d, b.trans=%d (%04x), up=%d (%04x)\n\n", 
      b.rule[0],b.rule[1], b.trans, b.trans, 
      *(Bit16 *)&up->peer[0], *(Bit16 *)&up->peer[0]);

   kp = &k;
   kp->PeerAddress[0] = *(Bit32 *)&up->peer[0];
   kp->AdjAddr_high = *(Bit32 *)&up->peer[0];
   kp->AdjAddr_low = *(Bit16 *)&up->peer[4];
   kp->TransAddress = *(Bit16 *)&up->peer[0];
   kp->Interface = 11;  kp->PeerMaskVal = 12;
   kp->TransMaskVal = 13;  kp->AdjMaskVal = 14;
   kp->AdjAddrType = 15;  kp->Class = 16;
   kp->Kind = 17;  kp->Rsrv = 18;

   printf("k=");
   bp = (Bit8 *)kp;
   for (j = 0; j != 3; ++j) printf("%d.", *bp++);  printf("%d  ", *bp++);
   for (j = 4; j != 9; ++j) printf("%d.", *bp++);  printf("%d  ", *bp++);
   printf("%d.", *bp++);  printf("%d  ", *bp++);
   for (j = 12; j != 19; ++j) printf("%d.", *bp++);  printf("%d\n", *bp++);

   for (;;) {
      scanf("%x", &sec);
      printf("   = %u seconds\n", sec);
      }

  } 