/* 1607, Thu 17 Feb 00

   X_NM_RC.H:  Globals for the Xwindow plots

   Copyright (C) 1996-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: x_nm_rc.h,v $
 * Revision 1.1.1.2.2.8  2002/02/23 01:57:24  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.4  2000/06/06 03:38:15  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2.2.1  1999/11/29 00:17:23  nevil
 * Make changes to support NetBSD on an Alpha (see version.history for details)
 *
 * Revision 1.1.1.2  1999/10/03 21:06:20  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:34  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1  1998/11/16 03:57:28  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:01  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:26  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2  1998/10/18 23:44:16  nevil
 * Added Nicolai's patches, some 'tidying up' of the source
 *
 * Revision 1.1.3.1  1998/10/13 02:48:31  nevil
 * Import of Nicolai's 4.2.2
 *
 * Revision 1.1.1.1  1998/08/24 12:09:29  nguba
 * NetraMet 4.2 Original Distribution
 *
 * Revision 1.3  1998/05/07 04:28:53  rtfm
 * Implement NetFlowMet, the Cisco NetFlow RTFM meter
 */

#ifndef XNMRC
#define EXTERN  extern
#define DECLARE  0
#define INIT(v)
#else
#define EXTERN
#define DECLARE  1
#define INIT(v)  = v
#endif

EXTERN int request_stop;  /* Set by sigint handler */

#define N_TOP_BORDER        10
#define N_LEFT_BORDER       10
#define N_RIGHT_BORDER      10
#define N_BOTTOM_BORDER     10

#define N_MID_SPACE         10

#define N_MAIN_WIDTH       640
#define N_MAIN_HEIGHT      480

#define N_LABEL_HEIGHT      15
#define N_LABEL_LEFT_MARGIN  5

#define N_GRAPH_MARGIN          5
#define N_TITLE_RIGHT_MARGIN   90
#define N_TITLE_TOP_MARGIN     20

#define DEF_ND_FLOWS  30  /* Default max nbr of flows plotted */

void nm_x_startup(int argc, char *argv[],  /* x_ob.c routines */
   int next_event_s);
void set_plot_color(String cp);

void set_log_type(XtPointer lt);  /* x_support routines */
void set_name_type(XtPointer nt);
void set_initial_parameters(void);
void set_ordinate_type(XtPointer ot);
void set_metric_type(XtPointer mt);
void set_select_type(XtPointer st);
void set_axis_range(XtPointer at);
void draw_xaxis(void);
void draw_yaxis(void);
void draw_title(void);
void nm_select_points(void);
void nm_compute_points(void);
void nm_plot_points(void);
int nm_nearest_flow(int sx,int sy);
void nm_flow_details(char *msg, int action, int np);

void shutdown_nifty(void);  /* x_nm_rc routines */
int nm_timer_callback(char *msg, int OK_to_display);
void set_sample_columns(void);

void display_number(FILE *f, unsigned long x);  /* nm_display.c routines */
void display_timeinterval(FILE *f, unsigned long t);
void display_attrib(FILE *f, 
   struct flow_info *fp, unsigned char col,
   struct meter_status *ms);

#define MXIDLE  255  /* Max nbr of samples since flow was active */
EXTERN int short n_recent;  /* 'recent' = 'within last n_recent samples' */

EXTERN struct meter_status *plot_ms;

EXTERN unsigned int max_flows;
struct flow_data {  /* Sample-to-sample differences */
   unsigned char ruleset, flowkind,
      active;  /* Number of samples since last active */
   unsigned long 
      starttime,lasttime;  /* Flow end-points */
   counter64
      up_pkt_count,down_pkt_count,  /* SNMP counters */
      up_byte_count,down_byte_count;
   unsigned long
      up_pkt_rate,down_pkt_rate,  /* Last sample deltas */
      up_byte_rate,down_byte_rate;
   unsigned long
      interval;  /* Best estimate of time flow was sampled */
   };
EXTERN struct flow_data *flow_table;

EXTERN int n_selected_flows;
struct flow_select {
   unsigned long traffic;
   unsigned int flownbr;
   };
EXTERN struct flow_select *select_table;
EXTERN unsigned long tt;  /* Total traffic for last selection */
EXTERN int nd_flows;  /* Nbr of flows to display */
struct display_data {
   unsigned int flownbr;
   unsigned char active;
   float vx,vy;
   int sx,sy;
   };
EXTERN struct display_data *dflows;
EXTERN int n_flows_to_plot;

EXTERN XtPointer xtype,ytype, ptype, ordinate, selection;
/* These are small integers, cast to XtPointer so that they can be
   passed back from the X menu handlers, then (eventually) cast
   back to int by the routines in x_support which use them  */

EXTERN float pxmin,pxaxis,pxmax, pxscale;
EXTERN float pymin,pyaxis,pymax, pyscale;
EXTERN int colourscale;

EXTERN char logging_samples, logging_points;
EXTERN int show_names;

enum {  /* x and y scales */
   SX100S, SX15M, SX2H,  /* x time */
   SY40P,                /* y % */
   SY900, SY9K, SY90K, SY900K, SY9M, SY90M   /* y pkts and bytes */
   };
enum {  /* Plot types */
   PTSAMPPC,  /* Sample % */
   PTSAMPKB,  /* Sample count */
   PTFLOWKB   /* Total count */
   };
enum {  /* Quantities */
   PQBYTES, PQPKTS
   };
enum {  /* Logging */
   LGSAMPLE, LGPOINT, LGNONE
   };
enum {  /* Selections */
   STLAST, STRECENT, STALL
   };
