/* 1620, Fri 17 Dec 99

   FD_DATA.H:  Global declarations for fd_filter and fd_extract

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: fd_data.h,v $
 * Revision 1.1.1.2.2.11  2002/02/23 01:57:15  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.6  2000/08/08 19:44:41  nevil
 * 44b8 release
 *
 * Revision 1.1.1.2.2.4  2000/06/06 03:38:07  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2.2.1  2000/01/12 02:57:02  nevil
 * Implement 'packet pair matched' turnaroundtime distribution attributes.
 * Fix ASN-related bugs in NeTraMet, distribution-related bugs in fd_filter.
 *
 * Revision 1.1.1.2  1999/10/03 21:06:13  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.7  1999/05/18 03:36:23  nevil
 * Implement IPv6 in NeTraMet, and its manager/collectors.
 * - This is controlled by the V6 #define
 * - NeTraMet recognises v6 packets and fishes through their extension
 *     headers until it finds the actual payload.
 * - NeMaC et al display v6 addresses in the fom specified by RFC 2373
 * - fd_util and fd_extract allow colons in addresses (for defining tags)
 *
 * Revision 1.1.1.1.2.6  1999/02/03 04:41:41  nevil
 * Implementation of TCP attributes, part 5
 *
 * Revision 1.1.1.1.2.5  1999/01/27 04:26:11  nevil
 * Minor corrections to fix compiler warnings
 *
 * Revision 1.1.1.1.2.4  1999/01/20 04:01:32  nevil
 * Implementation of TCP attributes, part 4
 *
 * Revision 1.1.1.1.2.3  1999/01/08 01:33:58  nevil
 * Implement TCPdata and DScodepoint attributes
 *
 * Revision 1.1.1.1.2.2  1998/12/23 01:14:10  nevil
 * Distribution file for 4.3b6
 *
 * Revision 1.1.1.1.2.1  1998/11/26 04:13:48  nevil
 * Fix problems in fd_filter and fd_extract when dealing with 'new'
 * attributes, especially those used with NETFLOW. In particular:
 * - Make sure attribs[] is referred to via attr_ix[]
 * - Get the separators correctly from a #Format record (no quotes)
 * - fd_extract wasn't writing out its data for the last sample!
 *
 * Revision 1.1.1.1  1998/11/16 03:57:26  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:00  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:23  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2  1998/10/18 23:44:03  nevil
 * Added Nicolai's patches, some 'tidying up' of the source
 *
 * Revision 1.1.3.1  1998/10/13 02:48:15  nevil
 * Import of Nicolai's 4.2.2
 *
 * Revision 1.1.1.1  1998/08/24 12:09:28  nguba
 * NetraMet 4.2 Original Distribution
 *
 * Revision 1.4  1998/07/21 00:43:57  rtfm
 * Change attrib numbers for 'New Attribs' I-D
 * First release version of SRL
 *
 * Revision 1.3  1998/05/07 04:28:53  rtfm
 * Implement NetFlowMet, the Cisco NetFlow RTFM meter
 */

#ifndef EXTERN
#define EXTERN  extern
#define DECLARE  0
#define INIT(v)
#else
#define EXTERN
#define DECLARE  1
#define INIT(v)  = v
#endif

extern int errno;

EXTERN int snmp_dump_packet INIT(0);

EXTERN int verbose, testing, listrules, listformat, quiet;

#define MXTAGS  200
#define MXCOLS   20

/* fd_filter and fd_extract treat addresses as strings,
   maaximum lengths as follows .. */

#define MAC_ADDR_LEN      6
#define PEER_ADDR_LEN    20
#define TRANS_ADDR_LEN    2

#define RULE_ADDR_LEN    20

#if NEW_ATR
#define TCP_DATA_LEN   40
struct subflow_data {
   Bit32 n_subflows, mx_active_subflows,
      ToTCPDecrSeq, FromTCPDecrSeq;
   counter64
      ToTCPLenOctets, FromTCPLenOctets,
      ToTCPSeqOctets, FromTCPSeqOctets,
      ToTCPAckOctets, FromTCPAckOctets;
   };

#define DIST_PARAM_LEN  6
#define MXBUCKETS     100
struct distribution {
   unsigned char selector;  /* Attribute number */
/*    mask_params[DIST_PARAM_LEN], value_params[DIST_PARAM_LEN]; */
   unsigned int counts[MXBUCKETS+1];

   unsigned int Transform, ScaleFactor; /* 'mask' parameters */
   unsigned int LowerLimit, UpperLimit;
   unsigned int Buckets, Parameter1;  /* 'value' parameters */
   unsigned int Parameter2, Parameter3;

   struct distribution *next;
   };
#define DS_NULL  0  /* Distribution transform type values */
#define DS_LIN   1
#define DS_LOG   2

#define tcp_value(a)     (a == FTTCPDATA)
#endif  /* NEW_ATR */

#define Counter64_value(a)   ( (a >= FTUPOCTETS   && a <= FTDOWNPDUS) \
                            || (a >= FTUPOCTETS_D && a <= FTDOWNPDUS_D) )

#define string_value(a)  (attribs[attr_ix[a]].len > 4)
#define STR_LEN   64

struct flow_info {  /* Accounting flow as viewed by programs */
   unsigned int FlowIndex;
   unsigned int LowInterface, HighInterface;
   unsigned int LowAdjType, HighAdjType;
   unsigned char LowAdjAddress[STR_LEN+1], LowAdjMask[STR_LEN+1],
      HighAdjAddress[STR_LEN+1], HighAdjMask[STR_LEN+1];
   unsigned int
      LowPeerType, HighPeerType;
   unsigned char LowPeerAddress[STR_LEN+1], LowPeerMask[STR_LEN+1],
      HighPeerAddress[STR_LEN+1], HighPeerMask[STR_LEN+1];
   unsigned int
      LowTransType, HighTransType;
   unsigned int   LowTransAddress, LowTransMask,
      HighTransAddress, HighTransMask;
   unsigned int FlowStatus, FlowRuleSet;
   counter64
      FwdPackets,FwdBytes,  BackPackets,BackBytes;
   unsigned int
      FirstTime,LastTime;
   unsigned int LowClass, HighClass, FlowClass;
   unsigned int LowKind, HighKind, FlowKind;
   unsigned int DSCodePoint;

#if defined(NETFLOW)
   unsigned int
      LowRouteASN, HighRouteASN,
      LowRoutePrefix, HighRoutePrefix,  MeterId;
#endif
#if NEW_ATR
   struct subflow_data sfd;
   struct distribution *dist;
   unsigned int
      ToLostPDUs, FromLostPDUs,
      ToPQOverflows, FromPQOverflows;
#endif  /* NEW_ATR */

   counter64  /* New attributes (created by fd_filter) */
      upbci,   /* To byte rate (bytes since last sample) */
      dnbci,   /* From byte rate */
      uppci,   /* To packet rate */
      dnpci;   /* From packet rate */
   unsigned int
      TagNbr;  /* Tag nbr */
#if NEW_ATR
   struct subflow_data sfd_rate;
   unsigned int
      d_ToLostPDUs, d_FromLostPDUs,
      d_ToPQOverflows, d_FromPQOverflows;
   struct distribution *dist_rate;
#endif  /* NEW_ATR */
   };

EXTERN struct flow_info curr_flow;


#define AT_DUMMY       0  /* Addr_type values */

#define AT_IP4         1  /* Address Family Numbers */
#define AT_IP6         2
#define AT_CLNS        3
#define AT_OTHER       6  /* 'generic' 802 address family */
#define AT_ETHERNET    7  /* ifType medium */
#define AT_TOKENRING   9  /* ifType medium */
#define AT_NOVELL     11
#define AT_ETHERTALK  12
#define AT_DECNET     13
#define AT_FDDI       15  /* ifType medium */
#define AT_AAL5       49  /* ifType AAL5 over ATM */

#define MX_PROTOCOLS  AT_DECNET

#define AT3_IGNORE     0  /* Addr_type values */
#define AT3_DUMMY      1
#define AT3_ADJACENT   1
#define AT3_IP         2
#define AT3_CLNS       3
#define AT3_IDPR       4
#define AT3_DECNET     5
#define AT3_NOVELL     6
#define AT3_ETHERTALK  7
#define AT3_TRANS      8
#define AT3_IP_FRAG   11
#define AT3_OTHER     12

EXTERN char new_addr_type[]  /* v3 to v4 AddressType translation */
#if DECLARE
   = {
      0,               /*  0 Default */
      0,               /*  1 Adjacent */
      1,               /*  2 IP */
      3,               /*  3 CLNS */
      0,               /*  4 IDPR */
      13,              /*  5 DECnet */
      11,              /*  6 Novell IPX */
      12,              /*  7 EtherTalk */
      0,               /*  8 Transport */
      0,               /*  9 */
      0,               /* 10 */
      1,               /* 11 IP fragments */
      6,               /* 12 Other */
      }
#endif
   ;

#define PT_ICMP       1  /* IP protocol type values */
#define PT_TCP        6
#define PT_UDP       17
#define PT_OSPF      89

#define WNP_FTPDATA  20  /* Well-known tcp/udp port numbers */
#define WNP_FTP      21
#define WNP_TELNET   23
#define WNP_SMTP     25
#define WNP_DOMAIN   53
#define WNP_GOPHER   70
#define WNP_WWW      80
#define WNP_NNTP    119
#define WNP_NTP     123
#define WNP_SNMP    161

#define RF_SET       -2  /* -1 is EOF !!! */
#define RF_RULES     -3
#define RF_ACTIONS   -4
#define RF_FORMAT    -5
#define RF_STATS     -6
#define RF_TAG       -7
#define RF_COLUMN    -8
#define RF_TIME      -9

#define OP_EQ       -41
#define OP_NE       -42

#define EX_SCALE    -51  /* Keywords for fd_extract */
#define EX_KILO     -52
#define EX_MEGA     -53
#define EX_ELAPSED  -54
#define EX_CLOCK    -55
#define EX_SECS     -56
#define EX_MINS     -57
#define EX_HOURS    -58
#define EX_DAYS     -59

#define FTFLOWINDEX		1  /* Flow table attribute values */
#define FTFLOWTIMEMARK          2
#define FTFLOWSTATUS		3

#define FTLOWINTERFACE          4
#define FTLOWADJACENTTYPE       5
#define FTLOWADJACENTADDRESS    6
#define FTLOWADJACENTMASK       7
#define FTLOWPEERTYPE		8
#define FTLOWPEERADDRESS	9
#define FTLOWPEERMASK	       10
#define FTLOWTRANSTYPE         11
#define FTLOWTRANSADDRESS      12
#define FTLOWTRANSMASK         13

#define FTHIINTERFACE          14
#define FTHIADJACENTTYPE       15
#define FTHIADJACENTADDRESS    16
#define FTHIADJACENTMASK       17
#define FTHIPEERTYPE	       18
#define FTHIPEERADDRESS	       19
#define FTHIPEERMASK	       20
#define FTHITRANSTYPE          21
#define FTHITRANSADDRESS       22
#define FTHITRANSMASK          23

#define FTPDUSCALE             24
#define FTOCTETSCALE           25
#define FTRULESET              26
#define FTUPOCTETS	       27
#define FTUPPDUS	       28
#define FTDOWNOCTETS	       29
#define FTDOWNPDUS	       30
#define FTFIRSTTIME	       31
#define FTLASTTIME	       32

#define FTLOWSUBSCRIBERID      33
#define FTHISUBSCRIBERID       34
#define FTSESSIONID            35

#define FTSOURCECLASS          36
#define FTDESTCLASS            37
#define FTFLOWCLASS            38
#define FTSOURCEKIND           39
#define FTDESTKIND             40
#define FTFLOWKIND             41

#define FTDSCODEPOINT         118

#define FTUPOCTETS_D	      127  /* Rate attributes (added by fd_filter) */
#define FTUPPDUS_D	      128
#define FTDOWNOCTETS_D	      129
#define FTDOWNPDUS_D	      130
#define FTTAGNBR              131

#if !NEW_ATR
#define N_OLD_ATRS   (FTFLOWKIND + 1 + 5)  /* DSCP + 5 rate attributes */
#define LASTATTRIB       FTTAGNBR   /* Probably redefined below */
#else
#define FTTOLOSTPDUS          121
#define FTFROMLOSTPDUS        122
#define FTTOPQOVERFLOWS       123  /* PQOF */
#define FTFROMPQOVERFLOWS     124

#define FTTOLOSTPDUS_D        132
#define FTFROMLOSTPDUS_D      133
#define FTTOPQOVERFLOWS_D     134  /* PQOF */
#define FTFROMPQOVERFLOWS_D   135
#define N_OLD_ATRS   (FTFLOWKIND + 1+4 + 5+8)
#define LASTATTRIB  FTFROMPQOVERFLOWS_D   /* Probably redefined below */
#endif


#if !defined(NEW_ATR)
#define N_DIST_ATRS        0
#else
#define FTDISTRIBUTIONS        65 /* Bit set for each distribution in flow */
#define FTTOPACKETSIZE         66
#define FTFROMPACKETSIZE       67
#define FTTOINTERARRIVALTIME   68
#define FTFROMINTERARRIVALTIME 69
#define FTTOTURNAROUNDTIME     70
#define FTFROMTURNAROUNDTIME   71
#define FTTOBITRATE            72
#define FTFROMBITRATE          73
#define FTTOPDURATE            74
#define FTFROMPDURATE          75

#define FTTOTCPTIME            76
#define FTFROMTCPTIME          77
#define FTTOTCPSIZE            78
#define FTFROMTCPSIZE          79
#define FTTOTCPRATE1           80
#define FTFROMTCPRATE1         81
#define FTTOTCPRATE2           82
#define FTFROMTCPRATE2         83

#define FTTOTURNAROUNDTIME1    70
#define FTFROMTURNAROUNDTIME1  71
#define FTTOTURNAROUNDTIME2    84
#define FTFROMTURNAROUNDTIME2  85
#define FTTOTURNAROUNDTIME3    86
#define FTFROMTURNAROUNDTIME3  87
#define FTTOTURNAROUNDTIME4    88
#define FTFROMTURNAROUNDTIME4  89

#define FTTOFLOWOCTETS         90
#define FTFROMFLOWOCTETS       91
#define FTTOFLOWPDUS           92
#define FTFROMFLOWPDUS         93
#define FTFLOWTIME             94

#define LAST_DISTRIB        FTFLOWTIME

#define FTTOPACKETSIZE_D          166  /* Rates for fd_filter */
#define FTFROMPACKETSIZE_D        167
#define FTTOINTERARRIVALTIME_D    168
#define FTFROMINTERARRIVALTIME_D  169
#define FTTOTURNAROUNDTIME_D      170
#define FTFROMTURNAROUNDTIME_D    171
#define FTTOBITRATE_D             172
#define FTFROMBITRATE_D           173
#define FTTOPDURATE_D             174
#define FTFROMPDURATE_D           175

#define FTTOTCPTIME_D             176
#define FTFROMTCPTIME_D           177
#define FTTOTCPSIZE_D             178
#define FTFROMTCPSIZE_D           179
#define FTTOTCPRATE1_D            180
#define FTFROMTCPRATE1_D          181
#define FTTOTCPRATE2_D            182
#define FTFROMTCPRATE2_D          183

#define FTTOTURNAROUNDTIME1_D     170
#define FTFROMTURNAROUNDTIME1_D   171
#define FTTOTURNAROUNDTIME2_D     184
#define FTFROMTURNAROUNDTIME2_D   185
#define FTTOTURNAROUNDTIME3_D     186
#define FTFROMTURNAROUNDTIME3_D   187
#define FTTOTURNAROUNDTIME4_D     188
#define FTFROMTURNAROUNDTIME4_D   189

#define FTTOFLOWOCTETS_D          190
#define FTFROMFLOWOCTETS_D        191
#define FTTOFLOWPDUS_D            192
#define FTFROMFLOWPDUS_D          193
#define FTFLOWTIME_D              194

#define LAST_DISTRIB_D      FTFLOWTIME_D

#define DISTRIB_ATTRIB(a)  (a >= FTTOPACKETSIZE && \
                            a <= LAST_DISTRIB)
#define DISTRIB_BASE       FTTOPACKETSIZE
#define DELTA_ATTRIB(a)    (a >= FTTOPACKETSIZE_D && \
                            a <= LAST_DISTRIB_D)
#define DELTA_BASE         FTTOPACKETSIZE_D
#define N_DIST_ATRS        (1+(LAST_DISTRIB - FTDISTRIBUTIONS)*2)
# if LASTATTRIB < LAST_DISTRIB_D
#  undef LASTATTRIB
#  define LASTATTRIB       LAST_DISTRIB_D  /* max(basic, dist) */
# endif
#endif

#if !defined(NETFLOW)
#define N_NF_ATRS        0
#else
#define FTMETERID             112
#define FTLOWROUTEASN         113
#define FTLOWROUTEPREFIX      114
#define FTHIROUTEASN          115
#define FTHIROUTEPREFIX       116

#define NF_ATTRIB(a)  (a >= FTMETERID && a <= FTHIASWIDTH)
#define N_NF_ATRS     (FTHIROUTEPREFIX+1 - FTMETERID)
# if LASTATTRIB < FTHIROUTEPREFIX
#  undef LASTATTRIB
#  define LASTATTRIB    FTHIROUTEPREFIX  /* max(basic, dist, nf) */
# endif
#endif

#if !defined(NEW_ATR)
#define N_TCP_ATRS        0
#else
#define FTTCPDATA             125
#define FTTCPDATA_D           225
#define N_TCP_ATRS              2
# undef LASTATTRIB
# define LASTATTRIB   FTTCPDATA_D  /* max(basic, dist, nf, tcp) */
#endif

#define N_ATTRIBS  (N_OLD_ATRS + N_DIST_ATRS \
                      + N_NF_ATRS + N_TCP_ATRS)


typedef union {
   unsigned int *intval;
   unsigned char *charval;
   counter64 *c64val;
#if NEW_ATR
   struct subflow_data *sfval;
   struct distribution **distval;
#endif
   } val;
struct attrib_info {
   char *name;
   unsigned char index;
   unsigned char len;
   val value;
   };

EXTERN int attr_ix[1+LASTATTRIB];  /* Index to attribs[] */

#define N_SYNONYMS   2+2
     /* Synonyms: To/FromTurnaroundTime + TAT rates */

#define SZ_ATTRIBS  (1 + N_OLD_ATRS + 4 + \
                         N_DIST_ATRS + N_NF_ATRS + N_TCP_ATRS + \
                         N_SYNONYMS)
                  /* 1: 'null,'  4: old 'rate's */
EXTERN struct attrib_info attribs[SZ_ATTRIBS]
#if DECLARE
   = {
   "null",                  0,                      0,              NULL,
   "flowindex",             FTFLOWINDEX,            4,              NULL,
   "flowtimemark",          FTFLOWTIMEMARK,         4,              NULL,
   "flowstatus",            FTFLOWSTATUS,           1,              NULL,
   "sourceinterface",       FTLOWINTERFACE,         1,              NULL,
   "sourceadjacenttype",    FTLOWADJACENTTYPE,      1,              NULL,
   "sourceadjacentaddress", FTLOWADJACENTADDRESS,   MAC_ADDR_LEN,   NULL,
   "sourceadjacentmask",    FTLOWADJACENTMASK,      MAC_ADDR_LEN,   NULL,
   "sourcepeertype",        FTLOWPEERTYPE,          1,              NULL,
   "sourcepeeraddress",     FTLOWPEERADDRESS,       PEER_ADDR_LEN,  NULL,
   "sourcepeermask",        FTLOWPEERMASK,          PEER_ADDR_LEN,  NULL,
   "sourcetranstype",       FTLOWTRANSTYPE,         1,              NULL,
   "sourcetransaddress",    FTLOWTRANSADDRESS,      TRANS_ADDR_LEN, NULL,
   "sourcetransmask",       FTLOWTRANSMASK,         TRANS_ADDR_LEN, NULL,

   "destinterface",         FTHIINTERFACE,          1,              NULL,
   "destadjacenttype",      FTHIADJACENTTYPE,       1,              NULL,
   "destadjacentaddress",   FTHIADJACENTADDRESS,    MAC_ADDR_LEN,   NULL,
   "destadjacentmask",      FTHIADJACENTMASK,       MAC_ADDR_LEN,   NULL,
   "destpeertype",          FTHIPEERTYPE,           1,              NULL,
   "destpeeraddress",       FTHIPEERADDRESS,        PEER_ADDR_LEN,  NULL,
   "destpeermask",          FTHIPEERMASK,           PEER_ADDR_LEN,  NULL,
   "desttranstype",         FTHITRANSTYPE,          1,              NULL,
   "desttransaddress",      FTHITRANSADDRESS,       TRANS_ADDR_LEN, NULL,
   "desttransmask",         FTHITRANSMASK,          TRANS_ADDR_LEN, NULL,

   "pduscale",              FTPDUSCALE,             0,              NULL,
   "octetscale",            FTOCTETSCALE,           0,              NULL,
   "flowruleset",           FTRULESET,              1,              NULL,
   "tooctets",              FTUPOCTETS,             8,              NULL,
   "topdus",                FTUPPDUS,               8,              NULL,
   "fromoctets",            FTDOWNOCTETS,           8,              NULL,
   "frompdus",              FTDOWNPDUS,             8,              NULL,
   "firsttime",             FTFIRSTTIME,            4,              NULL,
   "lasttime",              FTLASTTIME,             4,              NULL,

   "sourcesubscriberid",    FTLOWSUBSCRIBERID,      0,              NULL,
   "destsubscriberid",      FTHISUBSCRIBERID,       0,              NULL,
   "sessionid",             FTSESSIONID,            0,              NULL,

   "sourceclass",           FTSOURCECLASS,          1,              NULL,
   "destclass",             FTDESTCLASS,            1,              NULL,
   "flowclass",             FTFLOWCLASS,            1,              NULL,
   "sourcekind",            FTSOURCEKIND,           1,              NULL,
   "destkind",              FTDESTKIND,             1,              NULL,
   "flowkind",              FTFLOWKIND,             1,              NULL,

   "tooctetrate",           FTUPOCTETS_D,           8,              NULL,
   "topdurate",             FTUPPDUS_D,             8,              NULL,
   "fromoctetrate",         FTDOWNOCTETS_D,         8,              NULL,
   "frompdurate",           FTDOWNPDUS_D,           8,              NULL,
   "d_tooctets",            FTUPOCTETS_D,           8,              NULL,
   "d_topdus",              FTUPPDUS_D,             8,              NULL,
   "d_fromoctets",          FTDOWNOCTETS_D,         8,              NULL,
   "d_frompdus",            FTDOWNPDUS_D,           8,              NULL,

   "tagnbr",                FTTAGNBR,               1,              NULL,

   "dscodepoint",           FTDSCODEPOINT,          1,              NULL

#if defined(NEW_ATR)
   ,
   "tolostpdus",            FTTOLOSTPDUS,           4,              NULL,
   "fromlostpdus",          FTFROMLOSTPDUS,         4,              NULL,
   "d_tolostpdus",          FTTOLOSTPDUS_D,         4,              NULL,
   "d_fromlostpdus",        FTFROMLOSTPDUS_D,       4,              NULL,
   "topqoverflows",         FTTOPQOVERFLOWS,        4,              NULL,
   "frompqoverflows",       FTFROMPQOVERFLOWS,      4,              NULL,
   "d_topqoverflows",       FTTOPQOVERFLOWS_D,      4,              NULL,
   "d_frompqoverflows",     FTFROMPQOVERFLOWS_D,    4,              NULL,

   "distributions",         FTDISTRIBUTIONS,        0,              NULL,
   "topacketsize",          FTTOPACKETSIZE,         DIST_PARAM_LEN, NULL,
   "frompacketsize",        FTFROMPACKETSIZE,       DIST_PARAM_LEN, NULL,
   "tointerarrivaltime",    FTTOINTERARRIVALTIME,   DIST_PARAM_LEN, NULL,
   "frominterarrivaltime",  FTFROMINTERARRIVALTIME, DIST_PARAM_LEN, NULL,
   "toturnaroundtime",      FTTOTURNAROUNDTIME,     DIST_PARAM_LEN, NULL,
   "fromturnaroundtime",    FTFROMTURNAROUNDTIME,   DIST_PARAM_LEN, NULL,
   "tobitrate",             FTTOBITRATE,            DIST_PARAM_LEN, NULL,
   "frombitrate",           FTFROMBITRATE,          DIST_PARAM_LEN, NULL,
   "topktrate",             FTTOPDURATE,            DIST_PARAM_LEN, NULL,
   "frompktrate",           FTFROMPDURATE,          DIST_PARAM_LEN, NULL,

   "totcptime",             FTTOTCPTIME,            DIST_PARAM_LEN, NULL,
   "fromtcptime",           FTFROMTCPTIME,          DIST_PARAM_LEN, NULL,
   "totcpsize",             FTTOTCPSIZE,            DIST_PARAM_LEN, NULL,
   "fromtcpsize",           FTFROMTCPSIZE,          DIST_PARAM_LEN, NULL,
   "totcprate1",            FTTOTCPRATE1,           DIST_PARAM_LEN, NULL,
   "fromtcprate1",          FTFROMTCPRATE1,         DIST_PARAM_LEN, NULL,
   "totcprate2",            FTTOTCPRATE2,           DIST_PARAM_LEN, NULL,
   "fromtcprate2",          FTFROMTCPRATE2,         DIST_PARAM_LEN, NULL,

   "toturnaroundtime1",     FTTOTURNAROUNDTIME1,    DIST_PARAM_LEN, NULL,
   "fromturnaroundtime1",   FTFROMTURNAROUNDTIME1,  DIST_PARAM_LEN, NULL,
   "toturnaroundtime2",     FTTOTURNAROUNDTIME2,    DIST_PARAM_LEN, NULL,
   "fromturnaroundtime2",   FTFROMTURNAROUNDTIME2,  DIST_PARAM_LEN, NULL,
   "toturnaroundtime3",     FTTOTURNAROUNDTIME3,    DIST_PARAM_LEN, NULL,
   "fromturnaroundtime3",   FTFROMTURNAROUNDTIME3,  DIST_PARAM_LEN, NULL,
   "toturnaroundtime4",     FTTOTURNAROUNDTIME4,    DIST_PARAM_LEN, NULL,
   "fromturnaroundtime4",   FTFROMTURNAROUNDTIME4,  DIST_PARAM_LEN, NULL,

   "toflowoctets",          FTTOFLOWOCTETS,         DIST_PARAM_LEN, NULL,
   "fromflowoctets",        FTFROMFLOWOCTETS,       DIST_PARAM_LEN, NULL,
   "toflowpdus",            FTTOFLOWPDUS,           DIST_PARAM_LEN, NULL,
   "fromflowpdus",          FTFROMFLOWPDUS,         DIST_PARAM_LEN, NULL,
   "flowtime",              FTFLOWTIME,             DIST_PARAM_LEN,  NULL,

   "d_topacketsize",         FTTOPACKETSIZE_D,         DIST_PARAM_LEN, NULL,
   "d_frompacketsize",       FTFROMPACKETSIZE_D,       DIST_PARAM_LEN, NULL,
   "d_tointerarrivaltime",   FTTOINTERARRIVALTIME_D,   DIST_PARAM_LEN, NULL,
   "d_frominterarrivaltime", FTFROMINTERARRIVALTIME_D, DIST_PARAM_LEN, NULL,
   "d_toturnaroundtime",     FTTOTURNAROUNDTIME_D,     DIST_PARAM_LEN, NULL,
   "d_fromturnaroundtime",   FTFROMTURNAROUNDTIME_D,   DIST_PARAM_LEN, NULL,
   "d_tobitrate",            FTTOBITRATE_D,            DIST_PARAM_LEN, NULL,
   "d_frombitrate",          FTFROMBITRATE_D,          DIST_PARAM_LEN, NULL,
   "d_topktrate",            FTTOPDURATE_D,            DIST_PARAM_LEN, NULL,
   "d_frompktrate",          FTFROMPDURATE_D,          DIST_PARAM_LEN, NULL,

   "d_totcptime",            FTTOTCPTIME_D,            DIST_PARAM_LEN, NULL,
   "d_fromtcptime",          FTFROMTCPTIME_D,          DIST_PARAM_LEN, NULL,
   "d_totcpsize" ,           FTTOTCPSIZE_D,            DIST_PARAM_LEN, NULL,
   "d_fromtcpsize",          FTFROMTCPSIZE_D,          DIST_PARAM_LEN, NULL,
   "d_totcprate1",           FTTOTCPRATE1_D,           DIST_PARAM_LEN, NULL,
   "d_fromtcprate1",         FTFROMTCPRATE1_D,         DIST_PARAM_LEN, NULL,
   "d_totcprate2",           FTTOTCPRATE2_D,           DIST_PARAM_LEN, NULL,
   "d_fromtcprate2",         FTFROMTCPRATE2_D,         DIST_PARAM_LEN, NULL,

   "d_toturnaroundtime1",   FTTOTURNAROUNDTIME1_D,     DIST_PARAM_LEN, NULL,
   "d_fromturnaroundtime1", FTFROMTURNAROUNDTIME1_D,   DIST_PARAM_LEN, NULL,
   "d_toturnaroundtime2",   FTTOTURNAROUNDTIME2_D,     DIST_PARAM_LEN, NULL,
   "d_fromturnaroundtime2", FTFROMTURNAROUNDTIME2_D,   DIST_PARAM_LEN, NULL,
   "d_toturnaroundtime3",   FTTOTURNAROUNDTIME3_D,     DIST_PARAM_LEN, NULL,
   "d_fromturnaroundtime3", FTFROMTURNAROUNDTIME3_D,   DIST_PARAM_LEN, NULL,
   "d_toturnaroundtime4",   FTTOTURNAROUNDTIME4_D,     DIST_PARAM_LEN, NULL,
   "d_fromturnaroundtime4", FTFROMTURNAROUNDTIME4_D,   DIST_PARAM_LEN, NULL,

   "d_toflowoctets",        FTTOFLOWOCTETS_D,          DIST_PARAM_LEN, NULL,
   "d_fromflowoctets",      FTFROMFLOWOCTETS_D,        DIST_PARAM_LEN, NULL,
   "d_toflowpdus",          FTTOFLOWPDUS_D,            DIST_PARAM_LEN, NULL,
   "d_fromflowpdus",        FTFROMFLOWPDUS_D,          DIST_PARAM_LEN, NULL,
   "d_flowtime",            FTFLOWTIME_D,              DIST_PARAM_LEN, NULL
#endif

#if defined(NETFLOW)
   ,
   "meterid",               FTMETERID,              1,              NULL,
   "sourceasn",             FTLOWROUTEASN,          TRANS_ADDR_LEN, NULL,
   "sourceprefix",          FTLOWROUTEPREFIX,       1,              NULL,
   "destasn",               FTHIROUTEASN,           TRANS_ADDR_LEN, NULL,
   "destprefix",            FTHIROUTEPREFIX,        1,              NULL
#endif

#if NEW_ATR
   ,
   "tcpdata",               FTTCPDATA,              TCP_DATA_LEN,   NULL,
   "d_tcpdata",             FTTCPDATA_D,            TCP_DATA_LEN,   NULL
#endif

   }
#endif
   ;

struct flow_stats {

   unsigned char format[1+N_ATTRIBS];
   char *separator[1+N_ATTRIBS];
   int n_attr;
   unsigned char required[1+LASTATTRIB];
#if NEW_ATR
   unsigned long distrib_bits, delta_bits;
#endif  /* NEW_ATR */

   FILE *flows;
   int MIBver;
   };



EXTERN FILE *rfp;  /* Scanner globals */
EXTERN char inbuf[12000],*ibp, ebuf[80];  /* Input, error message buffers */
EXTERN int lic, ic,  /* Last input char, current input char */
   iblisted, rule_line, rferrors;


/* Forward procedure declarations .. */

/* Functions declared in fd_parse.c */

char *gnbr(unsigned int *n, char *s);
char *gcstring(char *s, int *len);

int parse_open(char *fn);
void p_error(char *msg);
int nextchar(void);
int nexttoken(void);
int relop_next(void);
void getfdstring(unsigned char *arg);
int wordis(char *p, char *w);
int getword(void);
int getnbr(void);

void scan_format(struct flow_stats *fs, int single_record, int list);

val attrib_ptr(struct flow_info *fip, int a);
char *get_value(val v, int a, char *pb);
void put_value(FILE *out, int a, val v);

#if NEW_ATR
struct distribution *get_dist(void);
void free_dist(struct distribution *d);
#endif  /* NEW_ATR */
