/* 1325, Wed 10 Sep 97

   F64_TEST.C:  Test 64-bit get/put routines

   Copyright (C) 1997-2002 by Nevil Brownlee
   CAIDA | University of Auckland */

/*
 * $Log: f64_test.c,v $
 * Revision 1.1.1.2.2.7  2002/02/23 01:57:15  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.3  2000/06/06 03:38:07  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2  1999/10/03 21:06:13  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:27  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1  1998/11/16 03:57:26  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:00  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:23  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2  1998/10/18 23:44:02  nevil
 * Added Nicolai's patches, some 'tidying up' of the source
 *
 * Revision 1.1.3.1  1998/10/13 02:48:15  nevil
 * Import of Nicolai's 4.2.2
 *
 * Revision 1.1.1.1  1998/08/24 12:09:28  nguba
 * NetraMet 4.2 Original Distribution
 *
 * Revision 1.3  1998/05/07 04:28:53  rtfm
 * Implement NetFlowMet, the Cisco NetFlow RTFM meter
 */

#if HAVE_CONFIG_H
#include <ntm_conf.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ausnmp.h"
#include "asn1.h"
/* #include "nmc.h" */
#define EXTERN
#include "nmc_c64.h"

void test(counter64 *c)
{
   char buf[50], *bp;
   counter64 z;
   bp = putc64(buf, c);
   *bp = '\0';
   printf(" >> %s  len=%d\n", buf, bp-buf);
   bp = getc64(&z, buf);
#if SIZEOF_LONG == 4
   printf(" << %lx %lx  len=%d\n", z.high,z.low, bp-buf);
#else
   printf(" << %lx  len=%d\n", z, bp-buf);
#endif
   }

int main(int argc,char *argv[])
{
   counter64 t;
   counter64 cc, m;
   int x, r;

#if WORDS_BIGENDIAN
   printf("WORDS_BIGENDIAN = 1");
#else
   printf("WORDS_BIGENDIAN = 0");
#endif
   printf(", SIZEOF_LONG = %d\n",SIZEOF_LONG); 


#if SIZEOF_LONG == 4
   cc.high = cc.low = 0;
   test(&cc);

   cc.high = 0;  cc.low = 1;
   for (x = 0; x != 10; ++x) {
      c64timesu16((union u64 *)&m, (union u64 *)&cc, 100);
      memcpy(&cc, &m, sizeof(counter64));
      printf("%2d:  %lx %lx\n", x+1, cc.high,cc.low);

#else

   cc = 0;
   test(&cc);

   cc = 1;
   for (x = 0; x != 10; ++x) {
      cc *= 100;
      printf("%2d:  %lx\n", x+1, cc);
#endif
      test(&cc);
      }

   }
