/* 
 * Motif Tools Library, Version 3.1
 * $Id: Icons.c,v 1.1.1.1 2001/07/18 11:06:02 root Exp $
 * 
 * Written by David Flanagan.
 * Copyright (c) 1992-2001 by David Flanagan.
 * All Rights Reserved.  See the file COPYRIGHT for details.
 * This is open source software.  See the file LICENSE for details.
 * There is no warranty for this software.  See NO_WARRANTY for details.
 *
 * $Log: Icons.c,v $
 * Revision 1.1.1.1  2001/07/18 11:06:02  root
 * Initial checkin.
 *
 * Revision 1.2  2001/06/12 16:25:28  andre
 * *** empty log message ***
 *
 *
 */

#include <Xmt/Xmt.h>
#include <Xmt/Xpm.h>
#include <Xmt/AppResP.h>
#include <X11/IntrinsicP.h>

/* XPM */
static char * information[] = {
"20 48 2 1",
" 	c None",
".	c #00FF00",
"                    ",
"                    ",
"       ....         ",
"     ........       ",
"    ..........      ",
"   ............     ",
"   ............     ",
"   ............     ",
"   ............     ",
"   ............     ",
"   ............     ",
"    ..........      ",
"     ........       ",
"      ......        ",
"                    ",
"                    ",
"  ............      ",
" ..............     ",
" ..............     ",
" ..............     ",
"  .............     ",
"   ............     ",
"    ...........     ",
"     ..........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"      .........     ",
"   ...............  ",
" .................. ",
" .................. ",
" .................. ",
" .................. ",
" .................. ",
" .................. ",
"  ................. ",
"                    "};

/* XPM */
static char * error[] = {
"48 48 3 1",
"       c None",
".      c #FF0000",
"+      c #FFFFFF",
"               .................                ",
"              ...................               ",
"             .....................              ",
"            .......................             ",
"           .........................            ",
"          ...........................           ",
"         .............................          ",
"        ...............................         ",
"       .................................        ",
"      .............+++++++++++...........       ",
"     .............+++++++++++++...........      ",
"    .............+++++++++++++++...........     ",
"   ...............+++++++++++++++...........    ",
"  .................+++++++++++++++...........   ",
" ...................+++++++++++++++...........  ",
".....................+++++++++++++++........... ",
"......................+++++++++++++++...........",
"..........++...........+++++++++++++++..........",
"..........+++...........++++++++++++++..........",
"..........++++...........+++++++++++++..........",
"..........+++++...........++++++++++++..........",
"..........++++++...........+++++++++++..........",
"..........+++++++...........++++++++++..........",
"..........++++++++...........+++++++++..........",
"..........+++++++++...........++++++++..........",
"..........++++++++++...........+++++++..........",
"..........+++++++++++...........++++++..........",
"..........++++++++++++...........+++++..........",
"..........+++++++++++++...........++++..........",
"..........++++++++++++++...........+++..........",
"..........+++++++++++++++...........++..........",
"...........+++++++++++++++......................",
" ...........+++++++++++++++.....................",
"  ...........+++++++++++++++................... ",
"   ...........+++++++++++++++.................  ",
"    ...........+++++++++++++++...............   ",
"     ...........+++++++++++++++.............    ",
"      ...........+++++++++++++.............     ",
"       ...........+++++++++++.............      ",
"        .................................       ",
"         ...............................        ",
"          .............................         ",
"           ...........................          ",
"            .........................           ",
"             .......................            ",
"              .....................             ",
"               ...................              ",
"                .................               "};

/* XPM */
static char * warning[] = {
"16 48 2 1",
" 	c None",
".	c #FF8017",
"      ....      ",
"    ........    ",
"   ..........   ",
"  ............  ",
"  ............  ",
" .............. ",
" .............. ",
"................",
"................",
"................",
"................",
"................",
"................",
"................",
"................",
" .............. ",
" .............. ",
" .............. ",
"  ............  ",
"  ............  ",
"  ............  ",
"  ............  ",
"   ..........   ",
"   ..........   ",
"   ..........   ",
"   ..........   ",
"   ..........   ",
"   ..........   ",
"   ..........   ",
"   ..........   ",
"   ..........   ",
"   ..........   ",
"    ........    ",
"                ",
"                ",
"                ",
"      ....      ",
"    ........    ",
"   ..........   ",
"   ..........   ",
"  ............  ",
"  ............  ",
"  ............  ",
"  ............  ",
"   ..........   ",
"   ..........   ",
"    ........    ",
"      ....      "};

#if NeedFunctionPrototypes
void XmtRegisterImprovedIcons(Widget w, XmtColorTable ctable)
#else
void XmtRegisterImprovedIcons(w, ctable)
Widget w;
XmtColorTable ctable;
#endif
{
    XmtImage *ii, *ei, *wi;
    XImage *ixi, *exi, *wxi;
    Widget shell = XmtGetShell(w);
    Visual *visual = XmtGetVisual(shell);
    Colormap cmap = shell->core.colormap;
    int depth = shell->core.depth;
    XmtAppResources *appres;

    ii = XmtParseXpmData(information);
    ei = XmtParseXpmData(error);
    wi = XmtParseXpmData(warning);

    if (!ctable) {
	appres = XmtGetApplicationResources(shell);
	ctable = appres->colortable;
    }
    
    if (XmtCreateXImageFromXmtImage(shell, visual, cmap, depth, ctable,
				    ii, &ixi, NULL, NULL, NULL))
	XmInstallImage(ixi, "xm_information");

    if (XmtCreateXImageFromXmtImage(shell, visual, cmap, depth, ctable,
				    ei, &exi, NULL, NULL, NULL))
	XmInstallImage(exi, "xm_error");

    if (XmtCreateXImageFromXmtImage(shell, visual, cmap, depth, ctable,
				    wi, &wxi, NULL, NULL, NULL))
	XmInstallImage(wxi, "xm_warning");

    XmtFreeXmtImage(ii);
    XmtFreeXmtImage(ei);
    XmtFreeXmtImage(wi);
}
