// EXchess source code, (c) Daniel C. Homan  1997-2000
// Released under the GNU public license, see file license.txt

#include "define.h"
#include "chess.h"
#include "const.h"
#include "funct.h"

#if BORLAND
 #include <sys/timeb.h>
#else
 #include <sys/time.h>
#endif

// Function return the time since an arbitrary reference in
// 100ths of a second
long GetTime()
{
#if BORLAND
  struct timeb tval;

  ftime(&tval);
  return (tval.time*100 + long(float(tval.millitm)/10));
#else
  struct timeval tval;
  struct timezone tzone;

  if(!gettimeofday(&tval,&tzone))
   return (tval.tv_sec*100 + long(float(tval.tv_usec)/10000));
  else return (time(NULL)*100);
#endif
}

/*---------- Random Number Generators --------------*/

// random number generator: ran1 from Numerical Recipes in C
#define IA 16807
#define IM 2147483647
#define AM (1.0/IM)
#define IQ 127773
#define IR 2836
#define NTAB 32
#define NDIV (1+(IM-1)/NTAB)
#define EPS 1.2e-7
#define RNMX (1.0-EPS)

float ran(long *idum)
{
   int j;
   long k;
   static long iy=0;
   static long iv[NTAB];
   float temp;

   if (*idum <= 0 || !iy) {
       if (-(*idum) < 1) *idum=1;
       else *idum = -(*idum);
       for (j=NTAB+7; j>=0;j--) {
           k=(*idum)/IQ;
           *idum=IA*(*idum-k*IQ)-IR*k;
           if (*idum < 0) *idum += IM;
           if (j < NTAB) iv[j] = *idum;
       }
       iy=iv[0];
   }
   k=(*idum)/IQ;
   *idum=IA*(*idum-k*IQ)-IR*k;
   if (*idum < 0) *idum += IM;
   j=iy/NDIV;
   iy =iv[j];
   iv[j] = *idum;
   if ((temp=AM*iy) > RNMX) return RNMX;
   else return temp;
}

/* function to return a random bit */
unsigned long ibit(long *idum)
{
  if (ran(idum) > 0.5) return 1;
  return 0;
}


