static char wacct_c_rcsid[]="wacct.c,v 1.2 1994/12/01 14:46:06 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * wacct.c,v
 * Revision 1.2  1994/12/01  14:46:06  kerce
 * Solaris 2.x mods
 *
 * Revision 1.1.1.1  1994/06/18  19:43:28  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#define MAINPROGRAM
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#if defined(SYSV) || defined(SVR4)
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include "error.h"
#include "proto.h"
#include "stdstuff.h"
#include "util.h"
#include "acctfile.h"

/*
 * Randint(low, high) gives an integer value between low and
 * high inclusive.
 */
#define Randint(low,high) ((low + (high-low+1) * Rand()))

#ifdef sun
long random ();
void srandom PROTO((int seed));
#else
#define random rand
#define srandom srand
#endif

char *ProgramName = NULL;
void (*FatalErrorHook)();

double
Rand ()
{
  return (((double) random ()) / (double) (pow (2.0, 31.0) - 1));
}

void
WriteAcctFile (NumAcctFileWrites, AcctFileName, MinStartTime, MaxJobTime,
	      MaxSubStartOffsetTime)
     unsigned long NumAcctFileWrites;
     char *AcctFileName;
     unsigned long MinStartTime;
     unsigned long MaxJobTime;
     unsigned long MaxSubStartOffsetTime;
{
  int write_dusageResult;
  unsigned long NumWrites, RandMaxJobTime;
  dqs_rusage_type DUsage;
  string QComplex;
  FILE *AcctFile;

  AcctFile = fopen (AcctFileName, "w");
  if (AcctFile == NULL)
    {
      Error (NULL, 0, errno,
	     "FATAL ERROR: can't open accounting file named `%s'",
	     AcctFileName);
      exit (EXIT_FAILURE);
    }

  DUsage.job_number = 0;
  NumWrites = 0;

  do
    {
      DUsage.qname = "qname";
      DUsage.hostname = "hostname";
      DUsage.master = 1;
      strcpy (QComplex, "qcomplex a b c");
      DUsage.group = "group";
      DUsage.owner = "owner";
      DUsage.job_name = "jobname";
      DUsage.dqs_job_name = "dqs_jobname";
      DUsage.job_number++;
      RandMaxJobTime = Randint (0, MaxJobTime);
/*    printf ("RandMaxJobTime = %lu\n", RandMaxJobTime); */
      DUsage.submission_time = MinStartTime + RandMaxJobTime;
      DUsage.start_time =
	DUsage.submission_time + Randint (0, MaxSubStartOffsetTime);
      DUsage.end_time =
	DUsage.start_time
	  + Randint (0, (MinStartTime + MaxJobTime - DUsage.start_time));
      DUsage.exit_status = 1;
      DUsage.ru_wallclock = DUsage.end_time - DUsage.start_time;
      DUsage.ru_utime = Randint (0, DUsage.ru_wallclock);
      DUsage.ru_stime = Randint (0, DUsage.ru_utime);
      DUsage.ru_maxrss = 2;
      DUsage.ru_ixrss = 3;
      DUsage.ru_ismrss = 4;
      DUsage.ru_idrss = 5;
      DUsage.ru_isrss = 6;
      DUsage.ru_minflt = 7;
      DUsage.ru_majflt = 8;
      DUsage.ru_nswap = 9;
      DUsage.ru_inblock = 0;
      DUsage.ru_oublock = 1;
      DUsage.ru_msgsnd = 2;
      DUsage.ru_msgrcv = 3;
      DUsage.ru_nsignals = 4;
      DUsage.ru_nvcsw = 5;
      DUsage.ru_nivcsw = 6;
      
      write_dusageResult = dqs_write_rusage (AcctFile, &DUsage, QComplex);
      if (write_dusageResult <= 0) {
	char *ErrStr;
	
	if (write_dusageResult == -2)
	  ErrStr = "AcctFile not open";
	else
	  ErrStr = "wrote 0 characcters";
	
	Error (NULL, 0, errno,
	       "FATAL ERROR: write_dusage to accounting file named `%s': %s",
	       AcctFileName, ErrStr);

	exit (EXIT_FAILURE);
      }
      
      NumWrites++;
    }
  while (NumWrites < NumAcctFileWrites);

  fclose (AcctFile);
}

int
main (argc, argv)
     int argc;
     char **argv;
{
  char *AcctFileName;
  long TODSecs;
  unsigned long NumAcctFileWrites, Start, Days, MinStartTime, MaxJobTime;
  unsigned long MaxSubStartOffsetTime;
  int sscanfResult, RandomSeed;
  
  DENTER_MAIN ((DQS_EVENT, "wacct"));
  dqs_setup (QSUB, argv[0]);

  FatalErrorHook = NULL;
  ProgramName = argv[0];

  if ((argc < 2) || (argc > 6))
    {
      fprintf (stderr, "Usage: %s NumAcctFileWrites [Start] [Days] ",
	       ProgramName);
      fprintf (stderr, "[AcctFileName] [RandomSeed]\n");
      exit (EXIT_FAILURE);
    }
    
  sscanfResult = sscanf (argv[1], "%lu", &NumAcctFileWrites);
  if (sscanfResult != 1)
    {
      Error (NULL, 0, errno,
	     "FATAL ERROR: can't parse `%s' for NumAcctFileWrites", argv[1]);
      Error (NULL, 0, 0, "NumAcctFileWrites should be a positive integer");
      exit (EXIT_FAILURE);
    }
  
  if (argc > 2)
    {
      sscanfResult = sscanf (argv[2], "%lu", &Start);
      if (sscanfResult != 1)
	{
	  Error (NULL, 0, errno,
		 "FATAL ERROR: can't parse `%s' for Start", argv[2]);
	  Error (NULL, 0, 0, "Start should be a positive integer");
	  exit (EXIT_FAILURE);
	}
    }
  else
    Start = 7;

  if (argc > 3)
    {
      sscanfResult = sscanf (argv[3], "%lu", &Days);
      if (sscanfResult != 1)
	{
	  Error (NULL, 0, errno,
		 "FATAL ERROR: can't parse `%s' for Days", argv[3]);
	  Error (NULL, 0, 0, "Days should be a positive integer");
	  exit (EXIT_FAILURE);
	}
    }
  else
    Days = 7;

  /*
   *  Validate Start and Days.
   */
  if (Days > Start)
    {
      Error (NULL, 0, 0, "Days must be less than or equal to Start.");
      exit (EXIT_FAILURE);
    }

  if (argc > 4)
    AcctFileName = argv[4];
  else
    {
      AcctFileName = BuildFileName (ACCTF);
      if (AcctFileName == (char *) NULL)
	{
	  Error (NULL, 0, 0,
		 "FATAL ERROR: can't decide on accounting file name");
	  exit (EXIT_FAILURE);
	}
    }

  {
    struct stat statBuf;
    int statResult;

    statResult = stat (AcctFileName, &statBuf);
    if (statResult == 0)
      {
	Error (NULL, 0, 0,
	       "FATAL ERROR: refuse to write over an existing accounting file named `%s'",
	       AcctFileName);
	exit (EXIT_FAILURE);
      }
  }

  if (argc > 5)
    {
      sscanfResult = sscanf (argv[5], "%d", &RandomSeed);
      if (sscanfResult != 1) {
	Error (NULL, 0, errno,
	       "FATAL ERROR: can't parse `%s' for RandomSeed", argv[5]);
	Error (NULL, 0, 0, "RandomSeed should be an integer");
	exit (EXIT_FAILURE);
      }
    }
  else
    RandomSeed = getpid ();
  
  TODSecs = TimeOfDayInSecs ();
  if (TODSecs == -1)
    {
      Error (NULL, 0, errno, "FATAL ERROR: can't determine time of day");
      exit (EXIT_FAILURE);
    }

  MinStartTime = TODSecs - (Start * SECSPERDAY);
  MaxJobTime = Days * SECSPERDAY;
  MaxSubStartOffsetTime = 1000;

  printf ("MinStartTime = %lu\n", MinStartTime);
  printf ("MaxJobTime = %lu\n", MaxJobTime);
  printf ("MaxSubStartOffsetTime = %lu\n", MaxSubStartOffsetTime);
  printf ("RandomSeed = %d\n", RandomSeed);
  printf ("Writing %lu lines to file named ", NumAcctFileWrites);
  printf ("`%s'...", AcctFileName);
  fflush (stdout);

  srandom (RandomSeed);

  WriteAcctFile (NumAcctFileWrites, AcctFileName, MinStartTime, MaxJobTime,
		MaxSubStartOffsetTime);

  printf ("done\n");

  exit (EXIT_SUCCESS);
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
