static char     initdata_rcsid[] = "initdata.c,v 1.1 1994/11/28 16:55:03 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  initdata.c,v
 * Revision 1.1  1994/11/28  16:55:03  kerce
 * Initial revision
 *
 * Revision 1.6  1994/09/13  18:01:59  raju
 * prototyepe declarations
 *
 * Revision 1.5  1994/08/21  02:57:39  raju
 * *** empty log message ***
 *
 * Revision 1.4  1994/08/03  19:00:13  raju
 * this is 1.2 again
 *
 * Revision 1.2  1994/07/20  01:01:35  raju
 * working version of cell_list and current_cell
 *
 * Revision 1.1  1994/07/19  23:24:09  raju
 * Initial revision
 *
 *
 *
 *
 **********************************************************/
#include "globals.h"
#include "qmonerrs.h"

extern queueiconstruct *queueicon;
extern queuepixstruct *queuepix;
char           *currconfigfile = NULL;
char           *grpconfigfile = NULL;
static char     curdir[MAX_STRING_SIZE];
extern Widget   toplevel;
Cursor          busycorsor;
Cursor          defaultcorsor;
extern int      startup;
extern char    *grpfile;

STACK_NODE     *cell_list=NULL;
STACK_NODE     *account_list=NULL;
STACK_NODE     *manager_list=NULL;
STACK_NODE     *operator_list=NULL;
STACK_NODE     *user_list=NULL;
STACK_NODE     *host_list=NULL;

void find_hosts_and_queues ();
/*
 * Qmon_data_init  - Fill the data structures, get memory, find necessary info
 *		     for GUI construction.
 */

void Qmon_data_init()
{

	findbitmap_configfile();
	find_cells ();
	initgroup ();
	find_hosts_and_queues ();
        Qmonalloc();

}


/*
 * Qmonalloc - allocate memory for all datastructures 
 */

void Qmonalloc()
{

	char            buffer[MAX_STRING_SIZE];
	char            tmp_buffer[MAX_STRING_SIZE];
	char            cmdline[MAX_STRING_SIZE];
	char           *iconptr;
	char           *grpptr;
	char           *tmpptr;
	queueiconstruct *queptr;
	int             ii;
	int             totalicons;
	FILE           *pfp;
	char            dummys[MAX_STRING_SIZE];
	int             dummyi;
	/*
	 * qconf -qmon returns all of icons and their current state 
	 */
	sprintf(cmdline, "%s -cell %s -qmon", QCONF_BINARY, current_cell);

	if (!(pfp = popen(cmdline, "r")))
		logerr(ERROR_110);
	else {
		totalicons = 0;
		while (fgets(buffer, MAX_STRING_SIZE, pfp)) {
			buffer[strlen(buffer) - 1] = 0;
			sscanf(buffer, "\n%[^:]", tmp_buffer);
			if (!strcmp(tmp_buffer, "###"))
				totalicons++;
		}
	}

	pclose(pfp);
	sprintf(cmdline, "wc -l %s", currconfigfile);
	if (!(pfp = popen(cmdline, "r")))
		logerr(ERROR_110);
	else {
		fgets(buffer, MAX_STRING_SIZE, pfp);
		buffer[strlen(buffer) - 1] = 0;
		sscanf(buffer, "%d", &dummyi);
	}
	pclose(pfp);
	dummyi++;
	max_icons = totalicons + MAX_ADD_ICONS;
	queueicon = (queueiconstruct *) malloc(max_icons * sizeof(queueiconstruct));
	queuepix = (queuepixstruct *) malloc(dummyi * sizeof(queuepixstruct));
	bzero(queueicon, max_icons * sizeof(queueiconstruct));
	bzero(queuepix, dummyi * sizeof(queuepixstruct));
	busycorsor = XCreateFontCursor(getdpy(), XC_watch);
	defaultcorsor = XCreateFontCursor(getdpy(), XC_left_ptr);
	for (ii = 0; ii < max_icons; ii++) {
		queueicon[ii].old_loadavg =
			queueicon[ii].old_active_jobs =
			queueicon[ii].old_max_jobs = DUMMY_NUMBER;
	}

	if (startup) {

		sprintf(cmdline, "wc -l %s", grpconfigfile);
		if (!(pfp = popen(cmdline, "r"))) {
			logerr(ERROR_110);
		} else {
			fgets(buffer, 256, pfp);
			buffer[strlen(buffer) - 1] = 0;
			sscanf(buffer, "%d", &dummyi);
			pclose(pfp);
		}
		if (!dummyi) {
			startup = 0;
		} else {
			max_usergrps = dummyi;
		}

	}
}
/*
 * Qmonfree - free memory for all datastructures 
 */

void Qmonfree()
{
	free(queueicon);
	free(queuepix);
}
/*
 * void QmonNewq () { queueiconstruct *qicon=NULL; qicon =
 * malloc(sizeof(queueiconstruct)); bzero(qicon,sizeof(queueiconstruct)); } 
 */

/*
 * find_cells  - find the cells and fill the cell_list
 */

void find_cells()
{

	int             n=0;
	int             jj;
	int             totalicons;
	char           *tmpptr = NULL;
	char           *ptr1 = NULL;
	char            buffer[MAX_STRING_SIZE];
	char            tmp_buffer[MAX_STRING_SIZE];
	char            cmdline[MAX_STRING_SIZE];
	char            buffer1[2 * MAX_STRING_SIZE];
	FILE           *pfp;
	STACK_NODE     *p=NULL;

	/*
	 * Get the cell names from the resolve_file. 
	 */

	tmpptr = malloc(sizeof(char *));


	sprintf(cmdline, "cat %s/resolve_file", CONF_DIR);

	if (!(pfp = popen(cmdline, "r")))
		logerr(ERROR_111);
	else {
		while (fgets(buffer, MAX_STRING_SIZE, pfp)) {
			buffer[strlen(buffer) - 1] = 0;
			if (strncmp(buffer, "#", 1) != 0) {
			   p = (STACK_NODE *)malloc(sizeof(STACK_NODE));
			   if(p == NULL) {
  				printf(ERROR_106); exit(0);
			   }
			   sscanf(buffer, "\n%s", p->name);
			  /* push if stack_search fails */
	    		  if(!stack_search(&cell_list,p))
	    		  stack_push(&cell_list,p);
			}
		}
	}

        strcpy(current_cell,cell_list->name);


}
/*
 * find_hosts_and_queues 
 */
void find_hosts_and_queues()
{
   STACK_NODE *p = NULL;
   STACK_NODE *q = NULL;
   STACK_NODE *r = NULL;
   char    cmdline[MAX_STRING_SIZE];
   char    buffer[MAX_STRING_SIZE];
   char    dummyc[MAX_STRING_SIZE];
   FILE           *pfp;



   for( p = cell_list; p != NULL; p = p->next ) {
  
      /* Get account list */
      sprintf(cmdline, "%s -cell %s -sul", QCONF_BINARY,p->name);

      if (!(pfp = popen(cmdline, "r"))) {
                logerr(ERROR_109);
      }
      else {
	  fgets(buffer, MAX_STRING_SIZE, pfp);  /* skip first line */
	   while (fgets(buffer, MAX_STRING_SIZE, pfp)) {
	     buffer[strlen(buffer) - 1] = 0;
             q = (STACK_NODE *)malloc(sizeof(STACK_NODE));
	     sscanf(buffer,"\n%s",q->name);
             /* push if stack_search fails */
             if(!stack_search(&account_list,q))
                stack_push(&account_list,q);
	   } 
      }
      pclose(pfp);

      /* Get manager list */
      sprintf(cmdline, "%s -cell %s -sm", QCONF_BINARY,p->name);

      if (!(pfp = popen(cmdline, "r"))) {
                logerr(ERROR_109);
      }
      else {
	  fgets(buffer, MAX_STRING_SIZE, pfp);  /* skip first line */
	   while (fgets(buffer, MAX_STRING_SIZE, pfp)) {
	     buffer[strlen(buffer) - 1] = 0;
             q = (STACK_NODE *)malloc(sizeof(STACK_NODE));
	     sscanf(buffer,"\n%s",q->name);
             /* push if stack_search fails */
             if(!stack_search(&manager_list,q))
                stack_push(&manager_list,q);
	   } 
       }
      pclose(pfp);
      /* Get operator list */
      sprintf(cmdline, "%s -cell %s -so", QCONF_BINARY,p->name);

      if (!(pfp = popen(cmdline, "r"))) {
                logerr(ERROR_109);
      }
      else {
	  fgets(buffer, MAX_STRING_SIZE, pfp);  /* skip first line */
	   while (fgets(buffer, MAX_STRING_SIZE, pfp)) {
	     buffer[strlen(buffer) - 1] = 0;
             q = (STACK_NODE *)malloc(sizeof(STACK_NODE));
	     sscanf(buffer,"\n%s",q->name);
             /* push if stack_search fails */
             if(!stack_search(&operator_list,q))
                stack_push(&operator_list,q);
	   } 
      }
      pclose(pfp);
      /* Get host list */
      sprintf(cmdline, "%s -cell %s -sh", QCONF_BINARY,p->name);

      if (!(pfp = popen(cmdline, "r"))) {
                logerr(ERROR_109);
      }
      else {
	  fgets(buffer, MAX_STRING_SIZE, pfp);  /* skip first line */
	   while (fgets(buffer, MAX_STRING_SIZE, pfp)) {
	     buffer[strlen(buffer) - 1] = 0;
             q = (STACK_NODE *)malloc(sizeof(STACK_NODE));
	     sscanf(buffer,"\n%s",q->name);
             /* push if stack_search fails */
             if(!stack_search(&host_list,q))
                stack_push(&host_list,q);
	   } 
      }
      pclose(pfp);
   }

   for( p = cell_list; p != NULL; p = p->next ) {
      for( r = account_list; r != NULL; r = r->next ) {
  
      /* Get user list */
      sprintf(cmdline, "%s -cell %s -su %s", QCONF_BINARY,p->name,r->name);

      if (!(pfp = popen(cmdline, "r"))) {
                logerr(ERROR_109);
      }
      else {
	  fgets(buffer, MAX_STRING_SIZE, pfp);  /* skip first line */
	   while (fgets(buffer, MAX_STRING_SIZE, pfp)) {
	     buffer[strlen(buffer) - 1] = 0;
             q = (STACK_NODE *)malloc(sizeof(STACK_NODE));
	     sscanf(buffer,"\n%s%s",dummyc,q->name);
             /* push if stack_search fails */
             if(!stack_search(&user_list,q))
                stack_push(&user_list,q);
	   } 
      }
      pclose(pfp);
     }
   }

}

/*
 * findbitmap_configfile - where/which is the bitmap config file. 
 */
void findbitmap_configfile()
{

	char           *homedir;
	char            errmsg[MAX_STRING_SIZE];
	char            hmconfigfile[MAX_STRING_SIZE];	/* home config file */
	char            dfconfigfile[MAX_STRING_SIZE];	/* default config file */
	char            grpcfigfile[MAX_STRING_SIZE];	/* group config file */
	FILE           *fp, *pfp;

	homedir = getenv("HOME");
	sprintf(hmconfigfile, "%s/%s", homedir, BITMAPCONF);
	sprintf(dfconfigfile, "%s/%s", BITMAPDIR, BITMAPCONF);
	if ((fp = fopen(hmconfigfile, "r")) != NULL) {
		currconfigfile = malloc(strlen(hmconfigfile) + 1);
		strcpy(currconfigfile, hmconfigfile);
	} else if ((fp = fopen(dfconfigfile, "r")) != NULL) {
		currconfigfile = malloc(strlen(dfconfigfile) + 1);
		strcpy(currconfigfile, dfconfigfile);
	} else {
		sprintf(errmsg, "Qmon: cannot open %s or %s file",
			dfconfigfile, hmconfigfile);
		logerr(errmsg);
	}

	/* Open the grpconfigfile 	 */

	if (grpfile != NULL)
		sprintf(grpcfigfile, "%s", grpfile);
	else
		sprintf(grpcfigfile, "%s/%s", homedir, GRPFILE);
	if ((fp = fopen(grpcfigfile, "r")) != NULL) {
		grpconfigfile = malloc(strlen(grpcfigfile) + 1);
		strcpy(grpconfigfile, grpcfigfile);
		startup = 1;
	} else {
		sprintf(errmsg, "Qmon: cannot open qmon group file  %s \n",
			grpcfigfile);
/*
		logerr(errmsg);
*/
	}

}
