static char hash_rcsid[]="hash.c,v 1.2 1994/11/28 16:54:55 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  hash.c,v
 * Revision 1.2  1994/11/28  16:54:55  kerce
 * *** empty log message ***
 *
 * Revision 1.2  1994/09/13  18:01:59  raju
 * prototyepe declarations
 *
 * Revision 1.1  1994/07/11  15:28:24  raju
 * Initial revision
 *
 *
 *
 **********************************************************/

#include "globals.h"
struct hte {
  char *groupname;
  struct hte *next;
};

struct hte *groupnames[MAX_GROUPS];


/***********************************************************
 * hteinit - Initialize each entry in the hash table to NULL
 */
void hteinit()
{
  int i;

  for(i=0;i<MAX_GROUPS;i++)
    groupnames[i]=(struct hte *)NULL;
}


/***********************************************************
 * hash - Return the hashed value of word
 */
unsigned long hash(char *word,unsigned long ROOTLEN)
{
  unsigned long h;
  
  h = *word++;
  while (*word)
    h = (h * 128 + *word++) % ROOTLEN;
  return h;
}


/***********************************************************
 * htelookup - Return 1 if found in the hash table; 0 otherwise
 */
int htelookup(char *group)
{
  unsigned long index;
  struct hte *hteptr;

  index=hash(group,MAX_GROUPS);
  hteptr=groupnames[index];
  while(hteptr) {
    if(!strcasecmp(hteptr->groupname,group)) {
      return 1;
    }
    hteptr=hteptr->next;
#ifdef sgi
	hteptr=(struct hte *)NULL;
#endif
  }
  return 0;
}


/***********************************************************
 * hteadd - Add group to hash table if it doesn't already
 *          exist
 */
int hteadd(char *group)
{
  struct hte *htetmp;
  char *buffer;
  unsigned long index;
  static initialized=0;

  if(!initialized) {
    hteinit();
    initialized=1;
  }

  if(htelookup(group)) {
    return 0;
  }
  htetmp=NULL;
  htetmp=malloc(sizeof(struct hte *));
  buffer=malloc(strlen(group)+1);
  strcpy(buffer,group);
  index=hash(group,MAX_GROUPS);
  htetmp->next=groupnames[index];
  htetmp->groupname=buffer;
  groupnames[index]=htetmp;
  return 1;
}
