#include "main.h"

/*****************************************************
  get_make
  ******************************************************/
/* this will write out the make file after prompting
   the users for various input                      */
void get_make(){
  struct stat sbuf;
  
  printf("\n\nWe are configuring the makefile\n");
  printf("typing a question mark (?) at any prompt will provide brief help info\n\n\n");
  
  /*############CC SECTION##################*/
  MALLOC_STR(cc);
  strcpy(cc,"cc");
  PUT_NULL(cc);
  
  /*#########BIN_DIR SECTION##############*/

  if(SIMPLE_INSTALL){
      set_def(&bin_dir, t_bin_dir);
  }
   else{  
     get_line(&bin_dir, t_bin_dir);
   }

  if( make_dir(bin_dir,0755)==-1) printf("Can't make bin directory %s insufficient permissions\n",bin_dir );      

  
  MALLOC_STR(install_dir);
  strcpy(install_dir,bin_dir);
  
  /*###########CONF_DIR###########################*/

  if(SIMPLE_INSTALL){
  	set_def(&conf_dir, t_conf_dir);
  	printf("\n the resolve file and conf_file will be place in %s\n", conf_dir);
  }
  else{
       get_line(&conf_dir, t_conf_dir);
  }

  /* stat directory to see if it exists, if it doesn't try to make it
     if we can't, abort */

  if(stat(conf_dir,&sbuf)==-1){
    printf("\nDirectory %s doesn't exist and we will be writing configuration files to it.\n",conf_dir);
    printf("Trying to make %s\n",conf_dir);
    if( make_dir(conf_dir,0755)==-1) err_crit("Can't make directory insufficient permissions\n");        /* simulates mkdir -p*/
    
    printf("succeeded in making CONF_DIR directory\n");
    
  }


   /*##########Now get the QMASTER_SPOOL dir for consistent feel */
 
  /* note that this will effect the get_dqs.c*/

  if(SIMPLE_INSTALL){
  	set_def(&qmaster_spool_dir, t_qmaster_spool_dir);
  }
  else{
     get_line(&qmaster_spool_dir, t_qmaster_spool_dir);
  }
  if ( make_dir(qmaster_spool_dir,0755)==-1) printf("Can't make execd_spool_dir, May need to  make dirs after config finishes\n");

  
  
  /*##########Now get the DQS_execd spool-dir for consistent feel */
  if(SIMPLE_INSTALL){
  	set_def(&execd_spool_dir, t_dqs_execd_spool_dir);
  }
  else{
     get_line(&execd_spool_dir, t_dqs_execd_spool_dir);
  }
  if ( make_dir(execd_spool_dir,0755)==-1) printf("Can't make execd_spool_dir, May need to  make dirs after config finishes\n");
  
  /*###########DOC_DIR###########################*/
  if(SIMPLE_INSTALL){
      set_def(&doc_dir, t_doc_dir);
      printf("n\n The documentation will be installed in %s\n",doc_dir);
  }
  else{
     get_line(&doc_dir, t_doc_dir);
  }
  if ( make_dir(doc_dir,0755)==-1) printf("Can't make doc_dir, May need to  make dirs after config finishes\n");
  
  /*###########LIB_DIR###########################*/
  if(SIMPLE_INSTALL){
  	set_def(&lib_dir, t_lib_dir);

  	printf("\n The DQS libraries will be installed in %s\n",lib_dir);
  }
  else{
     get_line(&lib_dir, t_lib_dir);
  }
 if ( make_dir(lib_dir,0755)==-1) printf("Can't make lib_dir, May need to  make dirs after config finishes\n");
  
  /*###########MAN1_DIR###########################*/
  if(SIMPLE_INSTALL){
    set_def(&man1_dir, t_man1_dir);

    printf("\n the Man1 pages will be stored in %s\n",man1_dir);
  }
  else{  
  get_line(&man1_dir, t_man1_dir);
  }
  if ( make_dir(man1_dir,0755)==-1) printf("Can't make man1_dir, May need to  make dirs after config finishes\n");
  
  /*###########MAN3_DIR###########################*/
  if(SIMPLE_INSTALL){
  	set_def(&man3_dir, t_man3_dir);

  	printf("\n The Man3 pges will be stored in %s\n",man3_dir);
  }
  else{
     get_line(&man3_dir, t_man3_dir);
  }
  if ( make_dir(man3_dir,0755)==-1) printf("Can't make man3_dir, May need to  make dirs after config finishes\n");
  
  /*############UID/GID INSTALLBIN############*/
  if(SIMPLE_INSTALL){
  	set_def(&dqs_root, t_dqs_root);

  	printf("\n The uid for all binaries will be %s\n", dqs_root);
  }
  else{
     get_line(&dqs_root, t_dqs_root);
  }

  if(SIMPLE_INSTALL){
  	set_def(&dqs_sysgrp, t_dqs_sysgrp);

  	printf("\n The gid for DQS binaries will be %s\n", dqs_sysgrp);
  }
  else{
     get_line(&dqs_sysgrp, t_dqs_sysgrp);
  }
  
  /*############UID/GID INSTALLdoc/lib/man############*/
  if(SIMPLE_INSTALL){
  	set_def(&root,t_root);
  	set_def(&sysgrp, t_sysgrp);

  	printf("\n The docs and man will be installed with nuid=%s ngid=%s\n",
  	                    root, sysgrp);
  }
  else{
  	
     get_line(&root,t_root);

     get_line(&sysgrp, t_sysgrp);
     set_var(sysgrp,SYSGRP);
  }
  
  
}

/***********************************************************************
  WRITE_MAKE
  ************************************************************************/

void write_make()
{
  
  FILE* infd,*outfd;
  
  char buf[MAXLEN];
  
  
  
  if ( (infd   = fopen(MAKEFILE_BODY,"r")) ==(FILE*)NULL) err_crit("Can't open input Makefile body\n");
  DPRINTF(("About to try to open Makefile for writing ==:%s:\n",MAKEFILE));
  
  if ( (outfd  = fopen(MAKEFILE,"w")) ==(FILE*)NULL) err_crit("Can't open output Makefile\n");
  
  fprintf(outfd,"#Automatically generated by configure\n");
  fprintf(outfd,"INSTALL_DIR=%s\n",install_dir);
  fprintf(outfd,"BIN_DIR=%s\n",bin_dir);
  fprintf(outfd,"CONF_DIR=%s\n",conf_dir);
  fprintf(outfd,"DOC_DIR=%s\n",doc_dir);
  fprintf(outfd,"LIB_DIR=%s\n",lib_dir);
  fprintf(outfd,"MAN1_DIR=%s\n",man1_dir);
  fprintf(outfd,"MAN3_DIR=%s\n",man3_dir);
  fprintf(outfd,"ROOT=%s\n",root);
  fprintf(outfd,"DQS_ROOT=%s\n",dqs_root);
  fprintf(outfd,"SYSGRP=%s\n",sysgrp);
  fprintf(outfd,"DQS_SYSGRP=%s\n",dqs_sysgrp);
  fprintf(outfd,"CC=%s\n\n\n",cc);
  fprintf(outfd,"CFLAGS=-g\n");
  fprintf(outfd,"LFLAGS=\n");
  fprintf(outfd,"# the next line is a \"majic-cookie\" - don't remove it\n");


  while( (fgets(buf,MAXLEN,infd)) !=  NULL){
    fprintf(outfd,"%s",buf);
  } 
  fclose(infd);
  fclose(outfd);
  
  
}
