
#include <stdio.h>
#include <string.h>
FILE *f;


typedef struct ratio_dummy{
	char queue[16];
	float avgR;
} ratio_pair_t;


#define CRAYYMP 17.5

ratio_pair_t ratios[]= { "priority", 11.15,
                         "longterm", 11.15,
                         "sp2",      11.15,
                          "ibms590",  10.23,
                          "alpha",     3.86,
                          "ibms250",   3.14,
                          "ibms375",   3.02,                          
                          "hp",        2.68,
                          "ibms550",   2.51,
                          "ibms340",   1.62,
                          "ibms530",   1.52,
                          "ibms320h",  1.28,
                          "jra",       1.28,
                          "ibms320",   1.00,
                          "XXXX",     -1.00  };



void mysort(unsigned long , unsigned long* );
unsigned int mymode(unsigned long , unsigned long* );
float get_ratio(char*, int*);



main(int argc, char **argv)
{
int firsttime, tjobs, stlen, slx, slx2, i, djobs, rindex;
int maxdelay, maxwall, maxtime, maxmem, totalmem, distwall;
int delay, walltime, cputime, pages, totalwall, totalcpu, totaldelay;
unsigned long start_time, end_time;
float ratio, testratio, testdelay, testwall, testidea;

char old_cpu[1024];
char instream[1024];
char *fstatus;
char *tptr;
char fillsp[]="                                        ";
char cpuname[1024];

unsigned long wall[20000],cpu[20000],delayV[20000], pgs[20000];
unsigned int wallmedian, wallmode;
unsigned int cpumedian, cpumode;
unsigned int dlymedian, dlymode;
unsigned int pgsmedian, pgsmode;

f= fopen("machine_stats","r");

maxdelay=0;
maxtime=0;
maxmem=0;
tjobs=0;
maxwall=0;
totalwall=0;
totalcpu=0;
totaldelay=0;
totalmem=0;
slx=0;
djobs=0;
distwall=0;
strcpy(old_cpu," ");
firsttime=1;
printf("machine   \t totjobs distjobs distwall  maxdly  maxwall  maxcpu   maxpgs    totdly   totwall   totcpu   avgdly  meddly   moddly  avgwall  medwall  modwall   avgcpu   medcpu   modcpu   avgpgs   medpgs   modpgs\n");
printf("----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");

while(1){
	fstatus= fgets(instream,80,f);
	if(fstatus==NULL) break;

	tptr= strtok(instream," ");
	if(!tptr) break;
	if( firsttime ){
		strcpy(old_cpu,tptr);
		firsttime=0;
	}
	if(strcmp(old_cpu,tptr) ){
		strcpy(cpuname,old_cpu);
		strcat(cpuname,fillsp);
		cpuname[10]='\0';
        mysort(slx, wall);
        mysort(slx,cpu);
        mysort(slx,delayV);
        mysort(slx,pgs);
        slx2= slx/2;
        wallmedian= wall[slx2];
        cpumedian= cpu[slx2];
        dlymedian= delayV[slx2];
        pgsmedian= pgs[slx2];
 
        wallmode= mymode(slx, wall);
        cpumode= mymode(slx, cpu);
        dlymode= mymode(slx,delayV);
        pgsmode= mymode(slx, pgs);
        printf("%s\t %5d    %5d   %5d %8d %8d %8d %8d  %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d\n",
             cpuname, tjobs, djobs, distwall,maxdelay,maxwall,maxtime,maxmem,
             totaldelay, totalwall, totalcpu,
             totaldelay/tjobs, dlymedian, dlymode,
             totalwall/tjobs,wallmedian,wallmode,
             totalcpu/tjobs,cpumedian, cpumode,
             totalmem/tjobs, pgsmedian, pgsmode);
      
		maxdelay=0;
		maxtime=0;
		maxmem=0;
		maxwall=9;
		tjobs=0;
		djobs=0;
		distwall=0;
        totalwall=0;
        totalcpu=0;
        totaldelay=0;
        totalmem=0;
        slx=0;
		
	}

	strcpy(old_cpu,tptr);
	if(slx==0) ratio= get_ratio(old_cpu,&rindex);
	
	tptr= strtok(NULL," ");  /* skip user name */
	if(!tptr) break;

	tptr= strtok(NULL," ");  /* skip over complex name */
	if(!tptr) break;

	tptr= strtok(NULL," ");  /*  get delay  */
	if(!tptr) break;

    delay= abs(  atoi(tptr) );
    if(delay>1000000) continue;
    if(delay>maxdelay) maxdelay=delay;
    totaldelay=totaldelay+delay;
    delayV[slx]=delay;
    tptr= strtok(NULL," ");   /* get wallclcock */
    if(!tptr) break;

    if( *(tptr) == '-') walltime=0;
    else    walltime= atoi(tptr);
    if(walltime>1000000) continue;
    if(walltime> maxwall) maxwall=walltime;
    totalwall=totalwall+walltime;
    wall[slx]= walltime;
    tptr= strtok(NULL," ");
    if(!tptr) break;

    if( *(tptr) == '-') cputime=0;
    else     cputime= atoi(tptr);
    if(cputime>1000000)continue;
    if(cputime> maxtime) maxtime= cputime;
    totalcpu=totalcpu+cputime;
    cpu[slx]=cputime;
    tptr= strtok(NULL," ");
    if(!tptr) break;

    if( *(tptr) == '-') pages=0;
    else     pages= atoi(tptr);
    if(pages>1000000) continue;

    pgs[slx]= pages;

    if(pages>maxmem) maxmem= pages;
    totalmem=totalmem+pages;

    tptr= strtok(NULL," ");
    if(!tptr) break;

    start_time= atoi(tptr);


    tptr= strtok(NULL," ");
    if(!tptr) break;
    
    end_time= atoi(tptr);


/* theory: test to see if a job could be performed on a system with less */
/*  memory and in less time than the job spent wiating in the current ququq */
    
    if(pages<=32768){
    	testwall=walltime;
    	testdelay= delay;

        for(i=rindex+1;i<15;i++){
             if(ratios[i].avgR <0 ) break;    /* bail out */
             testratio= ratios[i].avgR;
             if( testratio == ratio) continue ; /* skip similar performance machines*/

             testidea= (ratio * testwall)/ testratio;

             if(testidea< testdelay){
                         djobs ++;
                         distwall=distwall+ walltime;
                         break;
             }
        }
    	
	}
    slx++;
    tjobs ++;
}

}

void mysort(unsigned long n, unsigned long uia[])
{
    unsigned long i,ir,j,l;
    unsigned long ruia;

    if (n < 2) return;
    l=(n >> 1)+1;
    ir=n;
    for (;;) {
        if (l > 1) {
            ruia=uia[--l];
        } else {
            ruia=uia[ir];
            uia[ir]=uia[1];
            if (--ir == 1) {
                uia[1]=ruia;
                break;
            }
        }
        i=l;
        j=l+l;
        while (j <= ir) {
            if (j < ir && uia[j] < uia[j+1]) j++;
            if (ruia < uia[j]) {
                uia[i]=uia[j];
                i=j;
                j <<= 1;
            } else j=ir+1;
        }
        uia[i]=ruia;
    }
}

unsigned int mymode(unsigned long n, unsigned long uia[])
{
float predictor, estimate, temp, ratio;
unsigned int rmode;
int predx, i;
int J=3;

predictor=0.0;
predx=0.0;
ratio= J;
ratio= ratio/n;

if(n<=J) return uia[1];
for (i=0;i< (n-J) ;i++){
    temp= uia[i+J]-uia[i];
    
    estimate= ratio * temp;
    if(estimate > predictor){
      predictor= estimate;
      rmode= (uia[i+J] + uia[i])/2;
    }
}
return rmode;

}

float get_ratio(char *name, int *indx)
{

int i, n_len;
float ratio;

if(!name) return -1.0;            /* error */

n_len= strlen(name);
for(i=0;i<100;i++){
	if( !strcmp(ratios[i].queue,"XXXX") )break;
	if(!strncmp(name,ratios[i].queue,n_len) )break;
}
ratio= ratios[i].avgR;
*indx=i;
return ratio;

}
