#ifndef __STDSTUFF__

#define __STDSTUFF__ 1

#include <stdlib.h>
#include <stddef.h>
#include "proto.h"

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

/* The following mess tries to handle conflicts with boolean definitions. */
#if !defined(TRUE) && !defined(FALSE)
typedef enum
{
  FALSE, TRUE
}
BOOLEAN;
#else
#define BOOLEAN int
#endif /* !defined(TRUE) && !defined(FALSE) */

#define ShowBoolean(Bool) \
	(Bool) == TRUE ? "TRUE" : "FALSE"

typedef int CHARACTER;

#define ShowString(String) \
	(String) == NULL ? "NULL" : (String)

/* Set up some constants for the ASCII character set. */
#ifndef ESC
#define ESC 27
#endif

/* Number bases. */
#define BINARY 2
#define OCTAL 8
#define DECIMAL 10
#define HEXADECIMAL 16

#ifndef _DEBUG_MALLOC_INC
#define malloc_enter(func)
#define malloc_leave(func)
#define malloc_chain_check()
#define malloc_dump(fd)
#define malloc_list(a,b,c)
#define malloc_inuse(hist)	(*(hist) = 0, 0)
#endif

void
GetProgramName PROTO((char *Program, char *DefaultName));

#endif /* __STDSTUFF__ */


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
