static char dqs_sig_handlers_rcsid[]="$Id: dqs_sig_handlers.c,v 1.4 1998/10/13 15:08:49 green Exp $";

/*----------------------------------------------------
 * dqs_sig_handlers.c Tom Green Mon Jan 31 10:43:05 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_sig_handlers.c,v $
 * Revision 1.4  1998/10/13 15:08:49  green
 * Solaris 2.6 support - hopefully, as I don't have access to one...
 *
 * Revision 1.3  1998/10/13 14:23:13  green
 * Patching Solaris defines - shooting in the dark here as I don't have access to
 * a Solaris 2.5 box
 *
 * Revision 1.2  1998/09/18 12:21:23  green
 * use WEXITSTATUS macro for extracting exit value for dusage
 *
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.32  1996/07/19 12:04:07  nrl
 * Changes to fix "non existent resources"
 *
 * Revision 3.31  1996/06/27  01:56:07  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.30  1996/06/17  02:29:10  nrl
 * Updtaes from Guntram Wolski, Ron Lee, John Makosky and
 * Bodo Beckebach
 *
 * Revision 3.29  1996/03/22  04:21:27  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.28  1996/03/12  17:12:40  nrl
 * removed aborts and replaced with an error messaging scheme
 * to send email to the dqs adminsitrator and wait for
 * actions by that administrator
 *
 * Revision 3.27  1996/02/19  19:02:26  nrl
 * added a separate subpriority field, pluys scheduling_flags and
 * job_seq_number to remove the 3.1.2.4 kludges , modified the
 * scheduling algorith once again
 *
 * Revision 3.26  1995/11/01  16:43:22  nrl
 * chnaged defualt mask to global "exec_mask"
 *
 * Revision 3.25  1995/09/19  19:55:57  nrl
 * Fixed segmentation crash due to missing parameter in sprintf
 * in MAI_AT_ABORT code
 *
 * Revision 3.24  1995/06/21  16:57:58  nrl
 * Major scheduling changes... added a subpriority field to manage
 * things within the user submitted priority. Added priority info to the
 * accounting file.
 *
 * Revision 3.23  1995/06/15  11:39:48  nrl
 * Changed accounting info for Solaris and AIX.
 *
 * Revision 3.22  1995/05/29  18:08:57  nrl
 * More solaris stuff GAGGHH had to differentiate more cases of
 * solaris2.3 and solaris2.4 stuff
 *
 * Revision 3.21  1995/05/28  16:44:41  nrl
 * Fixes for solaris2.3 and solaris 2.4 and mailer default recipients
 *
 * Revision 3.20  1995/05/26  19:07:46  nrl
 * Cleaned up signal handling and the notify option with the
 * help of Ron Lee.
 *
 * Revision 3.19  1995/03/02  16:23:38  nrl
 * Fixed bug in bug fix.. left out braces in crucial position so
 * that almost all job pids were being discarded.
 *
 * Revision 3.18  1995/03/01  20:52:58  nrl
 * Added dqs_delete_int0 function and corections to the interrupt
 * handler to remove stale entries from the Chil Head. This fixes the
 * intermittent problems with queue stalls.
 *
 * Revision 3.17  1995/02/16  20:34:31  nrl
 * Force cleared job structure to prevent garbage from fouling things up.
 * Added SIGCHLD to iomask to keep "mailer" from messing up
 * socket transfers.
 *
 * Revision 3.16  1995/02/06  16:31:55  nrl
 * Added "account" info to rusage structure and to the "acc_file"
 * for analysis by user.
 *
 * Revision 3.15  1995/02/01  23:17:48  nrl
 * Tidied up and hopefully bulletproofed "tid" management. Reversed
 * tid file naming to sort by time.
 *
 * Revision 3.14  1995/01/30  15:22:07  nrl
 * added "tid" verification between execd and qmaster to prevent
 * "ghost" jobs from persisting in visible queue. Changed ERROR messages
 * which were for information only to DEBUG messages.
 *
 * Revision 3.13  1995/01/17  16:32:11  nrl
 * completed mailer feature
 *
 * Revision 3.12  1994/06/17  17:34:50  green
 * some UNIXes(if you can call them that) don't have a way to get the
 * rusage stats - bzero the structure...
 *
 * Revision 3.11  1994/06/16  22:57:10  green
 * deliver a SIGTERM rather than a SIGQUIT at the death of the parent
 *
 * Revision 3.10  1994/06/13  14:42:18  green
 * OSF/1 on MIPS(DEC) doesn't define SIGCLD
 *
 * Revision 3.9  1994/06/12  23:07:56  green
 * give rest of process group 500 usec after SIGQUIT(delivered when
 * "master" is reaped) before delivering a SIGKILL to pgrp.
 *
 * Revision 3.8  1994/06/12  22:53:30  green
 * use SIGQUIT vs SIGTERM to nuke the rest of the pgrp
 *
 * Revision 3.7  1994/06/12  19:48:53  green
 * to avoid timing problems with the reaping of children after the
 * dqs_execd delivers a signal, inserted a 50 usec sleep in
 * dqs_reap_dead_children.  This, though somewhat hackey, precludes
 * the problem of having to wait till next sigalarm before the reap
 * (don't want dead babies smelling up the place...)
 *
 * Revision 3.6  1994/06/12  19:38:18  green
 * added SIGCLD to default mask of dshd/qconf/qmaster
 *
 * Revision 3.5  1994/06/12  02:32:40  green
 * removed "dshd" and moved the functionality in the dqs_execd - this
 * will allow for the dqs_execd to set queue/job resources and to
 * reap/report rusage
 *
 * some really strange timing errors in the "dshd" connecting to the
 * stderr port on "dsh" under Linux forced introduction of a sleep(1);
 * this needs to be followed up on.
 *
 * dqs_dshd_service no longer needed
 *
 * allowed SIGCHLD to interrupt io_mask
 *
 * Revision 3.4  1994/06/09  14:25:06  green
 * yanked PVM after further digging through the PVM code decided there
 * might be potential problems(let somebody else worry with pvm if they
 * want it...)
 *
 * pulled out some sloaris #defs - maybe one day SUN will ship me my
 * compiler
 *
 * Revision 3.3  1994/06/08  17:48:09  green
 * added P4 support(with the help of Ralph Butler - Thanks Ralph!)
 *
 * backed down to Rev. 3.3 of dqs_check_to_do_list.c
 *
 * Revision 3.2  1994/06/05  16:53:55  green
 * added DQS_DSHD_SERVICE and dqs_dshd_service to required support files
 *
 * forced a SIGQUIT to children on death of parent(eg: "master") in
 * dqs_sig_handlers.c
 *
 * Revision 3.1  1994/06/05  15:27:30  green
 * forced death of children(local and remote) at death of "master"
 * foresee a lot of confusion here when combined with "-notify"...
 *
 * Revision 3.0  1994/03/07  04:14:41  green
 * 3.0 freeze
 *
 * Revision 1.4  1994/02/24  18:11:31  green
 * added dqs_show_all_cofigurations() to dqs_execd.c an qmaster.c
 *
 * modified dqs_execd.c and dqs_load_avg.c to use me.default_cell rather than
 * conf.default_cell
 *
 * previous message about errant pointer reference was incorrect.
 * dqs_sig_handlers.c put back like it was previously
 *
 * there was however a point problem with dusage->master in dqs_setup.c.
 *
 * added dqs_show_all_cofigurations() to dqs_utility.c
 *
 * remade func.h
 *
 * activated the "-cell cell_name" option for dqs_execd in globals.h
 *
 * changed fscanf() to fgets() in qsub.c to fix problems on SV machines
 * and to avoid byte-stuffing problems.
 *
 * Revision 1.3  1994/02/24  14:29:22  green
 * added code to nuke jobs at machine reboot
 *
 * still need to ad "restart" code
 *
 * patched a potential memory reference bug in dqs_sig_handlers.c
 *
 * Revision 1.2  1994/02/09  19:57:22  green
 * initialized dusage->group
 *
 * Revision 1.1.1.1  1994/02/01  17:57:47  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

#include <sys/times.h>
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"
/********************************************************/
void dqs_setup_sig_handlers()
     
{
  
  DENTER((DQS_EVENT,"dqs_setup_sig_handlers"));
  /******* setup default masks *******/
  sigfillset(&default_mask); /* default mask */
  sigdelset(&default_mask,SIGINT);
  sigdelset(&default_mask,SIGQUIT);
  sigdelset(&default_mask,SIGALRM);
  sigdelset(&default_mask,SIGTERM);
  sigdelset(&default_mask,SIGURG);
  sigdelset(&default_mask,SIGIO);
  sigdelset(&default_mask,SIGABRT);
  sigdelset(&default_mask,SIGILL);
#ifdef SIGBUS
  sigdelset(&default_mask,SIGBUS);
#endif
  sigdelset(&default_mask,SIGSEGV);
  sigdelset(&default_mask,SIGVTALRM);
  sigdelset(&default_mask,SIGTTIN);
  sigdelset(&default_mask,SIGTTOU);
  if ((me.who==QCONF)||(me.who==DQS_EXECD)||(me.who==QMASTER))
    {
      DPRINTF((DQS_EVENT,"adding SIGCHLD/SIGCLD to default_mask"));
      sigdelset(&default_mask,SIGCHLD);
#ifdef SIGCLD
      sigdelset(&default_mask,SIGCLD);
#endif
    }
  
  sigfillset(&io_mask); /* io mask */
  sigdelset(&io_mask,SIGINT);
  sigdelset(&io_mask,SIGQUIT);
  sigdelset(&io_mask,SIGALRM);
  sigdelset(&io_mask,SIGURG);
  sigdelset(&io_mask,SIGIO);
  sigdelset(&io_mask,SIGABRT);
  sigdelset(&io_mask,SIGILL);
#ifdef SIGBUS
  sigdelset(&io_mask,SIGBUS);
#endif
  sigdelset(&io_mask,SIGSEGV);
  sigdelset(&io_mask,SIGVTALRM);
  sigdelset(&io_mask,SIGTTIN);
  sigdelset(&io_mask,SIGTTOU);
  
  /*     sigdelset(&io_mask,SIGCHLD);        ???*/
  
  /******* set default mask *******/
  sigprocmask(SIG_SETMASK,&default_mask,&exec_mask);
  
  /******* setup signal handlers *******/
  sigalrm_vec.sa_handler=dqs_alarmclock;
  sigfillset(&sigalrm_vec.sa_mask);
  sigdelset(&sigalrm_vec.sa_mask,SIGQUIT);
  sigdelset(&sigalrm_vec.sa_mask,SIGABRT);
  sigdelset(&sigalrm_vec.sa_mask,SIGILL);
  sigalrm_vec.sa_flags=0;
  sigaction(SIGALRM,&sigalrm_vec,&sigalrm_ovec);
  
  sigterm_vec.sa_handler=dqs_terminate;
  sigfillset(&sigterm_vec.sa_mask);
  sigdelset(&sigterm_vec.sa_mask,SIGABRT);
  sigdelset(&sigterm_vec.sa_mask,SIGILL);
  sigterm_vec.sa_flags=0;
  sigaction(SIGTERM,&sigterm_vec,&sigterm_ovec);
  
  if ((me.who==DQS_EXECD)||(me.who==QMASTER))
    {
      sigcld_vec.sa_handler=dqs_reap;
      sigcld_vec.sa_flags=SA_NOCLDSTOP;
      sigfillset(&sigcld_vec.sa_mask);
      sigdelset(&sigcld_vec.sa_mask,SIGQUIT);
      sigdelset(&sigcld_vec.sa_mask,SIGALRM);
      sigdelset(&sigcld_vec.sa_mask,SIGURG);
      sigdelset(&sigcld_vec.sa_mask,SIGIO);
      sigdelset(&sigcld_vec.sa_mask,SIGABRT);
      sigdelset(&sigcld_vec.sa_mask,SIGILL);
      sigcld_vec.sa_flags=0;
      sigaction(SIGCHLD,&sigcld_vec,&sigcld_ovec);
    }
  
  DEXIT;
  return;
  
}

/********************************************************/
void dqs_alarmclock()
     
{
  
  DENTER((DQS_EVENT,"dqs_alarmclock"));
  
  /*     ERROR((DQS_EVENT,"DQS_ERROR_0505 ALARM_CLOCK-ALARM_CLOCK-ALARM_CLOCK-ALARM_CLOCK-ALARM_CLOCK-")); */
  if (SFD<DQS_MAX_FD)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0506 ALARM_CLOCK shutdown %d",SFD));
      dqs_close_sfd(SFD);
    }
  
  DEXIT;
  return;
  
}


/***************************************************************************/
void dqs_terminate()
     
{
  
  DENTER((DQS_EVENT,"dqs_terminate"));
  shut_me_down=1;
  DEXIT;
  
}

/******************************************************************************/
void dqs_reap()
     
{
  DENTER((DQS_EVENT,"dqs_reap"));
  dead_children=1;
  DEXIT;
  return;
  
}

/************************************************************************************/
int dqs_reap_children()
     
     /* 
	several things have to be done here
	**   a) map child to jobnumber
	**   b) unlink spooled control file
	**   c) unlink spooled queue file
	**   d) gather statistics
	**   e) possibly send mail
	**   f) remove job from job list
	**   g) remove queue from queue list
	**   h) forward statistics back to qmaster
	*/
     
{
  
  int pid=999;
  dqs_job_type *job;
  dqs_queue_type *queue;
  dqs_list_type *lp;
  dqs_list_type listel;
  dqs_rusage_type *dusage;
  int dqs_mail_abnormal_termination, dqs_mail_stopped_child, dqs_mail_exit_status;
  char dqs_mail_term_msg[128];
  char dqs_mail_subj[1024];
  char dqs_mail_body[1024];
  char dqs_mail_start[128];
  char dqs_mail_end[128];
  char *acct_tmp;
  int  acct_int;
  
  struct rusage rusage;
  struct tms cpu_usage;
  time_t start_time;
  string str;
  dqs_list_type *mail_users;
  int            mail_options;
  int    termsignal, stopsignal;
  
#if (SVR3) /* DAMN this is irratating */
  union wait status;
#else
  int status;
#endif
  
  DENTER((DQS_EVENT,"dqs_reap_children"));;
  DPRINTF((DQS_EVENT,"========================REAPER======================"));
  
  dqs_sleep(0,150); /* have to do this to avoid timing conflicts when */
  /* the dqs_execd delivers a signal                */
  /* no pretty - I know...                          */
  dqs_mail_abnormal_termination=0;
  dqs_mail_stopped_child=0;
  dqs_mail_exit_status=0;
  while (pid > 0 ) {
    
    bzero((char *)&rusage,sizeof(rusage));
    
  restart:
    
#if (defined(_UNICOS) || defined(__hpux) || defined(solaris) || defined(SOLARIS23_UP) )
    pid=waitpid(-1,&status,WNOHANG);
#else
    pid=wait3(&status,WNOHANG,(struct rusage *) &rusage);
#endif	
    
    DPRINTF((DQS_EVENT,"------------------>PID %d",pid));
    
    if (pid==0) {
      DPRINTF((DQS_EVENT,"pid==0 - no stopped or exited children"));
      DEXIT; /* no stopped or exited children */
      continue;
    }
    
    if (pid==-1) {
      DPRINTF((DQS_EVENT,"pid==-1 - no children not previously waited for"));
      DEXIT;
      return;
    }
    
    if (WIFSTOPPED(status)) {
      stopsignal= WSTOPSIG(status);
      
      DPRINTF((DQS_EVENT,"PID %d WIFSTOPPED signal %d",pid,stopsignal));
      dqs_mail_stopped_child++ ;    /* flag possible suspended job*/
      continue;
    }
    if (WIFSIGNALED(status)) {
      termsignal= WTERMSIG(status);	  	
      DPRINTF((DQS_EVENT,"PID %d WIFSIGNALED # %d",pid,termsignal));
      dqs_mail_abnormal_termination++;
    }
    dqs_mail_exit_status= WEXITSTATUS(status);
    DPRINTF((DQS_EVENT,"Exit Status %d ", dqs_mail_exit_status));	  
    
    if (me.who==QMASTER)
      continue;
    
    /* skip over any child process doing remove tmp directory */
    lp=Child_head;
    while (lp)
      {
	DPRINTF((DQS_EVENT,"Child PID= %d Reap PID= %d",lp->int0,pid));
	if (lp->int0!=pid) lp=lp->next;
	else {
	  /* clean out child now that its process is done */
	  Child_head=dqs_del_int0(Child_head,pid);
	  goto restart;   
	}
      }
    
    lp=Job_head;
    while (lp) 
      {
	DPRINTF((DQS_EVENT,"Job PID= %d Reap PID= %d",lp->job->pid,pid));
	if (lp->job->pid!=pid)
	  lp=lp->next;
	else
	  break;
      }
    
    if (!lp) 
      { /* oops, we didn't find it! - no biggie, could have been mail/klog/etc */
	continue;
      }
    
    job=lp->job;
    queue=lp->queue;
    
    /* propagate death of the "master" */
    
    kill(-(int)job->pid,SIGTERM);
    dqs_sleep(0,500);
    kill(-(int)job->pid,SIGKILL);
    
    DPRINTF((DQS_EVENT,"unlinking \"%s\"",job->exec_file));
    unlink(job->exec_file);
    unlink(job->job_file);
    
    bzero((char *)&listel,sizeof(listel));
    listel.int0=dqs_remove_tmpdir(queue,job);
    if (listel.int0>0)
      Child_head=dqs_insert(DQS_STR0,TAIL,Child_head,&listel);
    
    DTRACE;
    
    dusage=(dqs_rusage_type *)dqs_malloc(sizeof(dqs_rusage_type));
    dusage->pid=pid;
    dusage->qname=dqs_string_insert(NULL,queue->qname);
    dusage->hostname=dqs_string_insert(NULL,queue->qhostname);
    dusage->group=dqs_string_insert(NULL,"NA");
    dusage->master=queue->master;
    dusage->owner=dqs_string_insert(NULL,job->owner);
    dusage->job_name=dqs_string_insert(NULL,job->job_name);
    dusage->dqs_job_name=dqs_string_insert(NULL,job->dqs_job_name);
    if(job->account_list){
      if(job->account_list->str0){
	acct_int= strlen(job->account_list->str0);
	if(job->account_list->str1){
	  acct_int=acct_int + strlen(job->account_list->str1);
	}
      }
      acct_tmp= (char *) dqs_malloc( acct_int +2);
      strcpy(acct_tmp,job->account_list->str0);
      if(job->account_list->str1){
	strcat(acct_tmp,"@");
	strcat(acct_tmp,job->account_list->str1);
      }
      dusage->account= dqs_string_insert(NULL,acct_tmp);
      free(acct_tmp);
    }
    DPRINTF((DQS_EVENT,"job->dqs_job_name***>%s<***",dusage->dqs_job_name));
    /* priority will include the BASE PRIORITY to ensure positive integer printout */
    dusage->priority= job->priority ;
    dusage->job_number=job->job_number;
    dusage->submission_time=job->submission_time;
    dusage->start_time=job->start_time;
    dusage->end_time=dqs_get_gmt();
    

    dusage->exit_status=WEXITSTATUS(status);
    dusage->ru_wallclock=dusage->end_time-dusage->start_time;
    
#if  (defined(SOLARIS24) || defined(SOLARIS25) || defined(SOLARIS26) || defined(SOLARIS27) || defined(SOLARIS28) )
    
    start_time= times( &cpu_usage);
    dusage->ru_utime=  cpu_usage.tms_utime/CLK_TCK;
    dusage->ru_stime=  cpu_usage.tms_stime/CLK_TCK;
    
    
    dusage->ru_maxrss=0;    /* someday we will find where SUN has hidden these things */
    dusage->ru_ixrss=0;     /* integral shared memory size */
    dusage->ru_ismrss=0;
    dusage->ru_idrss=0;     /* integral unshared data " */
    dusage->ru_isrss=0;     /* integral unshared stack " */
    dusage->ru_minflt=0;    /* page reclaims */
    dusage->ru_nswap=0;     /* page faults */
    dusage->ru_inblock=0;   /* block input operations */
    dusage->ru_oublock=0;   /* block output operations */
    dusage->ru_msgsnd=0;    /* messages sent */
    dusage->ru_msgrcv=0;    /* messages received */
    dusage->ru_nsignals=0;  /* signals received */
    dusage->ru_nvcsw=0;     /* voluntary context switches */
    dusage->ru_nivcsw=0;    /* involuntary " */
#else
    
    start_time= times( &cpu_usage);
    dusage->ru_utime= rusage.ru_utime.tv_sec;
    dusage->ru_stime= rusage.ru_stime.tv_sec;
    
    
    dusage->ru_maxrss=rusage.ru_maxrss;
    dusage->ru_ixrss=rusage.ru_ixrss;
#if ultrix
    dusage->ru_ismrss=rusage.ru_ismrss;
#else
    dusage->ru_ismrss=0;
#endif
    
    dusage->ru_idrss=rusage.ru_idrss;
    dusage->ru_isrss=rusage.ru_isrss;
    dusage->ru_minflt=rusage.ru_minflt;
    dusage->ru_majflt=rusage.ru_majflt;
    dusage->ru_nswap=rusage.ru_nswap;
    dusage->ru_inblock=rusage.ru_inblock;
    dusage->ru_oublock=rusage.ru_oublock;
    dusage->ru_msgsnd=rusage.ru_msgsnd;
    dusage->ru_msgrcv=rusage.ru_msgrcv;
    dusage->ru_nsignals=rusage.ru_nsignals;
    dusage->ru_nvcsw=rusage.ru_nvcsw;
    dusage->ru_nivcsw=rusage.ru_nivcsw;
#endif
    
    /*   send mail to users if requested                  */
    dqs_mail_abnormal_termination= dqs_mail_exit_status & 0x00ff;
    mail_users= job->mail_list;
    mail_options= job->mail_options;
    strcpy(dqs_mail_start,dqs_ctime(job->start_time) );
    strcpy(dqs_mail_end, dqs_ctime(dusage->end_time) );
    
    if( (VALID(MAIL_AT_EXIT,mail_options)) && (!dqs_mail_abnormal_termination) ){
      DPRINTF((DQS_EVENT,"mail VALID at EXIT"));     	
      sprintf(dqs_mail_subj,"Job %d Complete",job->job_number);
      sprintf(dqs_mail_body,"Job %d Complete\n Start Time= %s\n End Time  = %s",
	      job->job_number, dqs_mail_start, dqs_mail_end );
      dqs_mail(mail_users,dqs_mail_subj, dqs_mail_body);
    }
    
    if( (VALID(MAIL_AT_ABORT,mail_options) )&& (dqs_mail_abnormal_termination) ){
      DPRINTF((DQS_EVENT,"MAIL VALID at ABORT"));     	
      sprintf(dqs_mail_subj,"Job %d Aborted",job->job_number);
      sprintf(dqs_mail_body,"Job %d Aborted Exit Status= %d  Signal# %d \n Start Time= %s\n End Time  = %s",
	      job->job_number, dqs_mail_exit_status, termsignal,dqs_mail_start, dqs_mail_end );
      dqs_mail(mail_users,dqs_mail_subj, dqs_mail_body);
    }
    
    /* Note that we could have multiple instances of same job running under same queue */
    /* As such we play games with lp->str0 so we can use the same primitives */
    
    sprintf(str,"%d",job->pid);
    lp->str0=dqs_string_insert(lp->str0,str);
    Job_head=dqs_del_str0(Job_head,lp->str0); /* neat huh */
    
    bzero((char *)&listel,sizeof(listel));
    listel.type=DQS_EXECD;
    listel.int0=JOB_EXIT;
    listel.str0=dqs_string_insert(NULL,dusage->dqs_job_name);
    listel.rusage=dusage;
    listel.tid=dqs_get_tid();
    sprintf(str,"%s.%d",dusage->dqs_job_name,dusage->pid);
    listel.str1=dqs_string_insert(NULL,str);
    dqs_write_list_to_disk(RUSAGE_DIR,listel.str1,&listel,ALL);
    
    DPRINTF((DQS_EVENT,"*****  \"%s\"reaped \"%s\"",listel.tid->str0,dusage->dqs_job_name));
    Rusage_head=dqs_insert(DQS_STR0,ASCENDING,Rusage_head,&listel);
    
  }
  
  DEXIT;
  return;
  
}
