# Copyright (c) 2002, 2003 by Michael Gogins. All rights reserved.
# Tutorial demonstrating a MusicModel composition based on a Lindenmayer system.
import gc
import os
import sys
import math
import os.path
import CsoundAC
gc.disable()
model = CsoundAC.MusicModel()
model.setFilename('CellUnitTests.py')
model.setArtist('Michael_Gogins')
model.setTitle('Lindenmayer')
model.setCopyright('C_2010_Michael_Gogins')
model.setLicense('Creative_Commons_by_nc_nd')
model.setAlbum('Csound_Unit_Tests')
csound = model.getCppSound()
tests = CsoundAC.Sequence()
tests.thisown = False
model.addChild(tests)
cellAbsolute = CsoundAC.Cell()
cellAbsolute.thisown = False
tests.addChild(cellAbsolute)
cellAbsolute = CsoundAC.Cell()
cellAbsolute.thisown = False
tests.addChild(cellAbsolute)
cellRelative = CsoundAC.Cell()
cellRelative.thisown = False
tests.addChild(cellRelative)
hocket = CsoundAC.Hocket()
hocket.thisown = False
tests.addChild(hocket)
intercut = CsoundAC.Intercut()
intercut.thisown = False
tests.addChild(intercut)
stack = CsoundAC.Stack()
stack.thisown = False
tests.addChild(stack)
koch = CsoundAC.Koch()
koch.thisown = False
tests.addChild(koch)
motiveA = CsoundAC.ScoreNode()
motiveA.thisown = False
motiveB = CsoundAC.ScoreNode()
motiveB.thisown = False
motiveC = CsoundAC.ScoreNode()
motiveC.thisown = False
motiveA.getScore().append(0, 1, 144, 1, 60, 40)
motiveA.getScore().append(1, 1, 144, 1, 64, 40)
motiveA.getScore().append(2, 1, 144, 1, 67, 40)
motiveA.getScore().append(3, 1, 144, 1, 71, 40)
motiveB.getScore().append(0, 1, 144, 1, 60, 40)
motiveB.getScore().append(1, 1, 144, 1, 63, 40)
motiveB.getScore().append(2, 1, 144, 1, 60, 40)
motiveC.getScore().append(0, 1, 144, 1, 67, 40)
motiveC.getScore().append(1, 1, 144, 1, 69, 40)
motiveC.getScore().append(2, 1, 144, 1, 70, 40)
motiveC.getScore().append(3, 1, 144, 1, 71, 40)
intercut.addChild(motiveA)
intercut.addChild(motiveA)
intercut.addChild(motiveC)
stack.addChild(motiveA)
stack.addChild(motiveB)
koch.addChild(motiveC)
koch.addChild(motiveB)
koch.addChild(motiveA)
koch.duration = 30
print motiveA.getScore().getCsoundScore()
cellAbsolute.addChild(motiveA)
cellAbsolute.repeatCount = 5
cellAbsolute.durationSeconds = .5
cellAbsolute.relativeDuration = False
cellRelative.addChild(motiveA)
cellRelative.repeatCount = 5
cellRelative.durationSeconds = .5
cellRelative.relativeDuration = True

output = os.path.abspath(model.getFilename() + '.wav')
print 'Output:', output
model.setConformPitches(True)
csound.load('../../examples/CsoundAC.csd')
csound.setCommand("csound -m195 -RWZdfo" + output + " " + model.getFilename() + ".orc " + model.getFilename() + ".sco")
csound.setFilename(model.getFilename())
score = model.getScore()
score.arrange(1, 8)
print 'Events in generated score:', len(score)
duration = score.getDuration()
print 'Duration: %9.4f' % (duration)
print csound.getCommand()
argv = '--csound --playwav'.split()
model.processArgv(len(argv), argv)
