<CsoundSynthesizer>
<CsOptions>
; Change the driver and the device to fit the platform.
; For Linux:
; csound -RWdf -+rtaudio=alsa -odac
; For Windows:
csound -RWdf -+rtaudio=PortAudio -odac
</CsOptions>
<CsInstruments>
sr                              =                       48000
ksmps                           =                       20
nchnls                          =                       2
gSnapshotfile                   =                       "lua_score_generator.snap"
0dbfs					        =                      	1000000

                                lua_exec                {{
                                
local ChordSpace = require("ChordSpace")
local ffi = require("ffi")
local math = require("math")

-- Change the library name to fit the platform.
-- For Windows:
local csoundApi = ffi.load('csound64.dll.5.2')
-- For Linux:
-- local csoundApi = ffi.load('csound64.so.5.2')
ffi.cdef[[
    int csoundScoreEvent(void *csound, char opcode, double *pfields, long pfieldCount);
]]

local scoreEvent = ffi.new('double[11]')
local chord = ChordSpace.chordsForNames['BM7']
local modality = chord:clone()
local status = 144.0
local y = 0.5
local y1 = 0.5
-- SECTION A.
local time_ = 1.0
-- FilteredSines, ChebyDrone, ZakianFlute, ChebyDrone 
local arrangement = {3, 1, 10, 1} 
local velocity = 56.0
local d_velocity = 0.03
local dd_velocity = 0.0
local inc = 3.56
local iterations = 210
local interval = 1.0 / 3.0
local duration = 12 * interval
local i = 0
while i < iterations do
    i = i + 1
    if i % 20 == 0 then
        chord = chord:Q(7, modality)
    end
    if i % 60 == 0 then
        chord = chord:K()
    end
    y1 = inc * y * (1 - y)
    y = y1
    scoreEvent[0] = arrangement[1 + (i % 4)]
    scoreEvent[1] = time_
    time_ = time_ + interval
    scoreEvent[2] = duration
    local key = math.floor(24 + y1 * 72)
    scoreEvent[3] = ChordSpace.conformPitchToChord(key, chord)
    scoreEvent[4] = velocity
    velocity = velocity + d_velocity
    d_velocity = d_velocity + dd_velocity
    scoreEvent[6] = math.random(-1000, 1000) / 1000.0
    csoundApi.csoundScoreEvent(csound, 105, scoreEvent, 11)
end
-- SECTION B.
time_ = time_ + 5.0
-- FenderRhodesModel, FMWaterBell, Xing, ModerateFM
arrangement = {2, 4, 9, 7}
chord = chord:Q(5, modality)
velocity = 60.0
d_velocity = 0.0
dd_velocity = 0.00007
inc = 3.98972
interval = 1.0 / 12.0
duration = 9 * interval
iterations = 800
i = 0
while i < iterations do
    i = i + 1
    if i % 60 == 0 then
        chord = chord:T(-1)
        chord = chord:K()
    end
    y1 = inc * y * (1 - y)
    y = y1
    scoreEvent[0] = arrangement[1 + (i % 4)]
    scoreEvent[1] = time_
    time_ = time_ + interval
    scoreEvent[2] = duration
    local key = math.floor(36 + y1 * 60)
    scoreEvent[3] = ChordSpace.conformPitchToChord(key, chord)
    scoreEvent[4] = velocity
    velocity = velocity + d_velocity
    d_velocity = d_velocity + dd_velocity
    scoreEvent[6] = math.random(-1000, 1000) / 1000.0
    csoundApi.csoundScoreEvent(csound, 105, scoreEvent, 11)
end
-- SECTION C.
time_ = time_ + 2.0
-- Harpsichord, Guitar, Harpsichord, Guitar
local arrangement = {6, 5, 6, 5}
chord = chord:Q(-5, modality)
velocity = 66.0
d_velocity = -0.02
dd_velocity = 0.00008
inc = 3.99456
interval = 1.0 / 6.0
duration = 12 * interval
iterations = 250
i = 0
while i < iterations do
    i = i + 1
    if i % 15 == 0 then
        chord = chord:Q(2, modality)
    end
    if i % 60 == 0 then
        chord = chord:K()
    end
    y1 = inc * y * (1 - y)
    y = y1
    scoreEvent[0] = arrangement[1 + (i % 4)]
    scoreEvent[1] = time_
    time_ = time_ + interval
    scoreEvent[2] = duration
    local key = math.floor(36 + y1 * 48)
    scoreEvent[3] = ChordSpace.conformPitchToChord(key, chord)
    scoreEvent[4] = velocity
    velocity = velocity + d_velocity
    d_velocity = d_velocity + dd_velocity
    scoreEvent[6] = math.random(-1000, 1000) / 1000.0
    csoundApi.csoundScoreEvent(csound, 105, scoreEvent, 11)
end

}}

iampdbfs                        init                    32768
                                prints                  "Default amplitude at 0 dBFS:  %9.4f\n", iampdbfs
idbafs                          init                    dbamp(iampdbfs)
                                prints                  "dbA at 0 dBFS:                 %9.4f\n", idbafs
iheadroom                       init                    6
                                prints                  "Headroom (dB):                 %9.4f\n", iheadroom
idbaheadroom                    init                    idbafs - iheadroom
                                prints                  "dbA at headroom:               %9.4f\n", idbaheadroom
iampheadroom                    init                    ampdb(idbaheadroom)
                                prints                  "Amplitude at headroom:        %9.4f\n", iampheadroom
                                prints                  "Balance so the overall amps at the end of performance -6 dbfs.\n"

giSliderStyle                   =                       5
ivaluatorwidth                  =                       120
iwidgetheight                   =                       20
idisplaywidth                   =                       80
iguibox                         =                       2
iguioffset                      =                       3
iwidgetoffset                   =                       16
ipanelwidth                     =                       600
ipanelheight                    =                       500
                                FLpanel                 "Csound", ipanelwidth, ipanelheight, 10, 10, iguibox, 0, 1
itabswidth                      =                       ipanelwidth - (2 * iguioffset)
itabsheight                     =                       ipanelheight - (2 * iguioffset)
                                FLtabs                  itabswidth, itabsheight, iguioffset, iguioffset
itabwidth                       =                       itabswidth
itabtabheight                   =                       iwidgetheight + 2 * iguioffset
itabheight                      =                       itabsheight - itabtabheight
ifirstwidgetx                   =                       iwidgetoffset + 2 * iguioffset
ifirstwidgety                   =                       iwidgetoffset + itabtabheight + 2 * iguioffset

giFlatQ                         init                    sqrt(0.5)
giseed				            init                    0.5

gkHarpsichordGain               chnexport               "gkHarpsichordGain",            1
gkHarpsichordGain               init                    1
gkHarpsichordPan                chnexport               "gkHarpsichordPan",             1
gkHarpsichordPan                init                    0.5

                                connect                 "ChebyDrone",           "outleft", 	"Reverb",        "inleft"
                                connect                 "ChebyDrone",           "outright", "Reverb",        "inright"
                                connect                 "Compressor",           "outleft", 	"ParEq1",        "inleft"
                                connect                 "Compressor",           "outright", "ParEq1",        "inright"
                                connect                 "FenderRhodesModel",    "outleft", 	"Reverb",        "inleft"
                                connect                 "FenderRhodesModel",    "outright", "Reverb",        "inright"
                                connect                 "FilteredSines",        "outleft", 	"Reverb",        "inleft"
                                connect                 "FilteredSines",        "outright", "Reverb",        "inright"
                                connect                 "Guitar",               "outleft", 	"Reverb",        "inleft"
                                connect                 "Guitar",               "outright", "Reverb",        "inright"
                                connect                 "Harpsichord",          "outleft", 	"Reverb",        "inleft"
                                connect                 "Harpsichord",          "outright", "Reverb",        "inright"
                                connect                 "ModerateFM",          	"outleft", 	"Reverb",        "inleft"
                                connect                 "ModerateFM",          	"outright", "Reverb",        "inright"
                                connect                 "ParEq1",               "outleft", 	"ParEq2",        "inleft"
                                connect                 "ParEq1",               "outright", "ParEq2",        "inright"
                                connect                 "ParEq2",               "outleft", 	"MasterOutput",         "inleft"
                                connect                 "ParEq2",               "outright", "MasterOutput",         "inright"
                                connect                 "Reverb",               "outleft", 	"Compressor",           "inleft"
                                connect                 "Reverb",               "outright", "Compressor",           "inright"
                                connect                 "Xing",                 "outleft", 	"Reverb",        "inleft"
                                connect                 "Xing",                 "outright", "Reverb",        "inright"
                                connect                 "ZakianFlute",          "outleft", 	"Reverb",        "inleft"
                                connect                 "ZakianFlute",          "outright", "Reverb",        "inright"

                                alwayson                "Reverb"
                                alwayson                "Compressor"
                                alwayson                "ParEq1"
                      
          alwayson                "ParEq2"
                                alwayson                "MasterOutput"

                                //////////////////////////////////////////////
                                // CHEBYSHEV DRONE
                                // By Michael Gogins.
                                //////////////////////////////////////////////
                                FLgroup                 "ChebyDrone", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkChebyDroneC1, giChebyDroneC1  FLslider                "Coefficient 1", 0, 2, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giChebyDroneC1
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkChebyDroneC2, giChebyDroneC2  FLslider                "Coefficient 2", 0, 2, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giChebyDroneC2
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkChebyDroneC3, giChebyDroneC3  FLslider                "Coefficient 3", 0, 2, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giChebyDroneC3
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkChebyDroneC4, giChebyDroneC4  FLslider                "Coefficient 4", 0, 2, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giChebyDroneC4
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkChebyDroneC5, giChebyDroneC5  FLslider                "Coefficient 5", 0, 2, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giChebyDroneC5
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkChebyDroneC6, giChebyDroneC6  FLslider                "Coefficient 6", 0, 2, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giChebyDroneC6
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkChebyDroneC7, giChebyDroneC7  FLslider                "Coefficient 7", 0, 2, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giChebyDroneC7
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkChebyDroneC8, giChebyDroneC8  FLslider                "Coefficient 8", 0, 2, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giChebyDroneC8
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkChebyDroneC9, giChebyDroneC9  FLslider                "Coefficient 9", 0, 2, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giChebyDroneC9
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkChebyDroneLevel, giChebyDroneLevel    FLslider        "Output level", 0.0001, 1000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giChebyDroneLevel
                                FLgroupEnd
                                instr                   ChebyDrone
                                pset                    0, 0, 3600
i_instrument                    =                       p1
i_time                          =                       p2
i_duration                      =                       p3
i_midikey                       =                       p4
i_midivelocity                  =                       p5
i_phase                         =                       p6
i_pan                           =                       p7
i_depth                         =                       p8
i_height                        =                       p9
i_pitchclassset                 =                       p10
i_homogeneity                   =                       p11
ihertz                          =                       cpsmidinn(i_midikey)
iamp                            =                       ampdb(i_midivelocity) 
idampingattack                  =                       .01
idampingrelease                 =                       .02
idampingsustain                 =                       p3
iduration                       =                       idampingattack + idampingsustain + idampingrelease
p3                              =                       iduration
iattack                         init                    p3 / 4.0
idecay                          init                    p3 / 4.0
isustain                        init                    p3 / 2.0
aenvelope                       transeg                 0.0, iattack / 2.0, 2.5, iamp / 2.0, iattack / 2.0, -2.5, iamp, isustain, 0.0, iamp, idecay / 2.0, 2.5, iamp / 2.0, idecay / 2.0, -2.5, 0.
isinetable                      ftgenonce               0, 0, 65536, 10, 1, 0, .02
asignal                         poscil3                 1, ihertz, isinetable
asignal                         chebyshevpoly           asignal, 0, gkChebyDroneC1, gkChebyDroneC2, gkChebyDroneC3, gkChebyDroneC4, gkChebyDroneC5, gkChebyDroneC6, gkChebyDroneC7, gkChebyDroneC8, gkChebyDroneC9
adeclick                        linsegr                 0, idampingattack, 1, idampingsustain, 1, idampingrelease, 0
asignal                         =                       asignal * aenvelope * gkChebyDroneLevel
aoutleft, aoutright             pan2                    asignal * adeclick, i_pan
                                outleta                 "outleft", aoutleft
                                outleta                 "outright", aoutright
                                prints                  "instr %4d t %9.4f d %9.4f k %9.4f v %9.4f p %9.4f\n", p1, p2, p3, p4, p5, p7
                                endin

                                //////////////////////////////////////////////////////
                                // FenderRhodesModel
                                // Original by Perry Cook.
                                // Adapted by Michael Gogins.
                                //////////////////////////////////////////////////////
                                FLgroup                 "FenderRhodes", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkFenderRhodesLevel, giFenderRhodesLevel    FLslider        "Output level", 0.0001, 1000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giFenderRhodesLevel
                                FLgroupEnd
                                instr                   FenderRhodesModel
                                pset                    0, 0, 3600
i_instrument                    =                       p1
i_time                          =                       p2
i_duration                      =                       p3
i_midikey                       =                       p4
i_midivelocity                  =                       p5
i_phase                         =                       p6
i_pan                           =                       p7
i_depth                         =                       p8
i_height                        =                       p9
i_pitchclassset                 =                       p10
i_homogeneity                   =                       p11
iattack                         =                       0.01
isustain                        =                       p3
irelease                        =                       0.125
p3                              =                       isustain + iattack + irelease
adeclick                        linsegr                 0.0, iattack, 1.0, isustain, 1.0, irelease, 0.0
iindex                          =                       4
icrossfade                      =                       3
ivibedepth                      =                       0.2
iviberate                       =                       6
isine                           ftgenonce               0, 0, 65536,    10,     1
icosine                         ftgenonce               0, 0, 65536,    11,     1
icookblank                      ftgenonce               0, 0, 65536,     10,     0 ; Blank wavetable for some Cook FM opcodes.
ifn1                            =                       isine
ifn2                            =                       icosine
ifn3                            =                       isine
ifn4                            =                       icookblank
ivibefn                         =                       isine
ifrequency                      =                       cpsmidinn(i_midikey)
iamplitude                      =                       ampdb(i_midivelocity) * 6
asignal                         fmrhode                 iamplitude, ifrequency, iindex, icrossfade, ivibedepth, iviberate, ifn1, ifn2, ifn3, ifn4, ivibefn
aoutleft, aoutright		        pan2			        asignal * adeclick * gkFenderRhodesLevel, i_pan
                                outleta                 "outleft",  aoutleft
                                outleta                 "outright", aoutright
                                prints                  "instr %4d t %9.4f d %9.4f k %9.4f v %9.4f p %9.4f\n", p1, p2, p3, p4, p5, p7
                     
           endin

                                //////////////////////////////////////////////////////
                                // FilteredSines
                                // Original by Michael Bergeman.
                                // Adapted by Michael Gogins.
                                //////////////////////////////////////////////////////
                                FLgroup                 "FilteredSines", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkFilteredSinesLevel, giFilteredSinesLevel    FLslider        "Output level", 0.0001, 1000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giFilteredSinesLevel
                                FLgroupEnd
                                instr                   FilteredSines
                                ; Original pfields
                                ; p1 p2 p3 p4 p5 p6 p7 p8 p9
                                ; ins st dur db func at dec freq1 freq2
                                pset                    0, 0, 3600
i_instrument                    =                       p1
i_time                          =                       p2
i_duration                      =                       p3
i_midikey                       =                       p4
i_midivelocity                  =                       p5
i_phase                         =                       p6
i_pan                           =                       p7
i_depth                         =                       p8
i_height                        =                       p9
i_pitchclassset                 =                       p10
i_homogeneity                   =                       p11
iattack                         =                       0.03
isustain                        =                       p3
irelease                        =                       0.52
p3                              =                       p3 + iattack + irelease
i_duration                      =                       p3
adeclick                        linsegr                  0.0, iattack, 1.0, isustain, 1.0, irelease, 0.0
ip4                             =                       i_midivelocity
idb                             =                       ampdb(i_midivelocity) * 4
ibergeman                       ftgenonce               0, 0, 65536,     10,     0.28, 1, 0.74, 0.66, 0.78, 0.48, 0.05, 0.33, 0.12, 0.08, 0.01, 0.54, 0.19, 0.08, 0.05, 0.16, 0.01, 0.11, 0.3, 0.02, 0.2 ; Bergeman f1
ip5                             =                       ibergeman
ip3                             =                       i_duration
ip6                             =                       i_duration * 0.25
ip7                             =                       i_duration * 0.75
ip8                             =                       cpsmidinn(i_midikey - 0.01)
ip9                             =                       cpsmidinn(i_midikey + 0.01)
isc                             =                       idb * 0.333
k1                              line                    40, p3, 800
k2                              line                    440, p3, 220
k3                              linen                   isc, ip6, p3, ip7
k4                              line                    800, ip3, 40
k5                              line                    220, ip3, 440
k6                              linen                   isc, ip6, ip3, ip7
k7                              linen                   1, ip6, ip3, ip7
a5                              oscili                  k3, ip8, ip5
a6                              oscili                  k3, ip8 * 0.999, ip5
a7                              oscili                  k3, ip8 * 1.001, ip5
a1                              =                       a5 + a6 + a7
a8                              oscili                  k6, ip9, ip5
a9                              oscili                  k6, ip9 * 0.999, ip5
a10                             oscili                  k6, ip9 * 1.001, ip5
a11                             =                       a8 + a9 + a10
a2                              butterbp                a1, k1, 40
a3                              butterbp                a2, k5, k2 * 0.8
a4                              balance                 a3, a1
a12                             butterbp                a11, k4, 40
a13                             butterbp                a12, k2, k5 * 0.8
a14                             balance                 a13, a11
a15                             reverb2                 a4, 5, 0.3
a16                             reverb2                 a4, 4, 0.2
                                ; Constant-power pan.
ipi                             =                       4.0 * taninv(1.0)
iradians                        =                       i_pan * ipi / 2.0
itheta                          =                       iradians / 2.0
; Translate angle in [-1, 1] to left and right gain factors.
irightgain                      =                       sqrt(2.0) / 2.0 * (cos(itheta) + sin(itheta))
ileftgain                       =                       sqrt(2.0) / 2.0 * (cos(itheta) - sin(itheta))
a17                             =                       (a15 + a4) * ileftgain * k7
a18                             =                       (a16 + a4) * irightgain * k7
aoutleft                        =                       a17 * adeclick * gkFilteredSinesLevel
aoutright                       =                       a18 * adeclick * gkFilteredSinesLevel
                                outleta                 "outleft",  aoutleft
                                outleta                 "outright", aoutright
                                prints                  "instr %4d t %9.4f d %9.4f k %9.4f v %9.4f p %9.4f\n", p1, p2, p3, p4, p5, p7
                                endin

                                //////////////////////////////////////////////
                                // FMWaterBell
                                // Original by Steven Yi.
                                // Adapted by Michael Gogins.
                                //////////////////////////////////////////////
                                FLgroup                 "FMWaterBell", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkFMWaterBellLevel, giFMWaterBellLevel    FLslider        "Output level", 0.0001, 1000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giFMWaterBellLevel
                                FLgroupEnd
                                instr                   FMWaterBell
                                pset                    0, 0, 3600
i_instrument                    =                       p1
i_time                          =                       p2
i_duration                      =                       p3
i_midikey                       =                       p4
i_midivelocity                  =                       p5
i_phase                         =                       p6
i_pan                           =                       p7
i_depth                         =                       p8
i_height                        =                       p9
i_pitchclassset                 =                       p10
i_homogeneity                   =                       p11
ipch                            =                       cpsmidinn(i_midikey)
iamplitude                      =                       ampdb(i_midivelocity) * 2.0
ipch2                           =                       ipch
kpchline 	                    line                    ipch, i_duration, ipch2
iamp 	                        =                       2
ienvType	                    =                       2
kenv 	                        init 	                0
                                if ienvType == 0 kgoto env0  ; adsr
                                if ienvType == 1 kgoto env1  ; pyramid
                                if ienvType == 2 kgoto env2  ; ramp
env0:
kenv	                        adsr	                .3, .2, .9, .5
                                kgoto                   endEnvelope
env1:
kenv 	                        linseg	                0, i_duration * .5, 1, i_duration * .5, 0
                                kgoto                   endEnvelope
env2:
kenv	                        linseg 	                0, i_duration - .1, 1, .1, 0
kgoto                           endEnvelope
endEnvelope:
kc1                             =                       5
kc2                             =                       5
kvdepth                         =                       0.005
kvrate                          =                       6
icosine                  	    ftgenonce               0, 0, 65536, 11, 1
ifn1                            =                       icosine
ifn2                            =                       icosine
ifn3                            =                       icosine
ifn4                            =                       icosine
ivfn                            =                       icosine
asignal                         fmbell	                iamp, kpchline, kc1, kc2, kvdepth, kvrate, ifn1, ifn2, ifn3, ifn4, ivfn
iattack                         =                       0.003
isustain                        =                       p3
irelease                        =                       0.06
p3                              =                       isustain + iattack + irelease
adeclick                        linsegr                 0.0, iattack, 1.0, isustain, 1.0, irelease, 0.0
aoutleft,
 aoutright             pan2                    iamplitude * asignal * gkFMWaterBellLevel * adeclick, i_pan
                                outleta                 "outleft",  aoutleft
                                outleta                 "outright", aoutright
                                prints                  "instr %4d t %9.4f d %9.4f k %9.4f v %9.4f p %9.4f\n", p1, p2, p3, p4, p5, p7
                                endin

                                //////////////////////////////////////////////
                                // Guitar
                                // By Michael Gogins.
                                //////////////////////////////////////////////
                                FLgroup                 "Guitar", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkGuitarLevel, giGuitarLevel    FLslider        "Output level", 0.0001, 1000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giGuitarLevel
                                FLgroupEnd
                                instr                   Guitar
                                pset                    0, 0, 3600
i_instrument                    =                       p1
i_time                          =                       p2
i_duration                      =                       p3
i_midikey                       =                       p4
i_midivelocity                  =                       p5
i_phase                         =                       p6
i_pan                           =                       p7
i_depth                         =                       p8
i_height                        =                       p9
i_pitchclassset                 =                       p10
i_homogeneity                   =                       p11
ifrequency                      =                       cpsmidinn(i_midikey)
iamplitude                      =                       ampdb(i_midivelocity) / 8.0
iattack                         =                       0.01
isustain                        =                       p3
irelease                        =                       0.05
p3                              =                       isustain + iattack + irelease
adeclick                        linsegr                 0.0, iattack, 1.0, isustain, 1.0, irelease, 0.0
ifrequency                      =                       cpsmidinn(p4)
iamplitude                      =                       ampdb(p5) * 20
kamp                            linsegr                 0.0, iattack, iamplitude, isustain, iamplitude, irelease, 0.0
asigcomp                        pluck                   1, 440, 440, 0, 1
asig                            pluck                   1, ifrequency, ifrequency, 0, 1
af1                             reson                   asig, 110, 80
af2                             reson                   asig, 220, 100
af3                             reson                   asig, 440, 80
aout                            balance                 0.6 * af1+ af2 + 0.6 * af3 + 0.4 * asig, asigcomp
kexp                            expseg                  1.0, iattack, 2.0, isustain, 1.0, irelease, 1.0
kenv                            =                       kexp - 1.0
asignal                         =                       aout * kenv * kamp
aoutleft, aoutright             pan2                    asignal * adeclick * gkGuitarLevel, i_pan
                                outleta                 "outleft",  aoutleft
                                outleta                 "outright", aoutright
                                prints                  "instr %4d t %9.4f d %9.4f k %9.4f v %9.4f p %9.4f\n", p1, p2, p3, p4, p5, p7
                                endin

                                //////////////////////////////////////////////
                                // Original by James Kelley.
                                // Adapted by Michael Gogins.
                                //////////////////////////////////////////////
                                FLgroup                 "Harpsichord", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkHarpsichordLevel, giHarpsichordLevel    FLslider        "Output level", 0.0001, 1000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giHarpsichordLevel
                                FLgroupEnd
                                instr 			        Harpsichord
insno           		        =                       p1
itime           		        =                       p2
iduration       		        =                       p3
ikey            		        =                       p4
ivelocity                       =                       p5
iphase                          =                       p6
ipan                            =                       p7
idepth                          =                       p8
iheight                         =                       p9
ipcs                            =                       p10
ihomogeneity                    =                       p11
gkHarpsichordGain               =                       .25
gkHarpsichordPan                =                       .5
iattack                         =                       .005
isustain                        =                       p3
irelease                        =                       .3
p3                              =                       iattack + isustain + irelease
iHz                             =                       cpsmidinn(ikey)
kHz                             =                       k(iHz)
iamplitude                      =                       ampdb(ivelocity) * 36
aenvelope               	    transeg                 1.0, 20.0, -10.0, 0.05
apluck                  	    pluck                   1, kHz, iHz, 0, 1
iharptable              	    ftgenonce               0, 0, 65536,  7, -1, 1024, 1, 1024, -1
aharp                   	    poscil                  1, kHz, iharptable
aharp2                  	    balance                 apluck, aharp
asignal			                =                       (apluck + aharp2) * iamplitude * aenvelope * gkHarpsichordGain
adeclick                        linsegr                 0, iattack, 1, isustain, 1, irelease, 0
aoutleft, aoutright             pan2                    asignal * adeclick * gkHarpsichordLevel, ipan
                                outleta                 "outleft",  aoutleft
                                outleta                 "outright", aoutright
                                prints                  "instr %4d t %9.4f d %9.4f k %9.4f v %9.4f p %9.4f\n", p1, p2, p3, p4, p5, p7
                                endin

                                //////////////////////////////////////////////
                                // ModerateFM
                                // By Michael Gogins.
                                //////////////////////////////////////////////
                                FLgroup                 "ModerateFM", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkModerateFMCarrier, giModerateFMCarrier    FLslider    "Carrier", 0.5, 2, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1.0, giModerateFMCarrier
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkModerateFMModulator, giModerateFMModulator    FLslider "Modulator", 0.0, 10.0, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              0.5, giModerateFMModulator
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkModerateFMIndex, giModerateFMIndex    FLslider        "Index", 0.0, 10.0, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              0.25, giModerateFMIndex
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkModerateFMAmplitude, giModerateFMAmplitude    FLslider "FM amplitude", 0.0, 10.0, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              0.25, giModerateFMAmplitude
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkModerateFMLevel, giModerateFMLevel    FLslider        "Output level", 0.0001, 1000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giModerateFMLevel
                                FLgroupEnd
                                instr			        ModerateFM
                                pset                    0, 0, 1000
i_instrument                    =                       p1
i_time                          =                       p2
i_duration                      =                       p3
i_midikey                       =                       p4
i_midivelocity                  =                       p5
i_phase                         =                       p6
i_pan                           =                       p7
i_depth                         =                       p8
i_height                        =                       p9
i_pitchclassset                 =                       p10
i_homogeneity                   =                       p11
iattack			                =			            0.002
isustain		                =			            p3
idecay				
            =			            8
irelease		                =			            0.05
iHz                             =                       cpsmidinn(i_midikey)
idB                             =                       i_midivelocity
iamplitude                      =                       ampdb(idB) * 4.0
ifrequencyb             	    =                       iHz * 1.003
kcarrierb               	    =                       gkModerateFMCarrier * 1.004
aindenv                 	    transeg                 0.0, iattack, -11.0, 1.0, idecay, -7.0, 0.025, isustain, 0.0, 0.025, irelease, -17.0, 0.0
aindex                  	    =                       aindenv * gkModerateFMIndex * gkModerateFMAmplitude
kindex                          downsamp                aindex, ksmps
isinetable                      ftgenonce               0, 0, 65536, 10, 1, 0, .02
aouta                   	    foscili                 1.0, iHz, gkModerateFMCarrier, gkModerateFMModulator, kindex / 4., isinetable
aoutb                   	    foscili                 1.0, ifrequencyb, kcarrierb, gkModerateFMModulator, kindex, isinetable
asignal               		    =                       (aouta + aoutb) * aindenv
adeclick                        linsegr                 0, iattack, 1, isustain, 1, irelease, 0
asignal                         =                       asignal * iamplitude * gkModerateFMLevel
aoutleft, aoutright             pan2                    asignal * adeclick, i_pan
                                outleta                 "outleft",  aoutleft
                                outleta                 "outright", aoutright
                                prints                  "instr %4d t %9.4f d %9.4f k %9.4f v %9.4f p %9.4f\n", p1, p2, p3, p4, p5, p7
                                endin

                                //////////////////////////////////////////////////////
                                // PlainPluckedString
                                // By Michael Gogins.
                                //////////////////////////////////////////////////////
                                FLgroup                 "PlainPluckedString", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkPlainPluckedStringLevel, giPlainPluckedStringLevel    FLslider        "Output level", 0.0001, 1000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giPlainPluckedStringLevel
                                FLgroupEnd
                                instr                   PlainPluckedString
                                pset                    0, 0, 3600
i_instrument                    =                       p1
i_time                          =                       p2
i_duration                      =                       p3
i_midikey                       =                       p4
i_midivelocity                  =                       p5
i_phase                         =                       p6
i_pan                           =                       p7
i_depth                         =                       p8
i_height                        =                       p9
i_pitchclassset                 =                       p10
i_homogeneity                   =                       p11
iattack                         =                       0.002
isustain                        =                       p3
irelease                        =                       0.075
p3                              =                       isustain + iattack + irelease
adeclick                        linsegr                 0.0, iattack, 1.0, isustain, 1.0, irelease, 0.0
ifrequency                      =                       cpsmidinn(i_midikey)
iamplitude                      =                       ampdb(i_midivelocity) * 6
aenvelope                       transeg                 0, iattack, -4, iamplitude,  isustain, -4, iamplitude / 10.0, irelease, -4, 0
asignal1                        pluck                   1, ifrequency, ifrequency * 1.002, 0, 1
asignal2                        pluck                   1, ifrequency * 1.003, ifrequency, 0, 1
asignal                         =                       (asignal1 + asignal2) * aenvelope * gkPlainPluckedStringLevel
aoutleft, aoutright		        pan2			        asignal * adeclick, i_pan
                                outleta                 "outleft",  aoutleft
                                outleta                 "outright", aoutright
                                prints                  "instr %4d t %9.4f d %9.4f k %9.4f v %9.4f p %9.4f\n", p1, p2, p3, p4, p5, p7
                                endin

                                //////////////////////////////////////////////
                                // Original by Andrew Horner.
                                // Adapted by Michael Gogins.
                                // p4 pitch in octave.pch
                                // original pitch        = A6
                                // range                 = C6 - C7
                                // extended range        = F4 - C7
                                //////////////////////////////////////////////
                                FLgroup                 "Xing", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkXingLevel, giXingLevel    FLslider        "Output level", 0.0001, 1000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giXingLevel
                                FLgroupEnd
                                instr                   Xing
insno           		        =                       p1
itime           		        =                       p2
iduration       		        =                       p3
ikey            		        =                       p4
ivelocity                       =                       p5
iphase                          =                       p6
ipan                            =                       p7
idepth                          =                       p8
iheight                         =                       p9
ipcs                            =                       p10
ihomogeneity                    =                       p11
kgain			    	=                       1.25
iHz                             =                       cpsmidinn(ikey)
kHz                             =                       k(iHz)
iattack                         =                       (440.0 / iHz) * 0.01
isustain                        =                       p3
irelease                        =                       .3
p3                              =                       iattack + isustain + irelease
iduration                       =                       p3
iamplitude                      =                       ampdb(ivelocity) * 8.
isine                           ftgenonce               0, 0, 65536,    10,     1
kfreq                           =                       cpsmidinn(ikey)
iamp                            =                       1
inorm                           =                       32310
aamp1                           linseg                  0,.001,5200,.001,800,.001,3000,.0025,1100,.002,2800,.0015,1500,.001,2100,.011,1600,.03,1400,.95,700,1,320,1,180,1,90,1,40,1,20,1,12,1,6,1,3,1,0,1,0
adevamp1                        linseg                  0, .05, .3, iduration - .05, 0
adev1                           poscil                  adevamp1, 6.7, isine, .8
amp1                            =                       aamp1 * (1 + adev1)
aamp2                           linseg                  0,.0009,22000,.0005,7300,.0009,11000,.0004,5500,.0006,15000,.0004,5500,.0008,2200,.055,7300,.02,8500,.38,5000,.5,300,.5,73,.5,5.,5,0,1,1
adevamp2                        linseg                  0,.12,.5,iduration-.12,0
adev2                           poscil                  adevamp2, 10.5, isine, 0
amp2                            =                       aamp2 * (1 + adev2)
aamp3                           linseg                  0,.001,3000,.001,1000,.0017,12000,.0013,3700,.001,12500,.0018,3000,.0012,1200,.001,1400,.0017,6000,.0023,200,.001,3000,.001,1200,.0015,8000,.001,1800,.0015,6000,.08,1200,.2,200,.2,40,.2,10,.4,0,1,0
adevamp3                        linseg                  0, .02, .8, iduration - .02, 0
adev3                           poscil                  adevamp3, 70, isine ,0
amp3                            =                       aamp3 * (1 + adev3)
awt1                            poscil                  amp1, kfreq, isine
awt2                            poscil                  amp2, 2.7 * kfreq, isine
awt3                            poscil                  amp3, 4.95 * kfreq, isine
asig                            =                       awt1 + awt2 + awt3
arel                            linenr                  1,0, iduration, .06
; asignal                         =                       asig * arel * (iamp / inorm) * iamplitude * kgain
asignal                         =                       asig * (iamp / inorm) * iamplitude * kgain
adeclick                        linsegr                 0, iattack, 1, isustain, 1, irelease, 0
asignal                         =                       asignal * gkXingLevel
aoutleft, aoutright		        pan2			        asignal * adeclick, .875;ipan
                                outleta                 "outleft",  aoutleft
                                outleta                 "outright", aoutright
                                prints                  "instr %4d t %9.4f d %9.4f k %9.4f v %9.4f p %9.4f\n", p1, p2, p3, p4, p5, p7
                                endin


                                //////////////////////////////////////////////
                                // ZakianFlute
                                // Original by Lee Zakian.
                                // Adapted by Michael Gogins.
                                //////////////////////////////////////////////
                                FLgroup                 "ZakianFlute", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkZakianFlute, giZakianFlute    FLslider        "Output level", 0.0001, 1000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giZakianFlute
                                FLgroupEnd
                                instr			        ZakianFlute
if1                    		    ftgenonce               0, 0, 65536,    10,     1
iwtsin				            init			        if1
if2                    		    ftgenonce               0, 0, 16,       -2,     40, 40, 80, 160, 320, 640, 1280, 2560, 5120, 10240, 10240
if26                   		    ftgenonce               0, 0, 65536,    -10,    2000, 489, 74, 219, 125, 9, 33, 5, 5
if27                   		    ftgenonce               0, 0, 65536,    -10,    2729, 1926, 346, 662, 537, 110, 61, 29, 7
if28                   		    ftgenonce               0, 0, 65536,    -10,    2558, 2012, 390, 361, 534, 139, 53, 22, 10, 13, 10
if29                   		    ftgenonce               0, 0, 65536,    -10,    12318, 8844, 1841, 1636, 256, 150, 60, 46, 11
if30                   		    ftgenonce               0, 0, 65536,    -10,    1229, 16, 34, 57, 32
if31                   		    ftgenonce               0, 0, 65536,    -10,    163, 31, 1, 50, 31
if32                   		    ftgenonce               0, 0, 65536,    -10,    4128, 883, 354, 79, 59, 23
if33                   		    ftgenonce               0, 0, 65536,    -10,    1924, 930, 251, 50, 25, 14
if34                   		    ftgenonce               0, 0, 65536,    -10,    94, 6, 22, 8
if35                   		    ftgenonce               0, 0, 65536,    -10,    2661, 87, 33, 18
if36                   		    ftgenonce               0, 0, 65536,    -10,    174, 12
if37                   		    ftgenonce               0, 0, 65536,    -10,    314, 13
                                pset                    0, 0, 3600
i_instrument                    =                       p1
i_time                          =                       p2
i_duration                      =                       p3
i_midikey                       =                       p4
i_midivelocity                  =                       p5
i_phase                         =                       p6
i_pan                           =                       p7
i_depth                         =                       p8
i_height                        =                       p9
i_pitchclassset                 =                       p10
i_homogeneity                   =                       p11
ifrequency                      =                       cpsmidinn(i_midikey)
iamplitude                      =                       ampdb(i_midivelocity) * 4
iattack                         =                       .25
isustain                        =                       p3
irelease                        =                       .33333333
p3                              =                       iattack + isustain + irelease
iHz                             =                       ifrequency
kHz                             =                       k(iHz)
idB                             =                       i_midivelocity
adeclick77                        linsegr                 0, iattack, 1, isustain, 1, irelease, 0
ip3                     	    =                       (p3 < 3.0 ? p3 : 3.0)
; parameters
; p4    overall amplitude scaling factor
ip4                     	    init                    iamplitude
; p5    pitch in Hertz (normal pitch range: C4-C7)
ip5                     	    init                    iHz
; p6    percent vibrato depth, recommended values in range [-1., +1.]
ip6                     	    init                    1
;        0.0    -> no vibrato
;       +1.     -> 1% vibrato depth, where vibrato rate increases slightly
;       -1.     -> 1% vibrato depth, where vibrato rate decreases slightly
; p7    attack time in seconds
;       recommended value:  .12 for slurred notes, .06 for tongued notes
;                            (.03 for short notes)
ip7                     	    init                    .08
; p8    decay time in seconds
;       recommended value:  .1 (.05 for short notes)
ip8                     	    init                    .08
; p9    overall brightness / filter cutoff factor
;       1 -> least bright / minimum filter cutoff frequency (40 Hz)
;       9 -> brightest / maximum filter cutoff frequency (10,240Hz)
ip9                     	    init                    5
; initial variables
iampscale               	    =                       ip4                              ; overall amplitude scaling factor
ifreq                   	    =                       ip5                              ; pitch in Hertz
ivibdepth               	    =                       abs(ip6*ifreq/100.0)             ; vibrato depth relative to fundamental frequency
iattack                 	    =                       ip7 * (1.1 - .2*giseed)          ; attack time with up to +-10% random deviation
giseed                  	    =                       frac(giseed*105.947)             ; reset giseed
idecay                  	    =                       ip8 * (1.1 - .2*giseed)          ; decay time with up to +-10% random deviation
giseed                  	    =                       frac(giseed*105.947)
ifiltcut                	    tablei                  ip9, if2                          ; lowpass filter cutoff frequency
iattack                 	    =                       (iattack < 6/kr ? 6/kr : iattack)               ; minimal attack length
idecay                  	    =                       (idecay < 6/kr ? 6/kr : idecay)                 ; minimal decay length
isustain                	    =                       p3 - iattack - idecay
p3                      	    =                       (isustain < 5/kr ? iattack+idecay+5/kr : p3)    ; minimal sustain length
isustain                	    =                       (isustain < 5/kr ? 5/kr : isustain)
iatt                    	    =                       iattack/6
isus                    	    =                       isustain/4
idec                    	    =                       idecay/6
iphase                  	    =                       giseed                          ; use same phase for all wavetables
giseed                  	    =                       frac(giseed*105.947)
; vibrato block
; kvibdepth               	    linseg                  .1, .8*p3, 1, .2*p3, .7
kvibdepth               	    linseg                  .1, .8*ip3, 1, isustain, 1, .2*ip3, .7
kvibdepth               	    =                       kvibdepth* ivibdepth            ; vibrato depth
kvibdepthr              	    randi                   .1*kvibdepth, 5, giseed         ; up to 10% vibrato depth variation
giseed                  	    =                       frac(giseed*105.947)
kvibdepth               	    =                       kvibdepth + kvibdepthr
ivibr1                  	    =                       giseed                          ; vibrato rate
giseed                  	    =                       frac(giseed*105.947)
ivibr2                  	    =                       giseed
giseed                  	    =                       frac(giseed*105.947)

                                if                      ip6 < 0 goto            vibrato1
kvibrate                	    linseg                  2.5+ivibr1, p3, 4.5+ivibr2      ; if p6 positive vibrato gets faster
                                goto                    vibrato2
vibrato1:
ivibr3                  	    =                       giseed
giseed                  	    =                       frac(giseed*105.947)
kvibrate                	    linseg                  3.5+ivibr1, .1, 4.5+ivibr2, p3-.1, 2.5+ivibr3   ; if p6 negative vibrato gets slower
vibrato2:
kvibrater               	    randi                   .1*kvibrate, 5, giseed          ; up to 10% vibrato rate variation
giseed                  	    =                       frac(giseed*105.947)
kvibrate                	    =                       kvibrate + kvibrater
kvib                    	    oscili                  kvibdepth, kvibrate, iwtsin
ifdev1                  	    =                       -.03 * giseed                           ; frequency deviation
giseed                  	    =                       frac(giseed*105.947)
ifdev2                  	    =                       .003 * giseed
giseed                  	    =                       frac(giseed*105.947)
ifdev3                  	    =                       -.0015 * giseed
giseed                  	    =                       frac(giseed*105.947)
ifdev4                  	    =                       .012 * giseed
giseed                  	    =                       frac(giseed*105.947)
kfreqr                  	    linseg                  ifdev1, iattack, ifdev2, isustain, ifdev3, idecay, ifdev4
kfreq                   	    =                       kHz * (1 + kfreqr) + kvib
                                if                      ifreq <  427.28 goto    range1                          ; (cpspch(8.08) + cpspch(8.09))/2
                                if                      ifreq <  608.22 goto    range2                          ; (cpspch(9.02) + cpspch(9.03))/2
                                if                      ifreq <  1013.7 goto    range3                          ; (cpspch(9.11)
 + cpspch(10.00))/2
                                goto                    range4
; wavetable amplitude envelopes
range1:                 	    ; for low range tones
kamp1                   	    linseg                  0, iatt, 0.002, iatt, 0.045, iatt, 0.146, iatt,  \
                                                        0.272, iatt, 0.072, iatt, 0.043, isus, 0.230, isus, 0.000, isus, \
                                                        0.118, isus, 0.923, idec, 1.191, idec, 0.794, idec, 0.418, idec, \
                                                        0.172, idec, 0.053, idec, 0
kamp2                   	    linseg                  0, iatt, 0.009, iatt, 0.022, iatt, -0.049, iatt,  \
                                                        -0.120, iatt, 0.297, iatt, 1.890, isus, 1.543, isus, 0.000, isus, \
                                                        0.546, isus, 0.690, idec, -0.318, idec, -0.326, idec, -0.116, idec, \
                                                        -0.035, idec, -0.020, idec, 0
kamp3                   	    linseg                  0, iatt, 0.005, iatt, -0.026, iatt, 0.023, iatt,    \
                                                        0.133, iatt, 0.060, iatt, -1.245, isus, -0.760, isus, 1.000, isus,  \
                                                        0.360, isus, -0.526, idec, 0.165, idec, 0.184, idec, 0.060, idec,   \
                                                        0.010, idec, 0.013, idec, 0
iwt1                    	    =                       if26                                      ; wavetable numbers
iwt2                    	    =                       if27
iwt3                    	    =                       if28
inorm                   	    =                       3949
                                goto                    end
range2:                 	    ; for low mid-range tones
kamp1                   	    linseg                  0, iatt, 0.000, iatt, -0.005, iatt, 0.000, iatt, \
                                                        0.030, iatt, 0.198, iatt, 0.664, isus, 1.451, isus, 1.782, isus, \
                                                        1.316, isus, 0.817, idec, 0.284, idec, 0.171, idec, 0.082, idec, \
                                                        0.037, idec, 0.012, idec, 0
kamp2                   	    linseg                  0, iatt, 0.000, iatt, 0.320, iatt, 0.882, iatt,      \
                                                        1.863, iatt, 4.175, iatt, 4.355, isus, -5.329, isus, -8.303, isus,   \
                                                        -1.480, isus, -0.472, idec, 1.819, idec, -0.135, idec, -0.082, idec, \
                                                        -0.170, idec, -0.065, idec, 0
kamp3                   	    linseg                  0, iatt, 1.000, iatt, 0.520, iatt, -0.303, iatt,     \
                                                        0.059, iatt, -4.103, iatt, -6.784, isus, 7.006, isus, 11, isus,      \
                                                        12.495, isus, -0.562, idec, -4.946, idec, -0.587, idec, 0.440, idec, \
                                                        0.174, idec, -0.027, idec, 0
iwt1                    	    =                       if29
iwt2                    	    =                       if30
iwt3                    	    =                       if31
inorm                   	    =                       27668.2
                                goto                    end
range3:                 	    ; for high mid-range tones
kamp1                   	    linseg                  0, iatt, 0.005, iatt, 0.000, iatt, -0.082, iatt,      \
                                                        0.36, iatt, 0.581, iatt, 0.416, isus, 1.073, isus, 0.000, isus,       \
                                                        0.356, isus, .86, idec, 0.532, idec, 0.162, idec, 0.076, idec, 0.064, \
                                                        idec, 0.031, idec, 0
kamp2                   	    linseg                  0, iatt, -0.005, iatt, 0.000, iatt, 0.205, iatt,      \
                                                        -0.284, iatt, -0.208, iatt, 0.326, isus, -0.401, isus, 1.540, isus,   \
                                                        0.589, isus, -0.486, idec, -0.016, idec, 0.141, idec, 0.105, idec,    \
                                                        -0.003, idec, -0.023, idec, 0
kamp3                   	    linseg                  0, iatt, 0.722, iatt, 1.500, iatt, 3.697, iatt,       \
                                                        0.080, iatt, -2.327, iatt, -0.684, isus, -2.638, isus, 0.000, isus,   \
                                                        1.347, isus, 0.485, idec, -0.419, idec, -.700, idec, -0.278, idec,    \
                                                        0.167, idec, -0.059, idec, 0
iwt1                    	    =                       if32
iwt2                    	    =                       if33
iwt3                    	    =                       if34
inorm                   	    =                       3775
                                goto                    end
range4:                                                 ; for high range tones
kamp1                   	    linseg                  0, iatt, 0.000, iatt, 0.000, iatt, 0.211, iatt,         \
                                                        0.526, iatt, 0.989, iatt, 1.216, isus, 1.727, isus, 1.881, isus,        \
                                                        1.462, isus, 1.28, idec, 0.75, idec, 0.34, idec, 0.154, idec, 0.122,    \
                                                        idec, 0.028, idec, 0
kamp2                   	    linseg                  0, iatt, 0.500, iatt, 0.000, iatt, 0.181, iatt,         \
                                                        0.859, iatt, -0.205, iatt, -0.430, isus, -0.725, isus, -0.544, isus,    \
                                                        -0.436, isus, -0.109, idec, -0.03, idec, -0.022, idec, -0.046, idec,    \
                                                        -0.071, idec, -0.019, idec, 0
kamp3                   	    linseg                  0, iatt, 0.000, iatt, 1.000, iatt, 0.426, iatt,         \
                                                        0.222, iatt, 0.175, iatt, -0.153, isus, 0.355, isus, 0.175, isus,       \
                                                        0.16, isus, -0.246, idec, -0.045, idec, -0.072, idec, 0.057, idec,      \
                                                        -0.024, idec, 0.002, idec, 0
iwt1                    	    =                       if35
iwt2                    	    =                       if36
iwt3                    	    =                       if37
inorm                   	    =                       4909.05
                                goto                    end
end:
kampr1                  	    randi                   .02*kamp1, 10, giseed                   ; up to 2% wavetable amplitude variation
giseed                  	    =                       frac(giseed*105.947)
kamp1                   	    =                       kamp1 + kampr1
kampr2                  	    randi                   .02*kamp2, 10, giseed                   ; up to 2% wavetable amplitude variation
giseed                  	    =                       frac(giseed*105.947)
kamp2                   	    =                       kamp2 + kampr2
kampr3                  	    randi                   .02*kamp3, 10, giseed                   ; up to 2% wavetable amplitude variation
giseed                  	    =                       frac(giseed*105.947)
kamp3                   	    =                       kamp3 + kampr3
awt1                    	    poscil                  kamp1, kfreq, iwt1, iphase              ; wavetable lookup
awt2                    	    poscil                  kamp2, kfreq, iwt2, iphase
awt3                    	    poscil                  kamp3, kfreq, iwt3, iphase
asig                    	    =                       awt1 + awt2 + awt3
asig                    	    =                       asig*(iampscale/inorm)
kcut                    	    linseg                  0, iattack, ifiltcut, isustain, ifiltcut, idecay, 0     ; lowpass filter for brightness control
afilt                   	    tone                    asig, kcut
asignal                    	    balance                 afilt, asig
iattack                         =                       0.005
isustain                        =                       p3
irelease                        =                       0.06
p3                              =                       isustain + iattack + irelease
adeclick                        linsegr                 0.0, iattack, 1.0, isustain, 1.0, irelease, 0.0
aoutleft, aoutright             pan2                    asignal * adeclick * gkZakianFlute, i_pan
                                outleta                 "outleft",  aoutleft
                                outleta                 "outright", aoutright
                                prints                  "instr %4d t %9.4f d %9.4f k %9.4f v %9.4f p %9.4f\n", p1, p2, p3, p4, p5, p7
                                endin

                                //////////////////////////////////////////////
                                // OUTPUT INSTRUMENTS MUST GO BELOW HERE
                                //////////////////////////////////////////////

                                //////////////////////////////////////////////
                                // Reverb
                                // By Michael Gogins.
                                //////////////////////////////////////////////
                                FLgroup                 "Reverb", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset, iguibox
       
                         ix = ifirstwidgetx
                                iy = ifirstwidgety
gkReverbEnabled, giReverbEnabled FLbutton               "Enabled", 1, 0, 3, ivaluatorwidth, iwidgetheight, ix, iy, -1
                                FLsetVal_i              0, giReverbEnabled
iy                              =                       iy + 2 * iwidgetheight + iguioffset

gkReverbWet, giReverbWet        FLslider                "Wet", 0, 1, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giReverbWet
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkReverbDelay, giReverbDelay    FLslider                "Delay", 0, 1, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giReverbDelay
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkReverbCutoff, giReverbCutoff  FLslider                "Cutoff", 20, 20000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giReverbCutoff
                                FLgroupEnd
                                instr                   Reverb
ainleft                         inleta                  "inleft"
ainright                        inleta                  "inright"
if (gkReverbEnabled == 0) then
aoutleft                        =                       ainleft
aoutright                       =                       ainright
kdry				            =			            1.0 - gkReverbWet
else
awetleft, awetright             reverbsc                ainleft, ainright, gkReverbDelay, gkReverbCutoff
aoutleft			            =			            ainleft *  kdry + awetleft  * gkReverbWet
aoutright			            =			            ainright * kdry + awetright * gkReverbWet
endif
                                outleta                 "outleft", aoutleft
                                outleta                 "outright", aoutright
                                endin

                                //////////////////////////////////////////////
                                // Compressor
                                // By Michael Gogins.
                                //////////////////////////////////////////////
                                FLgroup                 "Compressor", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkCompressorEnabled, giCompressorEnabled    FLbutton                "Enabled", 1, 0, 3, ivaluatorwidth, iwidgetheight, ix, iy, -1
                                FLsetVal_i              0, giCompressorEnabled
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkCompressorThreshold, giCompressorThreshold  FLslider  "Threshhold", 0.000001, 1, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giCompressorThreshold
iy                              =                       iy + 2 * iwidgetheight + iguioffset

gkCompressorLowKnee, giCompressorLowKnee  FLslider      "Low knee", 0.000001, 100, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giCompressorLowKnee
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkCompressorHighKnee, giCompressorHighKnee  FLslider    "High knee", 0.000001, 100, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giCompressorHighKnee
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkCompressorRatio, giCompressorRatio  FLslider          "Ratio", 0.000001, 100, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giCompressorRatio
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkCompressorAttack, giCompressorAttack  FLslider        "Attack", 0.000001, 0.1, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giCompressorAttack
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkCompressorRelease, giCompressorRelease  FLslider      "Release", 0.000001, 0.1, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giCompressorRelease
                                FLgroupEnd
                                instr                   Compressor
ainleft                         inleta                  "inleft"
ainright                        inleta                  "inright"
                                if (gkCompressorEnabled == 0) then
aoutleft                        =                       ainleft
aoutright                       =                       ainright
                                else
aoutleft                        compress                ainleft,        ainleft,  gkCompressorThreshold, gkCompressorLowKnee, gkCompressorHighKnee, gkCompressorRatio, gkCompressorAttack, gkCompressorRelease, .05
aoutright                       compress                ainright,       ainright, gkCompressorThreshold, gkCompressorLowKnee, gkCompressorHighKnee, gkCompressorRatio, gkCompressorAttack, gkCompressorRelease, .05
                                endif
                                outleta                 "outleft",      aoutleft
                                outleta                 "outright",     aoutright
                                endin

                                //////////////////////////////////////////////
                                // ParEq1
                                // By Michael Gogins.
                                //////////////////////////////////////////////
                                FLgroup                 "EQ 1", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkParEq1Enabled, giParEq1Enabled    FLbutton             "Enabled", 1, 0, 3, ivaluatorwidth, iwidgetheight, ix, iy, -1
                                FLsetVal_i              0, giParEq1Enabled
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkParEq1Mode, giParEq1Mode      FLcount                 "Mode", 0, 2, 1, 0, 2, ivaluatorwidth, iwidgetheight, ix, iy, -1
                                FLsetVal_i              1, giParEq1Mode
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkParEq1Frequency, giParEq1Frequency  FLslider          "Frequency", 20, 20000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giParEq1Frequency
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkParEq1Gain, giParEq1Gain      FLslider                "Gain", -20, 20, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              0, giParEq1Gain
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkParEq1Q, giParEq1Q            FLslider                "Q", 0, 10, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giParEq1Q
                                FLgroupEnd
                                instr                   ParEq1
ainleft                         inleta                  "inleft"
ainright                        inleta                  "inright"
                                if (gkParEq1Enabled == 0) then
aoutleft                        =                       ainleft
aoutright                       =                       ainright
                                else
kamplitude                      =                       ampdb(gkParEq1Gain)
                                if      (gkParEq1Mode == 0) then
aoutleft                        pareq                   ainleft,        gkParEq1Frequency, kamplitude, giFlatQ + gkParEq1Q, 0
aoutright                       pareq                   ainright,       gkParEq1Frequency, kamplitude, giFlatQ + gkParEq1Q, 0
                                elseif  (gkParEq1Mode == 1) then
aoutleft                        pareq                   ainleft,        gkParEq1Frequency, kamplitude, giFlatQ + gkParEq1Q, 1
aoutright                       pareq                   ainright,       gkParEq1Frequency, kamplitude, giFlatQ + gkParEq1Q, 1
                                elseif  (gkParEq1Mode == 2) then
aoutleft                        pareq                   ainleft,        gkParEq1Frequency, kamplitude, giFlatQ + gkParEq1Q, 2
aoutright                       pareq                   ainright,       gkParEq1Frequency, kamplitude, giFlatQ + gkParEq1Q, 2
                                endif
                                endif
                                outleta                 "outleft",  aoutleft
                                outleta                 "outright", aoutright
                                endin

                                //////////////////////////////////////////////
                                // ParEq2
                                // By Michael Gogins.
                                //////////////////////////////////////////////
                                FLgroup                 "EQ 2", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx

                                iy = ifirstwidgety
gkParEq2Enabled, giParEq2Enabled    FLbutton             "Enabled", 1, 0, 3, ivaluatorwidth, iwidgetheight, ix, iy, -1
                                FLsetVal_i              0, giParEq2Enabled
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkParEq2Mode, giParEq2Mode      FLcount                 "Mode", 0, 2, 1, 0, 2, ivaluatorwidth, iwidgetheight, ix, iy, -1
                                FLsetVal_i              1, giParEq2Mode
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkParEq2Frequency, giParEq2Frequency  FLslider          "Frequency", 20, 20000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giParEq2Frequency
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkParEq2Gain, giParEq2Gain      FLslider                "Gain", -20, 20, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              0, giParEq2Gain
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkParEq2Q, giParEq2Q            FLslider                "Q", 0, 10, 0, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giParEq2Q
                                FLgroupEnd
                                instr                   ParEq2
ainleft                         inleta                  "inleft"
ainright                        inleta                  "inright"
                                if                      (gkParEq2Enabled == 0) then
aoutleft                        =                       ainleft
aoutright                       =                       ainright
                                else
                                if                      (gkParEq2Mode == 0) then
aoutleft                        pareq                   ainleft, 	gkParEq2Frequency, gkParEq2Gain, giFlatQ + gkParEq2Q, 0
aoutright                       pareq                   ainright,	gkParEq2Frequency, gkParEq2Gain, giFlatQ + gkParEq2Q, 0
                                elseif                  (gkParEq2Mode == 1) then
aoutleft                        pareq                   ainleft, 	gkParEq2Frequency, gkParEq2Gain, giFlatQ + gkParEq2Q, 1
aoutright                       pareq                   ainright,	gkParEq2Frequency, gkParEq2Gain, giFlatQ + gkParEq2Q, 1
                                elseif                  (gkParEq2Mode == 2) then
aoutleft                        pareq                   ainleft, 	gkParEq2Frequency, gkParEq2Gain, giFlatQ + gkParEq2Q, 2
aoutright                       pareq                   ainright,	gkParEq2Frequency, gkParEq2Gain, giFlatQ + gkParEq2Q, 2
                                endif
                                endif
                                outleta                 "outleft", 	aoutleft
                                outleta                 "outright", aoutright
                                endin

                                //////////////////////////////////////////////
                                // MasterOutput
                                // By Michael Gogins.
                                //////////////////////////////////////////////
                                FLgroup                 "Master", itabwidth, itabheight, iguioffset, itabtabheight + iguioffset , iguibox
                                ix = ifirstwidgetx
                                iy = ifirstwidgety
gkMasterLevel, giMasterLevel    FLslider                "Output level", 0.0001, 1000, -1, giSliderStyle, -1, ivaluatorwidth, iwidgetheight, ix, iy
                                FLsetVal_i              1, giMasterLevel
iy                              =                       iy + 2 * iwidgetheight + iguioffset
                                FLsetSnapGroup          1
gkSnapSave, giSnapSave          FLbutton                "Save snapshot", 1, 0, 1, ivaluatorwidth, iwidgetheight, ix, iy, 0, 200, 0, 3
iy                              =                       iy + 2 * iwidgetheight + iguioffset
gkSnapLoad, giSnapLoad          FLbutton                "Load snapshot", 1, 0, 1, ivaluatorwidth, iwidgetheight, ix, iy, 0, 201, 0, 3
                                FLgroupEnd

                                instr                   MasterOutput
ivalid                          filevalid               gSnapshotfile
                                if ivalid == 1          then
                                prints                  "Loading..."
                                FLloadsnap              gSnapshotfile
ivaluecount                     FLgetsnap               0
                                prints                  "%d values set.\n", ivaluecount
                                else
                                prints                  "Missing or invalid snapshot file."
                                endif
ainleft                         inleta                  "inleft"
ainright                        inleta                  "inright"
aoutleft                        =                       gkMasterLevel * ainleft
aoutright                       =                       gkMasterLevel * ainright
                                outs                    aoutleft, aoutright
                                endin

                                instr                   200
                                prints                  "Saving..."
isnapshot, ivaluecount          FLsetsnap               0
                                FLsavesnap              gSnapshotfile
                                endin

                                instr                   201
ivalid                          filevalid               gSnapshotfile
                                if ivalid == 1          then
                                prints                  "Loading..."
                                FLloadsnap              gSnapshotfile
ivaluecount                     FLgetsnap               0
                                else
                                prints                  "Missing or invalid snapshot file."
                                endif
                                endin

                                FLtabsEnd
                                FLpanelEnd
                                FLrun
</CsInstruments>

<CsScore>
e 180
</CsScore>

</CsoundSynthesizer>
