/*
   Copyright (C) 2008-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
#ifndef textstylewidget_h
#define textstylewidget_h

#include <qwidget.h>

class KColorButton;
class QPushButton;
class QBoxLayout;
class QColor;

namespace KoverArtist { class TextStyle; }


/** A high level gui widget for changing the various configuration elements
 * of a @ref KoverArtist::TextStyle koverartist text style.
 */
class TextStyleWidget: public QWidget
{
   typedef QWidget Inherited;
   Q_OBJECT

public:
   TextStyleWidget(KoverArtist::TextStyle* styleObj,
                   Qt::Orientations orientations,
                   QWidget* parent = 0);
   virtual ~TextStyleWidget();

signals:
   /** Emitted when the user changed text-style settings. */
   void changed();

public slots:
   /** Update the gui elements from the text-style object. */
   virtual void updateContents();

   virtual void changeFont();
   virtual void setColor(const QColor&);
   virtual void alignLeft();
   virtual void alignHCenter();
   virtual void alignRight();
   virtual void alignTop();
   virtual void alignVCenter();
   virtual void alignBottom();

protected:
   QPushButton* createButton(const char* icon, QWidget* parent,
                             const char* slot, QBoxLayout* box=0) const;

   /** Update the color of the color push-button. */
   virtual void updateColorButton();

private:
   TextStyleWidget(const TextStyleWidget&);
   TextStyleWidget& operator=(const TextStyleWidget&);

protected:
   KoverArtist::TextStyle *mStyle;
   QPushButton *mBtnAlignLeft, *mBtnAlignHCenter, *mBtnAlignRight;
   QPushButton *mBtnAlignTop, *mBtnAlignVCenter, *mBtnAlignBottom;
   KColorButton *mBtnColor;
};


#endif /*textstylewidget_h*/
