/*
   Copyright (C) 2008-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/

#include "tabbase.h"

#include <QtGui/QLabel>
#include <QtGui/QVBoxLayout>


TabBase::TabBase(KoverArtist::Project* aProject, QWidget* aParent)
:Inherited(aParent)
,mProject(aProject)
,mFntCaption(font())
{
   mMainBox = new QVBoxLayout(this);
   mMainBox->setMargin(2);
   mMainBox->setSpacing(2);

   mFntCaption.setBold(true);

   if (font().pointSize()>=0)
      mFntCaption.setPointSize(int(font().pointSize()*1.2));
   else mFntCaption.setPixelSize(int(font().pixelSize()*1.2));
}


TabBase::~TabBase()
{
}


QLabel* TabBase::createCaption(const QString& aText)
{
   if (mMainBox->itemAt(0)!=0)
      mMainBox->addStretch(8);

   QLabel* lbl = new QLabel(aText, this);
   lbl->setFont(mFntCaption);
   lbl->setFixedHeight(lbl->sizeHint().height());
   lbl->setMinimumWidth(lbl->sizeHint().width());
   mMainBox->addWidget(lbl, 0);

   mMainBox->addStretch(2);

   return lbl;
}


QLabel* TabBase::createLine(QWidget* aWidget, const QString& aText,
                            Qt::Alignment aAlign)
{
   QLabel* lbl = new QLabel(aText, this);
   lbl->setFixedSize(lbl->sizeHint());

   QHBoxLayout* hbox = new QHBoxLayout;
   mMainBox->addLayout(hbox);

   if (aAlign==Qt::AlignLeft)
   {
      hbox->addWidget(lbl, 0);
      hbox->addWidget(aWidget, 10);
   }
   else
   {
      hbox->addWidget(aWidget, 10);
      hbox->addWidget(lbl, 0);
   }

   return lbl;
}
