/*
   Copyright (C) 2008-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
#ifndef preview_h
#define preview_h

#include <QtGui/QLabel>


/** A widget that displays the preview of the rendered case.
 */
class Preview: public QLabel
{
   typedef QLabel Inherited;
   Q_OBJECT

public:
   Preview(QWidget* parent = 0, Qt::WindowFlags f = 0);
   virtual ~Preview();

signals:
   /** The widget needs update of the preview. */
   void updateRequest();

protected:
   virtual void resizeEvent(QResizeEvent* event);

private:
   Preview(const Preview&);
   Preview& operator=(const Preview&);
};

#endif /*preview_h*/
